/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.spark;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.PrimitiveIterator;
import java.util.Random;
import java.util.stream.LongStream;
import org.apache.commons.math3.distribution.PoissonDistribution;
import org.apache.commons.math3.random.Well1024a;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.PairFunction;
import org.apache.spark.util.random.SamplingUtils;
import org.apache.sysml.api.DMLScript;
import org.apache.sysml.hops.DataGenOp;
import org.apache.sysml.hops.Hop;
import org.apache.sysml.hops.OptimizerUtils;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysml.runtime.controlprogram.context.SparkExecutionContext;
import org.apache.sysml.runtime.controlprogram.parfor.stat.InfrastructureAnalyzer;
import org.apache.sysml.runtime.instructions.InstructionUtils;
import org.apache.sysml.runtime.instructions.cp.CPOperand;
import org.apache.sysml.runtime.instructions.spark.UnarySPInstruction;
import org.apache.sysml.runtime.instructions.spark.utils.RDDConverterUtils;
import org.apache.sysml.runtime.io.IOUtilFunctions;
import org.apache.sysml.runtime.matrix.MatrixCharacteristics;
import org.apache.sysml.runtime.matrix.data.LibMatrixDatagen;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.data.MatrixCell;
import org.apache.sysml.runtime.matrix.data.MatrixIndexes;
import org.apache.sysml.runtime.matrix.data.RandomMatrixGenerator;
import org.apache.sysml.runtime.matrix.operators.Operator;
import org.apache.sysml.runtime.util.UtilFunctions;
import org.apache.sysml.utils.Statistics;
import scala.Tuple2;

public class RandSPInstruction
extends UnarySPInstruction {
    private static final long INMEMORY_NUMBLOCKS_THRESHOLD = 0x100000L;
    private Hop.DataGenMethod method = Hop.DataGenMethod.INVALID;
    private long rows;
    private long cols;
    private int rowsInBlock;
    private int colsInBlock;
    private double minValue;
    private double maxValue;
    private double sparsity;
    private String pdf;
    private String pdfParams;
    private long seed = 0L;
    private String dir;
    private double seq_from;
    private double seq_to;
    private double seq_incr;
    private boolean replace;

    private RandSPInstruction(Operator op, Hop.DataGenMethod mthd, CPOperand in, CPOperand out, long rows, long cols, int rpb, int cpb, double minValue, double maxValue, double sparsity, long seed, String dir, String probabilityDensityFunction, String pdfParams, String opcode, String istr) {
        super(op, in, out, opcode, istr);
        this.method = mthd;
        this.rows = rows;
        this.cols = cols;
        this.rowsInBlock = rpb;
        this.colsInBlock = cpb;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.sparsity = sparsity;
        this.seed = seed;
        this.dir = dir;
        this.pdf = probabilityDensityFunction;
        this.pdfParams = pdfParams;
    }

    private RandSPInstruction(Operator op, Hop.DataGenMethod mthd, CPOperand in, CPOperand out, long rows, long cols, int rpb, int cpb, double seqFrom, double seqTo, double seqIncr, String opcode, String istr) {
        super(op, in, out, opcode, istr);
        this.method = mthd;
        this.rows = rows;
        this.cols = cols;
        this.rowsInBlock = rpb;
        this.colsInBlock = cpb;
        this.seq_from = seqFrom;
        this.seq_to = seqTo;
        this.seq_incr = seqIncr;
    }

    private RandSPInstruction(Operator op, Hop.DataGenMethod mthd, CPOperand in, CPOperand out, long rows, long cols, int rpb, int cpb, double maxValue, boolean replace, long seed, String opcode, String istr) {
        super(op, in, out, opcode, istr);
        this.method = mthd;
        this.rows = rows;
        this.cols = cols;
        this.rowsInBlock = rpb;
        this.colsInBlock = cpb;
        this.maxValue = maxValue;
        this.replace = replace;
        this.seed = seed;
    }

    public long getRows() {
        return this.rows;
    }

    public void setRows(long rows) {
        this.rows = rows;
    }

    public long getCols() {
        return this.cols;
    }

    public void setCols(long cols) {
        this.cols = cols;
    }

    public int getRowsInBlock() {
        return this.rowsInBlock;
    }

    public void setRowsInBlock(int rowsInBlock) {
        this.rowsInBlock = rowsInBlock;
    }

    public int getColsInBlock() {
        return this.colsInBlock;
    }

    public void setColsInBlock(int colsInBlock) {
        this.colsInBlock = colsInBlock;
    }

    public double getMinValue() {
        return this.minValue;
    }

    public void setMinValue(double minValue) {
        this.minValue = minValue;
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(double maxValue) {
        this.maxValue = maxValue;
    }

    public double getSparsity() {
        return this.sparsity;
    }

    public void setSparsity(double sparsity) {
        this.sparsity = sparsity;
    }

    public static RandSPInstruction parseInstruction(String str) throws DMLRuntimeException {
        String[] s = InstructionUtils.getInstructionPartsWithValueType(str);
        String opcode = s[0];
        Hop.DataGenMethod method = Hop.DataGenMethod.INVALID;
        if (opcode.equalsIgnoreCase("rand")) {
            method = Hop.DataGenMethod.RAND;
            InstructionUtils.checkNumFields(str, 12);
        } else if (opcode.equalsIgnoreCase("seq")) {
            method = Hop.DataGenMethod.SEQ;
            InstructionUtils.checkNumFields(str, 8);
        } else if (opcode.equalsIgnoreCase("sample")) {
            method = Hop.DataGenMethod.SAMPLE;
            InstructionUtils.checkNumFields(str, 7);
        }
        Operator op = null;
        CPOperand out = new CPOperand(s[s.length - 1]);
        if (method == Hop.DataGenMethod.RAND) {
            long rows = -1L;
            long cols = -1L;
            if (!s[1].contains("\u00b6")) {
                rows = Double.valueOf(s[1]).longValue();
            }
            if (!s[2].contains("\u00b6")) {
                cols = Double.valueOf(s[2]).longValue();
            }
            int rpb = Integer.parseInt(s[3]);
            int cpb = Integer.parseInt(s[4]);
            double minValue = -1.0;
            double maxValue = -1.0;
            if (!s[5].contains("\u00b6")) {
                minValue = Double.valueOf(s[5]);
            }
            if (!s[6].contains("\u00b6")) {
                maxValue = Double.valueOf(s[6]);
            }
            double sparsity = -1.0;
            if (!s[7].contains("\u00b6")) {
                sparsity = Double.valueOf(s[7]);
            }
            long seed = -1L;
            if (!s[8].contains("\u00b6")) {
                seed = Long.parseLong(s[8]);
            }
            String dir = s[9];
            String pdf = s[10];
            String pdfParams = s[11];
            return new RandSPInstruction(op, method, null, out, rows, cols, rpb, cpb, minValue, maxValue, sparsity, seed, dir, pdf, pdfParams, opcode, str);
        }
        if (method == Hop.DataGenMethod.SEQ) {
            long rows = Double.valueOf(s[1]).longValue();
            long cols = Double.valueOf(s[2]).longValue();
            int rpb = Integer.parseInt(s[3]);
            int cpb = Integer.parseInt(s[4]);
            double incr = Double.NaN;
            double to = Double.NaN;
            double from = Double.NaN;
            if (!s[5].contains("\u00b6")) {
                from = Double.valueOf(s[5]);
            }
            if (!s[6].contains("\u00b6")) {
                to = Double.valueOf(s[6]);
            }
            if (!s[7].contains("\u00b6")) {
                incr = Double.valueOf(s[7]);
            }
            CPOperand in = null;
            return new RandSPInstruction(op, method, in, out, rows, cols, rpb, cpb, from, to, incr, opcode, str);
        }
        if (method == Hop.DataGenMethod.SAMPLE) {
            double max = 0.0;
            long rows = 0L;
            boolean replace = false;
            if (!s[1].contains("\u00b6")) {
                max = Double.valueOf(s[1]);
            }
            if (!s[2].contains("\u00b6")) {
                rows = Double.valueOf(s[2]).longValue();
            }
            long cols = 1L;
            if (!s[3].contains("\u00b6")) {
                replace = Boolean.valueOf(s[3]);
            }
            long seed = Long.parseLong(s[4]);
            int rpb = Integer.parseInt(s[5]);
            int cpb = Integer.parseInt(s[6]);
            return new RandSPInstruction(op, method, null, out, rows, cols, rpb, cpb, max, replace, seed, opcode, str);
        }
        throw new DMLRuntimeException("Unrecognized data generation method: " + (Object)((Object)method));
    }

    @Override
    public void processInstruction(ExecutionContext ec) throws DMLRuntimeException {
        SparkExecutionContext sec = (SparkExecutionContext)ec;
        switch (this.method) {
            case RAND: {
                this.generateRandData(sec);
                break;
            }
            case SEQ: {
                this.generateSequence(sec);
                break;
            }
            case SAMPLE: {
                this.generateSample(sec);
                break;
            }
            default: {
                throw new DMLRuntimeException("Invalid datagen method: " + (Object)((Object)this.method));
            }
        }
    }

    private void generateRandData(SparkExecutionContext sec) throws DMLRuntimeException {
        JavaPairRDD seedsRDD;
        block11: {
            long numColBlocks;
            long numBlocks;
            double hdfsBlkSize;
            double totalSize;
            PrimitiveIterator.OfLong nnzIter;
            Well1024a bigrand;
            block10: {
                long lSeed = this.seed;
                if (lSeed == -1L) {
                    lSeed = DataGenOp.generateRandomSeed();
                }
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Process RandSPInstruction rand with seed = " + lSeed + "."));
                }
                if (this.isMemAvail(this.rows, this.cols, this.sparsity, this.minValue, this.maxValue) && DMLScript.rtplatform != DMLScript.RUNTIME_PLATFORM.SPARK) {
                    RandomMatrixGenerator rgen = LibMatrixDatagen.createRandomMatrixGenerator(this.pdf, (int)this.rows, (int)this.cols, this.rowsInBlock, this.colsInBlock, this.sparsity, this.minValue, this.maxValue, this.pdfParams);
                    MatrixBlock mb = MatrixBlock.randOperations(rgen, lSeed);
                    sec.setMatrixOutput(this.output.getName(), mb, this.getExtendedOpcode());
                    Statistics.decrementNoOfExecutedSPInst();
                    return;
                }
                seedsRDD = null;
                bigrand = LibMatrixDatagen.setupSeedsForRand(lSeed);
                LongStream nnz = LibMatrixDatagen.computeNNZperBlock(this.rows, this.cols, this.rowsInBlock, this.colsInBlock, this.sparsity);
                nnzIter = nnz.iterator();
                totalSize = OptimizerUtils.estimatePartitionedSizeExactSparsity(this.rows, this.cols, (long)this.rowsInBlock, (long)this.colsInBlock, (double)(this.rows * this.cols) * this.sparsity);
                hdfsBlkSize = InfrastructureAnalyzer.getHDFSBlockSize();
                numBlocks = new MatrixCharacteristics(this.rows, this.cols, this.rowsInBlock, this.colsInBlock).getNumBlocks();
                numColBlocks = (long)Math.ceil((double)this.cols / (double)this.colsInBlock);
                if (numBlocks >= 0x100000L) break block10;
                ArrayList<Tuple2> seeds = new ArrayList<Tuple2>();
                for (long i = 0L; i < numBlocks; ++i) {
                    long r = 1L + i / numColBlocks;
                    long c = 1L + i % numColBlocks;
                    MatrixIndexes indx = new MatrixIndexes(r, c);
                    Long seedForBlock = bigrand.nextLong();
                    seeds.add(new Tuple2((Object)indx, (Object)new Tuple2((Object)seedForBlock, (Object)nnzIter.nextLong())));
                }
                int numPartitions = (int)Math.max(Math.min(totalSize / hdfsBlkSize, (double)numBlocks), 1.0);
                seedsRDD = sec.getSparkContext().parallelizePairs(seeds, numPartitions);
                break block11;
            }
            Path path = new Path(LibMatrixDatagen.generateUniqueSeedPath(this.dir));
            PrintWriter pw = null;
            try {
                FileSystem fs = IOUtilFunctions.getFileSystem(path);
                pw = new PrintWriter((OutputStream)fs.create(path));
                StringBuilder sb = new StringBuilder();
                for (long i = 0L; i < numBlocks; ++i) {
                    sb.append(1L + i / numColBlocks);
                    sb.append(',');
                    sb.append(1L + i % numColBlocks);
                    sb.append(',');
                    sb.append(bigrand.nextLong());
                    sb.append(',');
                    sb.append(nnzIter.nextLong());
                    pw.println(sb.toString());
                    sb.setLength(0);
                }
            }
            catch (IOException ex) {
                try {
                    throw new DMLRuntimeException(ex);
                }
                catch (Throwable throwable) {
                    IOUtilFunctions.closeSilently(pw);
                    throw throwable;
                }
            }
            IOUtilFunctions.closeSilently(pw);
            int numPartitions = (int)Math.max(Math.min(totalSize / hdfsBlkSize, (double)numBlocks), 1.0);
            seedsRDD = sec.getSparkContext().textFile(path.toString(), numPartitions).mapToPair((PairFunction)new ExtractSeedTuple());
        }
        JavaPairRDD out = seedsRDD.mapToPair((PairFunction)new GenerateRandomBlock(this.rows, this.cols, this.rowsInBlock, this.colsInBlock, this.sparsity, this.minValue, this.maxValue, this.pdf, this.pdfParams));
        MatrixCharacteristics mcOut = sec.getMatrixCharacteristics(this.output.getName());
        if (!mcOut.dimsKnown(true)) {
            long lnnz = this.sparsity == 0.0 || this.sparsity == 1.0 ? (long)(this.sparsity * (double)this.rows * (double)this.cols) : -1L;
            mcOut.set(this.rows, this.cols, this.rowsInBlock, this.colsInBlock, lnnz);
        }
        sec.setRDDHandleForVariable(this.output.getName(), out);
    }

    private void generateSequence(SparkExecutionContext sec) throws DMLRuntimeException {
        long nnz;
        JavaRDD offsetsRDD;
        block11: {
            long numBlocks;
            double hdfsBlkSize;
            double totalSize;
            block10: {
                if (this.seq_incr == 0.0) {
                    throw new DMLRuntimeException("ERROR: While performing seq(" + this.seq_from + "," + this.seq_to + "," + this.seq_incr + ")");
                }
                this.seq_incr = LibMatrixDatagen.updateSeqIncr(this.seq_from, this.seq_to, this.seq_incr);
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Process RandSPInstruction seq with seqFrom=" + this.seq_from + ", seqTo=" + this.seq_to + ", seqIncr" + this.seq_incr));
                }
                offsetsRDD = null;
                nnz = UtilFunctions.getSeqLength(this.seq_from, this.seq_to, this.seq_incr);
                totalSize = OptimizerUtils.estimatePartitionedSizeExactSparsity(nnz, 1L, (long)this.rowsInBlock, (long)this.colsInBlock, nnz);
                hdfsBlkSize = InfrastructureAnalyzer.getHDFSBlockSize();
                numBlocks = (long)Math.ceil((double)nnz / (double)this.rowsInBlock);
                if (numBlocks >= 0x100000L) break block10;
                ArrayList<Double> offsets = new ArrayList<Double>();
                for (long i = 0L; i < numBlocks; ++i) {
                    double off = this.seq_from + this.seq_incr * (double)i * (double)this.rowsInBlock;
                    offsets.add(off);
                }
                int numPartitions = (int)Math.max(Math.min(totalSize / hdfsBlkSize, (double)numBlocks), 1.0);
                offsetsRDD = sec.getSparkContext().parallelize(offsets, numPartitions);
                break block11;
            }
            Path path = new Path(LibMatrixDatagen.generateUniqueSeedPath(this.dir));
            PrintWriter pw = null;
            try {
                FileSystem fs = IOUtilFunctions.getFileSystem(path);
                pw = new PrintWriter((OutputStream)fs.create(path));
                for (long i = 0L; i < numBlocks; ++i) {
                    double off = this.seq_from + this.seq_incr * (double)i * (double)this.rowsInBlock;
                    pw.println(off);
                }
            }
            catch (IOException ex) {
                try {
                    throw new DMLRuntimeException(ex);
                }
                catch (Throwable throwable) {
                    IOUtilFunctions.closeSilently(pw);
                    throw throwable;
                }
            }
            IOUtilFunctions.closeSilently(pw);
            int numPartitions = (int)Math.max(Math.min(totalSize / hdfsBlkSize, (double)numBlocks), 1.0);
            offsetsRDD = sec.getSparkContext().textFile(path.toString(), numPartitions).map((Function)new ExtractOffsetTuple());
        }
        if (nnz != this.rows && this.rows != -1L) {
            throw new DMLRuntimeException("Incorrect number of non-zeros: " + nnz + " != " + this.rows);
        }
        JavaPairRDD out = offsetsRDD.mapToPair((PairFunction)new GenerateSequenceBlock(this.rowsInBlock, this.seq_from, this.seq_to, this.seq_incr));
        MatrixCharacteristics mcOut = sec.getMatrixCharacteristics(this.output.getName());
        if (!mcOut.dimsKnown()) {
            mcOut.set(nnz, 1L, this.rowsInBlock, this.colsInBlock, nnz);
        }
        sec.setRDDHandleForVariable(this.output.getName(), out);
    }

    private void generateSample(SparkExecutionContext sec) throws DMLRuntimeException {
        if (this.maxValue < (double)this.rows && !this.replace) {
            throw new DMLRuntimeException("Sample (size=" + this.rows + ") larger than population (size=" + this.maxValue + ") can only be generated with replacement.");
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Process RandSPInstruction sample with range=" + this.maxValue + ", size=" + this.rows + ", replace=" + this.replace + ", seed=" + this.seed));
        }
        double fraction = SamplingUtils.computeFractionForSampleSize((int)((int)this.rows), (long)UtilFunctions.toLong(this.maxValue), (boolean)this.replace);
        Well1024a bigrand = LibMatrixDatagen.setupSeedsForRand(this.seed);
        double hdfsBlockSize = InfrastructureAnalyzer.getHDFSBlockSize();
        long outputSize = MatrixBlock.estimateSizeDenseInMemory(this.rows, 1L);
        int numPartitions = (int)Math.ceil((double)outputSize / hdfsBlockSize);
        long partitionSize = (long)Math.ceil(this.maxValue / (double)numPartitions);
        ArrayList<SampleTask> offsets = new ArrayList<SampleTask>();
        long st = 1L;
        while ((double)st <= this.maxValue) {
            SampleTask s = new SampleTask();
            s.range_start = st;
            s.seed = bigrand.nextLong();
            offsets.add(s);
            st += partitionSize;
        }
        JavaRDD offsetRDD = sec.getSparkContext().parallelize(offsets, numPartitions);
        JavaRDD rdd = offsetRDD.flatMap((FlatMapFunction)new GenerateSampleBlock(this.replace, fraction, (long)this.maxValue, partitionSize));
        JavaRDD randomizedRDD = rdd.mapToPair((PairFunction)new AttachRandom()).sortByKey().values();
        JavaPairRDD miRDD = randomizedRDD.zipWithIndex().filter((Function)new TrimSample(this.rows)).mapToPair((PairFunction)new Double2MatrixCell());
        MatrixCharacteristics mcOut = new MatrixCharacteristics(this.rows, 1L, this.rowsInBlock, this.colsInBlock, this.rows);
        JavaPairRDD<MatrixIndexes, MatrixBlock> mbRDD = RDDConverterUtils.binaryCellToBinaryBlock(sec.getSparkContext(), (JavaPairRDD<MatrixIndexes, MatrixCell>)miRDD, mcOut, true);
        MatrixCharacteristics retDims = sec.getMatrixCharacteristics(this.output.getName());
        retDims.setNonZeros(this.rows);
        sec.setRDDHandleForVariable(this.output.getName(), mbRDD);
    }

    private boolean isMemAvail(long lRows, long lCols, double sparsity, double min, double max) {
        double size = min == 0.0 && max == 0.0 ? (double)OptimizerUtils.estimateSizeEmptyBlock(this.rows, this.cols) : (double)OptimizerUtils.estimateSizeExactSparsity(this.rows, this.cols, sparsity);
        return OptimizerUtils.isValidCPDimensions(this.rows, this.cols) && OptimizerUtils.isValidCPMatrixSize(this.rows, this.cols, sparsity) && size < OptimizerUtils.getLocalMemBudget();
    }

    private static class GenerateSequenceBlock
    implements PairFunction<Double, MatrixIndexes, MatrixBlock> {
        private static final long serialVersionUID = 5779681055705756965L;
        private final double _global_seq_start;
        private final double _global_seq_end;
        private final double _seq_incr;
        private final int _brlen;

        public GenerateSequenceBlock(int brlen, double global_seq_start, double global_seq_end, double seq_incr) {
            this._global_seq_start = global_seq_start;
            this._global_seq_end = global_seq_end;
            this._seq_incr = seq_incr;
            this._brlen = brlen;
        }

        public Tuple2<MatrixIndexes, MatrixBlock> call(Double seq_from) throws Exception {
            double seq_to = this._seq_incr > 0.0 ? Math.min(this._global_seq_end, seq_from + this._seq_incr * (double)(this._brlen - 1)) : Math.max(this._global_seq_end, seq_from + this._seq_incr * (double)(this._brlen + 1));
            long globalRow = Math.round((seq_from - this._global_seq_start) / this._seq_incr) + 1L;
            long rowIndex = UtilFunctions.computeBlockIndex(globalRow, this._brlen);
            MatrixIndexes indx = new MatrixIndexes(rowIndex, 1L);
            MatrixBlock blk = MatrixBlock.seqOperations(seq_from, seq_to, this._seq_incr);
            return new Tuple2((Object)indx, (Object)blk);
        }
    }

    private static class GenerateRandomBlock
    implements PairFunction<Tuple2<MatrixIndexes, Tuple2<Long, Long>>, MatrixIndexes, MatrixBlock> {
        private static final long serialVersionUID = 1616346120426470173L;
        private long _rlen;
        private long _clen;
        private int _brlen;
        private int _bclen;
        private double _sparsity;
        private double _min;
        private double _max;
        private String _pdf;
        private String _pdfParams;

        public GenerateRandomBlock(long rlen, long clen, int brlen, int bclen, double sparsity, double min, double max, String pdf, String pdfParams) {
            this._rlen = rlen;
            this._clen = clen;
            this._brlen = brlen;
            this._bclen = bclen;
            this._sparsity = sparsity;
            this._min = min;
            this._max = max;
            this._pdf = pdf;
            this._pdfParams = pdfParams;
        }

        public Tuple2<MatrixIndexes, MatrixBlock> call(Tuple2<MatrixIndexes, Tuple2<Long, Long>> kv) throws Exception {
            MatrixIndexes ix = (MatrixIndexes)kv._1();
            long blockRowIndex = ix.getRowIndex();
            long blockColIndex = ix.getColumnIndex();
            int lrlen = UtilFunctions.computeBlockSize(this._rlen, blockRowIndex, this._brlen);
            int lclen = UtilFunctions.computeBlockSize(this._clen, blockColIndex, this._bclen);
            long seed = (Long)((Tuple2)kv._2)._1;
            long blockNNZ = (Long)((Tuple2)kv._2)._2;
            MatrixBlock blk = new MatrixBlock();
            RandomMatrixGenerator rgen = LibMatrixDatagen.createRandomMatrixGenerator(this._pdf, lrlen, lclen, lrlen, lclen, this._sparsity, this._min, this._max, this._pdfParams);
            blk.randOperationsInPlace(rgen, LongStream.of(blockNNZ), null, seed);
            return new Tuple2(kv._1, (Object)blk);
        }
    }

    private static class ExtractOffsetTuple
    implements Function<String, Double> {
        private static final long serialVersionUID = -3980257526545002552L;

        private ExtractOffsetTuple() {
        }

        public Double call(String arg) throws Exception {
            return Double.parseDouble(arg);
        }
    }

    private static class ExtractSeedTuple
    implements PairFunction<String, MatrixIndexes, Tuple2<Long, Long>> {
        private static final long serialVersionUID = 3973794676854157101L;

        private ExtractSeedTuple() {
        }

        public Tuple2<MatrixIndexes, Tuple2<Long, Long>> call(String arg) throws Exception {
            String[] parts = IOUtilFunctions.split(arg, ",");
            MatrixIndexes ix = new MatrixIndexes(Long.parseLong(parts[0]), Long.parseLong(parts[1]));
            Tuple2 seed = new Tuple2((Object)Long.parseLong(parts[2]), (Object)Long.parseLong(parts[3]));
            return new Tuple2((Object)ix, (Object)seed);
        }
    }

    private static class AttachRandom
    implements PairFunction<Double, Double, Double> {
        private static final long serialVersionUID = -7508858192367406554L;
        Random r = new Random();

        AttachRandom() {
        }

        public Tuple2<Double, Double> call(Double t) throws Exception {
            return new Tuple2((Object)this.r.nextDouble(), (Object)t);
        }
    }

    private static class Double2MatrixCell
    implements PairFunction<Tuple2<Double, Long>, MatrixIndexes, MatrixCell> {
        private static final long serialVersionUID = -2125669746624320536L;

        private Double2MatrixCell() {
        }

        public Tuple2<MatrixIndexes, MatrixCell> call(Tuple2<Double, Long> t) throws Exception {
            long rowID = (Long)t._2() + 1L;
            MatrixIndexes mi = new MatrixIndexes(rowID, 1L);
            MatrixCell mc = new MatrixCell((Double)t._1());
            return new Tuple2((Object)mi, (Object)mc);
        }
    }

    private static class TrimSample
    implements Function<Tuple2<Double, Long>, Boolean> {
        private static final long serialVersionUID = 6773370625013346530L;
        long _max;

        TrimSample(long max) {
            this._max = max;
        }

        public Boolean call(Tuple2<Double, Long> v1) throws Exception {
            return (Long)v1._2 < this._max;
        }
    }

    private static class GenerateSampleBlock
    implements FlatMapFunction<SampleTask, Double> {
        private static final long serialVersionUID = -8211490954143527232L;
        private double _frac;
        private boolean _replace;
        private long _maxValue;
        private long _partitionSize;

        GenerateSampleBlock(boolean replace, double frac, long max, long psize) {
            this._replace = replace;
            this._frac = frac;
            this._maxValue = max;
            this._partitionSize = psize;
        }

        public Iterator<Double> call(SampleTask t) throws Exception {
            long st = t.range_start;
            long end = Math.min(t.range_start + this._partitionSize, this._maxValue);
            ArrayList<Double> retList = new ArrayList<Double>();
            if (this._frac == 1.0) {
                for (long i = st; i <= end; ++i) {
                    retList.add(Double.valueOf(i));
                }
            } else if (this._replace) {
                PoissonDistribution pdist = new PoissonDistribution(this._frac > 0.0 ? this._frac : 1.0);
                for (long i = st; i <= end; ++i) {
                    for (int count = pdist.sample(); count > 0; --count) {
                        retList.add(Double.valueOf(i));
                    }
                }
            } else {
                Random rnd = new Random(t.seed);
                for (long i = st; i <= end; ++i) {
                    if (!(rnd.nextDouble() < this._frac)) continue;
                    retList.add(Double.valueOf(i));
                }
            }
            return retList.iterator();
        }
    }

    private static class SampleTask
    implements Serializable {
        private static final long serialVersionUID = -725284524434342939L;
        long seed;
        long range_start;

        private SampleTask() {
        }

        public String toString() {
            return "(" + this.seed + "," + this.range_start + ")";
        }
    }
}

