/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.spark;

import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.PairFunction;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysml.runtime.controlprogram.context.SparkExecutionContext;
import org.apache.sysml.runtime.instructions.cp.CPOperand;
import org.apache.sysml.runtime.instructions.spark.AppendRSPInstruction;
import org.apache.sysml.runtime.instructions.spark.utils.FrameRDDAggregateUtils;
import org.apache.sysml.runtime.matrix.data.FrameBlock;
import org.apache.sysml.runtime.matrix.operators.Operator;
import scala.Tuple2;

public class FrameAppendRSPInstruction
extends AppendRSPInstruction {
    protected FrameAppendRSPInstruction(Operator op, CPOperand in1, CPOperand in2, CPOperand out, boolean cbind, String opcode, String istr) {
        super(op, in1, in2, out, cbind, opcode, istr);
    }

    @Override
    public void processInstruction(ExecutionContext ec) throws DMLRuntimeException {
        SparkExecutionContext sec = (SparkExecutionContext)ec;
        JavaPairRDD<Long, FrameBlock> in1 = sec.getFrameBinaryBlockRDDHandleForVariable(this.input1.getName());
        JavaPairRDD<Long, FrameBlock> in2 = sec.getFrameBinaryBlockRDDHandleForVariable(this.input2.getName());
        JavaPairRDD out = null;
        long leftRows = sec.getMatrixCharacteristics(this.input1.getName()).getRows();
        if (this._cbind) {
            JavaPairRDD<Long, FrameBlock> in1Aligned = in1.mapToPair((PairFunction)new ReduceSideAppendAlignFunction(leftRows));
            in1Aligned = FrameRDDAggregateUtils.mergeByKey(in1Aligned);
            JavaPairRDD<Long, FrameBlock> in2Aligned = in2.mapToPair((PairFunction)new ReduceSideAppendAlignFunction(leftRows));
            in2Aligned = FrameRDDAggregateUtils.mergeByKey(in2Aligned);
            out = in1Aligned.join(in2Aligned).mapValues((Function)new ReduceSideColumnsFunction(this._cbind));
        } else {
            JavaPairRDD right = in2.mapToPair((PairFunction)new ReduceSideAppendRowsFunction(leftRows));
            out = in1.union(right);
        }
        this.updateBinaryAppendOutputMatrixCharacteristics(sec, this._cbind);
        sec.setRDDHandleForVariable(this.output.getName(), out);
        sec.addLineageRDD(this.output.getName(), this.input1.getName());
        sec.addLineageRDD(this.output.getName(), this.input2.getName());
        sec.getFrameObject(this.output.getName()).setSchema(sec.getFrameObject(this.input1.getName()).mergeSchemas(sec.getFrameObject(this.input2.getName())));
    }

    private static class ReduceSideAppendAlignFunction
    implements PairFunction<Tuple2<Long, FrameBlock>, Long, FrameBlock> {
        private static final long serialVersionUID = 5850400295183766409L;
        private long _rows;

        public ReduceSideAppendAlignFunction(long rows) {
            this._rows = rows;
        }

        public Tuple2<Long, FrameBlock> call(Tuple2<Long, FrameBlock> arg0) throws Exception {
            FrameBlock resultBlock = new FrameBlock(((FrameBlock)arg0._2()).getSchema());
            long index = (Long)arg0._1() / 1000L * 1000L + 1L;
            int maxRows = (int)(this._rows - index + 1L >= 1000L ? 1000L : this._rows - index + 1L);
            resultBlock.ensureAllocatedColumns(maxRows);
            resultBlock = resultBlock.leftIndexingOperations((FrameBlock)arg0._2(), 0, maxRows - 1, 0, ((FrameBlock)arg0._2()).getNumColumns() - 1, new FrameBlock());
            return new Tuple2((Object)index, (Object)resultBlock);
        }
    }

    private static class ReduceSideAppendRowsFunction
    implements PairFunction<Tuple2<Long, FrameBlock>, Long, FrameBlock> {
        private static final long serialVersionUID = 1723795153048336791L;
        private long _offset;

        public ReduceSideAppendRowsFunction(long offset) {
            this._offset = offset;
        }

        public Tuple2<Long, FrameBlock> call(Tuple2<Long, FrameBlock> arg0) throws Exception {
            return new Tuple2((Object)((Long)arg0._1() + this._offset), arg0._2());
        }
    }

    private static class ReduceSideColumnsFunction
    implements Function<Tuple2<FrameBlock, FrameBlock>, FrameBlock> {
        private static final long serialVersionUID = -97824903649667646L;
        private boolean _cbind = true;

        public ReduceSideColumnsFunction(boolean cbind) {
            this._cbind = cbind;
        }

        public FrameBlock call(Tuple2<FrameBlock, FrameBlock> arg0) throws Exception {
            FrameBlock left = (FrameBlock)arg0._1();
            FrameBlock right = (FrameBlock)arg0._2();
            return left.appendOperations(right, new FrameBlock(), this._cbind);
        }
    }
}

