/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.spark;

import org.apache.sysml.lops.BinaryM;
import org.apache.sysml.parser.Expression;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.instructions.InstructionUtils;
import org.apache.sysml.runtime.instructions.cp.CPOperand;
import org.apache.sysml.runtime.instructions.spark.BinarySPInstruction;
import org.apache.sysml.runtime.instructions.spark.MatrixBVectorArithmeticSPInstruction;
import org.apache.sysml.runtime.instructions.spark.MatrixMatrixArithmeticSPInstruction;
import org.apache.sysml.runtime.instructions.spark.MatrixScalarArithmeticSPInstruction;
import org.apache.sysml.runtime.instructions.spark.SPInstruction;
import org.apache.sysml.runtime.matrix.operators.BinaryOperator;
import org.apache.sysml.runtime.matrix.operators.Operator;

public abstract class ArithmeticBinarySPInstruction
extends BinarySPInstruction {
    ArithmeticBinarySPInstruction(Operator op, CPOperand in1, CPOperand in2, CPOperand out, String opcode, String istr) {
        super(op, in1, in2, out, opcode, istr);
        this._sptype = SPInstruction.SPINSTRUCTION_TYPE.ArithmeticBinary;
    }

    public static ArithmeticBinarySPInstruction parseInstruction(String str) throws DMLRuntimeException {
        BinaryOperator operator;
        CPOperand in1 = new CPOperand("", Expression.ValueType.UNKNOWN, Expression.DataType.UNKNOWN);
        CPOperand in2 = new CPOperand("", Expression.ValueType.UNKNOWN, Expression.DataType.UNKNOWN);
        CPOperand out = new CPOperand("", Expression.ValueType.UNKNOWN, Expression.DataType.UNKNOWN);
        String opcode = null;
        boolean isBroadcast = false;
        BinaryM.VectorType vtype = null;
        if (str.startsWith("SPARK\u00b0map")) {
            String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
            InstructionUtils.checkNumFields(parts, 5);
            opcode = parts[0];
            in1.split(parts[1]);
            in2.split(parts[2]);
            out.split(parts[3]);
            vtype = BinaryM.VectorType.valueOf(parts[5]);
            isBroadcast = true;
        } else {
            opcode = ArithmeticBinarySPInstruction.parseBinaryInstruction(str, in1, in2, out);
        }
        Expression.DataType dt1 = in1.getDataType();
        Expression.DataType dt2 = in2.getDataType();
        Operator operator2 = dt1 != dt2 ? InstructionUtils.parseScalarBinaryOperator(opcode, dt1 == Expression.DataType.SCALAR) : (operator = InstructionUtils.parseExtendedBinaryOperator(opcode));
        if (dt1 == Expression.DataType.MATRIX || dt2 == Expression.DataType.MATRIX) {
            if (dt1 == Expression.DataType.MATRIX && dt2 == Expression.DataType.MATRIX) {
                if (isBroadcast) {
                    return new MatrixBVectorArithmeticSPInstruction((Operator)operator, in1, in2, out, vtype, opcode, str);
                }
                return new MatrixMatrixArithmeticSPInstruction(operator, in1, in2, out, opcode, str);
            }
            return new MatrixScalarArithmeticSPInstruction(operator, in1, in2, out, opcode, str);
        }
        return null;
    }
}

