/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.mr;

import java.util.ArrayList;
import org.apache.sysml.parser.Expression;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.instructions.InstructionUtils;
import org.apache.sysml.runtime.instructions.mr.MRInstruction;
import org.apache.sysml.runtime.instructions.mr.UnaryMRInstructionBase;
import org.apache.sysml.runtime.matrix.data.MatrixValue;
import org.apache.sysml.runtime.matrix.data.OperationsOnMatrixValues;
import org.apache.sysml.runtime.matrix.mapred.CachedValueMap;
import org.apache.sysml.runtime.matrix.mapred.IndexedMatrixValue;
import org.apache.sysml.runtime.matrix.operators.ScalarOperator;

public class ScalarInstruction
extends UnaryMRInstructionBase {
    private ScalarInstruction(ScalarOperator op, byte in, byte out, String istr) {
        super(op, in, out);
        this.mrtype = MRInstruction.MRINSTRUCTION_TYPE.ArithmeticBinary;
        this.instString = istr;
        op.setConstant(op.getConstant());
    }

    public static ScalarInstruction parseInstruction(String str) throws DMLRuntimeException {
        InstructionUtils.checkNumFields(str, 3);
        String[] parts = InstructionUtils.getInstructionParts(str);
        String opcode = parts[0];
        boolean firstArgScalar = ScalarInstruction.isFirstArgumentScalar(str);
        double cst = Double.parseDouble(firstArgScalar ? parts[1] : parts[2]);
        byte in = Byte.parseByte(firstArgScalar ? parts[2] : parts[1]);
        byte out = Byte.parseByte(parts[3]);
        ScalarOperator sop = InstructionUtils.parseScalarBinaryOperator(opcode, firstArgScalar, cst);
        return new ScalarInstruction(sop, in, out, str);
    }

    @Override
    public void processInstruction(Class<? extends MatrixValue> valueClass, CachedValueMap cachedValues, IndexedMatrixValue tempValue, IndexedMatrixValue zeroInput, int blockRowFactor, int blockColFactor) throws DMLRuntimeException {
        ArrayList<IndexedMatrixValue> blkList = cachedValues.get(this.input);
        if (blkList != null) {
            for (IndexedMatrixValue in : blkList) {
                if (in == null) continue;
                IndexedMatrixValue out = this.input == this.output ? tempValue : cachedValues.holdPlace(this.output, valueClass);
                out.getIndexes().setIndexes(in.getIndexes());
                OperationsOnMatrixValues.performScalarIgnoreIndexes(in.getValue(), out.getValue(), (ScalarOperator)this.optr);
                if (out != tempValue) continue;
                cachedValues.add(this.output, out);
            }
        }
    }

    private static boolean isFirstArgumentScalar(String inst) {
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(inst);
        String arg1 = parts[1];
        String[] subparts = arg1.split("\u00b7");
        Expression.DataType dt = Expression.DataType.valueOf(subparts[1]);
        return dt == Expression.DataType.SCALAR;
    }
}

