/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.cp;

import org.apache.sysml.hops.HopsException;
import org.apache.sysml.hops.LiteralOp;
import org.apache.sysml.parser.Expression;
import org.apache.sysml.runtime.instructions.cp.BooleanObject;
import org.apache.sysml.runtime.instructions.cp.DoubleObject;
import org.apache.sysml.runtime.instructions.cp.IntObject;
import org.apache.sysml.runtime.instructions.cp.ScalarObject;
import org.apache.sysml.runtime.instructions.cp.StringObject;
import org.apache.sysml.runtime.util.UtilFunctions;

public abstract class ScalarObjectFactory {
    public static ScalarObject createScalarObject(Expression.ValueType vt, String value) {
        switch (vt) {
            case INT: {
                return new IntObject(UtilFunctions.parseToLong(value));
            }
            case DOUBLE: {
                return new DoubleObject(Double.parseDouble(value));
            }
            case BOOLEAN: {
                return new BooleanObject(Boolean.parseBoolean(value));
            }
            case STRING: {
                return new StringObject(value);
            }
        }
        throw new RuntimeException("Unsupported scalar value type: " + vt.name());
    }

    public static ScalarObject createScalarObject(Expression.ValueType vt, Object obj) {
        switch (vt) {
            case BOOLEAN: {
                return new BooleanObject((Boolean)obj);
            }
            case INT: {
                return new IntObject((Long)obj);
            }
            case DOUBLE: {
                return new DoubleObject((Double)obj);
            }
            case STRING: {
                return new StringObject((String)obj);
            }
        }
        throw new RuntimeException("Unsupported scalar value type: " + vt.name());
    }

    public static ScalarObject createScalarObject(Expression.ValueType vt, ScalarObject so) {
        switch (vt) {
            case DOUBLE: {
                return new DoubleObject(so.getDoubleValue());
            }
            case INT: {
                return new IntObject(so.getLongValue());
            }
            case BOOLEAN: {
                return new BooleanObject(so.getBooleanValue());
            }
            case STRING: {
                return new StringObject(so.getStringValue());
            }
        }
        throw new RuntimeException("Unsupported scalar value type: " + vt.name());
    }

    public static ScalarObject createScalarObject(Expression.ValueType vt, LiteralOp lit) throws HopsException {
        switch (vt) {
            case DOUBLE: {
                return new DoubleObject(lit.getDoubleValue());
            }
            case INT: {
                return new IntObject(lit.getLongValue());
            }
            case BOOLEAN: {
                return new BooleanObject(lit.getBooleanValue());
            }
            case STRING: {
                return new StringObject(lit.getStringValue());
            }
        }
        throw new RuntimeException("Unsupported scalar value type: " + vt.name());
    }
}

