/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.cp;

import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysml.runtime.instructions.cp.AppendCPInstruction;
import org.apache.sysml.runtime.instructions.cp.CPOperand;
import org.apache.sysml.runtime.instructions.cp.ScalarObject;
import org.apache.sysml.runtime.instructions.cp.StringObject;
import org.apache.sysml.runtime.matrix.operators.Operator;

public final class ScalarAppendCPInstruction
extends AppendCPInstruction {
    protected ScalarAppendCPInstruction(Operator op, CPOperand in1, CPOperand in2, CPOperand in3, CPOperand out, AppendCPInstruction.AppendType type, String opcode, String istr) {
        super(op, in1, in2, in3, out, type, opcode, istr);
    }

    @Override
    public void processInstruction(ExecutionContext ec) throws DMLRuntimeException {
        ScalarObject so1 = ec.getScalarInput(this.input1.getName(), this.input1.getValueType(), this.input1.isLiteral());
        ScalarObject so2 = ec.getScalarInput(this.input2.getName(), this.input2.getValueType(), this.input2.isLiteral());
        String val1 = so1.getStringValue();
        String val2 = so2.getStringValue();
        StringObject.checkMaxStringLength(val1.length() + val2.length());
        String outString = val1 + "\n" + val2;
        StringObject sores = new StringObject(outString);
        ec.setScalarOutput(this.output.getName(), sores);
    }
}

