/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.cp;

import org.apache.sysml.parser.Expression;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysml.runtime.instructions.InstructionUtils;
import org.apache.sysml.runtime.instructions.cp.CPInstruction;
import org.apache.sysml.runtime.instructions.cp.CPOperand;
import org.apache.sysml.runtime.instructions.cp.UnaryCPInstruction;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.operators.Operator;
import org.apache.sysml.runtime.matrix.operators.SimpleOperator;

public class QuantileSortCPInstruction
extends UnaryCPInstruction {
    private QuantileSortCPInstruction(Operator op, CPOperand in, CPOperand out, String opcode, String istr) {
        this(op, in, null, out, opcode, istr);
    }

    private QuantileSortCPInstruction(Operator op, CPOperand in1, CPOperand in2, CPOperand out, String opcode, String istr) {
        super(op, in1, in2, out, opcode, istr);
        this._cptype = CPInstruction.CPINSTRUCTION_TYPE.QSort;
    }

    public static QuantileSortCPInstruction parseInstruction(String str) throws DMLRuntimeException {
        CPOperand in1 = new CPOperand("", Expression.ValueType.UNKNOWN, Expression.DataType.UNKNOWN);
        CPOperand in2 = null;
        CPOperand out = new CPOperand("", Expression.ValueType.UNKNOWN, Expression.DataType.UNKNOWN);
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        String opcode = parts[0];
        if (opcode.equalsIgnoreCase("qsort")) {
            if (parts.length == 3) {
                QuantileSortCPInstruction.parseUnaryInstruction(str, in1, out);
                return new QuantileSortCPInstruction(new SimpleOperator(null), in1, out, opcode, str);
            }
            if (parts.length == 4) {
                in2 = new CPOperand("", Expression.ValueType.UNKNOWN, Expression.DataType.UNKNOWN);
                QuantileSortCPInstruction.parseUnaryInstruction(str, in1, in2, out);
                return new QuantileSortCPInstruction(new SimpleOperator(null), in1, in2, out, opcode, str);
            }
            throw new DMLRuntimeException("Invalid number of operands in instruction: " + str);
        }
        throw new DMLRuntimeException("Unknown opcode while parsing a QuantileSortCPInstruction: " + str);
    }

    @Override
    public void processInstruction(ExecutionContext ec) throws DMLRuntimeException {
        MatrixBlock matBlock = ec.getMatrixInput(this.input1.getName(), this.getExtendedOpcode());
        MatrixBlock wtBlock = null;
        if (this.input2 != null) {
            wtBlock = ec.getMatrixInput(this.input2.getName(), this.getExtendedOpcode());
        }
        MatrixBlock resultBlock = (MatrixBlock)matBlock.sortOperations(wtBlock, new MatrixBlock());
        ec.releaseMatrixInput(this.input1.getName(), this.getExtendedOpcode());
        if (this.input2 != null) {
            ec.releaseMatrixInput(this.input2.getName(), this.getExtendedOpcode());
        }
        ec.setMatrixOutput(this.output.getName(), resultBlock, this.getExtendedOpcode());
    }
}

