/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.cp;

import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysml.runtime.instructions.cp.CPOperand;
import org.apache.sysml.runtime.instructions.cp.RelationalBinaryCPInstruction;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.operators.BinaryOperator;
import org.apache.sysml.runtime.matrix.operators.Operator;

public class MatrixMatrixRelationalCPInstruction
extends RelationalBinaryCPInstruction {
    protected MatrixMatrixRelationalCPInstruction(Operator op, CPOperand in1, CPOperand in2, CPOperand out, String opcode, String istr) {
        super(op, in1, in2, out, opcode, istr);
    }

    @Override
    public void processInstruction(ExecutionContext ec) throws DMLRuntimeException {
        MatrixBlock inBlock1 = ec.getMatrixInput(this.input1.getName(), this.getExtendedOpcode());
        MatrixBlock inBlock2 = ec.getMatrixInput(this.input2.getName(), this.getExtendedOpcode());
        String output_name = this.output.getName();
        BinaryOperator bop = (BinaryOperator)this._optr;
        MatrixBlock retBlock = (MatrixBlock)inBlock1.binaryOperations(bop, inBlock2, new MatrixBlock());
        ec.releaseMatrixInput(this.input1.getName(), this.getExtendedOpcode());
        ec.releaseMatrixInput(this.input2.getName(), this.getExtendedOpcode());
        if (this.checkGuardedRepresentationChange(inBlock1, inBlock2, retBlock)) {
            retBlock.examSparsity();
        }
        ec.setMatrixOutput(output_name, retBlock, this.getExtendedOpcode());
    }
}

