/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.cp;

import org.apache.sysml.api.DMLScript;
import org.apache.sysml.debug.DebugState;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysml.runtime.instructions.Instruction;

public class BreakPointInstruction
extends Instruction {
    private BPINSTRUCTION_STATUS bpStatus;
    private String location = null;

    public BreakPointInstruction() {
        this.type = Instruction.INSTRUCTION_TYPE.BREAKPOINT;
        this.bpStatus = BPINSTRUCTION_STATUS.ENABLED;
    }

    public BreakPointInstruction(BPINSTRUCTION_STATUS status) {
        this.type = Instruction.INSTRUCTION_TYPE.BREAKPOINT;
        this.bpStatus = status;
    }

    public void setBPInstructionStatus(BPINSTRUCTION_STATUS status) {
        this.bpStatus = status;
    }

    public void setBPInstructionLocation(String loc) {
        this.location = loc;
    }

    public BPINSTRUCTION_STATUS getBPInstructionStatus() {
        return this.bpStatus;
    }

    public String getBPInstructionLocation() {
        return this.location;
    }

    public boolean isBPInstructionEnabled() {
        return this.bpStatus == BPINSTRUCTION_STATUS.ENABLED;
    }

    @Override
    public void processInstruction(ExecutionContext ec) throws DMLRuntimeException {
        if (DMLScript.ENABLE_DEBUG_MODE && this.isBPInstructionEnabled()) {
            DebugState dbState = ec.getDebugState();
            System.out.format("Breakpoint reached at %s.\n", dbState.getPC().toString());
            dbState.suspend = true;
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("BP");
        sb.append(" ");
        if (this.bpStatus == BPINSTRUCTION_STATUS.ENABLED) {
            sb.append("enabled");
        } else if (this.bpStatus == BPINSTRUCTION_STATUS.DISABLED) {
            sb.append("disabled");
        } else {
            sb.append("invisible");
        }
        return sb.toString();
    }

    public static enum BPINSTRUCTION_STATUS {
        INVISIBLE,
        ENABLED,
        DISABLED;

    }
}

