/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.functionobjects;

import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.functionobjects.ValueFunction;
import org.apache.sysml.runtime.matrix.data.CTableMap;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.data.MatrixIndexes;
import org.apache.sysml.runtime.matrix.data.Pair;
import org.apache.sysml.runtime.util.UtilFunctions;

public class CTable
extends ValueFunction {
    private static final long serialVersionUID = -5374880447194177236L;
    private static CTable singleObj = null;

    private CTable() {
    }

    public static CTable getCTableFnObject() {
        if (singleObj == null) {
            singleObj = new CTable();
        }
        return singleObj;
    }

    public void execute(double v1, double v2, double w, boolean ignoreZeros, CTableMap resultMap) throws DMLRuntimeException {
        if (Double.isNaN(v1) || Double.isNaN(v2) || Double.isNaN(w)) {
            return;
        }
        long row = UtilFunctions.toLong(v1);
        long col = UtilFunctions.toLong(v2);
        if (ignoreZeros && row == 0L && col == 0L) {
            return;
        }
        if (row <= 0L || col <= 0L) {
            throw new DMLRuntimeException("Erroneous input while computing the contingency table (one of the value <= zero): " + v1 + " " + v2);
        }
        resultMap.aggregate(row, col, w);
    }

    public void execute(double v1, double v2, double w, boolean ignoreZeros, MatrixBlock ctableResult) throws DMLRuntimeException {
        if (Double.isNaN(v1) || Double.isNaN(v2) || Double.isNaN(w)) {
            return;
        }
        long row = UtilFunctions.toLong(v1);
        long col = UtilFunctions.toLong(v2);
        if (ignoreZeros && row == 0L && col == 0L) {
            return;
        }
        if (row <= 0L || col <= 0L) {
            throw new DMLRuntimeException("Erroneous input while computing the contingency table (one of the value <= zero): " + v1 + " " + v2);
        }
        if (row > (long)ctableResult.getNumRows() || col > (long)ctableResult.getNumColumns()) {
            return;
        }
        ctableResult.quickSetValue((int)row - 1, (int)col - 1, ctableResult.quickGetValue((int)row - 1, (int)col - 1) + w);
    }

    public int execute(int row, double v2, double w, int maxCol, MatrixBlock ctableResult) throws DMLRuntimeException {
        if (Double.isNaN(v2) || Double.isNaN(w)) {
            return maxCol;
        }
        long col = UtilFunctions.toLong(v2);
        if (col <= 0L) {
            throw new DMLRuntimeException("Erroneous input while computing the contingency table (value <= zero): " + v2);
        }
        ctableResult.quickSetValue(row - 1, (int)col - 1, w);
        return Math.max(maxCol, (int)col);
    }

    public Pair<MatrixIndexes, Double> execute(long row, double v2, double w) throws DMLRuntimeException {
        if (Double.isNaN(v2) || Double.isNaN(w)) {
            return new Pair<MatrixIndexes, Double>(new MatrixIndexes(-1L, -1L), w);
        }
        long col = UtilFunctions.toLong(v2);
        if (col <= 0L) {
            throw new DMLRuntimeException("Erroneous input while computing the contingency table (value <= zero): " + v2);
        }
        return new Pair<MatrixIndexes, Double>(new MatrixIndexes(row, col), w);
    }
}

