/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.controlprogram.parfor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.mapred.JobConf;
import org.apache.sysml.api.DMLScript;
import org.apache.sysml.conf.CompilerConfig;
import org.apache.sysml.conf.ConfigurationManager;
import org.apache.sysml.conf.DMLConfig;
import org.apache.sysml.hops.Hop;
import org.apache.sysml.hops.OptimizerUtils;
import org.apache.sysml.hops.recompile.Recompiler;
import org.apache.sysml.parser.DMLProgram;
import org.apache.sysml.parser.DataIdentifier;
import org.apache.sysml.parser.Expression;
import org.apache.sysml.parser.ForStatementBlock;
import org.apache.sysml.parser.IfStatementBlock;
import org.apache.sysml.parser.ParForStatementBlock;
import org.apache.sysml.parser.StatementBlock;
import org.apache.sysml.parser.WhileStatementBlock;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.codegen.CodegenUtils;
import org.apache.sysml.runtime.controlprogram.ExternalFunctionProgramBlock;
import org.apache.sysml.runtime.controlprogram.ExternalFunctionProgramBlockCP;
import org.apache.sysml.runtime.controlprogram.ForProgramBlock;
import org.apache.sysml.runtime.controlprogram.FunctionProgramBlock;
import org.apache.sysml.runtime.controlprogram.IfProgramBlock;
import org.apache.sysml.runtime.controlprogram.LocalVariableMap;
import org.apache.sysml.runtime.controlprogram.ParForProgramBlock;
import org.apache.sysml.runtime.controlprogram.Program;
import org.apache.sysml.runtime.controlprogram.ProgramBlock;
import org.apache.sysml.runtime.controlprogram.WhileProgramBlock;
import org.apache.sysml.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysml.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysml.runtime.controlprogram.context.ExecutionContextFactory;
import org.apache.sysml.runtime.controlprogram.parfor.ParForBody;
import org.apache.sysml.runtime.controlprogram.parfor.stat.InfrastructureAnalyzer;
import org.apache.sysml.runtime.instructions.CPInstructionParser;
import org.apache.sysml.runtime.instructions.Instruction;
import org.apache.sysml.runtime.instructions.InstructionParser;
import org.apache.sysml.runtime.instructions.MRJobInstruction;
import org.apache.sysml.runtime.instructions.cp.BooleanObject;
import org.apache.sysml.runtime.instructions.cp.CPInstruction;
import org.apache.sysml.runtime.instructions.cp.Data;
import org.apache.sysml.runtime.instructions.cp.DoubleObject;
import org.apache.sysml.runtime.instructions.cp.FunctionCallCPInstruction;
import org.apache.sysml.runtime.instructions.cp.IntObject;
import org.apache.sysml.runtime.instructions.cp.ScalarObject;
import org.apache.sysml.runtime.instructions.cp.SpoofCPInstruction;
import org.apache.sysml.runtime.instructions.cp.StringObject;
import org.apache.sysml.runtime.instructions.cp.VariableCPInstruction;
import org.apache.sysml.runtime.instructions.gpu.GPUInstruction;
import org.apache.sysml.runtime.instructions.mr.MRInstruction;
import org.apache.sysml.runtime.instructions.spark.SPInstruction;
import org.apache.sysml.runtime.matrix.MatrixCharacteristics;
import org.apache.sysml.runtime.matrix.MatrixFormatMetaData;
import org.apache.sysml.runtime.matrix.data.InputInfo;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.data.OutputInfo;
import org.apache.sysml.udf.ExternalFunctionInvocationInstruction;

public class ProgramConverter {
    protected static final Log LOG = LogFactory.getLog((String)ProgramConverter.class.getName());
    public static final String NEWLINE = "\n";
    public static final String COMPONENTS_DELIM = "\u236e";
    public static final String ELEMENT_DELIM = "\u236a";
    public static final String DATA_FIELD_DELIM = "|";
    public static final String KEY_VALUE_DELIM = "=";
    public static final String LEVELIN = "\u23a8";
    public static final String LEVELOUT = "\u23ac";
    public static final String EMPTY = "null";
    public static final String CP_ROOT_THREAD_ID = "_t0";
    public static final String CP_CHILD_THREAD = "_t";
    public static final String PARFOR_CDATA_BEGIN = "<![CDATA[";
    public static final String PARFOR_CDATA_END = " ]]>";
    public static final String PARFOR_PROG_BEGIN = " PROG\u23a8";
    public static final String PARFOR_PROG_END = "\u23ac";
    public static final String PARFORBODY_BEGIN = "<![CDATA[PARFORBODY\u23a8";
    public static final String PARFORBODY_END = "\u23ac ]]>";
    public static final String PARFOR_VARS_BEGIN = "VARS: ";
    public static final String PARFOR_VARS_END = "";
    public static final String PARFOR_PBS_BEGIN = " PBS\u23a8";
    public static final String PARFOR_PBS_END = "\u23ac";
    public static final String PARFOR_INST_BEGIN = " INST: ";
    public static final String PARFOR_INST_END = "";
    public static final String PARFOR_EC_BEGIN = " EC: ";
    public static final String PARFOR_EC_END = "";
    public static final String PARFOR_PB_BEGIN = " PB\u23a8";
    public static final String PARFOR_PB_END = "\u23ac";
    public static final String PARFOR_PB_WHILE = " WHILE\u23a8";
    public static final String PARFOR_PB_FOR = " FOR\u23a8";
    public static final String PARFOR_PB_PARFOR = " PARFOR\u23a8";
    public static final String PARFOR_PB_IF = " IF\u23a8";
    public static final String PARFOR_PB_FC = " FC\u23a8";
    public static final String PARFOR_PB_EFC = " EFC\u23a8";
    public static final String PARFOR_CONF_STATS = "stats";
    public static final String NOT_SUPPORTED_EXTERNALFUNCTION_PB = "Not supported: ExternalFunctionProgramBlock contains MR instructions. (ExternalFunctionPRogramBlockCP can be used)";
    public static final String NOT_SUPPORTED_MR_INSTRUCTION = "Not supported: Instructions of type other than CP instructions";
    public static final String NOT_SUPPORTED_MR_PARFOR = "Not supported: Nested ParFOR REMOTE_MR due to possible deadlocks.(LOCAL can be used for innner ParFOR)";
    public static final String NOT_SUPPORTED_PB = "Not supported: type of program block";

    public static ExecutionContext createDeepCopyExecutionContext(ExecutionContext ec) throws CloneNotSupportedException, DMLRuntimeException {
        ExecutionContext cpec = ExecutionContextFactory.createContext(false, ec.getProgram());
        cpec.setVariables((LocalVariableMap)ec.getVariables().clone());
        for (String var : cpec.getVariables().keySet()) {
            Data dat = cpec.getVariables().get(var);
            if (!(dat instanceof MatrixObject) || !((MatrixObject)dat).getUpdateType().isInPlace()) continue;
            MatrixObject mo = (MatrixObject)dat;
            MatrixObject moNew = new MatrixObject(mo);
            if (mo.getNnz() != 0L) {
                MatrixBlock mbVar = (MatrixBlock)mo.acquireRead();
                moNew.acquireModify(new MatrixBlock(mbVar));
                mo.release();
            } else {
                moNew.acquireModify(new MatrixBlock((int)mo.getNumRows(), (int)mo.getNumColumns(), false));
            }
            moNew.release();
            cpec.setVariable(var, moNew);
        }
        return cpec;
    }

    public static ArrayList<ProgramBlock> rcreateDeepCopyProgramBlocks(ArrayList<ProgramBlock> childBlocks, long pid, int IDPrefix, HashSet<String> fnStack, HashSet<String> fnCreated, boolean plain, boolean forceDeepCopy) throws DMLRuntimeException {
        ArrayList<ProgramBlock> tmp = new ArrayList<ProgramBlock>();
        for (ProgramBlock pb : childBlocks) {
            Program prog = pb.getProgram();
            ProgramBlock tmpPB = null;
            if (pb instanceof WhileProgramBlock) {
                tmpPB = ProgramConverter.createDeepCopyWhileProgramBlock((WhileProgramBlock)pb, pid, IDPrefix, prog, fnStack, fnCreated, plain, forceDeepCopy);
            } else if (pb instanceof ForProgramBlock && !(pb instanceof ParForProgramBlock)) {
                tmpPB = ProgramConverter.createDeepCopyForProgramBlock((ForProgramBlock)pb, pid, IDPrefix, prog, fnStack, fnCreated, plain, forceDeepCopy);
            } else if (pb instanceof ParForProgramBlock) {
                ParForProgramBlock pfpb = (ParForProgramBlock)pb;
                tmpPB = ProgramConverter.createDeepCopyParForProgramBlock(pfpb, pid, IDPrefix, prog, fnStack, fnCreated, plain, forceDeepCopy);
            } else if (pb instanceof IfProgramBlock) {
                tmpPB = ProgramConverter.createDeepCopyIfProgramBlock((IfProgramBlock)pb, pid, IDPrefix, prog, fnStack, fnCreated, plain, forceDeepCopy);
            } else {
                tmpPB = new ProgramBlock(prog);
                tmpPB.setStatementBlock(ProgramConverter.createStatementBlockCopy(pb.getStatementBlock(), pid, plain, forceDeepCopy));
                tmpPB.setThreadID(pid);
            }
            tmpPB.setInstructions(ProgramConverter.createDeepCopyInstructionSet(pb.getInstructions(), pid, IDPrefix, prog, fnStack, fnCreated, plain, true));
            tmp.add(tmpPB);
        }
        return tmp;
    }

    public static WhileProgramBlock createDeepCopyWhileProgramBlock(WhileProgramBlock wpb, long pid, int IDPrefix, Program prog, HashSet<String> fnStack, HashSet<String> fnCreated, boolean plain, boolean forceDeepCopy) throws DMLRuntimeException {
        ArrayList<Instruction> predinst = ProgramConverter.createDeepCopyInstructionSet(wpb.getPredicate(), pid, IDPrefix, prog, fnStack, fnCreated, plain, true);
        WhileProgramBlock tmpPB = new WhileProgramBlock(prog, predinst);
        tmpPB.setStatementBlock(ProgramConverter.createWhileStatementBlockCopy((WhileStatementBlock)wpb.getStatementBlock(), pid, plain, forceDeepCopy));
        tmpPB.setThreadID(pid);
        tmpPB.setExitInstructions2(ProgramConverter.createDeepCopyInstructionSet(wpb.getExitInstructions(), pid, IDPrefix, prog, fnStack, fnCreated, plain, true));
        tmpPB.setChildBlocks(ProgramConverter.rcreateDeepCopyProgramBlocks(wpb.getChildBlocks(), pid, IDPrefix, fnStack, fnCreated, plain, forceDeepCopy));
        return tmpPB;
    }

    public static IfProgramBlock createDeepCopyIfProgramBlock(IfProgramBlock ipb, long pid, int IDPrefix, Program prog, HashSet<String> fnStack, HashSet<String> fnCreated, boolean plain, boolean forceDeepCopy) throws DMLRuntimeException {
        ArrayList<Instruction> predinst = ProgramConverter.createDeepCopyInstructionSet(ipb.getPredicate(), pid, IDPrefix, prog, fnStack, fnCreated, plain, true);
        IfProgramBlock tmpPB = new IfProgramBlock(prog, predinst);
        tmpPB.setStatementBlock(ProgramConverter.createIfStatementBlockCopy((IfStatementBlock)ipb.getStatementBlock(), pid, plain, forceDeepCopy));
        tmpPB.setThreadID(pid);
        tmpPB.setExitInstructions2(ProgramConverter.createDeepCopyInstructionSet(ipb.getExitInstructions(), pid, IDPrefix, prog, fnStack, fnCreated, plain, true));
        tmpPB.setChildBlocksIfBody(ProgramConverter.rcreateDeepCopyProgramBlocks(ipb.getChildBlocksIfBody(), pid, IDPrefix, fnStack, fnCreated, plain, forceDeepCopy));
        tmpPB.setChildBlocksElseBody(ProgramConverter.rcreateDeepCopyProgramBlocks(ipb.getChildBlocksElseBody(), pid, IDPrefix, fnStack, fnCreated, plain, forceDeepCopy));
        return tmpPB;
    }

    public static ForProgramBlock createDeepCopyForProgramBlock(ForProgramBlock fpb, long pid, int IDPrefix, Program prog, HashSet<String> fnStack, HashSet<String> fnCreated, boolean plain, boolean forceDeepCopy) throws DMLRuntimeException {
        ForProgramBlock tmpPB = new ForProgramBlock(prog, fpb.getIterVar());
        tmpPB.setStatementBlock(ProgramConverter.createForStatementBlockCopy((ForStatementBlock)fpb.getStatementBlock(), pid, plain, forceDeepCopy));
        tmpPB.setThreadID(pid);
        tmpPB.setFromInstructions(ProgramConverter.createDeepCopyInstructionSet(fpb.getFromInstructions(), pid, IDPrefix, prog, fnStack, fnCreated, plain, true));
        tmpPB.setToInstructions(ProgramConverter.createDeepCopyInstructionSet(fpb.getToInstructions(), pid, IDPrefix, prog, fnStack, fnCreated, plain, true));
        tmpPB.setIncrementInstructions(ProgramConverter.createDeepCopyInstructionSet(fpb.getIncrementInstructions(), pid, IDPrefix, prog, fnStack, fnCreated, plain, true));
        tmpPB.setExitInstructions(ProgramConverter.createDeepCopyInstructionSet(fpb.getExitInstructions(), pid, IDPrefix, prog, fnStack, fnCreated, plain, true));
        tmpPB.setChildBlocks(ProgramConverter.rcreateDeepCopyProgramBlocks(fpb.getChildBlocks(), pid, IDPrefix, fnStack, fnCreated, plain, forceDeepCopy));
        return tmpPB;
    }

    public static ForProgramBlock createShallowCopyForProgramBlock(ForProgramBlock fpb, Program prog) throws DMLRuntimeException {
        ForProgramBlock tmpPB = new ForProgramBlock(prog, fpb.getIterVar());
        tmpPB.setFromInstructions(fpb.getFromInstructions());
        tmpPB.setToInstructions(fpb.getToInstructions());
        tmpPB.setIncrementInstructions(fpb.getIncrementInstructions());
        tmpPB.setExitInstructions(fpb.getExitInstructions());
        tmpPB.setChildBlocks(fpb.getChildBlocks());
        return tmpPB;
    }

    public static ParForProgramBlock createDeepCopyParForProgramBlock(ParForProgramBlock pfpb, long pid, int IDPrefix, Program prog, HashSet<String> fnStack, HashSet<String> fnCreated, boolean plain, boolean forceDeepCopy) throws DMLRuntimeException {
        ParForProgramBlock tmpPB = null;
        tmpPB = IDPrefix == -1 ? new ParForProgramBlock(prog, pfpb.getIterVar(), pfpb.getParForParams(), pfpb.getResultVariables()) : new ParForProgramBlock(IDPrefix, prog, pfpb.getIterVar(), pfpb.getParForParams(), pfpb.getResultVariables());
        tmpPB.setStatementBlock(ProgramConverter.createForStatementBlockCopy((ForStatementBlock)pfpb.getStatementBlock(), pid, plain, forceDeepCopy));
        tmpPB.setThreadID(pid);
        tmpPB.disableOptimization();
        tmpPB.disableMonitorReport();
        tmpPB.setFromInstructions(ProgramConverter.createDeepCopyInstructionSet(pfpb.getFromInstructions(), pid, IDPrefix, prog, fnStack, fnCreated, plain, true));
        tmpPB.setToInstructions(ProgramConverter.createDeepCopyInstructionSet(pfpb.getToInstructions(), pid, IDPrefix, prog, fnStack, fnCreated, plain, true));
        tmpPB.setIncrementInstructions(ProgramConverter.createDeepCopyInstructionSet(pfpb.getIncrementInstructions(), pid, IDPrefix, prog, fnStack, fnCreated, plain, true));
        tmpPB.setExitInstructions(ProgramConverter.createDeepCopyInstructionSet(pfpb.getExitInstructions(), pid, IDPrefix, prog, fnStack, fnCreated, plain, true));
        if (plain || forceDeepCopy) {
            tmpPB.setChildBlocks(ProgramConverter.rcreateDeepCopyProgramBlocks(pfpb.getChildBlocks(), pid, IDPrefix, fnStack, fnCreated, plain, forceDeepCopy));
        } else {
            tmpPB.setChildBlocks(pfpb.getChildBlocks());
        }
        return tmpPB;
    }

    public static void createDeepCopyFunctionProgramBlock(String namespace, String oldName, long pid, int IDPrefix, Program prog, HashSet<String> fnStack, HashSet<String> fnCreated, boolean plain) throws DMLRuntimeException {
        FunctionProgramBlock fpb = prog.getFunctionProgramBlock(namespace, oldName);
        String fnameNew = plain ? oldName : oldName + CP_CHILD_THREAD + pid;
        String fnameNewKey = DMLProgram.constructFunctionKey(namespace, fnameNew);
        if (prog.getFunctionProgramBlocks().containsKey(fnameNewKey)) {
            return;
        }
        FunctionProgramBlock copy = null;
        ArrayList<DataIdentifier> tmp1 = new ArrayList<DataIdentifier>();
        ArrayList<DataIdentifier> tmp2 = new ArrayList<DataIdentifier>();
        if (fpb.getInputParams() != null) {
            tmp1.addAll(fpb.getInputParams());
        }
        if (fpb.getOutputParams() != null) {
            tmp2.addAll(fpb.getOutputParams());
        }
        if (fpb instanceof ExternalFunctionProgramBlockCP) {
            ExternalFunctionProgramBlockCP efpb = (ExternalFunctionProgramBlockCP)fpb;
            HashMap<String, String> tmp3 = efpb.getOtherParams();
            copy = IDPrefix != -1 ? new ExternalFunctionProgramBlockCP(prog, tmp1, tmp2, tmp3, ProgramConverter.saveReplaceFilenameThreadID(efpb.getBaseDir(), CP_CHILD_THREAD + IDPrefix, CP_CHILD_THREAD + pid)) : new ExternalFunctionProgramBlockCP(prog, tmp1, tmp2, tmp3, ProgramConverter.saveReplaceFilenameThreadID(efpb.getBaseDir(), CP_ROOT_THREAD_ID, CP_CHILD_THREAD + pid));
        } else if (fpb instanceof ExternalFunctionProgramBlock) {
            ExternalFunctionProgramBlock efpb = (ExternalFunctionProgramBlock)fpb;
            HashMap<String, String> tmp3 = efpb.getOtherParams();
            copy = IDPrefix != -1 ? new ExternalFunctionProgramBlock(prog, tmp1, tmp2, tmp3, ProgramConverter.saveReplaceFilenameThreadID(efpb.getBaseDir(), CP_CHILD_THREAD + IDPrefix, CP_CHILD_THREAD + pid)) : new ExternalFunctionProgramBlock(prog, tmp1, tmp2, tmp3, ProgramConverter.saveReplaceFilenameThreadID(efpb.getBaseDir(), CP_ROOT_THREAD_ID, CP_CHILD_THREAD + pid));
        } else if (!fnStack.contains(fnameNewKey)) {
            fnStack.add(fnameNewKey);
            copy = new FunctionProgramBlock(prog, tmp1, tmp2);
            copy.setChildBlocks(ProgramConverter.rcreateDeepCopyProgramBlocks(fpb.getChildBlocks(), pid, IDPrefix, fnStack, fnCreated, plain, fpb.isRecompileOnce()));
            copy.setRecompileOnce(fpb.isRecompileOnce());
            copy.setThreadID(pid);
            fnStack.remove(fnameNewKey);
        } else {
            copy = fpb;
        }
        prog.addFunctionProgramBlock(namespace, fnameNew, copy);
        fnCreated.add(DMLProgram.constructFunctionKey(namespace, fnameNew));
    }

    public static FunctionProgramBlock createDeepCopyFunctionProgramBlock(FunctionProgramBlock fpb, HashSet<String> fnStack, HashSet<String> fnCreated) throws DMLRuntimeException {
        if (fpb == null) {
            throw new DMLRuntimeException("Unable to create a deep copy of a non-existing FunctionProgramBlock.");
        }
        FunctionProgramBlock copy = null;
        ArrayList<DataIdentifier> tmp1 = new ArrayList<DataIdentifier>();
        ArrayList<DataIdentifier> tmp2 = new ArrayList<DataIdentifier>();
        if (fpb.getInputParams() != null) {
            tmp1.addAll(fpb.getInputParams());
        }
        if (fpb.getOutputParams() != null) {
            tmp2.addAll(fpb.getOutputParams());
        }
        copy = new FunctionProgramBlock(fpb.getProgram(), tmp1, tmp2);
        copy.setChildBlocks(ProgramConverter.rcreateDeepCopyProgramBlocks(fpb.getChildBlocks(), 0L, -1, fnStack, fnCreated, true, fpb.isRecompileOnce()));
        copy.setStatementBlock(fpb.getStatementBlock());
        copy.setRecompileOnce(fpb.isRecompileOnce());
        return copy;
    }

    public static ArrayList<Instruction> createDeepCopyInstructionSet(ArrayList<Instruction> instSet, long pid, int IDPrefix, Program prog, HashSet<String> fnStack, HashSet<String> fnCreated, boolean plain, boolean cpFunctions) throws DMLRuntimeException {
        ArrayList<Instruction> tmp = new ArrayList<Instruction>();
        for (Instruction inst : instSet) {
            if (inst instanceof FunctionCallCPInstruction && cpFunctions) {
                FunctionCallCPInstruction finst = (FunctionCallCPInstruction)inst;
                ProgramConverter.createDeepCopyFunctionProgramBlock(finst.getNamespace(), finst.getFunctionName(), pid, IDPrefix, prog, fnStack, fnCreated, plain);
            }
            tmp.add(ProgramConverter.cloneInstruction(inst, pid, plain, cpFunctions));
        }
        return tmp;
    }

    public static Instruction cloneInstruction(Instruction oInst, long pid, boolean plain, boolean cpFunctions) throws DMLRuntimeException {
        Instruction inst;
        block6: {
            inst = null;
            String tmpString = oInst.toString();
            try {
                if (oInst instanceof CPInstruction || oInst instanceof SPInstruction || oInst instanceof MRInstruction || oInst instanceof GPUInstruction) {
                    if (oInst instanceof FunctionCallCPInstruction && cpFunctions) {
                        FunctionCallCPInstruction tmp = (FunctionCallCPInstruction)oInst;
                        if (!plain) {
                            tmpString = tmp.updateInstStringFunctionName(tmp.getFunctionName(), tmp.getFunctionName() + CP_CHILD_THREAD + pid);
                        }
                    }
                    inst = InstructionParser.parseSingleInstruction(tmpString);
                    break block6;
                }
                if (oInst instanceof MRJobInstruction) {
                    inst = new MRJobInstruction((MRJobInstruction)oInst);
                    break block6;
                }
                throw new DMLRuntimeException("Failed to clone instruction: " + oInst);
            }
            catch (Exception ex) {
                throw new DMLRuntimeException(ex);
            }
        }
        inst = ProgramConverter.saveReplaceThreadID(inst, CP_ROOT_THREAD_ID, CP_CHILD_THREAD + pid);
        return inst;
    }

    public static StatementBlock createStatementBlockCopy(StatementBlock sb, long pid, boolean plain, boolean forceDeepCopy) throws DMLRuntimeException {
        StatementBlock ret = null;
        try {
            if (ConfigurationManager.getCompilerConfigFlag(CompilerConfig.ConfigType.ALLOW_PARALLEL_DYN_RECOMPILATION) && sb != null && (Recompiler.requiresRecompilation(sb.get_hops()) || forceDeepCopy)) {
                ret = new StatementBlock();
                ret.setDMLProg(sb.getDMLProg());
                ret.setParseInfo(sb);
                ret.setLiveIn(sb.liveIn());
                ret.setLiveOut(sb.liveOut());
                ret.setUpdatedVariables(sb.variablesUpdated());
                ret.setReadVariables(sb.variablesRead());
                ArrayList<Hop> hops = Recompiler.deepCopyHopsDag(sb.get_hops());
                if (!plain) {
                    Recompiler.updateFunctionNames(hops, pid);
                }
                ret.set_hops(hops);
                ret.updateRecompilationFlag();
            } else {
                ret = sb;
            }
        }
        catch (Exception ex) {
            throw new DMLRuntimeException(ex);
        }
        return ret;
    }

    public static IfStatementBlock createIfStatementBlockCopy(IfStatementBlock sb, long pid, boolean plain, boolean forceDeepCopy) throws DMLRuntimeException {
        IfStatementBlock ret = null;
        try {
            if (ConfigurationManager.getCompilerConfigFlag(CompilerConfig.ConfigType.ALLOW_PARALLEL_DYN_RECOMPILATION) && sb != null && (Recompiler.requiresRecompilation(sb.getPredicateHops()) || forceDeepCopy)) {
                ret = new IfStatementBlock();
                ret.setDMLProg(sb.getDMLProg());
                ret.setParseInfo(sb);
                ret.setLiveIn(sb.liveIn());
                ret.setLiveOut(sb.liveOut());
                ret.setUpdatedVariables(sb.variablesUpdated());
                ret.setReadVariables(sb.variablesRead());
                ret.setStatements(sb.getStatements());
                Hop hops = Recompiler.deepCopyHopsDag(sb.getPredicateHops());
                ret.setPredicateHops(hops);
                ret.updatePredicateRecompilationFlag();
            } else {
                ret = sb;
            }
        }
        catch (Exception ex) {
            throw new DMLRuntimeException(ex);
        }
        return ret;
    }

    public static WhileStatementBlock createWhileStatementBlockCopy(WhileStatementBlock sb, long pid, boolean plain, boolean forceDeepCopy) throws DMLRuntimeException {
        WhileStatementBlock ret = null;
        try {
            if (ConfigurationManager.getCompilerConfigFlag(CompilerConfig.ConfigType.ALLOW_PARALLEL_DYN_RECOMPILATION) && sb != null && (Recompiler.requiresRecompilation(sb.getPredicateHops()) || forceDeepCopy)) {
                ret = new WhileStatementBlock();
                ret.setDMLProg(sb.getDMLProg());
                ret.setParseInfo(sb);
                ret.setLiveIn(sb.liveIn());
                ret.setLiveOut(sb.liveOut());
                ret.setUpdatedVariables(sb.variablesUpdated());
                ret.setReadVariables(sb.variablesRead());
                ret.setUpdateInPlaceVars(sb.getUpdateInPlaceVars());
                ret.setStatements(sb.getStatements());
                Hop hops = Recompiler.deepCopyHopsDag(sb.getPredicateHops());
                ret.setPredicateHops(hops);
                ret.updatePredicateRecompilationFlag();
            } else {
                ret = sb;
            }
        }
        catch (Exception ex) {
            throw new DMLRuntimeException(ex);
        }
        return ret;
    }

    public static ForStatementBlock createForStatementBlockCopy(ForStatementBlock sb, long pid, boolean plain, boolean forceDeepCopy) throws DMLRuntimeException {
        ForStatementBlock ret = null;
        try {
            if (ConfigurationManager.getCompilerConfigFlag(CompilerConfig.ConfigType.ALLOW_PARALLEL_DYN_RECOMPILATION) && sb != null && (Recompiler.requiresRecompilation(sb.getFromHops()) || Recompiler.requiresRecompilation(sb.getToHops()) || Recompiler.requiresRecompilation(sb.getIncrementHops()) || forceDeepCopy)) {
                Hop hops;
                ret = sb instanceof ParForStatementBlock ? new ParForStatementBlock() : new ForStatementBlock();
                ret.setDMLProg(sb.getDMLProg());
                ret.setParseInfo(sb);
                ret.setLiveIn(sb.liveIn());
                ret.setLiveOut(sb.liveOut());
                ret.setUpdatedVariables(sb.variablesUpdated());
                ret.setReadVariables(sb.variablesRead());
                ret.setUpdateInPlaceVars(sb.getUpdateInPlaceVars());
                ret.setStatements(sb.getStatements());
                if (sb.requiresFromRecompilation()) {
                    hops = Recompiler.deepCopyHopsDag(sb.getFromHops());
                    ret.setFromHops(hops);
                }
                if (sb.requiresToRecompilation()) {
                    hops = Recompiler.deepCopyHopsDag(sb.getToHops());
                    ret.setToHops(hops);
                }
                if (sb.requiresIncrementRecompilation()) {
                    hops = Recompiler.deepCopyHopsDag(sb.getIncrementHops());
                    ret.setIncrementHops(hops);
                }
                ret.updatePredicateRecompilationFlags();
            } else {
                ret = sb;
            }
        }
        catch (Exception ex) {
            throw new DMLRuntimeException(ex);
        }
        return ret;
    }

    public static String serializeParForBody(ParForBody body) throws DMLRuntimeException {
        return ProgramConverter.serializeParForBody(body, new HashMap<String, byte[]>());
    }

    public static String serializeParForBody(ParForBody body, HashMap<String, byte[]> clsMap) throws DMLRuntimeException {
        ArrayList<ProgramBlock> pbs = body.getChildBlocks();
        ArrayList<String> rVnames = body.getResultVarNames();
        ExecutionContext ec = body.getEc();
        if (pbs.isEmpty()) {
            return "<![CDATA[PARFORBODY\u23a8\u23ac ]]>";
        }
        Program prog = pbs.get(0).getProgram();
        StringBuilder sb = new StringBuilder();
        sb.append(PARFORBODY_BEGIN);
        sb.append(NEWLINE);
        sb.append(DMLScript.getUUID());
        sb.append(COMPONENTS_DELIM);
        sb.append(NEWLINE);
        sb.append(ConfigurationManager.getDMLConfig().serializeDMLConfig());
        sb.append(COMPONENTS_DELIM);
        sb.append(NEWLINE);
        sb.append("stats=" + DMLScript.STATISTICS);
        sb.append(COMPONENTS_DELIM);
        sb.append(NEWLINE);
        sb.append(PARFOR_PROG_BEGIN);
        sb.append(NEWLINE);
        sb.append(ProgramConverter.serializeProgram(prog, pbs, clsMap));
        sb.append("\u23ac");
        sb.append(NEWLINE);
        sb.append(COMPONENTS_DELIM);
        sb.append(NEWLINE);
        sb.append(ProgramConverter.serializeStringArrayList(rVnames));
        sb.append(COMPONENTS_DELIM);
        sb.append(PARFOR_EC_BEGIN);
        sb.append(ProgramConverter.serializeExecutionContext(ec));
        sb.append("");
        sb.append(NEWLINE);
        sb.append(COMPONENTS_DELIM);
        sb.append(NEWLINE);
        sb.append(PARFOR_PBS_BEGIN);
        sb.append(NEWLINE);
        sb.append(ProgramConverter.rSerializeProgramBlocks(pbs, clsMap));
        sb.append("\u23ac");
        sb.append(NEWLINE);
        sb.append(PARFORBODY_END);
        return sb.toString();
    }

    private static String serializeProgram(Program prog, ArrayList<ProgramBlock> pbs, HashMap<String, byte[]> clsMap) throws DMLRuntimeException {
        HashMap<String, FunctionProgramBlock> fpb = prog.getFunctionProgramBlocks();
        HashSet<String> cand = new HashSet<String>();
        ProgramConverter.rFindSerializationCandidates(pbs, cand);
        return ProgramConverter.rSerializeFunctionProgramBlocks(fpb, cand, clsMap);
    }

    private static void rFindSerializationCandidates(ArrayList<ProgramBlock> pbs, HashSet<String> cand) throws DMLRuntimeException {
        for (ProgramBlock pb : pbs) {
            if (pb instanceof WhileProgramBlock) {
                WhileProgramBlock wpb = (WhileProgramBlock)pb;
                ProgramConverter.rFindSerializationCandidates(wpb.getChildBlocks(), cand);
                continue;
            }
            if (pb instanceof ForProgramBlock || pb instanceof ParForProgramBlock) {
                ForProgramBlock fpb = (ForProgramBlock)pb;
                ProgramConverter.rFindSerializationCandidates(fpb.getChildBlocks(), cand);
                continue;
            }
            if (pb instanceof IfProgramBlock) {
                IfProgramBlock ipb = (IfProgramBlock)pb;
                ProgramConverter.rFindSerializationCandidates(ipb.getChildBlocksIfBody(), cand);
                if (ipb.getChildBlocksElseBody() == null) continue;
                ProgramConverter.rFindSerializationCandidates(ipb.getChildBlocksElseBody(), cand);
                continue;
            }
            for (Instruction inst : pb.getInstructions()) {
                FunctionCallCPInstruction fci;
                String fkey;
                if (!(inst instanceof FunctionCallCPInstruction) || cand.contains(fkey = DMLProgram.constructFunctionKey((fci = (FunctionCallCPInstruction)inst).getNamespace(), fci.getFunctionName()))) continue;
                cand.add(fkey);
                FunctionProgramBlock fpb = pb.getProgram().getFunctionProgramBlock(fci.getNamespace(), fci.getFunctionName());
                ProgramConverter.rFindSerializationCandidates(fpb.getChildBlocks(), cand);
            }
        }
    }

    private static String serializeVariables(LocalVariableMap vars) throws DMLRuntimeException {
        StringBuilder sb = new StringBuilder();
        sb.append(PARFOR_VARS_BEGIN);
        sb.append(vars.serialize());
        sb.append("");
        return sb.toString();
    }

    public static String serializeDataObject(String key, Data dat) throws DMLRuntimeException {
        StringBuilder sb = new StringBuilder();
        String name = key;
        Expression.DataType datatype = dat.getDataType();
        Expression.ValueType valuetype = dat.getValueType();
        String value = null;
        String[] matrixMetaData = null;
        switch (datatype) {
            case SCALAR: {
                ScalarObject so = (ScalarObject)dat;
                value = so.getStringValue();
                break;
            }
            case MATRIX: {
                MatrixObject mo = (MatrixObject)dat;
                MatrixFormatMetaData md = (MatrixFormatMetaData)dat.getMetaData();
                MatrixCharacteristics mc = md.getMatrixCharacteristics();
                value = mo.getFileName();
                ParForProgramBlock.PartitionFormat partFormat = mo.getPartitionFormat() != null ? new ParForProgramBlock.PartitionFormat(mo.getPartitionFormat(), mo.getPartitionSize()) : ParForProgramBlock.PartitionFormat.NONE;
                matrixMetaData = new String[]{String.valueOf(mc.getRows()), String.valueOf(mc.getCols()), String.valueOf(mc.getRowsPerBlock()), String.valueOf(mc.getColsPerBlock()), String.valueOf(mc.getNonZeros()), InputInfo.inputInfoToString(md.getInputInfo()), OutputInfo.outputInfoToString(md.getOutputInfo()), String.valueOf(partFormat), String.valueOf((Object)mo.getUpdateType())};
                break;
            }
            default: {
                throw new DMLRuntimeException("Unable to serialize datatype " + (Object)((Object)datatype));
            }
        }
        sb.append(name);
        sb.append(DATA_FIELD_DELIM);
        sb.append((Object)datatype);
        sb.append(DATA_FIELD_DELIM);
        sb.append((Object)valuetype);
        sb.append(DATA_FIELD_DELIM);
        sb.append(value);
        if (matrixMetaData != null) {
            for (int i = 0; i < matrixMetaData.length; ++i) {
                sb.append(DATA_FIELD_DELIM);
                sb.append(matrixMetaData[i]);
            }
        }
        return sb.toString();
    }

    private static String serializeExecutionContext(ExecutionContext ec) throws DMLRuntimeException {
        return ec != null ? ProgramConverter.serializeVariables(ec.getVariables()) : EMPTY;
    }

    private static String serializeInstructions(ArrayList<Instruction> inst, HashMap<String, byte[]> clsMap) throws DMLRuntimeException {
        StringBuilder sb = new StringBuilder();
        int count = 0;
        for (Instruction linst : inst) {
            if (!(linst instanceof CPInstruction) && !(linst instanceof ExternalFunctionInvocationInstruction)) {
                throw new DMLRuntimeException("Not supported: Instructions of type other than CP instructions " + linst.getClass().getName() + NEWLINE + linst);
            }
            if (linst instanceof SpoofCPInstruction) {
                Class<?> cla = ((SpoofCPInstruction)linst).getOperatorClass();
                clsMap.put(cla.getName(), CodegenUtils.getClassData(cla.getName()));
            }
            if (count > 0) {
                sb.append(ELEMENT_DELIM);
            }
            sb.append(ProgramConverter.checkAndReplaceLiterals(linst.toString()));
            ++count;
        }
        return sb.toString();
    }

    private static String checkAndReplaceLiterals(String instStr) {
        String tmp = instStr;
        if (tmp.contains(COMPONENTS_DELIM)) {
            tmp = tmp.replaceAll(COMPONENTS_DELIM, ".");
            LOG.warn((Object)"Replaced special literal character sequence \u236e with '.'");
        }
        if (tmp.contains(ELEMENT_DELIM)) {
            tmp = tmp.replaceAll(ELEMENT_DELIM, ".");
            LOG.warn((Object)"Replaced special literal character sequence \u236a with '.'");
        }
        if (tmp.contains(LEVELIN)) {
            tmp = tmp.replaceAll(LEVELIN, "(");
            LOG.warn((Object)"Replaced special literal character sequence \u23a8 with '('");
        }
        if (tmp.contains("\u23ac")) {
            tmp = tmp.replaceAll("\u23ac", ")");
            LOG.warn((Object)"Replaced special literal character sequence \u23ac with ')'");
        }
        if (tmp.contains(PARFOR_CDATA_END)) {
            tmp = tmp.replaceAll(PARFOR_CDATA_END, ".");
            LOG.warn((Object)"Replaced special literal character sequence  ]]> with '.'");
        }
        return tmp;
    }

    private static String serializeStringHashMap(HashMap<String, String> vars) {
        StringBuilder sb = new StringBuilder();
        int count = 0;
        for (Map.Entry<String, String> e : vars.entrySet()) {
            if (count > 0) {
                sb.append(ELEMENT_DELIM);
            }
            sb.append(e.getKey());
            sb.append(KEY_VALUE_DELIM);
            sb.append(e.getValue());
            ++count;
        }
        return sb.toString();
    }

    public static String serializeStringCollection(Collection<String> set) {
        StringBuilder sb = new StringBuilder();
        int count = 0;
        for (String s : set) {
            if (count > 0) {
                sb.append(", ");
            }
            sb.append(s);
            ++count;
        }
        return sb.toString();
    }

    public static String serializeStringArrayList(ArrayList<String> vars) {
        StringBuilder sb = new StringBuilder();
        int count = 0;
        for (String s : vars) {
            if (count > 0) {
                sb.append(ELEMENT_DELIM);
            }
            sb.append(s);
            ++count;
        }
        return sb.toString();
    }

    private static String serializeDataIdentifiers(ArrayList<DataIdentifier> var) {
        StringBuilder sb = new StringBuilder();
        int count = 0;
        for (DataIdentifier dat : var) {
            if (count > 0) {
                sb.append(ELEMENT_DELIM);
            }
            sb.append(ProgramConverter.serializeDataIdentifier(dat));
            ++count;
        }
        return sb.toString();
    }

    private static String serializeDataIdentifier(DataIdentifier dat) {
        StringBuilder sb = new StringBuilder();
        sb.append(dat.getName());
        sb.append(DATA_FIELD_DELIM);
        sb.append((Object)dat.getDataType());
        sb.append(DATA_FIELD_DELIM);
        sb.append((Object)dat.getValueType());
        return sb.toString();
    }

    private static String rSerializeFunctionProgramBlocks(HashMap<String, FunctionProgramBlock> pbs, HashSet<String> cand, HashMap<String, byte[]> clsMap) throws DMLRuntimeException {
        StringBuilder sb = new StringBuilder();
        int count = 0;
        for (Map.Entry<String, FunctionProgramBlock> pb : pbs.entrySet()) {
            if (!cand.contains(pb.getKey())) continue;
            if (count > 0) {
                sb.append(ELEMENT_DELIM);
                sb.append(NEWLINE);
            }
            sb.append(pb.getKey());
            sb.append(KEY_VALUE_DELIM);
            sb.append(ProgramConverter.rSerializeProgramBlock(pb.getValue(), clsMap));
            ++count;
        }
        sb.append(NEWLINE);
        return sb.toString();
    }

    private static String rSerializeProgramBlocks(ArrayList<ProgramBlock> pbs, HashMap<String, byte[]> clsMap) throws DMLRuntimeException {
        StringBuilder sb = new StringBuilder();
        int count = 0;
        for (ProgramBlock pb : pbs) {
            if (count > 0) {
                sb.append(ELEMENT_DELIM);
                sb.append(NEWLINE);
            }
            sb.append(ProgramConverter.rSerializeProgramBlock(pb, clsMap));
            ++count;
        }
        return sb.toString();
    }

    private static String rSerializeProgramBlock(ProgramBlock pb, HashMap<String, byte[]> clsMap) throws DMLRuntimeException {
        StringBuilder sb = new StringBuilder();
        if (pb instanceof WhileProgramBlock) {
            sb.append(PARFOR_PB_WHILE);
        } else if (pb instanceof ForProgramBlock && !(pb instanceof ParForProgramBlock)) {
            sb.append(PARFOR_PB_FOR);
        } else if (pb instanceof ParForProgramBlock) {
            sb.append(PARFOR_PB_PARFOR);
        } else if (pb instanceof IfProgramBlock) {
            sb.append(PARFOR_PB_IF);
        } else if (pb instanceof FunctionProgramBlock && !(pb instanceof ExternalFunctionProgramBlock)) {
            sb.append(PARFOR_PB_FC);
        } else if (pb instanceof ExternalFunctionProgramBlock) {
            sb.append(PARFOR_PB_EFC);
        } else {
            sb.append(PARFOR_PB_BEGIN);
        }
        if (pb instanceof WhileProgramBlock) {
            WhileProgramBlock wpb = (WhileProgramBlock)pb;
            sb.append(PARFOR_INST_BEGIN);
            sb.append(ProgramConverter.serializeInstructions(wpb.getPredicate(), clsMap));
            sb.append("");
            sb.append(COMPONENTS_DELIM);
            sb.append(PARFOR_INST_BEGIN);
            sb.append(ProgramConverter.serializeInstructions(wpb.getExitInstructions(), clsMap));
            sb.append("");
            sb.append(COMPONENTS_DELIM);
            sb.append(PARFOR_PBS_BEGIN);
            sb.append(ProgramConverter.rSerializeProgramBlocks(wpb.getChildBlocks(), clsMap));
            sb.append("\u23ac");
        } else if (pb instanceof ForProgramBlock && !(pb instanceof ParForProgramBlock)) {
            ForProgramBlock fpb = (ForProgramBlock)pb;
            sb.append(fpb.getIterVar());
            sb.append(COMPONENTS_DELIM);
            sb.append(PARFOR_INST_BEGIN);
            sb.append(ProgramConverter.serializeInstructions(fpb.getFromInstructions(), clsMap));
            sb.append("");
            sb.append(COMPONENTS_DELIM);
            sb.append(PARFOR_INST_BEGIN);
            sb.append(ProgramConverter.serializeInstructions(fpb.getToInstructions(), clsMap));
            sb.append("");
            sb.append(COMPONENTS_DELIM);
            sb.append(PARFOR_INST_BEGIN);
            sb.append(ProgramConverter.serializeInstructions(fpb.getIncrementInstructions(), clsMap));
            sb.append("");
            sb.append(COMPONENTS_DELIM);
            sb.append(PARFOR_INST_BEGIN);
            sb.append(ProgramConverter.serializeInstructions(fpb.getExitInstructions(), clsMap));
            sb.append("");
            sb.append(COMPONENTS_DELIM);
            sb.append(PARFOR_PBS_BEGIN);
            sb.append(ProgramConverter.rSerializeProgramBlocks(fpb.getChildBlocks(), clsMap));
            sb.append("\u23ac");
        } else if (pb instanceof ParForProgramBlock) {
            ParForProgramBlock pfpb = (ParForProgramBlock)pb;
            if (ParForProgramBlock.PExecMode.valueOf(pfpb.getParForParams().get("mode")) == ParForProgramBlock.PExecMode.REMOTE_MR) {
                throw new DMLRuntimeException(NOT_SUPPORTED_MR_PARFOR);
            }
            sb.append(pfpb.getIterVar());
            sb.append(COMPONENTS_DELIM);
            sb.append(ProgramConverter.serializeStringArrayList(pfpb.getResultVariables()));
            sb.append(COMPONENTS_DELIM);
            sb.append(ProgramConverter.serializeStringHashMap(pfpb.getParForParams()));
            sb.append(COMPONENTS_DELIM);
            sb.append(PARFOR_INST_BEGIN);
            sb.append(ProgramConverter.serializeInstructions(pfpb.getFromInstructions(), clsMap));
            sb.append("");
            sb.append(COMPONENTS_DELIM);
            sb.append(PARFOR_INST_BEGIN);
            sb.append(ProgramConverter.serializeInstructions(pfpb.getToInstructions(), clsMap));
            sb.append("");
            sb.append(COMPONENTS_DELIM);
            sb.append(PARFOR_INST_BEGIN);
            sb.append(ProgramConverter.serializeInstructions(pfpb.getIncrementInstructions(), clsMap));
            sb.append("");
            sb.append(COMPONENTS_DELIM);
            sb.append(PARFOR_INST_BEGIN);
            sb.append(ProgramConverter.serializeInstructions(pfpb.getExitInstructions(), clsMap));
            sb.append("");
            sb.append(COMPONENTS_DELIM);
            sb.append(PARFOR_PBS_BEGIN);
            sb.append(ProgramConverter.rSerializeProgramBlocks(pfpb.getChildBlocks(), clsMap));
            sb.append("\u23ac");
        } else if (pb instanceof IfProgramBlock) {
            IfProgramBlock ipb = (IfProgramBlock)pb;
            sb.append(PARFOR_INST_BEGIN);
            sb.append(ProgramConverter.serializeInstructions(ipb.getPredicate(), clsMap));
            sb.append("");
            sb.append(COMPONENTS_DELIM);
            sb.append(PARFOR_INST_BEGIN);
            sb.append(ProgramConverter.serializeInstructions(ipb.getExitInstructions(), clsMap));
            sb.append("");
            sb.append(COMPONENTS_DELIM);
            sb.append(PARFOR_PBS_BEGIN);
            sb.append(ProgramConverter.rSerializeProgramBlocks(ipb.getChildBlocksIfBody(), clsMap));
            sb.append("\u23ac");
            sb.append(COMPONENTS_DELIM);
            sb.append(PARFOR_PBS_BEGIN);
            sb.append(ProgramConverter.rSerializeProgramBlocks(ipb.getChildBlocksElseBody(), clsMap));
            sb.append("\u23ac");
        } else if (pb instanceof FunctionProgramBlock && !(pb instanceof ExternalFunctionProgramBlock)) {
            FunctionProgramBlock fpb = (FunctionProgramBlock)pb;
            sb.append(ProgramConverter.serializeDataIdentifiers(fpb.getInputParams()));
            sb.append(COMPONENTS_DELIM);
            sb.append(ProgramConverter.serializeDataIdentifiers(fpb.getOutputParams()));
            sb.append(COMPONENTS_DELIM);
            sb.append(PARFOR_INST_BEGIN);
            sb.append(ProgramConverter.serializeInstructions(fpb.getInstructions(), clsMap));
            sb.append("");
            sb.append(COMPONENTS_DELIM);
            sb.append(PARFOR_PBS_BEGIN);
            sb.append(ProgramConverter.rSerializeProgramBlocks(fpb.getChildBlocks(), clsMap));
            sb.append("\u23ac");
            sb.append(COMPONENTS_DELIM);
        } else if (pb instanceof ExternalFunctionProgramBlock) {
            if (!(pb instanceof ExternalFunctionProgramBlockCP)) {
                throw new DMLRuntimeException(NOT_SUPPORTED_EXTERNALFUNCTION_PB);
            }
            ExternalFunctionProgramBlockCP fpb = (ExternalFunctionProgramBlockCP)pb;
            sb.append(ProgramConverter.serializeDataIdentifiers(fpb.getInputParams()));
            sb.append(COMPONENTS_DELIM);
            sb.append(ProgramConverter.serializeDataIdentifiers(fpb.getOutputParams()));
            sb.append(COMPONENTS_DELIM);
            sb.append(ProgramConverter.serializeStringHashMap(fpb.getOtherParams()));
            sb.append(COMPONENTS_DELIM);
            sb.append(fpb.getBaseDir());
            sb.append(COMPONENTS_DELIM);
            sb.append(PARFOR_INST_BEGIN);
            sb.append("");
            sb.append(COMPONENTS_DELIM);
            sb.append(PARFOR_PBS_BEGIN);
            sb.append(ProgramConverter.rSerializeProgramBlocks(fpb.getChildBlocks(), clsMap));
            sb.append("\u23ac");
        } else {
            sb.append(PARFOR_INST_BEGIN);
            sb.append(ProgramConverter.serializeInstructions(pb.getInstructions(), clsMap));
            sb.append("");
        }
        sb.append("\u23ac");
        return sb.toString();
    }

    public static ParForBody parseParForBody(String in, int id) throws DMLRuntimeException {
        ParForBody body = new ParForBody();
        String tmpin = in.replaceAll(NEWLINE, "");
        tmpin = tmpin.substring(PARFORBODY_BEGIN.length(), tmpin.length() - PARFORBODY_END.length());
        HierarchyAwareStringTokenizer st = new HierarchyAwareStringTokenizer(tmpin, COMPONENTS_DELIM);
        DMLScript.setUUID(st.nextToken());
        String confStr = st.nextToken();
        JobConf job = ConfigurationManager.getCachedJobConf();
        if (!InfrastructureAnalyzer.isLocalMode(job)) {
            if (confStr != null && !confStr.trim().isEmpty()) {
                DMLConfig dmlconf = DMLConfig.parseDMLConfig(confStr);
                CompilerConfig cconf = OptimizerUtils.constructCompilerConfig(dmlconf);
                ConfigurationManager.setLocalConfig(dmlconf);
                ConfigurationManager.setLocalConfig(cconf);
            }
            ParForProgramBlock.initInternalConfigurations(ConfigurationManager.getDMLConfig());
        }
        String aconfs = st.nextToken();
        ProgramConverter.parseAndSetAdditionalConfigurations(aconfs);
        String progStr = st.nextToken();
        Program prog = ProgramConverter.parseProgram(progStr, id);
        String rvarStr = st.nextToken();
        ArrayList<String> rvars = ProgramConverter.parseStringArrayList(rvarStr);
        body.setResultVarNames(rvars);
        String ecStr = st.nextToken();
        ExecutionContext ec = ProgramConverter.parseExecutionContext(ecStr, prog);
        String spbs = st.nextToken();
        ArrayList<ProgramBlock> pbs = ProgramConverter.rParseProgramBlocks(spbs, prog, id);
        body.setChildBlocks(pbs);
        body.setEc(ec);
        return body;
    }

    public static Program parseProgram(String in, int id) throws DMLRuntimeException {
        String lin = in.substring(PARFOR_PROG_BEGIN.length(), in.length() - "\u23ac".length()).trim();
        Program prog = new Program();
        HashMap<String, FunctionProgramBlock> fc = ProgramConverter.parseFunctionProgramBlocks(lin, prog, id);
        for (Map.Entry<String, FunctionProgramBlock> e : fc.entrySet()) {
            String[] keypart = e.getKey().split("::");
            String namespace = keypart[0];
            String name = keypart[1];
            prog.addFunctionProgramBlock(namespace, name, e.getValue());
        }
        return prog;
    }

    private static LocalVariableMap parseVariables(String in) throws DMLRuntimeException {
        LocalVariableMap ret = null;
        if (in.length() > PARFOR_VARS_BEGIN.length() + "".length()) {
            String varStr = in.substring(PARFOR_VARS_BEGIN.length(), in.length() - "".length()).trim();
            ret = LocalVariableMap.deserialize(varStr);
        } else {
            ret = new LocalVariableMap();
        }
        return ret;
    }

    private static HashMap<String, FunctionProgramBlock> parseFunctionProgramBlocks(String in, Program prog, int id) throws DMLRuntimeException {
        HashMap<String, FunctionProgramBlock> ret = new HashMap<String, FunctionProgramBlock>();
        HierarchyAwareStringTokenizer st = new HierarchyAwareStringTokenizer(in, ELEMENT_DELIM);
        while (st.hasMoreTokens()) {
            String lvar = st.nextToken();
            int index = lvar.indexOf(KEY_VALUE_DELIM);
            String tmp1 = lvar.substring(0, index);
            String tmp2 = lvar.substring(index + 1);
            ret.put(tmp1, (FunctionProgramBlock)ProgramConverter.rParseProgramBlock(tmp2, prog, id));
        }
        return ret;
    }

    private static ArrayList<ProgramBlock> rParseProgramBlocks(String in, Program prog, int id) throws DMLRuntimeException {
        ArrayList<ProgramBlock> pbs = new ArrayList<ProgramBlock>();
        String tmpdata = in.substring(PARFOR_PBS_BEGIN.length(), in.length() - "\u23ac".length());
        HierarchyAwareStringTokenizer st = new HierarchyAwareStringTokenizer(tmpdata, ELEMENT_DELIM);
        while (st.hasMoreTokens()) {
            String tmp = st.nextToken();
            pbs.add(ProgramConverter.rParseProgramBlock(tmp, prog, id));
        }
        return pbs;
    }

    private static ProgramBlock rParseProgramBlock(String in, Program prog, int id) throws DMLRuntimeException {
        ProgramBlock pb = null;
        if (in.startsWith(PARFOR_PB_WHILE)) {
            pb = ProgramConverter.rParseWhileProgramBlock(in, prog, id);
        } else if (in.startsWith(PARFOR_PB_FOR)) {
            pb = ProgramConverter.rParseForProgramBlock(in, prog, id);
        } else if (in.startsWith(PARFOR_PB_PARFOR)) {
            pb = ProgramConverter.rParseParForProgramBlock(in, prog, id);
        } else if (in.startsWith(PARFOR_PB_IF)) {
            pb = ProgramConverter.rParseIfProgramBlock(in, prog, id);
        } else if (in.startsWith(PARFOR_PB_FC)) {
            pb = ProgramConverter.rParseFunctionProgramBlock(in, prog, id);
        } else if (in.startsWith(PARFOR_PB_EFC)) {
            pb = ProgramConverter.rParseExternalFunctionProgramBlock(in, prog, id);
        } else if (in.startsWith(PARFOR_PB_BEGIN)) {
            pb = ProgramConverter.rParseGenericProgramBlock(in, prog, id);
        } else {
            throw new DMLRuntimeException("Not supported: type of program block " + in);
        }
        return pb;
    }

    private static WhileProgramBlock rParseWhileProgramBlock(String in, Program prog, int id) throws DMLRuntimeException {
        String lin = in.substring(PARFOR_PB_WHILE.length(), in.length() - "\u23ac".length());
        HierarchyAwareStringTokenizer st = new HierarchyAwareStringTokenizer(lin, COMPONENTS_DELIM);
        ArrayList<Instruction> inst = ProgramConverter.parseInstructions(st.nextToken(), id);
        ArrayList<Instruction> exit = ProgramConverter.parseInstructions(st.nextToken(), id);
        ArrayList<ProgramBlock> pbs = ProgramConverter.rParseProgramBlocks(st.nextToken(), prog, id);
        WhileProgramBlock wpb = new WhileProgramBlock(prog, inst);
        wpb.setExitInstructions2(exit);
        wpb.setChildBlocks(pbs);
        return wpb;
    }

    private static ForProgramBlock rParseForProgramBlock(String in, Program prog, int id) throws DMLRuntimeException {
        String lin = in.substring(PARFOR_PB_FOR.length(), in.length() - "\u23ac".length());
        HierarchyAwareStringTokenizer st = new HierarchyAwareStringTokenizer(lin, COMPONENTS_DELIM);
        String iterVar = st.nextToken();
        ArrayList<Instruction> from = ProgramConverter.parseInstructions(st.nextToken(), id);
        ArrayList<Instruction> to = ProgramConverter.parseInstructions(st.nextToken(), id);
        ArrayList<Instruction> incr = ProgramConverter.parseInstructions(st.nextToken(), id);
        ArrayList<Instruction> exit = ProgramConverter.parseInstructions(st.nextToken(), id);
        ArrayList<ProgramBlock> pbs = ProgramConverter.rParseProgramBlocks(st.nextToken(), prog, id);
        ForProgramBlock fpb = new ForProgramBlock(prog, iterVar);
        fpb.setFromInstructions(from);
        fpb.setToInstructions(to);
        fpb.setIncrementInstructions(incr);
        fpb.setExitInstructions(exit);
        fpb.setChildBlocks(pbs);
        return fpb;
    }

    private static ParForProgramBlock rParseParForProgramBlock(String in, Program prog, int id) throws DMLRuntimeException {
        String lin = in.substring(PARFOR_PB_PARFOR.length(), in.length() - "\u23ac".length());
        HierarchyAwareStringTokenizer st = new HierarchyAwareStringTokenizer(lin, COMPONENTS_DELIM);
        String iterVar = st.nextToken();
        ArrayList<String> resultVars = ProgramConverter.parseStringArrayList(st.nextToken());
        HashMap<String, String> params = ProgramConverter.parseStringHashMap(st.nextToken());
        ArrayList<Instruction> from = ProgramConverter.parseInstructions(st.nextToken(), 0);
        ArrayList<Instruction> to = ProgramConverter.parseInstructions(st.nextToken(), 0);
        ArrayList<Instruction> incr = ProgramConverter.parseInstructions(st.nextToken(), 0);
        ArrayList<Instruction> exit = ProgramConverter.parseInstructions(st.nextToken(), 0);
        ArrayList<ProgramBlock> pbs = ProgramConverter.rParseProgramBlocks(st.nextToken(), prog, 0);
        ParForProgramBlock pfpb = new ParForProgramBlock(id, prog, iterVar, params, resultVars);
        pfpb.disableOptimization();
        pfpb.setFromInstructions(from);
        pfpb.setToInstructions(to);
        pfpb.setIncrementInstructions(incr);
        pfpb.setExitInstructions(exit);
        pfpb.setChildBlocks(pbs);
        return pfpb;
    }

    private static IfProgramBlock rParseIfProgramBlock(String in, Program prog, int id) throws DMLRuntimeException {
        String lin = in.substring(PARFOR_PB_IF.length(), in.length() - "\u23ac".length());
        HierarchyAwareStringTokenizer st = new HierarchyAwareStringTokenizer(lin, COMPONENTS_DELIM);
        ArrayList<Instruction> inst = ProgramConverter.parseInstructions(st.nextToken(), id);
        ArrayList<Instruction> exit = ProgramConverter.parseInstructions(st.nextToken(), id);
        ArrayList<ProgramBlock> pbs1 = ProgramConverter.rParseProgramBlocks(st.nextToken(), prog, id);
        ArrayList<ProgramBlock> pbs2 = ProgramConverter.rParseProgramBlocks(st.nextToken(), prog, id);
        IfProgramBlock ipb = new IfProgramBlock(prog, inst);
        ipb.setExitInstructions2(exit);
        ipb.setChildBlocksIfBody(pbs1);
        ipb.setChildBlocksElseBody(pbs2);
        return ipb;
    }

    private static FunctionProgramBlock rParseFunctionProgramBlock(String in, Program prog, int id) throws DMLRuntimeException {
        String lin = in.substring(PARFOR_PB_FC.length(), in.length() - "\u23ac".length());
        HierarchyAwareStringTokenizer st = new HierarchyAwareStringTokenizer(lin, COMPONENTS_DELIM);
        ArrayList<DataIdentifier> dat1 = ProgramConverter.parseDataIdentifiers(st.nextToken());
        ArrayList<DataIdentifier> dat2 = ProgramConverter.parseDataIdentifiers(st.nextToken());
        ArrayList<Instruction> inst = ProgramConverter.parseInstructions(st.nextToken(), id);
        ArrayList<ProgramBlock> pbs = ProgramConverter.rParseProgramBlocks(st.nextToken(), prog, id);
        ArrayList<DataIdentifier> tmp1 = new ArrayList<DataIdentifier>(dat1);
        ArrayList<DataIdentifier> tmp2 = new ArrayList<DataIdentifier>(dat2);
        FunctionProgramBlock fpb = new FunctionProgramBlock(prog, tmp1, tmp2);
        fpb.setInstructions(inst);
        fpb.setChildBlocks(pbs);
        return fpb;
    }

    private static ExternalFunctionProgramBlock rParseExternalFunctionProgramBlock(String in, Program prog, int id) throws DMLRuntimeException {
        String lin = in.substring(PARFOR_PB_EFC.length(), in.length() - "\u23ac".length());
        HierarchyAwareStringTokenizer st = new HierarchyAwareStringTokenizer(lin, COMPONENTS_DELIM);
        ArrayList<DataIdentifier> dat1 = ProgramConverter.parseDataIdentifiers(st.nextToken());
        ArrayList<DataIdentifier> dat2 = ProgramConverter.parseDataIdentifiers(st.nextToken());
        HashMap<String, String> dat3 = ProgramConverter.parseStringHashMap(st.nextToken());
        String basedir = st.nextToken();
        ProgramConverter.parseInstructions(st.nextToken(), id);
        ArrayList<ProgramBlock> pbs = ProgramConverter.rParseProgramBlocks(st.nextToken(), prog, id);
        ArrayList<DataIdentifier> tmp1 = new ArrayList<DataIdentifier>(dat1);
        ArrayList<DataIdentifier> tmp2 = new ArrayList<DataIdentifier>(dat2);
        ExternalFunctionProgramBlockCP efpb = new ExternalFunctionProgramBlockCP(prog, tmp1, tmp2, dat3, basedir);
        efpb.setChildBlocks(pbs);
        return efpb;
    }

    private static ProgramBlock rParseGenericProgramBlock(String in, Program prog, int id) throws DMLRuntimeException {
        String lin = in.substring(PARFOR_PB_BEGIN.length(), in.length() - "\u23ac".length());
        StringTokenizer st = new StringTokenizer(lin, COMPONENTS_DELIM);
        ArrayList<Instruction> inst = ProgramConverter.parseInstructions(st.nextToken(), id);
        ProgramBlock pb = new ProgramBlock(prog);
        pb.setInstructions(inst);
        return pb;
    }

    private static ArrayList<Instruction> parseInstructions(String in, int id) throws DMLRuntimeException {
        ArrayList<Instruction> insts = new ArrayList<Instruction>();
        String lin = in.substring(PARFOR_INST_BEGIN.length(), in.length() - "".length());
        StringTokenizer st = new StringTokenizer(lin, ELEMENT_DELIM);
        while (st.hasMoreTokens()) {
            String instStr = st.nextToken();
            try {
                Instruction tmpinst = CPInstructionParser.parseSingleInstruction(instStr);
                tmpinst = ProgramConverter.saveReplaceThreadID(tmpinst, CP_ROOT_THREAD_ID, CP_CHILD_THREAD + id);
                insts.add(tmpinst);
            }
            catch (Exception ex) {
                throw new DMLRuntimeException("Failed to parse instruction: " + instStr, ex);
            }
        }
        return insts;
    }

    private static HashMap<String, String> parseStringHashMap(String in) {
        HashMap<String, String> vars = new HashMap<String, String>();
        StringTokenizer st = new StringTokenizer(in, ELEMENT_DELIM);
        while (st.hasMoreTokens()) {
            String lin = st.nextToken();
            int index = lin.indexOf(KEY_VALUE_DELIM);
            String tmp1 = lin.substring(0, index);
            String tmp2 = lin.substring(index + 1);
            vars.put(tmp1, tmp2);
        }
        return vars;
    }

    private static ArrayList<String> parseStringArrayList(String in) {
        ArrayList<String> vars = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(in, ELEMENT_DELIM);
        while (st.hasMoreTokens()) {
            String tmp = st.nextToken();
            vars.add(tmp);
        }
        return vars;
    }

    private static ArrayList<DataIdentifier> parseDataIdentifiers(String in) {
        ArrayList<DataIdentifier> vars = new ArrayList<DataIdentifier>();
        StringTokenizer st = new StringTokenizer(in, ELEMENT_DELIM);
        while (st.hasMoreTokens()) {
            String tmp = st.nextToken();
            DataIdentifier dat = ProgramConverter.parseDataIdentifier(tmp);
            vars.add(dat);
        }
        return vars;
    }

    private static DataIdentifier parseDataIdentifier(String in) {
        StringTokenizer st = new StringTokenizer(in, DATA_FIELD_DELIM);
        String name = st.nextToken();
        Expression.DataType dt = Expression.DataType.valueOf(st.nextToken());
        Expression.ValueType vt = Expression.ValueType.valueOf(st.nextToken());
        DataIdentifier dat = new DataIdentifier(name);
        dat.setDataType(dt);
        dat.setValueType(vt);
        return dat;
    }

    public static Object[] parseDataObject(String in) throws DMLRuntimeException {
        Object[] ret = new Object[2];
        StringTokenizer st = new StringTokenizer(in, DATA_FIELD_DELIM);
        String name = st.nextToken();
        Expression.DataType datatype = Expression.DataType.valueOf(st.nextToken());
        Expression.ValueType valuetype = Expression.ValueType.valueOf(st.nextToken());
        String valString = st.hasMoreTokens() ? st.nextToken() : "";
        Data dat = null;
        block0 : switch (datatype) {
            case SCALAR: {
                switch (valuetype) {
                    case INT: {
                        long value1 = Long.parseLong(valString);
                        dat = new IntObject(name, value1);
                        break block0;
                    }
                    case DOUBLE: {
                        double value2 = Double.parseDouble(valString);
                        dat = new DoubleObject(name, value2);
                        break block0;
                    }
                    case BOOLEAN: {
                        boolean value3 = Boolean.parseBoolean(valString);
                        dat = new BooleanObject(name, value3);
                        break block0;
                    }
                    case STRING: {
                        dat = new StringObject(name, valString);
                        break block0;
                    }
                }
                throw new DMLRuntimeException("Unable to parse valuetype " + (Object)((Object)valuetype));
            }
            case MATRIX: {
                MatrixObject mo = new MatrixObject(valuetype, valString);
                long rows = Long.parseLong(st.nextToken());
                long cols = Long.parseLong(st.nextToken());
                int brows = Integer.parseInt(st.nextToken());
                int bcols = Integer.parseInt(st.nextToken());
                long nnz = Long.parseLong(st.nextToken());
                InputInfo iin = InputInfo.stringToInputInfo(st.nextToken());
                OutputInfo oin = OutputInfo.stringToOutputInfo(st.nextToken());
                ParForProgramBlock.PartitionFormat partFormat = ParForProgramBlock.PartitionFormat.valueOf(st.nextToken());
                MatrixObject.UpdateType inplace = MatrixObject.UpdateType.valueOf(st.nextToken());
                MatrixCharacteristics mc = new MatrixCharacteristics(rows, cols, brows, bcols, nnz);
                MatrixFormatMetaData md = new MatrixFormatMetaData(mc, oin, iin);
                mo.setMetaData(md);
                mo.setVarName(name);
                if (partFormat._dpf != ParForProgramBlock.PDataPartitionFormat.NONE) {
                    mo.setPartitioned(partFormat._dpf, partFormat._N);
                }
                mo.setUpdateType(inplace);
                dat = mo;
                break;
            }
            default: {
                throw new DMLRuntimeException("Unable to parse datatype " + (Object)((Object)datatype));
            }
        }
        ret[0] = name;
        ret[1] = dat;
        return ret;
    }

    private static ExecutionContext parseExecutionContext(String in, Program prog) throws DMLRuntimeException {
        ExecutionContext ec = null;
        String lin = in.substring(PARFOR_EC_BEGIN.length(), in.length() - "".length()).trim();
        if (!lin.equals(EMPTY)) {
            LocalVariableMap vars = ProgramConverter.parseVariables(lin);
            ec = ExecutionContextFactory.createContext(false, prog);
            ec.setVariables(vars);
        }
        return ec;
    }

    private static void parseAndSetAdditionalConfigurations(String conf) {
        String[] statsFlag = conf.split(KEY_VALUE_DELIM);
        DMLScript.STATISTICS = Boolean.parseBoolean(statsFlag[1]);
    }

    private static Instruction saveReplaceThreadID(Instruction inst, String pattern, String replacement) throws DMLRuntimeException {
        if (inst instanceof MRJobInstruction) {
            MRJobInstruction mrinst = (MRJobInstruction)inst;
            mrinst.updateInstructionThreadID(pattern, replacement);
        } else if (inst instanceof VariableCPInstruction) {
            inst.updateInstructionThreadID(pattern, replacement);
        }
        return inst;
    }

    public static String saveReplaceFilenameThreadID(String fname, String pattern, String replace) {
        int pos = fname.lastIndexOf(pattern);
        if (pos < 0) {
            return fname;
        }
        return fname.substring(0, pos) + replace + fname.substring(pos + pattern.length());
    }

    private static class HierarchyAwareStringTokenizer {
        private String _str = null;
        private String _del = null;
        private int _off = -1;

        public HierarchyAwareStringTokenizer(String in, String delim) {
            this._str = in;
            this._del = delim;
            this._off = delim.length();
        }

        public boolean hasMoreTokens() {
            return this._str.length() > 0;
        }

        public String nextToken() {
            int nextDelim = this.determineNextSameLevelIndexOf(this._str, this._del);
            String token = null;
            if (nextDelim < 0) {
                nextDelim = this._str.length();
                this._off = 0;
            }
            token = this._str.substring(0, nextDelim);
            this._str = this._str.substring(nextDelim + this._off);
            return token;
        }

        private int determineNextSameLevelIndexOf(String data, String pattern) {
            String tmpdata = data;
            int index = 0;
            int count = 0;
            int off = 0;
            while (true) {
                int i1 = tmpdata.indexOf(pattern);
                int i2 = tmpdata.indexOf(ProgramConverter.LEVELIN);
                int i3 = tmpdata.indexOf("\u23ac");
                if (i1 < 0) {
                    return i1;
                }
                int min = i1;
                if (i2 >= 0) {
                    min = Math.min(min, i2);
                }
                if (i3 >= 0) {
                    min = Math.min(min, i3);
                }
                if (i1 == min && count == 0) {
                    return index + i1;
                }
                if (i2 == min) {
                    ++count;
                    off = ProgramConverter.LEVELIN.length();
                } else if (i3 == min) {
                    --count;
                    off = "\u23ac".length();
                }
                index += min + off;
                tmpdata = tmpdata.substring(min + off);
            }
        }
    }
}

