/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.parser;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysml.conf.ConfigurationManager;
import org.apache.sysml.hops.OptimizerUtils;
import org.apache.sysml.parser.AssignmentStatement;
import org.apache.sysml.parser.BinaryExpression;
import org.apache.sysml.parser.BooleanExpression;
import org.apache.sysml.parser.BuiltinFunctionExpression;
import org.apache.sysml.parser.ConstIdentifier;
import org.apache.sysml.parser.DMLProgram;
import org.apache.sysml.parser.DataIdentifier;
import org.apache.sysml.parser.DoubleIdentifier;
import org.apache.sysml.parser.Expression;
import org.apache.sysml.parser.ForStatement;
import org.apache.sysml.parser.ForStatementBlock;
import org.apache.sysml.parser.FunctionCallIdentifier;
import org.apache.sysml.parser.FunctionStatement;
import org.apache.sysml.parser.FunctionStatementBlock;
import org.apache.sysml.parser.IfStatement;
import org.apache.sysml.parser.IndexedIdentifier;
import org.apache.sysml.parser.IntIdentifier;
import org.apache.sysml.parser.IterablePredicate;
import org.apache.sysml.parser.LanguageException;
import org.apache.sysml.parser.MultiAssignmentStatement;
import org.apache.sysml.parser.ParForStatement;
import org.apache.sysml.parser.ParameterExpression;
import org.apache.sysml.parser.ParameterizedBuiltinFunctionExpression;
import org.apache.sysml.parser.ParseException;
import org.apache.sysml.parser.PrintStatement;
import org.apache.sysml.parser.RelationalExpression;
import org.apache.sysml.parser.Statement;
import org.apache.sysml.parser.StatementBlock;
import org.apache.sysml.parser.VariableSet;
import org.apache.sysml.parser.WhileStatement;
import org.apache.sysml.runtime.controlprogram.ParForProgramBlock;
import org.apache.sysml.runtime.controlprogram.parfor.stat.InfrastructureAnalyzer;
import org.apache.sysml.runtime.controlprogram.parfor.stat.Timing;
import org.apache.sysml.runtime.controlprogram.parfor.util.IDSequence;
import org.apache.sysml.runtime.util.UtilFunctions;
import org.apache.sysml.yarn.ropt.YarnClusterAnalyzer;

public class ParForStatementBlock
extends ForStatementBlock {
    private static final boolean LDEBUG = false;
    private static final Log LOG = LogFactory.getLog((String)ParForStatementBlock.class.getName());
    private static HashSet<String> _paramNames;
    public static final String CHECK = "check";
    public static final String PAR = "par";
    public static final String TASK_PARTITIONER = "taskpartitioner";
    public static final String TASK_SIZE = "tasksize";
    public static final String DATA_PARTITIONER = "datapartitioner";
    public static final String RESULT_MERGE = "resultmerge";
    public static final String EXEC_MODE = "mode";
    public static final String OPT_MODE = "opt";
    public static final String OPT_LOG = "log";
    public static final String PROFILE = "profile";
    private static HashMap<String, String> _paramDefaults;
    private static HashMap<String, String> _paramDefaults2;
    private static final boolean NORMALIZE = false;
    private static final boolean USE_FN_CACHE = false;
    private static final boolean ABORT_ON_FIRST_DEPENDENCY = true;
    private static final boolean CONSERVATIVE_CHECK = false;
    public static final String INTERAL_FN_INDEX_ROW = "__ixr";
    public static final String INTERAL_FN_INDEX_COL = "__ixc";
    private static IDSequence _idSeq;
    private static IDSequence _idSeqfn;
    private static HashMap<String, LinearFunction> _fncache;
    private long _ID = _idSeq.getNextID();
    private VariableSet _vsParent = null;
    private ArrayList<String> _resultVars = new ArrayList();
    private Bounds _bounds = null;

    public ParForStatementBlock() {
        LOG.trace((Object)("PARFOR(" + this._ID + "): ParForStatementBlock instance created"));
    }

    public long getID() {
        return this._ID;
    }

    public ArrayList<String> getResultVariables() {
        return this._resultVars;
    }

    private void addToResultVariablesNoDup(String var) {
        if (!this._resultVars.contains(var)) {
            this._resultVars.add(var);
        }
    }

    @Override
    public VariableSet validate(DMLProgram dmlProg, VariableSet ids, HashMap<String, ConstIdentifier> constVars, boolean conditional) throws LanguageException, ParseException, IOException {
        boolean check;
        LOG.trace((Object)("PARFOR(" + this._ID + "): validating ParForStatementBlock."));
        this._vsParent = new VariableSet(ids);
        if (LOG.isTraceEnabled()) {
            for (DataIdentifier di : this._vsParent.getVariables().values()) {
                LOG.trace((Object)("PARFOR: non-local " + di._name + ": " + di.getDataType().toString() + " with rowDim = " + di.getDim1()));
            }
        }
        VariableSet vs = super.validate(dmlProg, ids, constVars, conditional);
        ParForStatement pfs = (ParForStatement)this._statements.get(0);
        IterablePredicate predicate = pfs.getIterablePredicate();
        HashMap<String, String> params = predicate.getParForParams();
        if (params != null) {
            for (String string : params.keySet()) {
                if (_paramNames.contains(string)) continue;
                this.raiseValidateError("PARFOR: The specified parameter '" + string + "' is no valid parfor parameter.", false);
            }
            boolean constrained = params.containsKey(OPT_MODE) && params.get(OPT_MODE).equals(ParForProgramBlock.POptMode.CONSTRAINED.toString());
            for (String key : _paramNames) {
                if (params.containsKey(key)) continue;
                if (constrained) {
                    params.put(key, _paramDefaults2.get(key));
                    continue;
                }
                if (key.equals(PAR) && params.containsKey(EXEC_MODE) && params.get(EXEC_MODE).equals(ParForProgramBlock.PExecMode.REMOTE_MR.toString())) {
                    int maxPMap = InfrastructureAnalyzer.getRemoteParallelMapTasks();
                    if (InfrastructureAnalyzer.isYarnEnabled()) {
                        maxPMap = (int)Math.max((long)maxPMap, YarnClusterAnalyzer.getNumCores());
                    }
                    params.put(key, String.valueOf(maxPMap));
                    continue;
                }
                if (key.equals(PAR) && params.containsKey(EXEC_MODE) && params.get(EXEC_MODE).equals(ParForProgramBlock.PExecMode.REMOTE_MR_DP.toString())) {
                    int maxPRed = InfrastructureAnalyzer.getRemoteParallelReduceTasks();
                    if (InfrastructureAnalyzer.isYarnEnabled()) {
                        maxPRed = (int)Math.max((long)maxPRed, YarnClusterAnalyzer.getNumCores() / 2L);
                    }
                    params.put(key, String.valueOf(maxPRed));
                    continue;
                }
                params.put(key, _paramDefaults.get(key));
            }
        } else {
            params = new HashMap();
            params.putAll(_paramDefaults);
            predicate.setParForParams(params);
        }
        Timing time = new Timing(true);
        LOG.trace((Object)"PARFOR: running loop dependency analysis ...");
        HashSet<Candidate> hashSet = new HashSet<Candidate>();
        HashSet<Candidate> C2 = new HashSet<Candidate>();
        Integer sCount = 0;
        this.rDetermineCandidates(pfs.getBody(), hashSet, sCount);
        boolean bl = check = Integer.parseInt(params.get(CHECK)) == 1;
        if (check) {
            this._bounds = new Bounds();
            for (FunctionStatementBlock functionStatementBlock : dmlProg.getFunctionStatementBlocks()) {
                this.rDetermineBounds(functionStatementBlock, false);
            }
            this.rDetermineBounds(dmlProg.getStatementBlocks(), false);
            for (Candidate candidate : hashSet) {
                Expression.DataType dataType = this._vsParent.getVariables().get(candidate._var).getDataType();
                sCount = 0;
                boolean[] dep = new boolean[]{false, false, false};
                this.rCheckCandidates(candidate, dataType, pfs.getBody(), sCount, dep);
                if (LOG.isTraceEnabled()) {
                    if (dep[0]) {
                        LOG.trace((Object)("PARFOR: output dependency detected for var '" + candidate._var + "'."));
                    }
                    if (dep[1]) {
                        LOG.trace((Object)("PARFOR: data dependency detected for var '" + candidate._var + "'."));
                    }
                    if (dep[2]) {
                        LOG.trace((Object)("PARFOR: anti dependency detected for var '" + candidate._var + "'."));
                    }
                }
                if (!dep[0] && !dep[1] && !dep[2]) continue;
                C2.add(candidate);
                break;
            }
            if (C2.size() > 0) {
                LOG.trace((Object)"PARFOR: loop dependencies detected.");
                StringBuilder depVars = new StringBuilder();
                for (Candidate candidate : C2) {
                    if (depVars.length() > 0) {
                        depVars.append(", ");
                    }
                    depVars.append(candidate._var);
                }
                this.raiseValidateError("PARFOR loop dependency analysis: inter-iteration (loop-carried) dependencies detected for variable(s): " + depVars.toString() + ". \n Please, ensure independence of iterations.", false);
            } else {
                LOG.trace((Object)"PARFOR: no loop dependencies detected.");
            }
        } else {
            LOG.debug((Object)("INFO: PARFOR(" + this._ID + "): loop dependency analysis skipped."));
        }
        for (Candidate candidate : hashSet) {
            if (!check && candidate._dat.getDataType() == Expression.DataType.SCALAR) continue;
            this.addToResultVariablesNoDup(candidate._var);
        }
        ArrayList<String> tmp = new ArrayList<String>();
        this.rConsolidateResultVars(pfs.getBody(), tmp);
        for (String string : tmp) {
            if (!this._vsParent.containsVariable(string)) continue;
            this.addToResultVariablesNoDup(string);
        }
        LOG.debug((Object)("INFO: PARFOR(" + this._ID + "): validate successful (no dependencies) in " + time.stop() + "ms."));
        return vs;
    }

    public ArrayList<String> getReadOnlyParentVars() {
        ArrayList<String> ret = new ArrayList<String>();
        VariableSet read = this.variablesRead();
        VariableSet updated = this.variablesUpdated();
        VariableSet livein = this.liveIn();
        for (String var : livein.getVariableNames()) {
            if (!read.containsVariable(var) || updated.containsVariable(var)) continue;
            ret.add(var);
        }
        return ret;
    }

    public ParForProgramBlock.PartitionFormat determineDataPartitionFormat(String var) {
        ParForProgramBlock.PartitionFormat dpf = null;
        LinkedList<ParForProgramBlock.PartitionFormat> dpfc = new LinkedList<ParForProgramBlock.PartitionFormat>();
        try {
            ParForStatement dpfs = (ParForStatement)this._statements.get(0);
            this.rDeterminePartitioningCandidates(var, dpfs.getBody(), (List<ParForProgramBlock.PartitionFormat>)dpfc);
            for (ParForProgramBlock.PartitionFormat tmp : dpfc) {
                dpf = dpf != null && !dpf.equals(tmp) ? ParForProgramBlock.PartitionFormat.NONE : tmp;
            }
            if (dpf == null) {
                dpf = ParForProgramBlock.PartitionFormat.NONE;
            }
        }
        catch (LanguageException e) {
            LOG.trace((Object)"Unable to determine partitioning candidates.", (Throwable)e);
            dpf = ParForProgramBlock.PartitionFormat.NONE;
        }
        return dpf;
    }

    private void rDetermineCandidates(ArrayList<StatementBlock> asb, HashSet<Candidate> C, Integer sCount) throws LanguageException {
        for (StatementBlock sb : asb) {
            for (Statement s : sb._statements) {
                Integer n = sCount;
                sCount = sCount + 1;
                Integer n2 = sCount;
                if (s instanceof ForStatement) {
                    this.rDetermineCandidates(((ForStatement)s).getBody(), C, sCount);
                    continue;
                }
                if (s instanceof WhileStatement) {
                    this.rDetermineCandidates(((WhileStatement)s).getBody(), C, sCount);
                    continue;
                }
                if (s instanceof IfStatement) {
                    this.rDetermineCandidates(((IfStatement)s).getIfBody(), C, sCount);
                    this.rDetermineCandidates(((IfStatement)s).getElseBody(), C, sCount);
                    continue;
                }
                if (s instanceof FunctionStatement) {
                    this.rDetermineCandidates(((FunctionStatement)s).getBody(), C, sCount);
                    continue;
                }
                if (s instanceof PrintStatement && ((PrintStatement)s).getType() == PrintStatement.PRINTTYPE.STOP) {
                    this.raiseValidateError("PARFOR loop dependency analysis: stop() statement is not allowed inside a parfor loop body.", false);
                    continue;
                }
                VariableSet vsUpdated = s.variablesUpdated();
                if (vsUpdated == null) continue;
                for (String write : vsUpdated.getVariableNames()) {
                    if (!this._vsParent.containsVariable(write)) continue;
                    List<DataIdentifier> dats = this.getDataIdentifiers(s, true);
                    for (DataIdentifier dat : dats) {
                        Candidate c = new Candidate();
                        c._var = write;
                        c._dat = dat;
                        C.add(c);
                    }
                    LOG.trace((Object)("PARFOR: dependency candidate: var '" + write + "'"));
                }
            }
        }
    }

    private void rDeterminePartitioningCandidates(String var, ArrayList<StatementBlock> asb, List<ParForProgramBlock.PartitionFormat> C) throws LanguageException {
        for (StatementBlock sb : asb) {
            for (Statement s : sb._statements) {
                List<DataIdentifier> datsRead;
                if (s instanceof ForStatement) {
                    ForStatement fs = (ForStatement)s;
                    List<DataIdentifier> datsFromRead = this.rGetDataIdentifiers(fs.getIterablePredicate().getFromExpr());
                    List<DataIdentifier> datsToRead = this.rGetDataIdentifiers(fs.getIterablePredicate().getToExpr());
                    List<DataIdentifier> datsIncrementRead = this.rGetDataIdentifiers(fs.getIterablePredicate().getIncrementExpr());
                    this.rDeterminePartitioningCandidates(var, datsFromRead, C);
                    this.rDeterminePartitioningCandidates(var, datsToRead, C);
                    this.rDeterminePartitioningCandidates(var, datsIncrementRead, C);
                    this.rDeterminePartitioningCandidates(var, ((ForStatement)s).getBody(), C);
                    continue;
                }
                if (s instanceof WhileStatement) {
                    WhileStatement ws = (WhileStatement)s;
                    datsRead = this.rGetDataIdentifiers(ws.getConditionalPredicate().getPredicate());
                    this.rDeterminePartitioningCandidates(var, datsRead, C);
                    this.rDeterminePartitioningCandidates(var, ((WhileStatement)s).getBody(), C);
                    continue;
                }
                if (s instanceof IfStatement) {
                    IfStatement is = (IfStatement)s;
                    datsRead = this.rGetDataIdentifiers(is.getConditionalPredicate().getPredicate());
                    this.rDeterminePartitioningCandidates(var, datsRead, C);
                    this.rDeterminePartitioningCandidates(var, ((IfStatement)s).getIfBody(), C);
                    this.rDeterminePartitioningCandidates(var, ((IfStatement)s).getElseBody(), C);
                    continue;
                }
                if (s instanceof FunctionStatement) {
                    this.rDeterminePartitioningCandidates(var, ((FunctionStatement)s).getBody(), C);
                    continue;
                }
                List<DataIdentifier> datsRead2 = this.getDataIdentifiers(s, false);
                this.rDeterminePartitioningCandidates(var, datsRead2, C);
            }
        }
    }

    private void rDeterminePartitioningCandidates(String var, List<DataIdentifier> datsRead, List<ParForProgramBlock.PartitionFormat> C) {
        if (datsRead == null) {
            return;
        }
        for (DataIdentifier read : datsRead) {
            if (!var.equals(read.getName())) continue;
            if (read instanceof IndexedIdentifier) {
                C.add(this.determineAccessPattern((IndexedIdentifier)read));
                continue;
            }
            if (!(read instanceof DataIdentifier)) continue;
            C.add(ParForProgramBlock.PartitionFormat.NONE);
        }
    }

    private ParForProgramBlock.PartitionFormat determineAccessPattern(IndexedIdentifier dat) {
        boolean isSpark = OptimizerUtils.isSparkExecutionMode();
        int blksz = ConfigurationManager.getBlocksize();
        ParForProgramBlock.PartitionFormat dpf = null;
        Expression rowL = dat.getRowLowerBound();
        Expression rowU = dat.getRowUpperBound();
        Expression colL = dat.getColLowerBound();
        Expression colU = dat.getColUpperBound();
        boolean allRows = rowL == null && rowU == null;
        boolean allCols = colL == null && colU == null;
        try {
            LinearFunction l2;
            LinearFunction l1;
            dpf = allRows && colL != null && colL.equals(colU) ? ParForProgramBlock.PartitionFormat.COLUMN_WISE : (allCols && rowL != null && rowL.equals(rowU) ? ParForProgramBlock.PartitionFormat.ROW_WISE : (isSpark && allRows && colL != colU ? (!ParForStatementBlock.isAlignedBlocking(l1 = this.getLinearFunction(colL, true), l2 = this.getLinearFunction(colU, true), blksz) ? ParForProgramBlock.PartitionFormat.NONE : new ParForProgramBlock.PartitionFormat(ParForProgramBlock.PDataPartitionFormat.COLUMN_BLOCK_WISE_N, (int)l1._b[0])) : (isSpark && allCols && rowL != rowU ? (!ParForStatementBlock.isAlignedBlocking(l1 = this.getLinearFunction(rowL, true), l2 = this.getLinearFunction(rowU, true), blksz) ? ParForProgramBlock.PartitionFormat.NONE : new ParForProgramBlock.PartitionFormat(ParForProgramBlock.PDataPartitionFormat.ROW_BLOCK_WISE_N, (int)l1._b[0])) : ParForProgramBlock.PartitionFormat.NONE)));
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        return dpf;
    }

    private static boolean isAlignedBlocking(LinearFunction l1, LinearFunction l2, int blksz) {
        return l1 != null && l2 != null && l1.equalSlope(l2) && l1._b.length == 1 && l1._b[0] <= (long)blksz && l2._a - l1._a + 1L == l1._b[0] && (long)blksz / l1._b[0] * l1._b[0] == (long)blksz && l2.eval(1L) == l1._b[0];
    }

    private void rConsolidateResultVars(ArrayList<StatementBlock> asb, ArrayList<String> vars) throws LanguageException {
        for (StatementBlock sb : asb) {
            if (sb instanceof ParForStatementBlock) {
                vars.addAll(((ParForStatementBlock)sb).getResultVariables());
            }
            for (Statement s : sb._statements) {
                if (s instanceof ForStatement || s instanceof ParForStatement) {
                    this.rConsolidateResultVars(((ForStatement)s).getBody(), vars);
                    continue;
                }
                if (s instanceof WhileStatement) {
                    this.rConsolidateResultVars(((WhileStatement)s).getBody(), vars);
                    continue;
                }
                if (s instanceof IfStatement) {
                    this.rConsolidateResultVars(((IfStatement)s).getIfBody(), vars);
                    this.rConsolidateResultVars(((IfStatement)s).getElseBody(), vars);
                    continue;
                }
                if (!(s instanceof FunctionStatement)) continue;
                this.rConsolidateResultVars(((FunctionStatement)s).getBody(), vars);
            }
        }
    }

    private void rCheckCandidates(Candidate c, Expression.DataType cdt, ArrayList<StatementBlock> asb, Integer sCount, boolean[] dep) throws LanguageException {
        if (cdt == Expression.DataType.SCALAR || cdt == Expression.DataType.OBJECT) {
            dep[0] = true;
            return;
        }
        if (cdt == Expression.DataType.MATRIX && this.runConstantCheck(c._dat)) {
            LOG.trace((Object)("PARFOR: Possible output dependency detected via constant self-check: var '" + c._var + "'."));
            dep[0] = true;
            return;
        }
        for (StatementBlock sb : asb) {
            for (Statement s : sb._statements) {
                List<DataIdentifier> datsRead;
                Integer n = sCount;
                sCount = sCount + 1;
                Integer n2 = sCount;
                if (s instanceof ForStatement) {
                    this.rCheckCandidates(c, cdt, ((ForStatement)s).getBody(), sCount, dep);
                    continue;
                }
                if (s instanceof WhileStatement) {
                    this.rCheckCandidates(c, cdt, ((WhileStatement)s).getBody(), sCount, dep);
                    continue;
                }
                if (s instanceof IfStatement) {
                    this.rCheckCandidates(c, cdt, ((IfStatement)s).getIfBody(), sCount, dep);
                    this.rCheckCandidates(c, cdt, ((IfStatement)s).getElseBody(), sCount, dep);
                    continue;
                }
                if (s instanceof FunctionStatement) {
                    this.rCheckCandidates(c, cdt, ((FunctionStatement)s).getBody(), sCount, dep);
                    continue;
                }
                List<DataIdentifier> datsUpdated = this.getDataIdentifiers(s, true);
                if (datsUpdated != null) {
                    for (DataIdentifier write : datsUpdated) {
                        String writeStr = write.getName();
                        if (!c._var.equals(writeStr)) continue;
                        DataIdentifier dat2 = write;
                        if (cdt == Expression.DataType.MATRIX) {
                            if (c._dat == dat2 || this.runEqualsCheck(c._dat, dat2) || !this.runBanerjeeGCDTest(c._dat, dat2)) continue;
                            LOG.trace((Object)("PARFOR: Possible output dependency detected via GCD/Banerjee: var '" + write + "'."));
                            dep[0] = true;
                            return;
                        }
                        throw new LanguageException("PARFOR loop dependency analysis: cannot check for dependencies due to unknown datatype of var '" + c._var + "'.");
                    }
                }
                if ((datsRead = this.getDataIdentifiers(s, false)) == null) continue;
                for (DataIdentifier read : datsRead) {
                    String readStr = read.getName();
                    if (!c._var.equals(readStr)) continue;
                    DataIdentifier dat2 = read;
                    Expression.DataType dat2dt = this._vsParent.getVariables().get(readStr).getDataType();
                    if (cdt == Expression.DataType.SCALAR || cdt == Expression.DataType.OBJECT || dat2dt == Expression.DataType.SCALAR || dat2dt == Expression.DataType.OBJECT) {
                        dep[1] = true;
                        return;
                    }
                    if (cdt == Expression.DataType.MATRIX && dat2dt == Expression.DataType.MATRIX) {
                        if (this.runEqualsCheck(c._dat, dat2)) continue;
                        if (this.runBanerjeeGCDTest(c._dat, dat2)) {
                            LOG.trace((Object)("PARFOR: Possible data/anti dependency detected via GCD/Banerjee: var '" + read + "'."));
                            dep[1] = true;
                            dep[2] = true;
                            return;
                        }
                        if (dat2 instanceof IndexedIdentifier) continue;
                        LOG.trace((Object)("PARFOR: Possible data/anti dependency detected via GCD/Banerjee: var '" + read + "'."));
                        dep[1] = true;
                        dep[2] = true;
                        return;
                    }
                    throw new LanguageException("PARFOR loop dependency analysis: cannot check for dependencies due to unknown datatype of var '" + c._var + "'.");
                }
            }
        }
    }

    private List<DataIdentifier> getDataIdentifiers(Statement s, boolean target) {
        List<DataIdentifier> ret = null;
        if (s instanceof AssignmentStatement) {
            AssignmentStatement s2 = (AssignmentStatement)s;
            ret = target ? s2.getTargetList() : this.rGetDataIdentifiers(s2.getSource());
        } else if (s instanceof FunctionStatement) {
            FunctionStatement s2 = (FunctionStatement)s;
            ret = target ? s2.getOutputParams() : s2.getInputParams();
        } else if (s instanceof MultiAssignmentStatement) {
            MultiAssignmentStatement s2 = (MultiAssignmentStatement)s;
            ret = target ? s2.getTargetList() : this.rGetDataIdentifiers(s2.getSource());
        } else if (s instanceof PrintStatement) {
            PrintStatement s2 = (PrintStatement)s;
            ret = new ArrayList();
            for (Expression expression : s2.getExpressions()) {
                List<DataIdentifier> dataIdentifiers = this.rGetDataIdentifiers(expression);
                ret.addAll(dataIdentifiers);
            }
        }
        return ret;
    }

    private boolean isRowIgnorable(IndexedIdentifier dat1, IndexedIdentifier dat2) {
        for (IndexedIdentifier dat : new IndexedIdentifier[]{dat1, dat2}) {
            if (dat1.getRowLowerBound() != null) {
                for (DataIdentifier datsub : this.rGetDataIdentifiers(dat.getRowLowerBound())) {
                    if (!this._bounds._lower.containsKey(datsub.getName()) || datsub.getName().startsWith(INTERAL_FN_INDEX_ROW)) continue;
                    return false;
                }
            }
            if (dat1.getRowUpperBound() == null) continue;
            for (DataIdentifier datsub : this.rGetDataIdentifiers(dat.getRowUpperBound())) {
                if (!this._bounds._lower.containsKey(datsub.getName()) || datsub.getName().startsWith(INTERAL_FN_INDEX_ROW)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isColumnIgnorable(IndexedIdentifier dat1, IndexedIdentifier dat2) {
        for (IndexedIdentifier dat : new IndexedIdentifier[]{dat1, dat2}) {
            if (dat1.getColLowerBound() != null) {
                for (DataIdentifier datsub : this.rGetDataIdentifiers(dat.getColLowerBound())) {
                    if (!this._bounds._lower.containsKey(datsub.getName()) || datsub.getName().startsWith(INTERAL_FN_INDEX_COL)) continue;
                    return false;
                }
            }
            if (dat1.getColUpperBound() == null) continue;
            for (DataIdentifier datsub : this.rGetDataIdentifiers(dat.getColUpperBound())) {
                if (!this._bounds._lower.containsKey(datsub.getName()) || datsub.getName().startsWith(INTERAL_FN_INDEX_COL)) continue;
                return false;
            }
        }
        return true;
    }

    private List<DataIdentifier> rGetDataIdentifiers(Expression e) {
        ArrayList<DataIdentifier> ret = new ArrayList<DataIdentifier>();
        if (e instanceof DataIdentifier && !(e instanceof FunctionCallIdentifier) && !(e instanceof BuiltinFunctionExpression) && !(e instanceof ParameterizedBuiltinFunctionExpression)) {
            ret.add((DataIdentifier)e);
        } else if (e instanceof FunctionCallIdentifier) {
            FunctionCallIdentifier fci = (FunctionCallIdentifier)e;
            for (ParameterExpression ee : fci.getParamExprs()) {
                ret.addAll(this.rGetDataIdentifiers(ee.getExpr()));
            }
        } else if (e instanceof BinaryExpression) {
            BinaryExpression be = (BinaryExpression)e;
            ret.addAll(this.rGetDataIdentifiers(be.getLeft()));
            ret.addAll(this.rGetDataIdentifiers(be.getRight()));
        } else if (e instanceof BooleanExpression) {
            BooleanExpression be = (BooleanExpression)e;
            ret.addAll(this.rGetDataIdentifiers(be.getLeft()));
            ret.addAll(this.rGetDataIdentifiers(be.getRight()));
        } else if (e instanceof BuiltinFunctionExpression) {
            BuiltinFunctionExpression be = (BuiltinFunctionExpression)e;
            if (be.getOpCode() != Expression.BuiltinFunctionOp.NROW && be.getOpCode() != Expression.BuiltinFunctionOp.NCOL || !(be.getFirstExpr() instanceof DataIdentifier)) {
                ret.addAll(this.rGetDataIdentifiers(be.getFirstExpr()));
                ret.addAll(this.rGetDataIdentifiers(be.getSecondExpr()));
                ret.addAll(this.rGetDataIdentifiers(be.getThirdExpr()));
            }
        } else if (e instanceof ParameterizedBuiltinFunctionExpression) {
            ParameterizedBuiltinFunctionExpression be = (ParameterizedBuiltinFunctionExpression)e;
            for (Expression ee : be.getVarParams().values()) {
                ret.addAll(this.rGetDataIdentifiers(ee));
            }
        } else if (e instanceof RelationalExpression) {
            RelationalExpression re = (RelationalExpression)e;
            ret.addAll(this.rGetDataIdentifiers(re.getLeft()));
            ret.addAll(this.rGetDataIdentifiers(re.getRight()));
        }
        return ret;
    }

    private void rDetermineBounds(ArrayList<StatementBlock> sbs, boolean flag) throws LanguageException {
        for (StatementBlock sb : sbs) {
            this.rDetermineBounds(sb, flag);
        }
    }

    private void rDetermineBounds(StatementBlock sb, boolean flag) throws LanguageException {
        for (Statement s : sb._statements) {
            ArrayList<StatementBlock> tmp;
            boolean lFlag = flag;
            if (!(s instanceof ParForStatement)) {
                if (s instanceof ForStatement) {
                    // empty if block
                }
            } else {
                ArrayList<StatementBlock> tmp2;
                ForStatement fs = (ForStatement)s;
                IterablePredicate ip = fs._predicate;
                if (sb == this) {
                    lFlag = true;
                }
                if (lFlag || this.rIsParent(sb, (StatementBlock)this)) {
                    if (ip.getIterVar()._name.equals(INTERAL_FN_INDEX_ROW) || ip.getIterVar()._name.equals(INTERAL_FN_INDEX_COL)) {
                        throw new LanguageException(" The iteration variable must not use the internal iteration variable name prefix '" + ip.getIterVar()._name + "'.");
                    }
                    long low = Integer.MIN_VALUE;
                    long up = Integer.MAX_VALUE;
                    long incr = -1L;
                    if (ip.getFromExpr() instanceof IntIdentifier) {
                        low = ((IntIdentifier)ip.getFromExpr()).getValue();
                    }
                    if (ip.getToExpr() instanceof IntIdentifier) {
                        up = ((IntIdentifier)ip.getToExpr()).getValue();
                    }
                    incr = ip.getIncrementExpr() instanceof IntIdentifier ? ((IntIdentifier)ip.getIncrementExpr()).getValue() : (low <= up ? 1L : -1L);
                    this._bounds._lower.put(ip.getIterVar()._name, low);
                    this._bounds._upper.put(ip.getIterVar()._name, up);
                    this._bounds._increment.put(ip.getIterVar()._name, incr);
                    if (lFlag) {
                        this._bounds._local.add(ip.getIterVar()._name);
                    }
                }
                if (lFlag || (tmp2 = fs.getBody()) == null) continue;
                this.rDetermineBounds(tmp2, lFlag);
                continue;
            }
            if (s instanceof ForStatement) {
                tmp = ((ForStatement)s).getBody();
                if (tmp == null) continue;
                this.rDetermineBounds(tmp, lFlag);
                continue;
            }
            if (s instanceof WhileStatement) {
                tmp = ((WhileStatement)s).getBody();
                if (tmp == null) continue;
                this.rDetermineBounds(tmp, lFlag);
                continue;
            }
            if (s instanceof IfStatement) {
                ArrayList<StatementBlock> tmp2;
                tmp = ((IfStatement)s).getIfBody();
                if (tmp != null) {
                    this.rDetermineBounds(tmp, lFlag);
                }
                if ((tmp2 = ((IfStatement)s).getElseBody()) == null) continue;
                this.rDetermineBounds(tmp2, lFlag);
                continue;
            }
            if (!(s instanceof FunctionStatement) || (tmp = ((FunctionStatement)s).getBody()) == null) continue;
            this.rDetermineBounds(tmp, lFlag);
        }
    }

    private boolean rIsParent(ArrayList<StatementBlock> cParent, StatementBlock cChild) {
        for (StatementBlock sb : cParent) {
            if (!this.rIsParent(sb, cChild)) continue;
            return true;
        }
        return false;
    }

    private boolean rIsParent(StatementBlock cParent, StatementBlock cChild) {
        boolean ret = false;
        if (cParent == cChild) {
            ret = true;
        } else {
            for (Statement s : cParent.getStatements()) {
                if (s instanceof ForStatement) {
                    ret = this.rIsParent(((ForStatement)s).getBody(), cChild);
                } else if (s instanceof WhileStatement) {
                    ret = this.rIsParent(((WhileStatement)s).getBody(), cChild);
                } else if (s instanceof IfStatement) {
                    ret = this.rIsParent(((IfStatement)s).getIfBody(), cChild);
                    ret |= this.rIsParent(((IfStatement)s).getElseBody(), cChild);
                }
                if (!ret) continue;
                break;
            }
        }
        return ret;
    }

    private boolean runBanerjeeGCDTest(DataIdentifier dat1, DataIdentifier dat2) throws LanguageException {
        int i;
        int i2;
        LOG.trace((Object)"PARFOR: runBanerjeeGCDCheck.");
        boolean ret = true;
        LinearFunction f1 = this.getLinearFunction(dat1);
        LinearFunction f2 = this.getLinearFunction(dat2);
        this.forceConsistency(f1, f2);
        LOG.trace((Object)("PARFOR: f1: " + f1.toString()));
        LOG.trace((Object)("PARFOR: f2: " + f2.toString()));
        long lgcd = f1._b[0];
        for (i2 = 1; i2 < f1._b.length; ++i2) {
            lgcd = this.determineGCD(lgcd, f1._b[i2]);
        }
        for (i2 = 0; i2 < f2._b.length; ++i2) {
            lgcd = this.determineGCD(lgcd, f2._b[i2]);
        }
        if (Math.abs(f1._a - f2._a) % lgcd != 0L) {
            ret = false;
        }
        LOG.trace((Object)("PARFOR: GCD result: " + ret));
        if (ret) {
            boolean ixid = dat1 instanceof IndexedIdentifier && dat2 instanceof IndexedIdentifier;
            boolean ignoreRow = ixid && this.isRowIgnorable((IndexedIdentifier)dat1, (IndexedIdentifier)dat2);
            boolean ignoreCol = ixid && this.isColumnIgnorable((IndexedIdentifier)dat1, (IndexedIdentifier)dat2);
            LinearFunction f1p = null;
            LinearFunction f2p = null;
            if (ignoreRow) {
                f1p = this.getColLinearFunction(dat1);
                f2p = this.getColLinearFunction(dat2);
            }
            if (ignoreCol) {
                f1p = this.getRowLinearFunction(dat1);
                f2p = this.getRowLinearFunction(dat2);
            }
            LOG.trace((Object)("PARFOR: f1p: " + (f1p == null ? "null" : f1p.toString())));
            LOG.trace((Object)("PARFOR: f2p: " + (f2p == null ? "null" : f2p.toString())));
            if (f1p != null && f2p != null) {
                this.forceConsistency(f1p, f2p);
                long lgcd2 = f1p._b[0];
                for (i = 1; i < f1p._b.length; ++i) {
                    lgcd2 = this.determineGCD(lgcd2, f1p._b[i]);
                }
                for (i = 0; i < f2p._b.length; ++i) {
                    lgcd2 = this.determineGCD(lgcd2, f2p._b[i]);
                }
                if (Math.abs(f1p._a - f2p._a) % lgcd2 != 0L) {
                    ret = false;
                }
                LOG.trace((Object)("PARFOR: GCD result: " + ret));
            }
        }
        if (ret) {
            long lintercept = f2._a - f1._a;
            long lmax = 0L;
            long lmin = 0L;
            int len = Math.max(f1._b.length, f2._b.length);
            for (i = 0; i < len; ++i) {
                String var = f1._b.length > i ? f1._vars[i] : f2._vars[i];
                long lower = this._bounds._lower.get(var);
                long upper = this._bounds._upper.get(var);
                if (f1._b.length > i) {
                    lmax = f1._b[i] > 0L ? (lmax += f1._b[i] * upper) : (lmax += f1._b[i] * lower);
                }
                if (f2._b.length > i) {
                    lmax = f2._b[i] > 0L ? (lmax -= f2._b[i] * lower) : (lmax -= f2._b[i] * upper);
                }
                if (f1._b.length > i) {
                    lmin = f1._b[i] > 0L ? (lmin += f1._b[i] * lower) : (lmin += f1._b[i] * upper);
                }
                if (f2._b.length <= i) continue;
                if (f2._b[i] > 0L) {
                    lmin -= f2._b[i] * upper;
                    continue;
                }
                lmin -= f2._b[i] * lower;
            }
            LOG.trace((Object)("PARFOR: Banerjee lintercept " + lintercept));
            LOG.trace((Object)("PARFOR: Banerjee lmax " + lmax));
            LOG.trace((Object)("PARFOR: Banerjee lmin " + lmin));
            if (lmin > lintercept || lintercept > lmax || lmin == lmax) {
                ret = false;
            }
            LOG.trace((Object)("PARFOR: Banerjee result: " + ret));
        }
        return ret;
    }

    private boolean runConstantCheck(DataIdentifier dat1) throws LanguageException {
        LOG.trace((Object)"PARFOR: runConstantCheck.");
        boolean ret = true;
        LinearFunction f1 = this.getLinearFunction(dat1);
        if (f1 == null) {
            return true;
        }
        LOG.trace((Object)("PARFOR: f1: " + f1.toString()));
        boolean gcheck = true;
        for (String var : this._bounds._local) {
            if (var.startsWith(INTERAL_FN_INDEX_ROW) || var.startsWith(INTERAL_FN_INDEX_COL)) continue;
            boolean lcheck = false;
            for (int i = 0; i < f1._vars.length; ++i) {
                if (!var.equals(f1._vars[i]) || f1._b[i] == 0L) continue;
                lcheck = true;
            }
            if (lcheck) continue;
            gcheck = false;
            break;
        }
        if (gcheck) {
            ret = false;
        }
        return ret;
    }

    private boolean runEqualsCheck(DataIdentifier dat1, DataIdentifier dat2) throws LanguageException {
        LOG.trace((Object)"PARFOR: runEqualsCheck.");
        if (dat1 instanceof IndexedIdentifier != dat2 instanceof IndexedIdentifier) {
            return false;
        }
        boolean ret = true;
        LinearFunction f1 = this.getLinearFunction(dat1);
        LinearFunction f2 = this.getLinearFunction(dat2);
        this.forceConsistency(f1, f2);
        ret = f1.equals(f2);
        LOG.trace((Object)("PARFOR: f1: " + f1.toString()));
        LOG.trace((Object)("PARFOR: f2: " + f2.toString()));
        LOG.trace((Object)("PARFOR: (f1==f2): " + ret));
        if (!ret) {
            boolean ixid = dat1 instanceof IndexedIdentifier && dat2 instanceof IndexedIdentifier;
            boolean ignoreRow = ixid && this.isRowIgnorable((IndexedIdentifier)dat1, (IndexedIdentifier)dat2);
            boolean ignoreCol = ixid && this.isColumnIgnorable((IndexedIdentifier)dat1, (IndexedIdentifier)dat2);
            LinearFunction f1p = null;
            LinearFunction f2p = null;
            if (ignoreRow) {
                f1p = this.getColLinearFunction(dat1);
                f2p = this.getColLinearFunction(dat2);
            }
            if (ignoreCol) {
                f1p = this.getRowLinearFunction(dat1);
                f2p = this.getRowLinearFunction(dat2);
            }
            if (f1p != null && f2p != null) {
                this.forceConsistency(f1p, f2p);
                ret = f1p.equals(f2p);
                LOG.trace((Object)("PARFOR: f1p: " + f1p.toString()));
                LOG.trace((Object)("PARFOR: f2p: " + f2p.toString()));
                LOG.trace((Object)("PARFOR: (f1p==f2p): " + ret));
            }
        }
        return ret;
    }

    private long determineGCD(long a, long b) {
        if (b == 0L) {
            return a;
        }
        return this.determineGCD(b, a % b);
    }

    private LinearFunction getLinearFunction(DataIdentifier dat) throws LanguageException {
        LinearFunction out = null;
        if (!(dat instanceof IndexedIdentifier)) {
            return new LinearFunction(0L, 0L, dat.getName());
        }
        IndexedIdentifier idat = (IndexedIdentifier)dat;
        Expression sub1 = idat.getRowLowerBound();
        Expression sub2 = idat.getColLowerBound();
        try {
            long colDim;
            if (idat.getRowLowerBound() != null && idat.getRowUpperBound() != null && idat.getRowLowerBound() == idat.getRowUpperBound()) {
                out = sub1 instanceof IntIdentifier ? new LinearFunction(((IntIdentifier)sub1).getValue(), 0L, null) : (sub1 instanceof DataIdentifier ? new LinearFunction(0L, 1L, ((DataIdentifier)sub1)._name) : this.rParseBinaryExpression((BinaryExpression)sub1));
                if (out.hasNonIndexVariables()) {
                    String id = INTERAL_FN_INDEX_ROW + _idSeqfn.getNextID();
                    out = new LinearFunction(0L, 1L, id);
                    this._bounds._lower.put(id, 1L);
                    this._bounds._upper.put(id, this._vsParent.getVariable(idat._name).getDim1());
                    this._bounds._increment.put(id, 1L);
                }
            } else {
                Expression sub1a = sub1;
                Expression sub1b = idat.getRowUpperBound();
                String id = INTERAL_FN_INDEX_ROW + _idSeqfn.getNextID();
                out = new LinearFunction(0L, 1L, id);
                if (sub1a == null && sub1b == null || !(sub1a instanceof IntIdentifier) || !(sub1b instanceof IntIdentifier)) {
                    this._bounds._lower.put(id, 1L);
                    this._bounds._upper.put(id, this._vsParent.getVariable(idat._name).getDim1());
                    this._bounds._increment.put(id, 1L);
                } else if (sub1a instanceof IntIdentifier && sub1b instanceof IntIdentifier) {
                    this._bounds._lower.put(id, ((IntIdentifier)sub1a).getValue());
                    this._bounds._upper.put(id, ((IntIdentifier)sub1b).getValue());
                    this._bounds._increment.put(id, 1L);
                } else {
                    out = null;
                }
            }
            if ((colDim = this._vsParent.getVariable(idat._name).getDim2()) > 0L) {
                out.scale(colDim);
            } else {
                LOG.debug((Object)("PARFOR: Warning - matrix dimensionality of '" + idat._name + "' unknown, cannot scale linear functions."));
            }
        }
        catch (Exception ex) {
            LOG.debug((Object)("PARFOR: Unable to parse MATRIX subscript expression for '" + String.valueOf(sub1) + "'."), (Throwable)ex);
            out = null;
        }
        if (out != null) {
            try {
                LinearFunction tmpOut = null;
                if (idat.getColLowerBound() != null && idat.getColUpperBound() != null && idat.getColLowerBound() == idat.getColUpperBound()) {
                    if (sub2 instanceof IntIdentifier) {
                        out.addConstant(((IntIdentifier)sub2).getValue());
                    } else {
                        tmpOut = sub2 instanceof DataIdentifier ? new LinearFunction(0L, 1L, ((DataIdentifier)sub2)._name) : this.rParseBinaryExpression((BinaryExpression)sub2);
                    }
                    if (tmpOut != null && tmpOut.hasNonIndexVariables()) {
                        String id = INTERAL_FN_INDEX_COL + _idSeqfn.getNextID();
                        tmpOut = new LinearFunction(0L, 1L, id);
                        this._bounds._lower.put(id, 1L);
                        this._bounds._upper.put(id, this._vsParent.getVariable(idat._name).getDim2());
                        this._bounds._increment.put(id, 1L);
                    }
                } else {
                    Expression sub2a = sub2;
                    Expression sub2b = idat.getColUpperBound();
                    String id = INTERAL_FN_INDEX_COL + _idSeqfn.getNextID();
                    tmpOut = new LinearFunction(0L, 1L, id);
                    if (sub2a == null && sub2b == null || !(sub2a instanceof IntIdentifier) || !(sub2b instanceof IntIdentifier)) {
                        this._bounds._lower.put(id, 1L);
                        this._bounds._upper.put(id, this._vsParent.getVariable(idat._name).getDim2());
                        this._bounds._increment.put(id, 1L);
                    } else if (sub2a instanceof IntIdentifier && sub2b instanceof IntIdentifier) {
                        this._bounds._lower.put(id, ((IntIdentifier)sub2a).getValue());
                        this._bounds._upper.put(id, ((IntIdentifier)sub2b).getValue());
                        this._bounds._increment.put(id, 1L);
                    } else {
                        out = null;
                    }
                }
                if (tmpOut != null) {
                    out.addFunction(tmpOut);
                }
            }
            catch (Exception ex) {
                LOG.debug((Object)("PARFOR: Unable to parse MATRIX subscript expression for '" + String.valueOf(sub2) + "'."), (Throwable)ex);
                out = null;
            }
        }
        if (out != null) {
            this.cleanupFunction(out);
            this.verifyFunction(out);
        }
        return out;
    }

    private LinearFunction getRowLinearFunction(DataIdentifier dat) throws LanguageException {
        LinearFunction out = null;
        IndexedIdentifier idat = (IndexedIdentifier)dat;
        Expression sub1 = idat.getRowLowerBound();
        try {
            if (idat.getRowLowerBound() != null && idat.getRowUpperBound() != null && idat.getRowLowerBound() == idat.getRowUpperBound()) {
                out = sub1 instanceof IntIdentifier ? new LinearFunction(((IntIdentifier)sub1).getValue(), 0L, null) : (sub1 instanceof DataIdentifier ? new LinearFunction(0L, 1L, ((DataIdentifier)sub1)._name) : this.rParseBinaryExpression((BinaryExpression)sub1));
            }
        }
        catch (Exception ex) {
            LOG.debug((Object)("PARFOR: Unable to parse MATRIX subscript expression for '" + String.valueOf(sub1) + "'."), (Throwable)ex);
            out = null;
        }
        if (out != null) {
            this.cleanupFunction(out);
            this.verifyFunction(out);
        }
        return out;
    }

    private LinearFunction getColLinearFunction(DataIdentifier dat) throws LanguageException {
        LinearFunction out = null;
        IndexedIdentifier idat = (IndexedIdentifier)dat;
        Expression sub1 = idat.getColLowerBound();
        try {
            if (idat.getColLowerBound() != null && idat.getColUpperBound() != null && idat.getColLowerBound() == idat.getColUpperBound()) {
                out = sub1 instanceof IntIdentifier ? new LinearFunction(((IntIdentifier)sub1).getValue(), 0L, null) : (sub1 instanceof DataIdentifier ? new LinearFunction(0L, 1L, ((DataIdentifier)sub1)._name) : this.rParseBinaryExpression((BinaryExpression)sub1));
            }
        }
        catch (Exception ex) {
            LOG.debug((Object)("PARFOR: Unable to parse MATRIX subscript expression for '" + String.valueOf(sub1) + "'."), (Throwable)ex);
            out = null;
        }
        if (out != null) {
            this.cleanupFunction(out);
            this.verifyFunction(out);
        }
        return out;
    }

    private LinearFunction getLinearFunction(Expression expr, boolean ignoreMinWithConstant) throws LanguageException {
        if (expr instanceof IntIdentifier) {
            return new LinearFunction(((IntIdentifier)expr).getValue(), 0L, null);
        }
        if (expr instanceof BinaryExpression) {
            return this.rParseBinaryExpression((BinaryExpression)expr);
        }
        if (expr instanceof BuiltinFunctionExpression && ignoreMinWithConstant) {
            BuiltinFunctionExpression bexpr = (BuiltinFunctionExpression)expr;
            if (bexpr.getOpCode() == Expression.BuiltinFunctionOp.MIN) {
                if (bexpr.getFirstExpr() instanceof BinaryExpression) {
                    return this.rParseBinaryExpression((BinaryExpression)bexpr.getFirstExpr());
                }
                if (bexpr.getSecondExpr() instanceof BinaryExpression) {
                    return this.rParseBinaryExpression((BinaryExpression)bexpr.getSecondExpr());
                }
            }
        } else if (expr instanceof DataIdentifier) {
            return new LinearFunction(0L, 1L, ((DataIdentifier)expr)._name);
        }
        return null;
    }

    private String getFunctionID(IndexedIdentifier dat) {
        IndexedIdentifier idat = dat;
        Expression ex1a = idat.getRowLowerBound();
        Expression ex1b = idat.getRowUpperBound();
        Expression ex2a = idat.getColLowerBound();
        Expression ex2b = idat.getColUpperBound();
        StringBuilder sb = new StringBuilder();
        sb.append(String.valueOf(ex1a));
        sb.append(',');
        sb.append(String.valueOf(ex1b));
        sb.append(',');
        sb.append(String.valueOf(ex2a));
        sb.append(',');
        sb.append(String.valueOf(ex2b));
        return sb.toString();
    }

    private void cleanupFunction(LinearFunction f1) {
        for (int i = 0; i < f1._b.length; ++i) {
            if (f1._vars[i] != null) continue;
            f1.removeVar(i);
            --i;
        }
    }

    private void verifyFunction(LinearFunction f1) throws LanguageException {
        if (f1 == null || f1._b.length != f1._vars.length) {
            if (LOG.isTraceEnabled() && f1 != null) {
                LOG.trace((Object)("PARFOR: f1: " + f1.toString()));
            }
            throw new LanguageException("PARFOR loop dependency analysis: MATRIX subscripts are not in linear form (a0 + a1*x).");
        }
        for (String var : f1._vars) {
            if (this._bounds._lower.containsKey(var)) continue;
            LOG.trace((Object)("PARFOR: not allowed variable in matrix subscript: " + var));
            throw new LanguageException("PARFOR loop dependency analysis: MATRIX subscripts use non-index variables.");
        }
    }

    private void forceConsistency(LinearFunction f1, LinearFunction f2) {
        boolean warn = false;
        for (int i = 0; i < f1._b.length && f2._b.length >= i + 1; ++i) {
            if (f1._vars[i].equals(f2._vars[i]) || f1._vars[i].startsWith(INTERAL_FN_INDEX_ROW) && f2._vars[i].startsWith(INTERAL_FN_INDEX_ROW) || f1._vars[i].startsWith(INTERAL_FN_INDEX_COL) && f2._vars[i].startsWith(INTERAL_FN_INDEX_COL)) continue;
            boolean exchange = false;
            for (int j = i + 1; j < f2._b.length; ++j) {
                if (!f1._vars[i].equals(f2._vars[j]) && (!f1._vars[i].startsWith(INTERAL_FN_INDEX_ROW) || !f2._vars[j].startsWith(INTERAL_FN_INDEX_ROW)) && (!f1._vars[i].startsWith(INTERAL_FN_INDEX_COL) || !f2._vars[j].startsWith(INTERAL_FN_INDEX_COL))) continue;
                long btmp = f2._b[i];
                String vartmp = f2._vars[i];
                f2._b[i] = f2._b[j];
                f2._vars[i] = f2._vars[j];
                f2._b[j] = btmp;
                f2._vars[j] = vartmp;
                exchange = true;
            }
            if (exchange) continue;
            warn = true;
        }
        if (warn && LOG.isTraceEnabled()) {
            LOG.trace((Object)"PARFOR: Warning - index functions f1 and f2 cannot be made consistent.");
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private LinearFunction rParseBinaryExpression(BinaryExpression be) throws LanguageException {
        LinearFunction ret = null;
        Expression l = be.getLeft();
        Expression r = be.getRight();
        if (be.getOpCode() == Expression.BinaryOp.PLUS) {
            if (l instanceof BinaryExpression) {
                ret = this.rParseBinaryExpression((BinaryExpression)l);
                Long cvalR = this.parseLongConstant(r);
                if (ret == null) return null;
                if (cvalR == null) return null;
                ret.addConstant(cvalR);
                return ret;
            }
            if (r instanceof BinaryExpression) {
                ret = this.rParseBinaryExpression((BinaryExpression)r);
                Long cvalL = this.parseLongConstant(l);
                if (ret == null) return null;
                if (cvalL == null) return null;
                ret.addConstant(cvalL);
                return ret;
            }
            Long cvalL = this.parseLongConstant(l);
            Long cvalR = this.parseLongConstant(r);
            if (cvalL != null) {
                return new LinearFunction(cvalL, 1L, ((DataIdentifier)r)._name);
            }
            if (cvalR == null) return null;
            return new LinearFunction(cvalR, 1L, ((DataIdentifier)l)._name);
        }
        if (be.getOpCode() == Expression.BinaryOp.MINUS) {
            if (l instanceof BinaryExpression) {
                ret = this.rParseBinaryExpression((BinaryExpression)l);
                if (ret == null) return ret;
                ret.addConstant(this.parseLongConstant(r) * -1L);
                return ret;
            }
            if (r instanceof BinaryExpression) {
                ret = this.rParseBinaryExpression((BinaryExpression)r);
                if (ret == null) return ret;
                ret._a *= -1L;
                int i = 0;
                while (true) {
                    if (i >= ret._b.length) {
                        Long cvalL = this.parseLongConstant(l);
                        ret.addConstant(cvalL);
                        return ret;
                    }
                    int n = i++;
                    ret._b[n] = ret._b[n] * -1L;
                }
            }
            Long cvalL = this.parseLongConstant(l);
            Long cvalR = this.parseLongConstant(r);
            if (cvalL != null) {
                return new LinearFunction(cvalL, -1L, ((DataIdentifier)r)._name);
            }
            if (cvalR == null) return null;
            return new LinearFunction(cvalR * -1L, 1L, ((DataIdentifier)l)._name);
        }
        if (be.getOpCode() != Expression.BinaryOp.MULT) return null;
        Long cvalL = this.parseLongConstant(l);
        Long cvalR = this.parseLongConstant(r);
        if (cvalL != null && r instanceof DataIdentifier) {
            return new LinearFunction(0L, cvalL, ((DataIdentifier)r)._name);
        }
        if (cvalR != null && l instanceof DataIdentifier) {
            return new LinearFunction(0L, cvalR, ((DataIdentifier)l)._name);
        }
        if (cvalL != null && r instanceof BinaryExpression) {
            LinearFunction ltmp = this.rParseBinaryExpression((BinaryExpression)r);
            return ltmp.scale(cvalL);
        }
        if (cvalR == null) return null;
        if (!(l instanceof BinaryExpression)) return null;
        LinearFunction ltmp = this.rParseBinaryExpression((BinaryExpression)l);
        return ltmp.scale(cvalR);
    }

    private Long parseLongConstant(Expression expr) {
        double tmp;
        Long ret = null;
        if (expr instanceof IntIdentifier) {
            ret = ((IntIdentifier)expr).getValue();
        } else if (expr instanceof DoubleIdentifier && (tmp = ((DoubleIdentifier)expr).getValue()) == Math.floor(tmp)) {
            ret = UtilFunctions.toLong(tmp);
        }
        return ret;
    }

    static {
        _idSeq = null;
        _idSeqfn = null;
        _paramNames = new HashSet();
        _paramNames.add(CHECK);
        _paramNames.add(PAR);
        _paramNames.add(TASK_PARTITIONER);
        _paramNames.add(TASK_SIZE);
        _paramNames.add(DATA_PARTITIONER);
        _paramNames.add(RESULT_MERGE);
        _paramNames.add(EXEC_MODE);
        _paramNames.add(OPT_MODE);
        _paramNames.add(PROFILE);
        _paramNames.add(OPT_LOG);
        _paramDefaults = new HashMap();
        _paramDefaults.put(CHECK, "1");
        _paramDefaults.put(PAR, String.valueOf(InfrastructureAnalyzer.getLocalParallelism()));
        _paramDefaults.put(TASK_PARTITIONER, String.valueOf((Object)ParForProgramBlock.PTaskPartitioner.FIXED));
        _paramDefaults.put(TASK_SIZE, "1");
        _paramDefaults.put(DATA_PARTITIONER, String.valueOf((Object)ParForProgramBlock.PDataPartitioner.NONE));
        _paramDefaults.put(RESULT_MERGE, String.valueOf((Object)ParForProgramBlock.PResultMerge.LOCAL_AUTOMATIC));
        _paramDefaults.put(EXEC_MODE, String.valueOf((Object)ParForProgramBlock.PExecMode.LOCAL));
        _paramDefaults.put(OPT_MODE, String.valueOf((Object)ParForProgramBlock.POptMode.RULEBASED));
        _paramDefaults.put(PROFILE, "0");
        _paramDefaults.put(OPT_LOG, OptimizerUtils.getDefaultLogLevel().toString());
        _paramDefaults2 = new HashMap();
        _paramDefaults2.put(CHECK, "1");
        _paramDefaults2.put(PAR, "-1");
        _paramDefaults2.put(TASK_PARTITIONER, String.valueOf((Object)ParForProgramBlock.PTaskPartitioner.UNSPECIFIED));
        _paramDefaults2.put(TASK_SIZE, "-1");
        _paramDefaults2.put(DATA_PARTITIONER, String.valueOf((Object)ParForProgramBlock.PDataPartitioner.UNSPECIFIED));
        _paramDefaults2.put(RESULT_MERGE, String.valueOf((Object)ParForProgramBlock.PResultMerge.UNSPECIFIED));
        _paramDefaults2.put(EXEC_MODE, String.valueOf((Object)ParForProgramBlock.PExecMode.UNSPECIFIED));
        _paramDefaults2.put(PROFILE, "0");
        _paramDefaults2.put(OPT_LOG, OptimizerUtils.getDefaultLogLevel().toString());
        _idSeq = new IDSequence();
        _idSeqfn = new IDSequence();
    }

    private class LinearFunction {
        long _a;
        long[] _b;
        String[] _vars;

        LinearFunction(long a, long b, String name) {
            this._a = a;
            this._b = new long[1];
            this._b[0] = b;
            this._vars = new String[1];
            this._vars[0] = name;
        }

        public void addConstant(long value) {
            this._a += value;
        }

        public void addFunction(LinearFunction f2) {
            this._a += f2._a;
            long[] tmpb = new long[this._b.length + f2._b.length];
            System.arraycopy(this._b, 0, tmpb, 0, this._b.length);
            System.arraycopy(f2._b, 0, tmpb, this._b.length, f2._b.length);
            this._b = tmpb;
            String[] tmpvars = new String[this._vars.length + f2._vars.length];
            System.arraycopy(this._vars, 0, tmpvars, 0, this._vars.length);
            System.arraycopy(f2._vars, 0, tmpvars, this._vars.length, f2._vars.length);
            this._vars = tmpvars;
        }

        public void removeVar(int i) {
            long[] tmpb = new long[this._b.length - 1];
            System.arraycopy(this._b, 0, tmpb, 0, i);
            System.arraycopy(this._b, i + 1, tmpb, i, this._b.length - i - 1);
            this._b = tmpb;
            String[] tmpvars = new String[this._vars.length - 1];
            System.arraycopy(this._vars, 0, tmpvars, 0, i);
            System.arraycopy(this._vars, i + 1, tmpvars, i, this._vars.length - i - 1);
            this._vars = tmpvars;
        }

        public LinearFunction scale(long scale) {
            this._a *= scale;
            for (int i = 0; i < this._b.length; ++i) {
                if (this._b[i] == 0L) continue;
                int n = i;
                this._b[n] = this._b[n] * scale;
            }
            return this;
        }

        public LinearFunction normalize(int index, long lower, long increment) {
            this._a -= this._b[index] * lower;
            int n = index;
            this._b[n] = this._b[n] * increment;
            return this;
        }

        public long eval(Long ... x) {
            long ret = this._a;
            for (int i = 0; i < this._b.length; ++i) {
                if (this._b[i] == 0L) continue;
                int n = i;
                long l = this._b[n] * x[i];
                this._b[n] = l;
                ret += l;
            }
            return ret;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("(");
            sb.append(this._a);
            sb.append(") + ");
            sb.append("(");
            for (int i = 0; i < this._b.length; ++i) {
                if (i > 0) {
                    sb.append("+");
                }
                sb.append("(");
                sb.append(this._b[i]);
                sb.append(" * ");
                sb.append(this._vars[i]);
                sb.append(")");
            }
            sb.append(")");
            return sb.toString();
        }

        public boolean equals(Object o2) {
            if (o2 == null || !(o2 instanceof LinearFunction)) {
                return false;
            }
            LinearFunction f2 = (LinearFunction)o2;
            return this._a == f2._a && this.equalSlope(f2);
        }

        public boolean equalSlope(LinearFunction f2) {
            boolean ret = this._b.length == f2._b.length;
            for (int i = 0; i < this._b.length && ret; ret &= this._vars[i].equals(f2._vars[i]) || this._vars[i].startsWith(ParForStatementBlock.INTERAL_FN_INDEX_ROW) && f2._vars[i].startsWith(ParForStatementBlock.INTERAL_FN_INDEX_ROW) || this._vars[i].startsWith(ParForStatementBlock.INTERAL_FN_INDEX_COL) && f2._vars[i].startsWith(ParForStatementBlock.INTERAL_FN_INDEX_COL), ++i) {
                ret &= this._b[i] == f2._b[i];
            }
            return ret;
        }

        public int hashCode() {
            return super.hashCode();
        }

        public boolean hasNonIndexVariables() {
            for (String var : this._vars) {
                if (var == null || ((ParForStatementBlock)ParForStatementBlock.this)._bounds._lower.containsKey(var)) continue;
                return true;
            }
            return false;
        }
    }

    private static class Bounds {
        HashMap<String, Long> _lower = new HashMap();
        HashMap<String, Long> _upper = new HashMap();
        HashMap<String, Long> _increment = new HashMap();
        HashSet<String> _local = new HashSet();

        private Bounds() {
        }
    }

    private static class Candidate {
        String _var;
        DataIdentifier _dat;

        private Candidate() {
        }
    }
}

