/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.lops;

import org.apache.sysml.lops.Aggregate;
import org.apache.sysml.lops.Lop;
import org.apache.sysml.lops.LopProperties;
import org.apache.sysml.lops.LopsException;
import org.apache.sysml.lops.compile.JobType;
import org.apache.sysml.parser.Expression;

public class CumulativeOffsetBinary
extends Lop {
    private Aggregate.OperationTypes _op;
    private double _initValue = 0.0;

    public CumulativeOffsetBinary(Lop data, Lop offsets, Expression.DataType dt, Expression.ValueType vt, Aggregate.OperationTypes op, LopProperties.ExecType et) throws LopsException {
        super(Lop.Type.CumulativeOffsetBinary, dt, vt);
        this.checkSupportedOperations(op);
        this._op = op;
        this.init(data, offsets, dt, vt, et);
    }

    public CumulativeOffsetBinary(Lop data, Lop offsets, Expression.DataType dt, Expression.ValueType vt, double init, Aggregate.OperationTypes op, LopProperties.ExecType et) throws LopsException {
        super(Lop.Type.CumulativeOffsetBinary, dt, vt);
        this.checkSupportedOperations(op);
        this._op = op;
        this._initValue = init;
        this.init(data, offsets, dt, vt, et);
    }

    private void init(Lop input1, Lop input2, Expression.DataType dt, Expression.ValueType vt, LopProperties.ExecType et) {
        this.addInput(input1);
        this.addInput(input2);
        input1.addOutput(this);
        input2.addOutput(this);
        if (et == LopProperties.ExecType.MR) {
            boolean breaksAlignment = true;
            boolean aligner = false;
            boolean definesMRJob = false;
            this.lps.addCompatibility(JobType.GMR);
            this.lps.addCompatibility(JobType.DATAGEN);
            this.lps.setProperties(this.inputs, et, LopProperties.ExecLocation.Reduce, breaksAlignment, aligner, definesMRJob);
        } else {
            boolean breaksAlignment = false;
            boolean aligner = false;
            boolean definesMRJob = false;
            this.lps.addCompatibility(JobType.INVALID);
            this.lps.setProperties(this.inputs, et, LopProperties.ExecLocation.ControlProgram, breaksAlignment, aligner, definesMRJob);
        }
    }

    @Override
    public String toString() {
        return "CumulativeOffsetBinary";
    }

    private void checkSupportedOperations(Aggregate.OperationTypes op) throws LopsException {
        if (op != Aggregate.OperationTypes.KahanSum && op != Aggregate.OperationTypes.Product && op != Aggregate.OperationTypes.Min && op != Aggregate.OperationTypes.Max) {
            throw new LopsException("Unsupported aggregate operation type: " + (Object)((Object)op));
        }
    }

    private String getOpcode() {
        switch (this._op) {
            case KahanSum: {
                return "bcumoffk+";
            }
            case Product: {
                return "bcumoff*";
            }
            case Min: {
                return "bcumoffmin";
            }
            case Max: {
                return "bcumoffmax";
            }
        }
        return null;
    }

    @Override
    public String getInstructions(int input_index1, int input_index2, int output_index) {
        return this.getInstructions(String.valueOf(input_index1), String.valueOf(input_index2), String.valueOf(output_index));
    }

    @Override
    public String getInstructions(String input1, String input2, String output) {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.getExecType());
        sb.append("\u00b0");
        sb.append(this.getOpcode());
        sb.append("\u00b0");
        sb.append(this.getInputs().get(0).prepInputOperand(input1));
        sb.append("\u00b0");
        sb.append(this.getInputs().get(1).prepInputOperand(input2));
        sb.append("\u00b0");
        sb.append(this.prepOutputOperand(output));
        if (this.getExecType() == LopProperties.ExecType.SPARK) {
            sb.append("\u00b0");
            sb.append(this._initValue);
        }
        return sb.toString();
    }
}

