/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.hops.rewrite;

import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysml.hops.AggBinaryOp;
import org.apache.sysml.hops.AggUnaryOp;
import org.apache.sysml.hops.BinaryOp;
import org.apache.sysml.hops.DataGenOp;
import org.apache.sysml.hops.Hop;
import org.apache.sysml.hops.HopsException;
import org.apache.sysml.hops.IndexingOp;
import org.apache.sysml.hops.LeftIndexingOp;
import org.apache.sysml.hops.LiteralOp;
import org.apache.sysml.hops.OptimizerUtils;
import org.apache.sysml.hops.ParameterizedBuiltinOp;
import org.apache.sysml.hops.QuaternaryOp;
import org.apache.sysml.hops.ReorgOp;
import org.apache.sysml.hops.TernaryOp;
import org.apache.sysml.hops.UnaryOp;
import org.apache.sysml.hops.rewrite.HopRewriteRule;
import org.apache.sysml.hops.rewrite.HopRewriteUtils;
import org.apache.sysml.hops.rewrite.ProgramRewriteStatus;
import org.apache.sysml.lops.MapMultChain;
import org.apache.sysml.parser.Expression;

public class RewriteAlgebraicSimplificationDynamic
extends HopRewriteRule {
    private static final Log LOG = LogFactory.getLog((String)RewriteAlgebraicSimplificationDynamic.class.getName());
    private static Hop.AggOp[] LOOKUP_VALID_ROW_COL_AGGREGATE = new Hop.AggOp[]{Hop.AggOp.SUM, Hop.AggOp.SUM_SQ, Hop.AggOp.MIN, Hop.AggOp.MAX, Hop.AggOp.MEAN, Hop.AggOp.VAR};
    private static Hop.AggOp[] LOOKUP_VALID_EMPTY_AGGREGATE = new Hop.AggOp[]{Hop.AggOp.SUM, Hop.AggOp.SUM_SQ, Hop.AggOp.MIN, Hop.AggOp.MAX, Hop.AggOp.PROD, Hop.AggOp.TRACE};
    private static Hop.AggOp[] LOOKUP_VALID_UNNECESSARY_AGGREGATE = new Hop.AggOp[]{Hop.AggOp.SUM, Hop.AggOp.MIN, Hop.AggOp.MAX, Hop.AggOp.PROD, Hop.AggOp.TRACE};
    private static Hop.OpOp1[] LOOKUP_VALID_EMPTY_UNARY = new Hop.OpOp1[]{Hop.OpOp1.ABS, Hop.OpOp1.SIN, Hop.OpOp1.TAN, Hop.OpOp1.SQRT, Hop.OpOp1.ROUND, Hop.OpOp1.CUMSUM};
    private static Hop.OpOp2[] LOOKUP_VALID_WDIVMM_BINARY = new Hop.OpOp2[]{Hop.OpOp2.MULT, Hop.OpOp2.DIV};
    private static Hop.OpOp1[] LOOKUP_VALID_WUMM_UNARY = new Hop.OpOp1[]{Hop.OpOp1.ABS, Hop.OpOp1.ROUND, Hop.OpOp1.CEIL, Hop.OpOp1.FLOOR, Hop.OpOp1.EXP, Hop.OpOp1.LOG, Hop.OpOp1.SQRT, Hop.OpOp1.SIGMOID, Hop.OpOp1.SPROP};
    private static Hop.OpOp2[] LOOKUP_VALID_WUMM_BINARY = new Hop.OpOp2[]{Hop.OpOp2.MULT, Hop.OpOp2.POW};

    @Override
    public ArrayList<Hop> rewriteHopDAGs(ArrayList<Hop> roots, ProgramRewriteStatus state) throws HopsException {
        if (roots == null) {
            return roots;
        }
        for (Hop h : roots) {
            this.rule_AlgebraicSimplification(h, false);
        }
        Hop.resetVisitStatus(roots, true);
        for (Hop h : roots) {
            this.rule_AlgebraicSimplification(h, true);
        }
        Hop.resetVisitStatus(roots, true);
        return roots;
    }

    @Override
    public Hop rewriteHopDAG(Hop root, ProgramRewriteStatus state) throws HopsException {
        if (root == null) {
            return root;
        }
        this.rule_AlgebraicSimplification(root, false);
        root.resetVisitStatus();
        this.rule_AlgebraicSimplification(root, true);
        return root;
    }

    private void rule_AlgebraicSimplification(Hop hop, boolean descendFirst) throws HopsException {
        if (hop.isVisited()) {
            return;
        }
        for (int i = 0; i < hop.getInput().size(); ++i) {
            Hop hi = hop.getInput().get(i);
            if (descendFirst) {
                this.rule_AlgebraicSimplification(hi, descendFirst);
            }
            hi = this.removeEmptyRightIndexing(hop, hi, i);
            hi = this.removeUnnecessaryRightIndexing(hop, hi, i);
            hi = this.removeEmptyLeftIndexing(hop, hi, i);
            hi = this.removeUnnecessaryLeftIndexing(hop, hi, i);
            if (OptimizerUtils.ALLOW_OPERATOR_FUSION) {
                hi = this.fuseLeftIndexingChainToAppend(hop, hi, i);
            }
            hi = this.removeUnnecessaryCumulativeOp(hop, hi, i);
            hi = this.removeUnnecessaryReorgOperation(hop, hi, i);
            hi = this.removeUnnecessaryOuterProduct(hop, hi, i);
            if (OptimizerUtils.ALLOW_OPERATOR_FUSION) {
                hi = this.fuseDatagenAndReorgOperation(hop, hi, i);
            }
            hi = this.simplifyColwiseAggregate(hop, hi, i);
            hi = this.simplifyRowwiseAggregate(hop, hi, i);
            hi = this.simplifyColSumsMVMult(hop, hi, i);
            hi = this.simplifyRowSumsMVMult(hop, hi, i);
            hi = this.simplifyUnnecessaryAggregate(hop, hi, i);
            hi = this.simplifyEmptyAggregate(hop, hi, i);
            hi = this.simplifyEmptyUnaryOperation(hop, hi, i);
            hi = this.simplifyEmptyReorgOperation(hop, hi, i);
            hi = this.simplifyEmptySortOperation(hop, hi, i);
            hi = this.simplifyEmptyMatrixMult(hop, hi, i);
            hi = this.simplifyIdentityRepMatrixMult(hop, hi, i);
            hi = this.simplifyScalarMatrixMult(hop, hi, i);
            hi = this.simplifyMatrixMultDiag(hop, hi, i);
            hi = this.simplifyDiagMatrixMult(hop, hi, i);
            hi = this.simplifySumDiagToTrace(hi);
            hi = this.pushdownBinaryOperationOnDiag(hop, hi, i);
            hi = this.pushdownSumOnAdditiveBinary(hop, hi, i);
            if (OptimizerUtils.ALLOW_OPERATOR_FUSION) {
                hi = this.simplifyWeightedSquaredLoss(hop, hi, i);
                hi = this.simplifyWeightedSigmoidMMChains(hop, hi, i);
                hi = this.simplifyWeightedDivMM(hop, hi, i);
                hi = this.simplifyWeightedCrossEntropy(hop, hi, i);
                hi = this.simplifyWeightedUnaryMM(hop, hi, i);
                hi = this.simplifyDotProductSum(hop, hi, i);
                hi = this.fuseSumSquared(hop, hi, i);
                hi = this.fuseAxpyBinaryOperationChain(hop, hi, i);
            }
            hi = this.reorderMinusMatrixMult(hop, hi, i);
            hi = this.simplifySumMatrixMult(hop, hi, i);
            hi = this.simplifyEmptyBinaryOperation(hop, hi, i);
            hi = this.simplifyScalarMVBinaryOperation(hi);
            hi = this.simplifyNnzComputation(hop, hi, i);
            hi = this.simplifyNrowNcolComputation(hop, hi, i);
            hi = this.simplifyTableSeqExpand(hop, hi, i);
            if (descendFirst) continue;
            this.rule_AlgebraicSimplification(hi, descendFirst);
        }
        hop.setVisited();
    }

    private Hop removeEmptyRightIndexing(Hop parent, Hop hi, int pos) throws HopsException {
        Hop input;
        if (hi instanceof IndexingOp && hi.getDataType() == Expression.DataType.MATRIX && (input = hi.getInput().get(0)).getNnz() == 0L && HopRewriteUtils.isDimsKnown(hi)) {
            Hop hnew = HopRewriteUtils.createDataGenOpByVal(new LiteralOp(hi.getDim1()), new LiteralOp(hi.getDim2()), 0.0);
            HopRewriteUtils.replaceChildReference(parent, hi, hnew, pos);
            HopRewriteUtils.cleanupUnreferenced(hi, input);
            hi = hnew;
            LOG.debug((Object)"Applied removeEmptyRightIndexing");
        }
        return hi;
    }

    private Hop removeUnnecessaryRightIndexing(Hop parent, Hop hi, int pos) {
        Hop input;
        if (hi instanceof IndexingOp && HopRewriteUtils.isEqualSize(hi, input = hi.getInput().get(0)) && (hi.getDim1() != 1L || hi.getDim2() != 1L)) {
            HopRewriteUtils.replaceChildReference(parent, hi, input, pos);
            HopRewriteUtils.cleanupUnreferenced(hi);
            hi = input;
            LOG.debug((Object)"Applied removeUnnecessaryRightIndexing");
        }
        return hi;
    }

    private Hop removeEmptyLeftIndexing(Hop parent, Hop hi, int pos) throws HopsException {
        if (hi instanceof LeftIndexingOp && hi.getDataType() == Expression.DataType.MATRIX) {
            Hop input1 = hi.getInput().get(0);
            Hop input2 = hi.getInput().get(1);
            if (input1.getNnz() == 0L && input2.getNnz() == 0L) {
                Hop hnew = HopRewriteUtils.createDataGenOp(input1, 0.0);
                HopRewriteUtils.replaceChildReference(parent, hi, hnew, pos);
                HopRewriteUtils.cleanupUnreferenced(hi, input2);
                hi = hnew;
                LOG.debug((Object)"Applied removeEmptyLeftIndexing");
            }
        }
        return hi;
    }

    private Hop removeUnnecessaryLeftIndexing(Hop parent, Hop hi, int pos) {
        Hop input;
        if (hi instanceof LeftIndexingOp && HopRewriteUtils.isEqualSize(hi, input = hi.getInput().get(1))) {
            HopRewriteUtils.replaceChildReference(parent, hi, input, pos);
            HopRewriteUtils.cleanupUnreferenced(hi);
            hi = input;
            LOG.debug((Object)"Applied removeUnnecessaryLeftIndexing");
        }
        return hi;
    }

    private Hop fuseLeftIndexingChainToAppend(Hop parent, Hop hi, int pos) {
        BinaryOp bop;
        Hop pred1;
        Hop input1;
        Hop pred2;
        Hop input2;
        boolean applied = false;
        if (hi instanceof LeftIndexingOp && HopRewriteUtils.isFullColumnIndexing((LeftIndexingOp)hi) && hi.getInput().get(0) instanceof LeftIndexingOp && HopRewriteUtils.isFullColumnIndexing((LeftIndexingOp)hi.getInput().get(0)) && hi.getInput().get(0).getParent().size() == 1 && hi.getInput().get(0).getInput().get(0).getDim2() == 2L) {
            input2 = hi.getInput().get(1);
            pred2 = hi.getInput().get(4);
            input1 = hi.getInput().get(0).getInput().get(1);
            pred1 = hi.getInput().get(0).getInput().get(4);
            if (pred1 instanceof LiteralOp && HopRewriteUtils.getDoubleValueSafe((LiteralOp)pred1) == 1.0 && pred2 instanceof LiteralOp && HopRewriteUtils.getDoubleValueSafe((LiteralOp)pred2) == 2.0 && input1.getDataType() != Expression.DataType.SCALAR && input2.getDataType() != Expression.DataType.SCALAR) {
                bop = HopRewriteUtils.createBinary(input1, input2, Hop.OpOp2.CBIND);
                HopRewriteUtils.replaceChildReference(parent, hi, bop, pos);
                hi = bop;
                applied = true;
            }
        }
        if (!applied && hi instanceof LeftIndexingOp && HopRewriteUtils.isFullRowIndexing((LeftIndexingOp)hi) && hi.getInput().get(0) instanceof LeftIndexingOp && HopRewriteUtils.isFullRowIndexing((LeftIndexingOp)hi.getInput().get(0)) && hi.getInput().get(0).getParent().size() == 1 && hi.getInput().get(0).getInput().get(0).getDim1() == 2L) {
            input2 = hi.getInput().get(1);
            pred2 = hi.getInput().get(2);
            input1 = hi.getInput().get(0).getInput().get(1);
            pred1 = hi.getInput().get(0).getInput().get(2);
            if (pred1 instanceof LiteralOp && HopRewriteUtils.getDoubleValueSafe((LiteralOp)pred1) == 1.0 && pred2 instanceof LiteralOp && HopRewriteUtils.getDoubleValueSafe((LiteralOp)pred2) == 2.0 && input1.getDataType() != Expression.DataType.SCALAR && input2.getDataType() != Expression.DataType.SCALAR) {
                bop = HopRewriteUtils.createBinary(input1, input2, Hop.OpOp2.RBIND);
                HopRewriteUtils.replaceChildReference(parent, hi, bop, pos);
                hi = bop;
                applied = true;
                LOG.debug((Object)("Applied fuseLeftIndexingChainToAppend2 (line " + hi.getBeginLine() + ")"));
            }
        }
        return hi;
    }

    private Hop removeUnnecessaryCumulativeOp(Hop parent, Hop hi, int pos) {
        Hop input;
        if (hi instanceof UnaryOp && ((UnaryOp)hi).isCumulativeUnaryOperation() && HopRewriteUtils.isDimsKnown(input = hi.getInput().get(0)) && input.getDim1() == 1L) {
            Hop.OpOp1 op = ((UnaryOp)hi).getOp();
            HopRewriteUtils.replaceChildReference(parent, hi, input, pos);
            hi = input;
            LOG.debug((Object)("Applied removeUnnecessaryCumulativeOp: " + (Object)((Object)op)));
        }
        return hi;
    }

    private Hop removeUnnecessaryReorgOperation(Hop parent, Hop hi, int pos) {
        if (hi instanceof ReorgOp) {
            ReorgOp rop = (ReorgOp)hi;
            Hop input = hi.getInput().get(0);
            boolean apply = false;
            apply |= rop.getOp() == Hop.ReOrgOp.RESHAPE && HopRewriteUtils.isEqualSize(hi, input);
            if (apply |= (rop.getOp() == Hop.ReOrgOp.TRANSPOSE || rop.getOp() == Hop.ReOrgOp.RESHAPE) && rop.getDim1() == 1L && rop.getDim2() == 1L) {
                HopRewriteUtils.replaceChildReference(parent, hi, input, pos);
                hi = input;
                LOG.debug((Object)"Applied removeUnnecessaryReorg.");
            }
        }
        return hi;
    }

    private Hop removeUnnecessaryOuterProduct(Hop parent, Hop hi, int pos) {
        if (hi instanceof BinaryOp) {
            Hop.OpOp2 bop = ((BinaryOp)hi).getOp();
            Hop left = hi.getInput().get(0);
            Hop right = hi.getInput().get(1);
            if (HopRewriteUtils.isMatrixMultiply(right) && HopRewriteUtils.isDataGenOpWithConstantValue(right.getInput().get(1), 1.0) && right.getInput().get(0).getDim2() == 1L) {
                HopRewriteUtils.replaceChildReference(hi, right, right.getInput().get(0), 1);
                HopRewriteUtils.cleanupUnreferenced(right);
                LOG.debug((Object)("Applied removeUnnecessaryOuterProduct1 (line " + right.getBeginLine() + ")"));
            } else if (HopRewriteUtils.isMatrixMultiply(right) && HopRewriteUtils.isDataGenOpWithConstantValue(right.getInput().get(0), 1.0) && right.getInput().get(1).getDim1() == 1L) {
                HopRewriteUtils.replaceChildReference(hi, right, right.getInput().get(1), 1);
                HopRewriteUtils.cleanupUnreferenced(right);
                LOG.debug((Object)("Applied removeUnnecessaryOuterProduct2 (line " + right.getBeginLine() + ")"));
            } else if (HopRewriteUtils.isValidOuterBinaryOp(bop) && HopRewriteUtils.isMatrixMultiply(left) && HopRewriteUtils.isDataGenOpWithConstantValue(left.getInput().get(1), 1.0) && left.getInput().get(0).getDim2() == 1L && left.getDim1() != 1L && right.getDim1() == 1L) {
                BinaryOp hnew = HopRewriteUtils.createBinary(left.getInput().get(0), right, bop, true);
                HopRewriteUtils.replaceChildReference(parent, hi, hnew, pos);
                HopRewriteUtils.cleanupUnreferenced(hi);
                hi = hnew;
                LOG.debug((Object)("Applied removeUnnecessaryOuterProduct3 (line " + right.getBeginLine() + ")"));
            }
        }
        return hi;
    }

    private Hop fuseDatagenAndReorgOperation(Hop parent, Hop hi, int pos) {
        DataGenOp dop;
        if (HopRewriteUtils.isTransposeOperation(hi) && hi.getInput().get(0) instanceof DataGenOp && hi.getInput().get(0).getParent().size() == 1 && ((dop = (DataGenOp)hi.getInput().get(0)).getOp() == Hop.DataGenMethod.RAND || dop.getOp() == Hop.DataGenMethod.SINIT) && (dop.getDim1() == 1L || dop.getDim2() == 1L)) {
            HopRewriteUtils.removeAllChildReferences(hi);
            ArrayList parents = (ArrayList)hi.getParent().clone();
            for (int i = 0; i < parents.size(); ++i) {
                Hop lparent = (Hop)parents.get(i);
                int ppos = HopRewriteUtils.getChildReferencePos(lparent, hi);
                HopRewriteUtils.removeChildReferenceByPos(lparent, hi, ppos);
                HopRewriteUtils.addChildReference(lparent, dop, pos);
            }
            HashMap<String, Integer> rparams = dop.getParamIndexMap();
            int pos1 = rparams.get("rows");
            int pos2 = rparams.get("cols");
            rparams.put("rows", pos2);
            rparams.put("cols", pos1);
            dop.refreshSizeInformation();
            hi = dop;
            LOG.debug((Object)"Applied fuseDatagenReorgOperation.");
        }
        return hi;
    }

    private Hop simplifyColwiseAggregate(Hop parent, Hop hi, int pos) throws HopsException {
        if (hi instanceof AggUnaryOp) {
            AggUnaryOp uhi = (AggUnaryOp)hi;
            Hop input = uhi.getInput().get(0);
            if (HopRewriteUtils.isValidOp(uhi.getOp(), LOOKUP_VALID_ROW_COL_AGGREGATE) && uhi.getDirection() == Hop.Direction.Col) {
                if (input.getDim1() == 1L) {
                    if (uhi.getOp() == Hop.AggOp.VAR) {
                        Hop emptyRow = HopRewriteUtils.createDataGenOp(uhi, input, 0.0);
                        HopRewriteUtils.replaceChildReference(parent, hi, emptyRow, pos);
                        HopRewriteUtils.cleanupUnreferenced(hi, input);
                        hi = emptyRow;
                        LOG.debug((Object)"Applied simplifyColwiseAggregate for colVars");
                    } else {
                        HopRewriteUtils.replaceChildReference(parent, hi, input, pos);
                        HopRewriteUtils.cleanupUnreferenced(hi);
                        hi = input;
                        LOG.debug((Object)"Applied simplifyColwiseAggregate1");
                    }
                } else if (input.getDim2() == 1L) {
                    ArrayList parents = (ArrayList)hi.getParent().clone();
                    uhi.setDirection(Hop.Direction.RowCol);
                    uhi.setDataType(Expression.DataType.SCALAR);
                    UnaryOp cast = HopRewriteUtils.createUnary(uhi, Hop.OpOp1.CAST_AS_MATRIX);
                    for (Hop p : parents) {
                        int ix = HopRewriteUtils.getChildReferencePos(p, hi);
                        HopRewriteUtils.replaceChildReference(p, hi, cast, ix);
                    }
                    hi = cast;
                    LOG.debug((Object)"Applied simplifyColwiseAggregate2");
                }
            }
        }
        return hi;
    }

    private Hop simplifyRowwiseAggregate(Hop parent, Hop hi, int pos) throws HopsException {
        if (hi instanceof AggUnaryOp) {
            AggUnaryOp uhi = (AggUnaryOp)hi;
            Hop input = uhi.getInput().get(0);
            if (HopRewriteUtils.isValidOp(uhi.getOp(), LOOKUP_VALID_ROW_COL_AGGREGATE) && uhi.getDirection() == Hop.Direction.Row) {
                if (input.getDim2() == 1L) {
                    if (uhi.getOp() == Hop.AggOp.VAR) {
                        Hop emptyCol = HopRewriteUtils.createDataGenOp(input, uhi, 0.0);
                        HopRewriteUtils.replaceChildReference(parent, hi, emptyCol, pos);
                        HopRewriteUtils.cleanupUnreferenced(hi, input);
                        hi = emptyCol;
                        LOG.debug((Object)"Applied simplifyRowwiseAggregate for rowVars");
                    } else {
                        HopRewriteUtils.replaceChildReference(parent, hi, input, pos);
                        HopRewriteUtils.cleanupUnreferenced(hi);
                        hi = input;
                        LOG.debug((Object)"Applied simplifyRowwiseAggregate1");
                    }
                } else if (input.getDim1() == 1L) {
                    ArrayList parents = (ArrayList)hi.getParent().clone();
                    uhi.setDirection(Hop.Direction.RowCol);
                    uhi.setDataType(Expression.DataType.SCALAR);
                    UnaryOp cast = HopRewriteUtils.createUnary(uhi, Hop.OpOp1.CAST_AS_MATRIX);
                    for (Hop p : parents) {
                        int ix = HopRewriteUtils.getChildReferencePos(p, hi);
                        HopRewriteUtils.replaceChildReference(p, hi, cast, ix);
                    }
                    hi = cast;
                    LOG.debug((Object)"Applied simplifyRowwiseAggregate2");
                }
            }
        }
        return hi;
    }

    private Hop simplifyColSumsMVMult(Hop parent, Hop hi, int pos) throws HopsException {
        if (hi instanceof AggUnaryOp) {
            AggUnaryOp uhi = (AggUnaryOp)hi;
            Hop input = uhi.getInput().get(0);
            if (uhi.getOp() == Hop.AggOp.SUM && uhi.getDirection() == Hop.Direction.Col && HopRewriteUtils.isBinary(input, Hop.OpOp2.MULT)) {
                Hop left = input.getInput().get(0);
                Hop right = input.getInput().get(1);
                if (left.getDim1() > 1L && left.getDim2() > 1L && right.getDim1() > 1L && right.getDim2() == 1L) {
                    ReorgOp trans = HopRewriteUtils.createTranspose(right);
                    AggBinaryOp mmult = HopRewriteUtils.createMatrixMultiply(trans, left);
                    HopRewriteUtils.replaceChildReference(parent, hi, mmult, pos);
                    HopRewriteUtils.cleanupUnreferenced(uhi, input);
                    hi = mmult;
                    LOG.debug((Object)"Applied simplifyColSumsMVMult");
                }
            }
        }
        return hi;
    }

    private Hop simplifyRowSumsMVMult(Hop parent, Hop hi, int pos) throws HopsException {
        if (hi instanceof AggUnaryOp) {
            AggUnaryOp uhi = (AggUnaryOp)hi;
            Hop input = uhi.getInput().get(0);
            if (uhi.getOp() == Hop.AggOp.SUM && uhi.getDirection() == Hop.Direction.Row && HopRewriteUtils.isBinary(input, Hop.OpOp2.MULT)) {
                Hop left = input.getInput().get(0);
                Hop right = input.getInput().get(1);
                if (left.getDim1() > 1L && left.getDim2() > 1L && right.getDim1() == 1L && right.getDim2() > 1L) {
                    ReorgOp trans = HopRewriteUtils.createTranspose(right);
                    AggBinaryOp mmult = HopRewriteUtils.createMatrixMultiply(left, trans);
                    HopRewriteUtils.replaceChildReference(parent, hi, mmult, pos);
                    HopRewriteUtils.cleanupUnreferenced(hi, input);
                    hi = mmult;
                    LOG.debug((Object)"Applied simplifyRowSumsMVMult");
                }
            }
        }
        return hi;
    }

    private Hop simplifyUnnecessaryAggregate(Hop parent, Hop hi, int pos) throws HopsException {
        if (hi instanceof AggUnaryOp && ((AggUnaryOp)hi).getDirection() == Hop.Direction.RowCol) {
            AggUnaryOp uhi = (AggUnaryOp)hi;
            Hop input = uhi.getInput().get(0);
            if (HopRewriteUtils.isValidOp(uhi.getOp(), LOOKUP_VALID_UNNECESSARY_AGGREGATE) && input.getDim1() == 1L && input.getDim2() == 1L) {
                UnaryOp cast = HopRewriteUtils.createUnary(input, Hop.OpOp1.CAST_AS_SCALAR);
                HopRewriteUtils.replaceChildReference(parent, hi, cast, pos);
                hi = cast;
                LOG.debug((Object)"Applied simplifyUnncessaryAggregate");
            }
        }
        return hi;
    }

    private Hop simplifyEmptyAggregate(Hop parent, Hop hi, int pos) throws HopsException {
        if (hi instanceof AggUnaryOp) {
            AggUnaryOp uhi = (AggUnaryOp)hi;
            Hop input = uhi.getInput().get(0);
            if (HopRewriteUtils.isValidOp(uhi.getOp(), LOOKUP_VALID_EMPTY_AGGREGATE) && HopRewriteUtils.isEmpty(input)) {
                Hop hnew = null;
                hnew = uhi.getDirection() == Hop.Direction.RowCol ? new LiteralOp(0.0) : (uhi.getDirection() == Hop.Direction.Col ? HopRewriteUtils.createDataGenOp(uhi, input, 0.0) : HopRewriteUtils.createDataGenOp(input, uhi, 0.0));
                HopRewriteUtils.replaceChildReference(parent, hi, hnew, pos);
                hi = hnew;
                LOG.debug((Object)"Applied simplifyEmptyAggregate");
            }
        }
        return hi;
    }

    private Hop simplifyEmptyUnaryOperation(Hop parent, Hop hi, int pos) throws HopsException {
        if (hi instanceof UnaryOp) {
            UnaryOp uhi = (UnaryOp)hi;
            Hop input = uhi.getInput().get(0);
            if (HopRewriteUtils.isValidOp(uhi.getOp(), LOOKUP_VALID_EMPTY_UNARY) && HopRewriteUtils.isEmpty(input)) {
                Hop hnew = HopRewriteUtils.createDataGenOp(input, 0.0);
                HopRewriteUtils.replaceChildReference(parent, hi, hnew, pos);
                hi = hnew;
                LOG.debug((Object)"Applied simplifyEmptyUnaryOperation");
            }
        }
        return hi;
    }

    private Hop simplifyEmptyReorgOperation(Hop parent, Hop hi, int pos) throws HopsException {
        ReorgOp rhi;
        Hop input;
        if (hi instanceof ReorgOp && HopRewriteUtils.isEmpty(input = (rhi = (ReorgOp)hi).getInput().get(0))) {
            Hop hnew = null;
            if (rhi.getOp() == Hop.ReOrgOp.TRANSPOSE) {
                hnew = HopRewriteUtils.createDataGenOp(input, true, input, true, 0.0);
            } else if (rhi.getOp() == Hop.ReOrgOp.REV) {
                hnew = HopRewriteUtils.createDataGenOp(input, 0.0);
            } else if (rhi.getOp() == Hop.ReOrgOp.DIAG) {
                if (HopRewriteUtils.isDimsKnown(input)) {
                    hnew = input.getDim2() == 1L ? HopRewriteUtils.createDataGenOp(input, false, input, true, 0.0) : HopRewriteUtils.createDataGenOpByVal(HopRewriteUtils.createValueHop(input, true), new LiteralOp(1L), 0.0);
                }
            } else if (rhi.getOp() == Hop.ReOrgOp.RESHAPE) {
                hnew = HopRewriteUtils.createDataGenOpByVal(rhi.getInput().get(1), rhi.getInput().get(2), 0.0);
            }
            if (hnew != null) {
                HopRewriteUtils.replaceChildReference(parent, hi, hnew, pos);
                hi = hnew;
                LOG.debug((Object)"Applied simplifyEmptyReorgOperation");
            }
        }
        return hi;
    }

    private Hop simplifyEmptySortOperation(Hop parent, Hop hi, int pos) throws HopsException {
        ReorgOp rhi;
        Hop input;
        if (hi instanceof ReorgOp && ((ReorgOp)hi).getOp() == Hop.ReOrgOp.SORT && HopRewriteUtils.isEmpty(input = (rhi = (ReorgOp)hi).getInput().get(0))) {
            Hop hnew = null;
            boolean ixret = false;
            if (rhi.getInput().get(3) instanceof LiteralOp) {
                ixret = HopRewriteUtils.getBooleanValue((LiteralOp)rhi.getInput().get(3));
                hnew = ixret ? HopRewriteUtils.createSeqDataGenOp(input) : HopRewriteUtils.createDataGenOp(input, 0.0);
            }
            if (hnew != null) {
                HopRewriteUtils.replaceChildReference(parent, hi, hnew, pos);
                hi = hnew;
                LOG.debug((Object)("Applied simplifyEmptySortOperation (indexreturn=" + ixret + ")."));
            }
        }
        return hi;
    }

    private Hop simplifyEmptyMatrixMult(Hop parent, Hop hi, int pos) throws HopsException {
        if (HopRewriteUtils.isMatrixMultiply(hi)) {
            Hop left = hi.getInput().get(0);
            Hop right = hi.getInput().get(1);
            if (HopRewriteUtils.isEmpty(left) || HopRewriteUtils.isEmpty(right)) {
                Hop hnew = HopRewriteUtils.createDataGenOp(left, right, 0.0);
                HopRewriteUtils.replaceChildReference(parent, hi, hnew, pos);
                hi = hnew;
                LOG.debug((Object)"Applied simplifyEmptyMatrixMult");
            }
        }
        return hi;
    }

    private Hop simplifyIdentityRepMatrixMult(Hop parent, Hop hi, int pos) throws HopsException {
        if (HopRewriteUtils.isMatrixMultiply(hi)) {
            Hop left = hi.getInput().get(0);
            Hop right = hi.getInput().get(1);
            if (HopRewriteUtils.isDimsKnown(right) && right.getDim1() == 1L && right.getDim2() == 1L && right instanceof DataGenOp && ((DataGenOp)right).getOp() == Hop.DataGenMethod.RAND && ((DataGenOp)right).hasConstantValue(1.0)) {
                HopRewriteUtils.replaceChildReference(parent, hi, left, pos);
                hi = left;
                LOG.debug((Object)"Applied simplifyIdentiyMatrixMult");
            }
        }
        return hi;
    }

    private Hop simplifyScalarMatrixMult(Hop parent, Hop hi, int pos) throws HopsException {
        if (HopRewriteUtils.isMatrixMultiply(hi)) {
            Hop left = hi.getInput().get(0);
            Hop right = hi.getInput().get(1);
            if (HopRewriteUtils.isDimsKnown(left) && left.getDim1() == 1L && left.getDim2() == 1L) {
                UnaryOp cast = HopRewriteUtils.createUnary(left, Hop.OpOp1.CAST_AS_SCALAR);
                BinaryOp mult = HopRewriteUtils.createBinary(cast, right, Hop.OpOp2.MULT);
                HopRewriteUtils.replaceChildReference(parent, hi, mult, pos);
                HopRewriteUtils.cleanupUnreferenced(hi);
                hi = mult;
                LOG.debug((Object)"Applied simplifyScalarMatrixMult1");
            } else if (HopRewriteUtils.isDimsKnown(right) && right.getDim1() == 1L && right.getDim2() == 1L) {
                UnaryOp cast = HopRewriteUtils.createUnary(right, Hop.OpOp1.CAST_AS_SCALAR);
                BinaryOp mult = HopRewriteUtils.createBinary(cast, left, Hop.OpOp2.MULT);
                HopRewriteUtils.replaceChildReference(parent, hi, mult, pos);
                HopRewriteUtils.cleanupUnreferenced(hi);
                hi = mult;
                LOG.debug((Object)"Applied simplifyScalarMatrixMult2");
            }
        }
        return hi;
    }

    private Hop simplifyMatrixMultDiag(Hop parent, Hop hi, int pos) throws HopsException {
        BinaryOp hnew = null;
        if (HopRewriteUtils.isMatrixMultiply(hi)) {
            Hop left = hi.getInput().get(0);
            Hop right = hi.getInput().get(1);
            if (left instanceof ReorgOp && ((ReorgOp)left).getOp() == Hop.ReOrgOp.DIAG && HopRewriteUtils.isDimsKnown(left) && left.getDim2() > 1L) {
                if (right.getDim2() == 1L) {
                    Hop input = left.getInput().get(0);
                    hnew = HopRewriteUtils.createBinary(input, right, Hop.OpOp2.MULT);
                    LOG.debug((Object)"Applied simplifyMatrixMultDiag1");
                } else if (right.getDim2() > 1L) {
                    Hop input = left.getInput().get(0);
                    hnew = HopRewriteUtils.createBinary(right, input, Hop.OpOp2.MULT);
                    LOG.debug((Object)"Applied simplifyMatrixMultDiag2");
                }
            }
        }
        if (hnew != null) {
            HopRewriteUtils.replaceChildReference(parent, hi, hnew, pos);
            HopRewriteUtils.cleanupUnreferenced(hi);
            hi = hnew;
        }
        return hi;
    }

    private Hop simplifyDiagMatrixMult(Hop parent, Hop hi, int pos) {
        Hop hi2;
        if (hi instanceof ReorgOp && ((ReorgOp)hi).getOp() == Hop.ReOrgOp.DIAG && hi.getDim2() == 1L && HopRewriteUtils.isMatrixMultiply(hi2 = hi.getInput().get(0))) {
            Hop left = hi2.getInput().get(0);
            Hop right = hi2.getInput().get(1);
            ReorgOp trans = HopRewriteUtils.createTranspose(right);
            BinaryOp mult = HopRewriteUtils.createBinary(left, trans, Hop.OpOp2.MULT);
            AggUnaryOp rowSum = HopRewriteUtils.createAggUnaryOp(mult, Hop.AggOp.SUM, Hop.Direction.Row);
            HopRewriteUtils.replaceChildReference(parent, hi, rowSum, pos);
            HopRewriteUtils.cleanupUnreferenced(hi, hi2);
            hi = rowSum;
            LOG.debug((Object)"Applied simplifyDiagMatrixMult");
        }
        return hi;
    }

    private Hop simplifySumDiagToTrace(Hop hi) {
        Hop hi2;
        AggUnaryOp au;
        if (hi instanceof AggUnaryOp && (au = (AggUnaryOp)hi).getOp() == Hop.AggOp.SUM && au.getDirection() == Hop.Direction.RowCol && (hi2 = au.getInput().get(0)) instanceof ReorgOp && ((ReorgOp)hi2).getOp() == Hop.ReOrgOp.DIAG && hi2.getDim2() == 1L) {
            Hop hi3 = hi2.getInput().get(0);
            HopRewriteUtils.replaceChildReference(au, hi2, hi3, 0);
            HopRewriteUtils.cleanupUnreferenced(hi2);
            au.setOp(Hop.AggOp.TRACE);
            LOG.debug((Object)"Applied simplifySumDiagToTrace");
        }
        return hi;
    }

    private Hop pushdownBinaryOperationOnDiag(Hop parent, Hop hi, int pos) {
        if (HopRewriteUtils.isBinary(hi, Hop.OpOp2.MULT)) {
            Hop left = hi.getInput().get(0);
            Hop right = hi.getInput().get(1);
            boolean applyLeft = false;
            boolean applyRight = false;
            if (left instanceof ReorgOp && ((ReorgOp)left).getOp() == Hop.ReOrgOp.DIAG && left.getParent().size() == 1 && left.getInput().get(0).getDim2() == 1L && right.getDataType() == Expression.DataType.SCALAR) {
                applyLeft = true;
            } else if (right instanceof ReorgOp && ((ReorgOp)right).getOp() == Hop.ReOrgOp.DIAG && right.getParent().size() == 1 && right.getInput().get(0).getDim2() == 1L && left.getDataType() == Expression.DataType.SCALAR) {
                applyRight = true;
            }
            if (applyLeft || applyRight) {
                Hop input;
                int lpos;
                ArrayList parents = (ArrayList)hi.getParent().clone();
                ArrayList<Integer> parentspos = new ArrayList<Integer>();
                for (Hop lparent : parents) {
                    lpos = HopRewriteUtils.getChildReferencePos(lparent, hi);
                    HopRewriteUtils.removeChildReferenceByPos(lparent, hi, lpos);
                    parentspos.add(lpos);
                }
                if (applyLeft) {
                    input = left.getInput().get(0);
                    HopRewriteUtils.removeChildReferenceByPos(hi, left, 0);
                    HopRewriteUtils.removeChildReferenceByPos(left, input, 0);
                    HopRewriteUtils.addChildReference(left, hi, 0);
                    HopRewriteUtils.addChildReference(hi, input, 0);
                    hi.refreshSizeInformation();
                    hi = left;
                } else if (applyRight) {
                    input = right.getInput().get(0);
                    HopRewriteUtils.removeChildReferenceByPos(hi, right, 1);
                    HopRewriteUtils.removeChildReferenceByPos(right, input, 0);
                    HopRewriteUtils.addChildReference(right, hi, 0);
                    HopRewriteUtils.addChildReference(hi, input, 1);
                    hi.refreshSizeInformation();
                    hi = right;
                }
                for (int i = 0; i < parents.size(); ++i) {
                    Hop lparent;
                    lparent = (Hop)parents.get(i);
                    lpos = (Integer)parentspos.get(i);
                    HopRewriteUtils.addChildReference(lparent, hi, lpos);
                }
                LOG.debug((Object)"Applied pushdownBinaryOperationOnDiag.");
            }
        }
        return hi;
    }

    private Hop pushdownSumOnAdditiveBinary(Hop parent, Hop hi, int pos) {
        Hop right;
        BinaryOp bop;
        Hop left;
        if (hi instanceof AggUnaryOp && ((AggUnaryOp)hi).getDirection() == Hop.Direction.RowCol && ((AggUnaryOp)hi).getOp() == Hop.AggOp.SUM && hi.getInput().get(0) instanceof BinaryOp && hi.getInput().get(0).getParent().size() == 1 && HopRewriteUtils.isEqualSize(left = (bop = (BinaryOp)hi.getInput().get(0)).getInput().get(0), right = bop.getInput().get(1)) && left.getDataType() == Expression.DataType.MATRIX && right.getDataType() == Expression.DataType.MATRIX) {
            Hop.OpOp2 applyOp;
            Hop.OpOp2 opOp2 = applyOp = bop.getOp() == Hop.OpOp2.PLUS || bop.getOp() == Hop.OpOp2.MINUS ? bop.getOp() : null;
            if (applyOp != null) {
                AggUnaryOp sum1 = HopRewriteUtils.createSum(left);
                AggUnaryOp sum2 = HopRewriteUtils.createSum(right);
                BinaryOp newBin = HopRewriteUtils.createBinary(sum1, sum2, applyOp);
                HopRewriteUtils.replaceChildReference(parent, hi, newBin, pos);
                HopRewriteUtils.cleanupUnreferenced(hi, bop);
                hi = newBin;
                LOG.debug((Object)"Applied pushdownSumOnAdditiveBinary.");
            }
        }
        return hi;
    }

    private Hop simplifyWeightedSquaredLoss(Hop parent, Hop hi, int pos) throws HopsException {
        QuaternaryOp hnew = null;
        if (hi instanceof AggUnaryOp && ((AggUnaryOp)hi).getDirection() == Hop.Direction.RowCol && ((AggUnaryOp)hi).getOp() == Hop.AggOp.SUM && hi.getInput().get(0) instanceof BinaryOp && hi.getInput().get(0).getDim2() > 1L) {
            Hop V;
            Hop U;
            Hop W;
            Hop tmp;
            Hop lright;
            Hop lleft;
            Hop X;
            int uvIndex;
            BinaryOp bop = (BinaryOp)hi.getInput().get(0);
            boolean appliedPattern = false;
            if (bop.getOp() == Hop.OpOp2.MULT && HopRewriteUtils.isBinary(bop.getInput().get(1), Hop.OpOp2.POW) && bop.getInput().get(0).getDataType() == Expression.DataType.MATRIX && HopRewriteUtils.isEqualSize(bop.getInput().get(0), bop.getInput().get(1)) && bop.getInput().get(1).getInput().get(1) instanceof LiteralOp && HopRewriteUtils.getDoubleValue((LiteralOp)bop.getInput().get(1).getInput().get(1)) == 2.0) {
                Hop W2 = bop.getInput().get(0);
                Hop tmp2 = bop.getInput().get(1).getInput().get(0);
                if (HopRewriteUtils.isBinary(tmp2, Hop.OpOp2.MINUS) && HopRewriteUtils.isEqualSize(tmp2.getInput().get(0), tmp2.getInput().get(1)) && tmp2.getInput().get(0).getDataType() == Expression.DataType.MATRIX) {
                    uvIndex = -1;
                    if (tmp2.getInput().get(1) instanceof AggBinaryOp && HopRewriteUtils.isSingleBlock(tmp2.getInput().get(1).getInput().get(0), true)) {
                        uvIndex = 1;
                    } else if (tmp2.getInput().get(0) instanceof AggBinaryOp && HopRewriteUtils.isSingleBlock(tmp2.getInput().get(0).getInput().get(0), true)) {
                        uvIndex = 0;
                    }
                    if (uvIndex >= 0) {
                        X = tmp2.getInput().get(uvIndex == 0 ? 1 : 0);
                        Hop U2 = tmp2.getInput().get(uvIndex).getInput().get(0);
                        Hop V2 = tmp2.getInput().get(uvIndex).getInput().get(1);
                        V2 = !HopRewriteUtils.isTransposeOperation(V2) ? HopRewriteUtils.createTranspose(V2) : V2.getInput().get(0);
                        if (HopRewriteUtils.isNonZeroIndicator(W2, X)) {
                            W2 = new LiteralOp(1L);
                        }
                        hnew = new QuaternaryOp(hi.getName(), Expression.DataType.SCALAR, Expression.ValueType.DOUBLE, Hop.OpOp4.WSLOSS, X, U2, V2, W2, true);
                        HopRewriteUtils.setOutputParametersForScalar(hnew);
                        appliedPattern = true;
                        LOG.debug((Object)("Applied simplifyWeightedSquaredLoss1" + uvIndex + " (line " + hi.getBeginLine() + ")"));
                    }
                }
            }
            if (!appliedPattern && bop.getOp() == Hop.OpOp2.POW && bop.getInput().get(1) instanceof LiteralOp && HopRewriteUtils.getDoubleValue((LiteralOp)bop.getInput().get(1)) == 2.0 && HopRewriteUtils.isBinary(bop.getInput().get(0), Hop.OpOp2.MINUS) && bop.getInput().get(0).getDataType() == Expression.DataType.MATRIX && HopRewriteUtils.isEqualSize(bop.getInput().get(0).getInput().get(0), bop.getInput().get(0).getInput().get(1)) && bop.getInput().get(0).getInput().get(0).getDataType() == Expression.DataType.MATRIX) {
                lleft = bop.getInput().get(0).getInput().get(0);
                lright = bop.getInput().get(0).getInput().get(1);
                int wuvIndex = -1;
                if (lright instanceof BinaryOp && lright.getInput().get(1) instanceof AggBinaryOp) {
                    wuvIndex = 1;
                } else if (lleft instanceof BinaryOp && lleft.getInput().get(1) instanceof AggBinaryOp) {
                    wuvIndex = 0;
                }
                if (wuvIndex >= 0) {
                    X = bop.getInput().get(0).getInput().get(wuvIndex == 0 ? 1 : 0);
                    tmp = bop.getInput().get(0).getInput().get(wuvIndex);
                    if (((BinaryOp)tmp).getOp() == Hop.OpOp2.MULT && tmp.getInput().get(0).getDataType() == Expression.DataType.MATRIX && HopRewriteUtils.isEqualSize(tmp.getInput().get(0), tmp.getInput().get(1)) && HopRewriteUtils.isSingleBlock(tmp.getInput().get(1).getInput().get(0), true)) {
                        W = tmp.getInput().get(0);
                        U = tmp.getInput().get(1).getInput().get(0);
                        V = tmp.getInput().get(1).getInput().get(1);
                        V = !HopRewriteUtils.isTransposeOperation(V) ? HopRewriteUtils.createTranspose(V) : V.getInput().get(0);
                        hnew = new QuaternaryOp(hi.getName(), Expression.DataType.SCALAR, Expression.ValueType.DOUBLE, Hop.OpOp4.WSLOSS, X, U, V, W, false);
                        HopRewriteUtils.setOutputParametersForScalar(hnew);
                        appliedPattern = true;
                        LOG.debug((Object)("Applied simplifyWeightedSquaredLoss2" + wuvIndex + " (line " + hi.getBeginLine() + ")"));
                    }
                }
            }
            if (!appliedPattern && bop.getOp() == Hop.OpOp2.POW && bop.getInput().get(1) instanceof LiteralOp && HopRewriteUtils.getDoubleValue((LiteralOp)bop.getInput().get(1)) == 2.0 && HopRewriteUtils.isBinary(bop.getInput().get(0), Hop.OpOp2.MINUS) && bop.getInput().get(0).getDataType() == Expression.DataType.MATRIX && HopRewriteUtils.isEqualSize(bop.getInput().get(0).getInput().get(0), bop.getInput().get(0).getInput().get(1)) && bop.getInput().get(0).getInput().get(0).getDataType() == Expression.DataType.MATRIX) {
                lleft = bop.getInput().get(0).getInput().get(0);
                lright = bop.getInput().get(0).getInput().get(1);
                uvIndex = -1;
                if (lright instanceof AggBinaryOp && HopRewriteUtils.isSingleBlock(lright.getInput().get(0), true)) {
                    uvIndex = 1;
                } else if (lleft instanceof AggBinaryOp && HopRewriteUtils.isSingleBlock(lleft.getInput().get(0), true)) {
                    uvIndex = 0;
                }
                if (uvIndex >= 0) {
                    X = bop.getInput().get(0).getInput().get(uvIndex == 0 ? 1 : 0);
                    tmp = bop.getInput().get(0).getInput().get(uvIndex);
                    W = new LiteralOp(1L);
                    U = tmp.getInput().get(0);
                    V = tmp.getInput().get(1);
                    V = !HopRewriteUtils.isTransposeOperation(V) ? HopRewriteUtils.createTranspose(V) : V.getInput().get(0);
                    hnew = new QuaternaryOp(hi.getName(), Expression.DataType.SCALAR, Expression.ValueType.DOUBLE, Hop.OpOp4.WSLOSS, X, U, V, W, false);
                    HopRewriteUtils.setOutputParametersForScalar(hnew);
                    appliedPattern = true;
                    LOG.debug((Object)("Applied simplifyWeightedSquaredLoss3" + uvIndex + " (line " + hi.getBeginLine() + ")"));
                }
            }
        }
        if (hnew != null) {
            HopRewriteUtils.replaceChildReference(parent, hi, hnew, pos);
            hi = hnew;
        }
        return hi;
    }

    private Hop simplifyWeightedSigmoidMMChains(Hop parent, Hop hi, int pos) throws HopsException {
        QuaternaryOp hnew = null;
        if (HopRewriteUtils.isBinary(hi, Hop.OpOp2.MULT) && hi.getDim2() > 1L && HopRewriteUtils.isEqualSize(hi.getInput().get(0), hi.getInput().get(1)) && hi.getInput().get(0).getDataType() == Expression.DataType.MATRIX && hi.getInput().get(1) instanceof UnaryOp) {
            BinaryOp bop;
            Hop tX;
            Hop Y;
            Hop W;
            UnaryOp uop = (UnaryOp)hi.getInput().get(1);
            boolean appliedPattern = false;
            if (uop.getOp() == Hop.OpOp1.SIGMOID && uop.getInput().get(0) instanceof AggBinaryOp && HopRewriteUtils.isSingleBlock(uop.getInput().get(0).getInput().get(0), true)) {
                W = hi.getInput().get(0);
                Y = uop.getInput().get(0).getInput().get(0);
                tX = uop.getInput().get(0).getInput().get(1);
                tX = !HopRewriteUtils.isTransposeOperation(tX) ? HopRewriteUtils.createTranspose(tX) : tX.getInput().get(0);
                hnew = new QuaternaryOp(hi.getName(), Expression.DataType.MATRIX, Expression.ValueType.DOUBLE, Hop.OpOp4.WSIGMOID, W, Y, tX, false, false);
                hnew.setOutputBlocksizes(W.getRowsInBlock(), W.getColsInBlock());
                ((Hop)hnew).refreshSizeInformation();
                appliedPattern = true;
                LOG.debug((Object)("Applied simplifyWeightedSigmoid1 (line " + hi.getBeginLine() + ")"));
            }
            if (!appliedPattern && uop.getOp() == Hop.OpOp1.SIGMOID && HopRewriteUtils.isBinary(uop.getInput().get(0), Hop.OpOp2.MINUS) && uop.getInput().get(0).getInput().get(0) instanceof LiteralOp && HopRewriteUtils.getDoubleValueSafe((LiteralOp)uop.getInput().get(0).getInput().get(0)) == 0.0 && uop.getInput().get(0).getInput().get(1) instanceof AggBinaryOp && HopRewriteUtils.isSingleBlock(uop.getInput().get(0).getInput().get(1).getInput().get(0), true)) {
                W = hi.getInput().get(0);
                Y = uop.getInput().get(0).getInput().get(1).getInput().get(0);
                tX = uop.getInput().get(0).getInput().get(1).getInput().get(1);
                tX = !HopRewriteUtils.isTransposeOperation(tX) ? HopRewriteUtils.createTranspose(tX) : tX.getInput().get(0);
                hnew = new QuaternaryOp(hi.getName(), Expression.DataType.MATRIX, Expression.ValueType.DOUBLE, Hop.OpOp4.WSIGMOID, W, Y, tX, false, true);
                hnew.setOutputBlocksizes(W.getRowsInBlock(), W.getColsInBlock());
                ((Hop)hnew).refreshSizeInformation();
                appliedPattern = true;
                LOG.debug((Object)("Applied simplifyWeightedSigmoid2 (line " + hi.getBeginLine() + ")"));
            }
            if (!appliedPattern && uop.getOp() == Hop.OpOp1.LOG && HopRewriteUtils.isUnary(uop.getInput().get(0), Hop.OpOp1.SIGMOID) && uop.getInput().get(0).getInput().get(0) instanceof AggBinaryOp && HopRewriteUtils.isSingleBlock(uop.getInput().get(0).getInput().get(0).getInput().get(0), true)) {
                W = hi.getInput().get(0);
                Y = uop.getInput().get(0).getInput().get(0).getInput().get(0);
                tX = uop.getInput().get(0).getInput().get(0).getInput().get(1);
                tX = !HopRewriteUtils.isTransposeOperation(tX) ? HopRewriteUtils.createTranspose(tX) : tX.getInput().get(0);
                hnew = new QuaternaryOp(hi.getName(), Expression.DataType.MATRIX, Expression.ValueType.DOUBLE, Hop.OpOp4.WSIGMOID, W, Y, tX, true, false);
                hnew.setOutputBlocksizes(W.getRowsInBlock(), W.getColsInBlock());
                ((Hop)hnew).refreshSizeInformation();
                appliedPattern = true;
                LOG.debug((Object)("Applied simplifyWeightedSigmoid3 (line " + hi.getBeginLine() + ")"));
            }
            if (!appliedPattern && uop.getOp() == Hop.OpOp1.LOG && HopRewriteUtils.isUnary(uop.getInput().get(0), Hop.OpOp1.SIGMOID) && HopRewriteUtils.isBinary(uop.getInput().get(0).getInput().get(0), Hop.OpOp2.MINUS) && (bop = (BinaryOp)uop.getInput().get(0).getInput().get(0)).getInput().get(0) instanceof LiteralOp && HopRewriteUtils.getDoubleValueSafe((LiteralOp)bop.getInput().get(0)) == 0.0 && bop.getInput().get(1) instanceof AggBinaryOp && HopRewriteUtils.isSingleBlock(bop.getInput().get(1).getInput().get(0), true)) {
                Hop W2 = hi.getInput().get(0);
                Hop Y2 = bop.getInput().get(1).getInput().get(0);
                Hop tX2 = bop.getInput().get(1).getInput().get(1);
                tX2 = !HopRewriteUtils.isTransposeOperation(tX2) ? HopRewriteUtils.createTranspose(tX2) : tX2.getInput().get(0);
                hnew = new QuaternaryOp(hi.getName(), Expression.DataType.MATRIX, Expression.ValueType.DOUBLE, Hop.OpOp4.WSIGMOID, W2, Y2, tX2, true, true);
                hnew.setOutputBlocksizes(W2.getRowsInBlock(), W2.getColsInBlock());
                ((Hop)hnew).refreshSizeInformation();
                appliedPattern = true;
                LOG.debug((Object)("Applied simplifyWeightedSigmoid4 (line " + hi.getBeginLine() + ")"));
            }
        }
        if (hnew != null) {
            HopRewriteUtils.replaceChildReference(parent, hi, hnew, pos);
            hi = hnew;
        }
        return hi;
    }

    private Hop simplifyWeightedDivMM(Hop parent, Hop hi, int pos) throws HopsException {
        Hop hnew = null;
        boolean appliedPattern = false;
        if (HopRewriteUtils.isMatrixMultiply(hi) && (hi.getInput().get(0) instanceof BinaryOp && HopRewriteUtils.isValidOp(((BinaryOp)hi.getInput().get(0)).getOp(), LOOKUP_VALID_WDIVMM_BINARY) || hi.getInput().get(1) instanceof BinaryOp && hi.getDim2() > 1L && HopRewriteUtils.isValidOp(((BinaryOp)hi.getInput().get(1)).getOp(), LOOKUP_VALID_WDIVMM_BINARY))) {
            boolean mult;
            Hop V;
            Hop U;
            Hop W;
            Hop left = hi.getInput().get(0);
            Hop right = hi.getInput().get(1);
            if (right instanceof BinaryOp && HopRewriteUtils.isValidOp(((BinaryOp)right).getOp(), LOOKUP_VALID_WDIVMM_BINARY) && HopRewriteUtils.isEqualSize(right.getInput().get(0), right.getInput().get(1)) && HopRewriteUtils.isOuterProductLikeMM(right.getInput().get(1)) && HopRewriteUtils.isSingleBlock(right.getInput().get(1).getInput().get(0), true)) {
                W = right.getInput().get(0);
                U = right.getInput().get(1).getInput().get(0);
                V = right.getInput().get(1).getInput().get(1);
                if (HopRewriteUtils.isTransposeOfItself(left, U)) {
                    V = !HopRewriteUtils.isTransposeOperation(V) ? HopRewriteUtils.createTranspose(V) : V.getInput().get(0);
                    mult = ((BinaryOp)right).getOp() == Hop.OpOp2.MULT;
                    hnew = new QuaternaryOp(hi.getName(), Expression.DataType.MATRIX, Expression.ValueType.DOUBLE, Hop.OpOp4.WDIVMM, W, U, V, new LiteralOp(-1L), 1, mult, false);
                    hnew.setOutputBlocksizes(W.getRowsInBlock(), W.getColsInBlock());
                    hnew.refreshSizeInformation();
                    hnew = HopRewriteUtils.createTranspose(hnew);
                    appliedPattern = true;
                    LOG.debug((Object)("Applied simplifyWeightedDivMM1 (line " + hi.getBeginLine() + ")"));
                }
            }
            if (!appliedPattern && HopRewriteUtils.isBinary(right, LOOKUP_VALID_WDIVMM_BINARY[1]) && HopRewriteUtils.isEqualSize(right.getInput().get(0), right.getInput().get(1)) && HopRewriteUtils.isBinary(right.getInput().get(1), Hop.OpOp2.PLUS) && right.getInput().get(1).getInput().get(1).getDataType() == Expression.DataType.SCALAR && HopRewriteUtils.isOuterProductLikeMM(right.getInput().get(1).getInput().get(0)) && HopRewriteUtils.isSingleBlock(right.getInput().get(1).getInput().get(0).getInput().get(0), true)) {
                W = right.getInput().get(0);
                U = right.getInput().get(1).getInput().get(0).getInput().get(0);
                V = right.getInput().get(1).getInput().get(0).getInput().get(1);
                Hop X = right.getInput().get(1).getInput().get(1);
                if (HopRewriteUtils.isTransposeOfItself(left, U)) {
                    V = !HopRewriteUtils.isTransposeOperation(V) ? HopRewriteUtils.createTranspose(V) : V.getInput().get(0);
                    hnew = new QuaternaryOp(hi.getName(), Expression.DataType.MATRIX, Expression.ValueType.DOUBLE, Hop.OpOp4.WDIVMM, W, U, V, X, 3, false, false);
                    hnew.setOutputBlocksizes(W.getRowsInBlock(), W.getColsInBlock());
                    hnew.refreshSizeInformation();
                    hnew = HopRewriteUtils.createTranspose(hnew);
                    appliedPattern = true;
                    LOG.debug((Object)("Applied simplifyWeightedDivMM1e (line " + hi.getBeginLine() + ")"));
                }
            }
            if (!appliedPattern && left instanceof BinaryOp && HopRewriteUtils.isValidOp(((BinaryOp)left).getOp(), LOOKUP_VALID_WDIVMM_BINARY) && HopRewriteUtils.isEqualSize(left.getInput().get(0), left.getInput().get(1)) && HopRewriteUtils.isOuterProductLikeMM(left.getInput().get(1)) && HopRewriteUtils.isSingleBlock(left.getInput().get(1).getInput().get(0), true)) {
                W = left.getInput().get(0);
                U = left.getInput().get(1).getInput().get(0);
                V = left.getInput().get(1).getInput().get(1);
                if (HopRewriteUtils.isTransposeOfItself(right, V)) {
                    V = !HopRewriteUtils.isTransposeOperation(V) ? right : V.getInput().get(0);
                    mult = ((BinaryOp)left).getOp() == Hop.OpOp2.MULT;
                    hnew = new QuaternaryOp(hi.getName(), Expression.DataType.MATRIX, Expression.ValueType.DOUBLE, Hop.OpOp4.WDIVMM, W, U, V, new LiteralOp(-1L), 2, mult, false);
                    hnew.setOutputBlocksizes(W.getRowsInBlock(), W.getColsInBlock());
                    hnew.refreshSizeInformation();
                    appliedPattern = true;
                    LOG.debug((Object)("Applied simplifyWeightedDivMM2 (line " + hi.getBeginLine() + ")"));
                }
            }
            if (!appliedPattern && HopRewriteUtils.isBinary(left, LOOKUP_VALID_WDIVMM_BINARY[1]) && HopRewriteUtils.isEqualSize(left.getInput().get(0), left.getInput().get(1)) && HopRewriteUtils.isBinary(left.getInput().get(1), Hop.OpOp2.PLUS) && left.getInput().get(1).getInput().get(1).getDataType() == Expression.DataType.SCALAR && HopRewriteUtils.isOuterProductLikeMM(left.getInput().get(1).getInput().get(0)) && HopRewriteUtils.isSingleBlock(left.getInput().get(1).getInput().get(0).getInput().get(0), true)) {
                W = left.getInput().get(0);
                U = left.getInput().get(1).getInput().get(0).getInput().get(0);
                V = left.getInput().get(1).getInput().get(0).getInput().get(1);
                Hop X = left.getInput().get(1).getInput().get(1);
                if (HopRewriteUtils.isTransposeOfItself(right, V)) {
                    V = !HopRewriteUtils.isTransposeOperation(V) ? right : V.getInput().get(0);
                    hnew = new QuaternaryOp(hi.getName(), Expression.DataType.MATRIX, Expression.ValueType.DOUBLE, Hop.OpOp4.WDIVMM, W, U, V, X, 4, false, false);
                    hnew.setOutputBlocksizes(W.getRowsInBlock(), W.getColsInBlock());
                    hnew.refreshSizeInformation();
                    appliedPattern = true;
                    LOG.debug((Object)("Applied simplifyWeightedDivMM2e (line " + hi.getBeginLine() + ")"));
                }
            }
            if (!appliedPattern && HopRewriteUtils.isBinary(right, LOOKUP_VALID_WDIVMM_BINARY[0]) && HopRewriteUtils.isBinary(right.getInput().get(1), Hop.OpOp2.MINUS) && HopRewriteUtils.isOuterProductLikeMM(right.getInput().get(1).getInput().get(0)) && right.getInput().get(1).getInput().get(1).getDataType() == Expression.DataType.MATRIX && HopRewriteUtils.isSingleBlock(right.getInput().get(1).getInput().get(0).getInput().get(0), true)) {
                W = right.getInput().get(0);
                U = right.getInput().get(1).getInput().get(0).getInput().get(0);
                V = right.getInput().get(1).getInput().get(0).getInput().get(1);
                Hop X = right.getInput().get(1).getInput().get(1);
                if (HopRewriteUtils.isNonZeroIndicator(W, X) && HopRewriteUtils.isTransposeOfItself(left, U)) {
                    V = !HopRewriteUtils.isTransposeOperation(V) ? HopRewriteUtils.createTranspose(V) : V.getInput().get(0);
                    hnew = new QuaternaryOp(hi.getName(), Expression.DataType.MATRIX, Expression.ValueType.DOUBLE, Hop.OpOp4.WDIVMM, X, U, V, new LiteralOp(-1L), 1, true, true);
                    hnew.setOutputBlocksizes(W.getRowsInBlock(), W.getColsInBlock());
                    hnew.refreshSizeInformation();
                    hnew = HopRewriteUtils.createTranspose(hnew);
                    appliedPattern = true;
                    LOG.debug((Object)("Applied simplifyWeightedDivMM3 (line " + hi.getBeginLine() + ")"));
                }
            }
            if (!appliedPattern && HopRewriteUtils.isBinary(left, LOOKUP_VALID_WDIVMM_BINARY[0]) && HopRewriteUtils.isBinary(left.getInput().get(1), Hop.OpOp2.MINUS) && HopRewriteUtils.isOuterProductLikeMM(left.getInput().get(1).getInput().get(0)) && left.getInput().get(1).getInput().get(1).getDataType() == Expression.DataType.MATRIX && HopRewriteUtils.isSingleBlock(left.getInput().get(1).getInput().get(0).getInput().get(0), true)) {
                W = left.getInput().get(0);
                U = left.getInput().get(1).getInput().get(0).getInput().get(0);
                V = left.getInput().get(1).getInput().get(0).getInput().get(1);
                Hop X = left.getInput().get(1).getInput().get(1);
                if (HopRewriteUtils.isNonZeroIndicator(W, X) && HopRewriteUtils.isTransposeOfItself(right, V)) {
                    V = !HopRewriteUtils.isTransposeOperation(V) ? right : V.getInput().get(0);
                    hnew = new QuaternaryOp(hi.getName(), Expression.DataType.MATRIX, Expression.ValueType.DOUBLE, Hop.OpOp4.WDIVMM, X, U, V, new LiteralOp(-1L), 2, true, true);
                    hnew.setOutputBlocksizes(W.getRowsInBlock(), W.getColsInBlock());
                    hnew.refreshSizeInformation();
                    appliedPattern = true;
                    LOG.debug((Object)("Applied simplifyWeightedDivMM4 (line " + hi.getBeginLine() + ")"));
                }
            }
            if (!appliedPattern && HopRewriteUtils.isBinary(right, LOOKUP_VALID_WDIVMM_BINARY[0]) && HopRewriteUtils.isBinary(right.getInput().get(1), Hop.OpOp2.MINUS) && HopRewriteUtils.isOuterProductLikeMM(right.getInput().get(1).getInput().get(0)) && right.getInput().get(1).getInput().get(1).getDataType() == Expression.DataType.MATRIX && HopRewriteUtils.isSingleBlock(right.getInput().get(1).getInput().get(0).getInput().get(0), true)) {
                W = right.getInput().get(0);
                U = right.getInput().get(1).getInput().get(0).getInput().get(0);
                V = right.getInput().get(1).getInput().get(0).getInput().get(1);
                Hop X = right.getInput().get(1).getInput().get(1);
                if (HopRewriteUtils.isTransposeOfItself(left, U)) {
                    V = !HopRewriteUtils.isTransposeOperation(V) ? HopRewriteUtils.createTranspose(V) : V.getInput().get(0);
                    hnew = new QuaternaryOp(hi.getName(), Expression.DataType.MATRIX, Expression.ValueType.DOUBLE, Hop.OpOp4.WDIVMM, W, U, V, X, 1, true, true);
                    hnew.setOutputBlocksizes(W.getRowsInBlock(), W.getColsInBlock());
                    hnew.refreshSizeInformation();
                    hnew = HopRewriteUtils.createTranspose(hnew);
                    appliedPattern = true;
                    LOG.debug((Object)("Applied simplifyWeightedDivMM5 (line " + hi.getBeginLine() + ")"));
                }
            }
            if (!appliedPattern && HopRewriteUtils.isBinary(left, LOOKUP_VALID_WDIVMM_BINARY[0]) && HopRewriteUtils.isBinary(left.getInput().get(1), Hop.OpOp2.MINUS) && HopRewriteUtils.isOuterProductLikeMM(left.getInput().get(1).getInput().get(0)) && left.getInput().get(1).getInput().get(1).getDataType() == Expression.DataType.MATRIX && HopRewriteUtils.isSingleBlock(left.getInput().get(1).getInput().get(0).getInput().get(0), true)) {
                W = left.getInput().get(0);
                U = left.getInput().get(1).getInput().get(0).getInput().get(0);
                V = left.getInput().get(1).getInput().get(0).getInput().get(1);
                Hop X = left.getInput().get(1).getInput().get(1);
                if (HopRewriteUtils.isTransposeOfItself(right, V)) {
                    V = !HopRewriteUtils.isTransposeOperation(V) ? right : V.getInput().get(0);
                    hnew = new QuaternaryOp(hi.getName(), Expression.DataType.MATRIX, Expression.ValueType.DOUBLE, Hop.OpOp4.WDIVMM, W, U, V, X, 2, true, true);
                    hnew.setOutputBlocksizes(W.getRowsInBlock(), W.getColsInBlock());
                    hnew.refreshSizeInformation();
                    appliedPattern = true;
                    LOG.debug((Object)("Applied simplifyWeightedDivMM6 (line " + hi.getBeginLine() + ")"));
                }
            }
        }
        if (!appliedPattern && HopRewriteUtils.isBinary(hi, LOOKUP_VALID_WDIVMM_BINARY[0]) && HopRewriteUtils.isEqualSize(hi.getInput().get(0), hi.getInput().get(1)) && hi.getDim2() > 1L && hi.getInput().get(0).getDataType() == Expression.DataType.MATRIX && hi.getInput().get(0).getDim2() > hi.getInput().get(0).getColsInBlock() && HopRewriteUtils.isOuterProductLikeMM(hi.getInput().get(1)) && (((AggBinaryOp)hi.getInput().get(1)).checkMapMultChain() == MapMultChain.ChainType.NONE || hi.getInput().get(1).getInput().get(1).getDim2() > 1L) && HopRewriteUtils.isSingleBlock(hi.getInput().get(1).getInput().get(0), true)) {
            Hop W = hi.getInput().get(0);
            Hop U = hi.getInput().get(1).getInput().get(0);
            Hop V = hi.getInput().get(1).getInput().get(1);
            if (!HopRewriteUtils.isSparse(U) && !HopRewriteUtils.isSparse(V)) {
                V = !HopRewriteUtils.isTransposeOperation(V) ? HopRewriteUtils.createTranspose(V) : V.getInput().get(0);
                hnew = new QuaternaryOp(hi.getName(), Expression.DataType.MATRIX, Expression.ValueType.DOUBLE, Hop.OpOp4.WDIVMM, W, U, V, new LiteralOp(-1L), 0, true, false);
                hnew.setOutputBlocksizes(W.getRowsInBlock(), W.getColsInBlock());
                hnew.refreshSizeInformation();
                appliedPattern = true;
                LOG.debug((Object)("Applied simplifyWeightedDivMM7 (line " + hi.getBeginLine() + ")"));
            }
        }
        if (hnew != null) {
            HopRewriteUtils.replaceChildReference(parent, hi, hnew, pos);
            hi = hnew;
        }
        return hi;
    }

    private Hop simplifyWeightedCrossEntropy(Hop parent, Hop hi, int pos) throws HopsException {
        QuaternaryOp hnew = null;
        boolean appliedPattern = false;
        if (hi instanceof AggUnaryOp && ((AggUnaryOp)hi).getDirection() == Hop.Direction.RowCol && ((AggUnaryOp)hi).getOp() == Hop.AggOp.SUM && hi.getInput().get(0) instanceof BinaryOp && hi.getInput().get(0).getDim2() > 1L) {
            Hop V;
            Hop U;
            Hop X;
            BinaryOp bop = (BinaryOp)hi.getInput().get(0);
            Hop left = bop.getInput().get(0);
            Hop right = bop.getInput().get(1);
            if (bop.getOp() == Hop.OpOp2.MULT && left.getDataType() == Expression.DataType.MATRIX && HopRewriteUtils.isEqualSize(left, right) && HopRewriteUtils.isUnary(right, Hop.OpOp1.LOG) && right.getInput().get(0) instanceof AggBinaryOp && HopRewriteUtils.isSingleBlock(right.getInput().get(0).getInput().get(0), true)) {
                X = left;
                U = right.getInput().get(0).getInput().get(0);
                V = right.getInput().get(0).getInput().get(1);
                V = !HopRewriteUtils.isTransposeOperation(V) ? HopRewriteUtils.createTranspose(V) : V.getInput().get(0);
                hnew = new QuaternaryOp(hi.getName(), Expression.DataType.SCALAR, Expression.ValueType.DOUBLE, Hop.OpOp4.WCEMM, X, U, V, new LiteralOp(0.0), 0, false, false);
                hnew.setOutputBlocksizes(X.getRowsInBlock(), X.getColsInBlock());
                appliedPattern = true;
                LOG.debug((Object)("Applied simplifyWeightedCEMM (line " + hi.getBeginLine() + ")"));
            }
            if (!appliedPattern && bop.getOp() == Hop.OpOp2.MULT && left.getDataType() == Expression.DataType.MATRIX && HopRewriteUtils.isEqualSize(left, right) && HopRewriteUtils.isUnary(right, Hop.OpOp1.LOG) && HopRewriteUtils.isBinary(right.getInput().get(0), Hop.OpOp2.PLUS) && right.getInput().get(0).getInput().get(0) instanceof AggBinaryOp && right.getInput().get(0).getInput().get(1) instanceof LiteralOp && right.getInput().get(0).getInput().get(1).getDataType() == Expression.DataType.SCALAR && HopRewriteUtils.isSingleBlock(right.getInput().get(0).getInput().get(0).getInput().get(0), true)) {
                X = left;
                U = right.getInput().get(0).getInput().get(0).getInput().get(0);
                V = right.getInput().get(0).getInput().get(0).getInput().get(1);
                Hop eps = right.getInput().get(0).getInput().get(1);
                V = !HopRewriteUtils.isTransposeOperation(V) ? HopRewriteUtils.createTranspose(V) : V.getInput().get(0);
                hnew = new QuaternaryOp(hi.getName(), Expression.DataType.SCALAR, Expression.ValueType.DOUBLE, Hop.OpOp4.WCEMM, X, U, V, eps, 1, false, false);
                hnew.setOutputBlocksizes(X.getRowsInBlock(), X.getColsInBlock());
                LOG.debug((Object)("Applied simplifyWeightedCEMMEps (line " + hi.getBeginLine() + ")"));
            }
        }
        if (hnew != null) {
            HopRewriteUtils.replaceChildReference(parent, hi, hnew, pos);
            hi = hnew;
        }
        return hi;
    }

    private Hop simplifyWeightedUnaryMM(Hop parent, Hop hi, int pos) throws HopsException {
        Hop nl;
        QuaternaryOp hnew = null;
        boolean appliedPattern = false;
        if (hi instanceof BinaryOp && HopRewriteUtils.isValidOp(((BinaryOp)hi).getOp(), LOOKUP_VALID_WDIVMM_BINARY) && HopRewriteUtils.isEqualSize(hi.getInput().get(0), hi.getInput().get(1)) && hi.getDim2() > 1L && hi.getInput().get(0).getDataType() == Expression.DataType.MATRIX && hi.getInput().get(0).getDim2() > hi.getInput().get(0).getColsInBlock() && hi.getInput().get(1) instanceof UnaryOp && HopRewriteUtils.isValidOp(((UnaryOp)hi.getInput().get(1)).getOp(), LOOKUP_VALID_WUMM_UNARY) && hi.getInput().get(1).getInput().get(0) instanceof AggBinaryOp && HopRewriteUtils.isSingleBlock(hi.getInput().get(1).getInput().get(0).getInput().get(0), true)) {
            Hop W = hi.getInput().get(0);
            Hop U = hi.getInput().get(1).getInput().get(0).getInput().get(0);
            Hop V = hi.getInput().get(1).getInput().get(0).getInput().get(1);
            boolean mult = ((BinaryOp)hi).getOp() == Hop.OpOp2.MULT;
            Hop.OpOp1 op = ((UnaryOp)hi.getInput().get(1)).getOp();
            V = !HopRewriteUtils.isTransposeOperation(V) ? HopRewriteUtils.createTranspose(V) : V.getInput().get(0);
            hnew = new QuaternaryOp(hi.getName(), Expression.DataType.MATRIX, Expression.ValueType.DOUBLE, Hop.OpOp4.WUMM, W, U, V, mult, op, null);
            hnew.setOutputBlocksizes(W.getRowsInBlock(), W.getColsInBlock());
            ((Hop)hnew).refreshSizeInformation();
            appliedPattern = true;
            LOG.debug((Object)("Applied simplifyWeightedUnaryMM1 (line " + hi.getBeginLine() + ")"));
        }
        if (!appliedPattern && hi instanceof BinaryOp && HopRewriteUtils.isValidOp(((BinaryOp)hi).getOp(), Hop.OpOp2.MULT) && (HopRewriteUtils.isLiteralOfValue(hi.getInput().get(0), 2.0) || HopRewriteUtils.isLiteralOfValue(hi.getInput().get(1), 2.0)) && HopRewriteUtils.isBinary(nl = hi.getInput().get(0) instanceof LiteralOp ? hi.getInput().get(1) : hi.getInput().get(0), Hop.OpOp2.MULT) && nl.getParent().size() == 1 && HopRewriteUtils.isEqualSize(nl.getInput().get(0), nl.getInput().get(1)) && nl.getDim2() > 1L && nl.getInput().get(0).getDataType() == Expression.DataType.MATRIX && nl.getInput().get(0).getDim2() > nl.getInput().get(0).getColsInBlock() && HopRewriteUtils.isOuterProductLikeMM(nl.getInput().get(1)) && (((AggBinaryOp)nl.getInput().get(1)).checkMapMultChain() == MapMultChain.ChainType.NONE || nl.getInput().get(1).getInput().get(1).getDim2() > 1L) && HopRewriteUtils.isSingleBlock(nl.getInput().get(1).getInput().get(0), true)) {
            Hop W = nl.getInput().get(0);
            Hop U = nl.getInput().get(1).getInput().get(0);
            Hop V = nl.getInput().get(1).getInput().get(1);
            V = !HopRewriteUtils.isTransposeOperation(V) ? HopRewriteUtils.createTranspose(V) : V.getInput().get(0);
            hnew = new QuaternaryOp(hi.getName(), Expression.DataType.MATRIX, Expression.ValueType.DOUBLE, Hop.OpOp4.WUMM, W, U, V, true, null, Hop.OpOp2.MULT);
            hnew.setOutputBlocksizes(W.getRowsInBlock(), W.getColsInBlock());
            ((Hop)hnew).refreshSizeInformation();
            appliedPattern = true;
            LOG.debug((Object)("Applied simplifyWeightedUnaryMM2.7 (line " + hi.getBeginLine() + ")"));
        }
        if (!appliedPattern && hi instanceof BinaryOp && HopRewriteUtils.isValidOp(((BinaryOp)hi).getOp(), LOOKUP_VALID_WDIVMM_BINARY) && HopRewriteUtils.isEqualSize(hi.getInput().get(0), hi.getInput().get(1)) && hi.getDim2() > 1L && hi.getInput().get(0).getDataType() == Expression.DataType.MATRIX && hi.getInput().get(0).getDim2() > hi.getInput().get(0).getColsInBlock() && hi.getInput().get(1) instanceof BinaryOp && HopRewriteUtils.isValidOp(((BinaryOp)hi.getInput().get(1)).getOp(), LOOKUP_VALID_WUMM_BINARY)) {
            Hop left = hi.getInput().get(1).getInput().get(0);
            Hop right = hi.getInput().get(1).getInput().get(1);
            Hop abop = null;
            if (right.getDataType() == Expression.DataType.SCALAR && right instanceof LiteralOp && HopRewriteUtils.getDoubleValue((LiteralOp)right) == 2.0 && left instanceof AggBinaryOp && HopRewriteUtils.isSingleBlock(left.getInput().get(0), true)) {
                abop = left;
            } else if (left.getDataType() == Expression.DataType.SCALAR && left instanceof LiteralOp && HopRewriteUtils.getDoubleValue((LiteralOp)left) == 2.0 && ((BinaryOp)hi.getInput().get(1)).getOp() == Hop.OpOp2.MULT && right instanceof AggBinaryOp && HopRewriteUtils.isSingleBlock(right.getInput().get(0), true)) {
                abop = right;
            }
            if (abop != null) {
                Hop W = hi.getInput().get(0);
                Hop U = abop.getInput().get(0);
                Hop V = abop.getInput().get(1);
                boolean mult = ((BinaryOp)hi).getOp() == Hop.OpOp2.MULT;
                Hop.OpOp2 op = ((BinaryOp)hi.getInput().get(1)).getOp();
                V = !HopRewriteUtils.isTransposeOperation(V) ? HopRewriteUtils.createTranspose(V) : V.getInput().get(0);
                hnew = new QuaternaryOp(hi.getName(), Expression.DataType.MATRIX, Expression.ValueType.DOUBLE, Hop.OpOp4.WUMM, W, U, V, mult, null, op);
                hnew.setOutputBlocksizes(W.getRowsInBlock(), W.getColsInBlock());
                ((Hop)hnew).refreshSizeInformation();
                appliedPattern = true;
                LOG.debug((Object)("Applied simplifyWeightedUnaryMM2 (line " + hi.getBeginLine() + ")"));
            }
        }
        if (hnew != null) {
            HopRewriteUtils.replaceChildReference(parent, hi, hnew, pos);
            hi = hnew;
        }
        return hi;
    }

    private Hop simplifyDotProductSum(Hop parent, Hop hi, int pos) throws HopsException {
        if (hi instanceof AggUnaryOp && ((AggUnaryOp)hi).getOp() == Hop.AggOp.SUM && ((AggUnaryOp)hi).getDirection() == Hop.Direction.RowCol && hi.getInput().get(0).getDim2() == 1L) {
            Hop baLeft = null;
            Hop baRight = null;
            Hop hi2 = hi.getInput().get(0);
            if (HopRewriteUtils.isBinary(hi2, Hop.OpOp2.POW) && hi2.getInput().get(1) instanceof LiteralOp && HopRewriteUtils.getDoubleValue((LiteralOp)hi2.getInput().get(1)) == 2.0 && hi2.getParent().size() == 1) {
                Hop input;
                baLeft = input = hi2.getInput().get(0);
                baRight = input;
            } else if (!(!HopRewriteUtils.isBinary(hi2, Hop.OpOp2.MULT, 1) || hi2.getInput().get(0).getDim2() != 1L || hi2.getInput().get(1).getDim2() != 1L || HopRewriteUtils.isBinary(hi2.getInput().get(0), Hop.OpOp2.MULT) || HopRewriteUtils.isBinary(hi2.getInput().get(1), Hop.OpOp2.MULT) || OptimizerUtils.ALLOW_SUM_PRODUCT_REWRITES && HopRewriteUtils.isBinary(hi2.getInput().get(0), Hop.OpOp2.POW) && hi2.getInput().get(0).getInput().get(1) instanceof LiteralOp && ((LiteralOp)hi2.getInput().get(0).getInput().get(1)).getLongValue() == 2L || OptimizerUtils.ALLOW_SUM_PRODUCT_REWRITES && HopRewriteUtils.isBinary(hi2.getInput().get(1), Hop.OpOp2.POW) && hi2.getInput().get(1).getInput().get(1) instanceof LiteralOp && ((LiteralOp)hi2.getInput().get(1).getInput().get(1)).getLongValue() == 2L)) {
                baLeft = hi2.getInput().get(0);
                baRight = hi2.getInput().get(1);
            }
            if (baLeft != null && baRight != null) {
                ReorgOp trans = HopRewriteUtils.createTranspose(baLeft);
                AggBinaryOp mmult = HopRewriteUtils.createMatrixMultiply(trans, baRight);
                UnaryOp cast = HopRewriteUtils.createUnary(mmult, Hop.OpOp1.CAST_AS_SCALAR);
                HopRewriteUtils.replaceChildReference(parent, hi, cast, pos);
                HopRewriteUtils.cleanupUnreferenced(hi, hi2);
                hi = cast;
                LOG.debug((Object)"Applied simplifyDotProductSum.");
            }
        }
        return hi;
    }

    private Hop fuseSumSquared(Hop parent, Hop hi, int pos) throws HopsException {
        Hop x;
        Hop sumInput;
        if (hi instanceof AggUnaryOp && ((AggUnaryOp)hi).getOp() == Hop.AggOp.SUM && HopRewriteUtils.isBinary(sumInput = hi.getInput().get(0), Hop.OpOp2.POW) && sumInput.getInput().get(1) instanceof LiteralOp && HopRewriteUtils.getDoubleValue((LiteralOp)sumInput.getInput().get(1)) == 2.0 && sumInput.getParent().size() == 1 && (x = sumInput.getInput().get(0)).getDim2() > 1L) {
            Hop.Direction dir = ((AggUnaryOp)hi).getDirection();
            AggUnaryOp sumSq = HopRewriteUtils.createAggUnaryOp(x, Hop.AggOp.SUM_SQ, dir);
            HopRewriteUtils.replaceChildReference(parent, hi, sumSq, pos);
            HopRewriteUtils.cleanupUnreferenced(hi, sumInput);
            hi = sumSq;
            LOG.debug((Object)"Applied fuseSumSquared.");
        }
        return hi;
    }

    private Hop fuseAxpyBinaryOperationChain(Hop parent, Hop hi, int pos) {
        if (hi instanceof BinaryOp && !((BinaryOp)hi).isOuterVectorOperator() && (((BinaryOp)hi).getOp() == Hop.OpOp2.PLUS || ((BinaryOp)hi).getOp() == Hop.OpOp2.MINUS)) {
            BinaryOp bop = (BinaryOp)hi;
            Hop left = bop.getInput().get(0);
            Hop right = bop.getInput().get(1);
            TernaryOp ternop = null;
            if (bop.getOp() == Hop.OpOp2.PLUS && left.getDataType() == Expression.DataType.MATRIX && HopRewriteUtils.isScalarMatrixBinaryMult(right) && right.getParent().size() == 1) {
                Hop smid = right.getInput().get(right.getInput().get(0).getDataType() == Expression.DataType.SCALAR ? 0 : 1);
                Hop mright = right.getInput().get(right.getInput().get(0).getDataType() == Expression.DataType.SCALAR ? 1 : 0);
                ternop = smid instanceof LiteralOp && HopRewriteUtils.getDoubleValueSafe((LiteralOp)smid) == 0.0 ? left : HopRewriteUtils.createTernaryOp(left, smid, mright, Hop.OpOp3.PLUS_MULT);
                LOG.debug((Object)("Applied fuseAxpyBinaryOperationChain1. (line " + hi.getBeginLine() + ")"));
            } else if (bop.getOp() == Hop.OpOp2.PLUS && right.getDataType() == Expression.DataType.MATRIX && HopRewriteUtils.isScalarMatrixBinaryMult(left) && left.getParent().size() == 1 && HopRewriteUtils.isEqualSize(left, right)) {
                Hop smid = left.getInput().get(left.getInput().get(0).getDataType() == Expression.DataType.SCALAR ? 0 : 1);
                Hop mright = left.getInput().get(left.getInput().get(0).getDataType() == Expression.DataType.SCALAR ? 1 : 0);
                ternop = smid instanceof LiteralOp && HopRewriteUtils.getDoubleValueSafe((LiteralOp)smid) == 0.0 ? right : HopRewriteUtils.createTernaryOp(right, smid, mright, Hop.OpOp3.PLUS_MULT);
                LOG.debug((Object)("Applied fuseAxpyBinaryOperationChain2. (line " + hi.getBeginLine() + ")"));
            } else if (bop.getOp() == Hop.OpOp2.MINUS && left.getDataType() == Expression.DataType.MATRIX && HopRewriteUtils.isScalarMatrixBinaryMult(right) && right.getParent().size() == 1) {
                Hop smid = right.getInput().get(right.getInput().get(0).getDataType() == Expression.DataType.SCALAR ? 0 : 1);
                Hop mright = right.getInput().get(right.getInput().get(0).getDataType() == Expression.DataType.SCALAR ? 1 : 0);
                ternop = smid instanceof LiteralOp && HopRewriteUtils.getDoubleValueSafe((LiteralOp)smid) == 0.0 ? left : HopRewriteUtils.createTernaryOp(left, smid, mright, Hop.OpOp3.MINUS_MULT);
                LOG.debug((Object)("Applied fuseAxpyBinaryOperationChain3. (line " + hi.getBeginLine() + ")"));
            }
            if (ternop != null) {
                HopRewriteUtils.replaceChildReference(parent, hi, ternop, pos);
                hi = ternop;
            }
        }
        return hi;
    }

    private Hop simplifyEmptyBinaryOperation(Hop parent, Hop hi, int pos) throws HopsException {
        if (hi instanceof BinaryOp) {
            BinaryOp bop = (BinaryOp)hi;
            Hop left = hi.getInput().get(0);
            Hop right = hi.getInput().get(1);
            if (left.getDataType() == Expression.DataType.MATRIX && right.getDataType() == Expression.DataType.MATRIX) {
                Hop hnew = null;
                boolean notBinaryMV = HopRewriteUtils.isNotMatrixVectorBinaryOperation(bop);
                switch (bop.getOp()) {
                    case MULT: {
                        if (HopRewriteUtils.isEmpty(left)) {
                            hnew = HopRewriteUtils.createDataGenOp(left, left, 0.0);
                            break;
                        }
                        if (HopRewriteUtils.isEmpty(right) && right.getDim1() > 1L && right.getDim2() > 1L) {
                            hnew = HopRewriteUtils.createDataGenOp(right, right, 0.0);
                            break;
                        }
                        if (!HopRewriteUtils.isEmpty(right)) break;
                        hnew = HopRewriteUtils.createDataGenOp(left, left, 0.0);
                        break;
                    }
                    case PLUS: {
                        if (HopRewriteUtils.isEmpty(left) && HopRewriteUtils.isEmpty(right)) {
                            hnew = HopRewriteUtils.createDataGenOp(left, left, 0.0);
                            break;
                        }
                        if (HopRewriteUtils.isEmpty(left) && notBinaryMV) {
                            hnew = right;
                            break;
                        }
                        if (!HopRewriteUtils.isEmpty(right)) break;
                        hnew = left;
                        break;
                    }
                    case MINUS: {
                        if (HopRewriteUtils.isEmpty(left) && notBinaryMV) {
                            HopRewriteUtils.removeChildReference(hi, left);
                            HopRewriteUtils.addChildReference(hi, new LiteralOp(0L), 0);
                            hnew = hi;
                            break;
                        }
                        if (!HopRewriteUtils.isEmpty(right)) break;
                        hnew = left;
                        break;
                    }
                    default: {
                        hnew = null;
                    }
                }
                if (hnew != null) {
                    HopRewriteUtils.replaceChildReference(parent, hi, hnew, pos);
                    hi = hnew;
                    LOG.debug((Object)"Applied simplifyEmptyBinaryOperation");
                }
            }
        }
        return hi;
    }

    private Hop reorderMinusMatrixMult(Hop parent, Hop hi, int pos) throws HopsException {
        if (HopRewriteUtils.isMatrixMultiply(hi)) {
            Hop hileft = hi.getInput().get(0);
            Hop hiright = hi.getInput().get(1);
            if (HopRewriteUtils.isBinary(hileft, Hop.OpOp2.MINUS) && hileft.getInput().get(0) instanceof LiteralOp && HopRewriteUtils.getDoubleValue((LiteralOp)hileft.getInput().get(0)) == 0.0 && hi.dimsKnown() && hileft.getInput().get(1).dimsKnown() && HopRewriteUtils.compareSize(hi, hileft.getInput().get(1)) < 0) {
                Hop hi2 = hileft.getInput().get(1);
                HopRewriteUtils.removeChildReference(hi, hileft);
                ArrayList parents = (ArrayList)hi.getParent().clone();
                BinaryOp minus = HopRewriteUtils.createBinary(new LiteralOp(0L), hi, Hop.OpOp2.MINUS);
                for (Hop p : parents) {
                    int ix = HopRewriteUtils.getChildReferencePos(p, hi);
                    HopRewriteUtils.removeChildReference(p, hi);
                    HopRewriteUtils.addChildReference(p, minus, ix);
                }
                HopRewriteUtils.addChildReference(hi, hi2, 0);
                HopRewriteUtils.cleanupUnreferenced(hileft);
                hi = minus;
                LOG.debug((Object)("Applied reorderMinusMatrixMult (line " + hi.getBeginLine() + ")."));
            } else if (HopRewriteUtils.isBinary(hiright, Hop.OpOp2.MINUS) && hiright.getInput().get(0) instanceof LiteralOp && HopRewriteUtils.getDoubleValue((LiteralOp)hiright.getInput().get(0)) == 0.0 && hi.dimsKnown() && hiright.getInput().get(1).dimsKnown() && HopRewriteUtils.compareSize(hi, hiright.getInput().get(1)) < 0) {
                Hop hi2 = hiright.getInput().get(1);
                HopRewriteUtils.removeChildReference(hi, hiright);
                ArrayList parents = (ArrayList)hi.getParent().clone();
                BinaryOp minus = HopRewriteUtils.createBinary(new LiteralOp(0L), hi, Hop.OpOp2.MINUS);
                for (Hop p : parents) {
                    int ix = HopRewriteUtils.getChildReferencePos(p, hi);
                    HopRewriteUtils.removeChildReference(p, hi);
                    HopRewriteUtils.addChildReference(p, minus, ix);
                }
                HopRewriteUtils.addChildReference(hi, hi2, 1);
                HopRewriteUtils.cleanupUnreferenced(hiright);
                hi = minus;
                LOG.debug((Object)("Applied reorderMinusMatrixMult (line " + hi.getBeginLine() + ")."));
            }
        }
        return hi;
    }

    private Hop simplifySumMatrixMult(Hop parent, Hop hi, int pos) {
        if (hi instanceof AggUnaryOp && ((AggUnaryOp)hi).getOp() == Hop.AggOp.SUM && hi.getInput().get(0) instanceof AggBinaryOp && (hi.getInput().get(0).getDim1() > 1L || hi.getInput().get(0).getDim2() > 1L) && hi.getInput().get(0).getParent().size() == 1) {
            Hop hi2 = hi.getInput().get(0);
            Hop left = hi2.getInput().get(0);
            Hop right = hi2.getInput().get(1);
            HopRewriteUtils.removeChildReference(hi, hi2);
            Hop root = null;
            if (((AggUnaryOp)hi).getDirection() == Hop.Direction.RowCol) {
                AggUnaryOp colSum = HopRewriteUtils.createAggUnaryOp(left, Hop.AggOp.SUM, Hop.Direction.Col);
                ReorgOp trans = HopRewriteUtils.createTranspose(colSum);
                AggUnaryOp rowSum = HopRewriteUtils.createAggUnaryOp(right, Hop.AggOp.SUM, Hop.Direction.Row);
                root = HopRewriteUtils.createBinary(trans, rowSum, Hop.OpOp2.MULT);
                LOG.debug((Object)"Applied simplifySumMatrixMult RC.");
            } else if (((AggUnaryOp)hi).getDirection() == Hop.Direction.Col) {
                AggUnaryOp colSum = HopRewriteUtils.createAggUnaryOp(left, Hop.AggOp.SUM, Hop.Direction.Col);
                root = HopRewriteUtils.createMatrixMultiply(colSum, right);
                LOG.debug((Object)"Applied simplifySumMatrixMult C.");
            } else if (((AggUnaryOp)hi).getDirection() == Hop.Direction.Row) {
                AggUnaryOp rowSum = HopRewriteUtils.createAggUnaryOp(right, Hop.AggOp.SUM, Hop.Direction.Row);
                root = HopRewriteUtils.createMatrixMultiply(left, rowSum);
                LOG.debug((Object)"Applied simplifySumMatrixMult R.");
            }
            HopRewriteUtils.addChildReference(hi, root, 0);
            hi.refreshSizeInformation();
            HopRewriteUtils.cleanupUnreferenced(hi2);
        }
        return hi;
    }

    private Hop simplifyScalarMVBinaryOperation(Hop hi) throws HopsException {
        Hop right;
        if (hi instanceof BinaryOp && ((BinaryOp)hi).supportsMatrixScalarOperations() && hi.getInput().get(0).getDataType() == Expression.DataType.MATRIX && hi.getInput().get(1).getDataType() == Expression.DataType.MATRIX && HopRewriteUtils.isDimsKnown(right = hi.getInput().get(1)) && right.getDim1() == 1L && right.getDim2() == 1L) {
            UnaryOp cast = HopRewriteUtils.createUnary(right, Hop.OpOp1.CAST_AS_SCALAR);
            HopRewriteUtils.replaceChildReference(hi, right, cast, 1);
            LOG.debug((Object)"Applied simplifyScalarMVBinaryOperation.");
        }
        return hi;
    }

    private Hop simplifyNnzComputation(Hop parent, Hop hi, int pos) throws HopsException {
        if (hi instanceof AggUnaryOp && ((AggUnaryOp)hi).getOp() == Hop.AggOp.SUM && ((AggUnaryOp)hi).getDirection() == Hop.Direction.RowCol && HopRewriteUtils.isBinary(hi.getInput().get(0), Hop.OpOp2.NOTEQUAL)) {
            Hop ppred = hi.getInput().get(0);
            Hop X = null;
            if (ppred.getInput().get(0) instanceof LiteralOp && HopRewriteUtils.getDoubleValue((LiteralOp)ppred.getInput().get(0)) == 0.0) {
                X = ppred.getInput().get(1);
            } else if (ppred.getInput().get(1) instanceof LiteralOp && HopRewriteUtils.getDoubleValue((LiteralOp)ppred.getInput().get(1)) == 0.0) {
                X = ppred.getInput().get(0);
            }
            if (X != null && X.getNnz() > 0L) {
                LiteralOp hnew = new LiteralOp(X.getNnz());
                HopRewriteUtils.replaceChildReference(parent, hi, hnew, pos);
                HopRewriteUtils.cleanupUnreferenced(hi);
                hi = hnew;
                LOG.debug((Object)"Applied simplifyNnzComputation.");
            }
        }
        return hi;
    }

    private Hop simplifyNrowNcolComputation(Hop parent, Hop hi, int pos) throws HopsException {
        if (hi instanceof UnaryOp) {
            if (((UnaryOp)hi).getOp() == Hop.OpOp1.NROW && hi.getInput().get(0).getDim1() > 0L) {
                LiteralOp hnew = new LiteralOp(hi.getInput().get(0).getDim1());
                HopRewriteUtils.replaceChildReference(parent, hi, hnew, pos, false);
                HopRewriteUtils.cleanupUnreferenced(hi);
                LOG.debug((Object)("Applied simplifyNrowComputation nrow(" + hi.getHopID() + ") -> " + hnew.getName() + " (line " + hi.getBeginLine() + ")."));
                hi = hnew;
            } else if (((UnaryOp)hi).getOp() == Hop.OpOp1.NCOL && hi.getInput().get(0).getDim2() > 0L) {
                LiteralOp hnew = new LiteralOp(hi.getInput().get(0).getDim2());
                HopRewriteUtils.replaceChildReference(parent, hi, hnew, pos, false);
                HopRewriteUtils.cleanupUnreferenced(hi);
                LOG.debug((Object)("Applied simplifyNcolComputation ncol(" + hi.getHopID() + ") -> " + hnew.getName() + " (line " + hi.getBeginLine() + ")."));
                hi = hnew;
            }
        }
        return hi;
    }

    private Hop simplifyTableSeqExpand(Hop parent, Hop hi, int pos) throws HopsException {
        if (hi instanceof TernaryOp && hi.getInput().size() == 5 && HopRewriteUtils.isLiteralOfValue(hi.getInput().get(2), 1.0) && hi.getInput().get(3) instanceof LiteralOp && hi.getInput().get(4) instanceof LiteralOp) {
            Hop second;
            Hop first = hi.getInput().get(0);
            if (HopRewriteUtils.isBasic1NSequence(first, second = hi.getInput().get(1), true) && second.dimsKnown() && HopRewriteUtils.isLiteralOfValue(hi.getInput().get(3), second.getDim1())) {
                HashMap<String, Hop> args = new HashMap<String, Hop>();
                args.put("target", second);
                args.put("max", hi.getInput().get(4));
                args.put("dir", new LiteralOp("cols"));
                args.put("ignore", new LiteralOp(false));
                args.put("cast", new LiteralOp(true));
                ParameterizedBuiltinOp pbop = HopRewriteUtils.createParameterizedBuiltinOp(second, args, Hop.ParamBuiltinOp.REXPAND);
                HopRewriteUtils.replaceChildReference(parent, hi, pbop, pos);
                HopRewriteUtils.cleanupUnreferenced(hi);
                hi = pbop;
                LOG.debug((Object)("Applied simplifyTableSeqExpand1 (line " + hi.getBeginLine() + ")"));
            } else if (HopRewriteUtils.isBasic1NSequence(second, first, true) && first.dimsKnown() && HopRewriteUtils.isLiteralOfValue(hi.getInput().get(4), first.getDim1())) {
                HashMap<String, Hop> args = new HashMap<String, Hop>();
                args.put("target", first);
                args.put("max", hi.getInput().get(3));
                args.put("dir", new LiteralOp("rows"));
                args.put("ignore", new LiteralOp(false));
                args.put("cast", new LiteralOp(true));
                ParameterizedBuiltinOp pbop = HopRewriteUtils.createParameterizedBuiltinOp(first, args, Hop.ParamBuiltinOp.REXPAND);
                HopRewriteUtils.replaceChildReference(parent, hi, pbop, pos);
                HopRewriteUtils.cleanupUnreferenced(hi);
                hi = pbop;
                LOG.debug((Object)("Applied simplifyTableSeqExpand2 (line " + hi.getBeginLine() + ")"));
            }
        }
        return hi;
    }
}

