/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.hops.codegen.cplan;

import java.util.ArrayList;
import org.apache.sysml.hops.Hop;
import org.apache.sysml.hops.codegen.SpoofFusedOp;
import org.apache.sysml.hops.codegen.cplan.CNode;
import org.apache.sysml.hops.codegen.cplan.CNodeTpl;
import org.apache.sysml.runtime.codegen.SpoofCellwise;
import org.apache.sysml.runtime.util.UtilFunctions;

public class CNodeCell
extends CNodeTpl {
    private static final String TEMPLATE = "package codegen;\nimport org.apache.sysml.runtime.codegen.LibSpoofPrimitives;\nimport org.apache.sysml.runtime.codegen.SpoofCellwise;\nimport org.apache.sysml.runtime.codegen.SpoofCellwise.AggOp;\nimport org.apache.sysml.runtime.codegen.SpoofCellwise.CellType;\nimport org.apache.sysml.runtime.codegen.SpoofOperator.SideInput;\nimport org.apache.commons.math3.util.FastMath;\n\npublic final class %TMP% extends SpoofCellwise {\n  public %TMP%() {\n    super(CellType.%TYPE%, %SPARSE_SAFE%, %AGG_OP%);\n  }\n  protected double genexec(double a, SideInput[] b, double[] scalars, int m, int n, int rowIndex, int colIndex) { \n%BODY_dense%    return %OUT%;\n  }\n}\n";
    private SpoofCellwise.CellType _type = null;
    private Hop.AggOp _aggOp = null;
    private boolean _sparseSafe = false;
    private boolean _requiresCastdtm = false;
    private boolean _multipleConsumers = false;

    public CNodeCell(ArrayList<CNode> inputs, CNode output) {
        super(inputs, output);
    }

    public void setMultipleConsumers(boolean flag) {
        this._multipleConsumers = flag;
    }

    public boolean hasMultipleConsumers() {
        return this._multipleConsumers;
    }

    public void setCellType(SpoofCellwise.CellType type) {
        this._type = type;
        this._hash = 0;
    }

    public SpoofCellwise.CellType getCellType() {
        return this._type;
    }

    public void setAggOp(Hop.AggOp aggop) {
        this._aggOp = aggop;
        this._hash = 0;
    }

    public Hop.AggOp getAggOp() {
        return this._aggOp;
    }

    public void setSparseSafe(boolean flag) {
        this._sparseSafe = flag;
    }

    public boolean isSparseSafe() {
        return this._sparseSafe;
    }

    public void setRequiresCastDtm(boolean flag) {
        this._requiresCastdtm = flag;
        this._hash = 0;
    }

    public boolean requiredCastDtm() {
        return this._requiresCastdtm;
    }

    @Override
    public void renameInputs() {
        this.rRenameDataNode(this._output, (CNode)this._inputs.get(0), "a");
        this.renameInputs(this._inputs, 1);
    }

    @Override
    public String codegen(boolean sparse) {
        String tmp = TEMPLATE;
        String tmpDense = this._output.codegen(false);
        this._output.resetGenerated();
        tmp = tmp.replace("%TMP%", this.createVarname());
        tmp = tmp.replace("%BODY_dense%", tmpDense);
        tmp = tmp.replace("%OUT%", this._output.getVarname());
        tmp = tmp.replace("%TYPE%", this.getCellType().name());
        tmp = tmp.replace("%AGG_OP%", this._aggOp != null ? "AggOp." + this._aggOp.name() : "null");
        tmp = tmp.replace("%SPARSE_SAFE%", String.valueOf(this.isSparseSafe()));
        return tmp;
    }

    @Override
    public void setOutputDims() {
    }

    @Override
    public CNodeTpl clone() {
        CNodeCell tmp = new CNodeCell(this._inputs, this._output);
        tmp.setDataType(this.getDataType());
        tmp.setCellType(this.getCellType());
        tmp.setMultipleConsumers(this.hasMultipleConsumers());
        return tmp;
    }

    @Override
    public SpoofFusedOp.SpoofOutputDimsType getOutputDimType() {
        switch (this._type) {
            case NO_AGG: {
                return SpoofFusedOp.SpoofOutputDimsType.INPUT_DIMS;
            }
            case ROW_AGG: {
                return SpoofFusedOp.SpoofOutputDimsType.ROW_DIMS;
            }
            case COL_AGG: {
                return SpoofFusedOp.SpoofOutputDimsType.COLUMN_DIMS_COLS;
            }
            case FULL_AGG: {
                return SpoofFusedOp.SpoofOutputDimsType.SCALAR;
            }
        }
        throw new RuntimeException("Unsupported cell type: " + this._type.toString());
    }

    @Override
    public int hashCode() {
        if (this._hash == 0) {
            int h = super.hashCode();
            h = UtilFunctions.intHashCode(h, this._type.hashCode());
            h = UtilFunctions.intHashCode(h, this._aggOp != null ? this._aggOp.hashCode() : 0);
            h = UtilFunctions.intHashCode(h, Boolean.hashCode(this._sparseSafe));
            this._hash = h = UtilFunctions.intHashCode(h, Boolean.hashCode(this._requiresCastdtm));
        }
        return this._hash;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof CNodeCell)) {
            return false;
        }
        CNodeCell that = (CNodeCell)o;
        return super.equals(that) && this._type == that._type && this._aggOp == that._aggOp && this._sparseSafe == that._sparseSafe && this._requiresCastdtm == that._requiresCastdtm && CNodeCell.equalInputReferences(this._output, that._output, (ArrayList<CNode>)this._inputs, (ArrayList<CNode>)that._inputs);
    }

    @Override
    public String getTemplateInfo() {
        StringBuilder sb = new StringBuilder();
        sb.append("SPOOF CELLWISE [type=");
        sb.append(this._type.name());
        sb.append(", aggOp=" + (this._aggOp != null ? this._aggOp.name() : "null"));
        sb.append(", sparseSafe=" + this._sparseSafe);
        sb.append(", castdtm=" + this._requiresCastdtm);
        sb.append(", mc=" + this._multipleConsumers);
        sb.append("]");
        return sb.toString();
    }
}

