/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.api.jmlc;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysml.api.DMLException;
import org.apache.sysml.api.jmlc.ResultVariables;
import org.apache.sysml.conf.CompilerConfig;
import org.apache.sysml.conf.ConfigurationManager;
import org.apache.sysml.hops.OptimizerUtils;
import org.apache.sysml.hops.ipa.FunctionCallGraph;
import org.apache.sysml.parser.DMLProgram;
import org.apache.sysml.parser.Expression;
import org.apache.sysml.runtime.controlprogram.FunctionProgramBlock;
import org.apache.sysml.runtime.controlprogram.LocalVariableMap;
import org.apache.sysml.runtime.controlprogram.Program;
import org.apache.sysml.runtime.controlprogram.caching.FrameObject;
import org.apache.sysml.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysml.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysml.runtime.controlprogram.context.ExecutionContextFactory;
import org.apache.sysml.runtime.instructions.cp.BooleanObject;
import org.apache.sysml.runtime.instructions.cp.Data;
import org.apache.sysml.runtime.instructions.cp.DoubleObject;
import org.apache.sysml.runtime.instructions.cp.IntObject;
import org.apache.sysml.runtime.instructions.cp.ScalarObject;
import org.apache.sysml.runtime.instructions.cp.StringObject;
import org.apache.sysml.runtime.matrix.MatrixCharacteristics;
import org.apache.sysml.runtime.matrix.MatrixFormatMetaData;
import org.apache.sysml.runtime.matrix.data.FrameBlock;
import org.apache.sysml.runtime.matrix.data.InputInfo;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.data.OutputInfo;
import org.apache.sysml.runtime.util.DataConverter;
import org.apache.sysml.utils.Explain;

public class PreparedScript {
    private static final Log LOG = LogFactory.getLog((String)PreparedScript.class.getName());
    private HashSet<String> _inVarnames = null;
    private HashSet<String> _outVarnames = null;
    private HashMap<String, Data> _inVarReuse = null;
    private Program _prog = null;
    private LocalVariableMap _vars = null;

    protected PreparedScript(Program prog, String[] inputs, String[] outputs) {
        this._prog = prog;
        this._vars = new LocalVariableMap();
        this._inVarnames = new HashSet();
        Collections.addAll(this._inVarnames, inputs);
        this._outVarnames = new HashSet();
        Collections.addAll(this._outVarnames, outputs);
        this._inVarReuse = new HashMap();
    }

    public void setScalar(String varname, boolean scalar) throws DMLException {
        this.setScalar(varname, scalar, false);
    }

    public void setScalar(String varname, boolean scalar, boolean reuse) throws DMLException {
        this.setScalar(varname, new BooleanObject(varname, scalar), reuse);
    }

    public void setScalar(String varname, long scalar) throws DMLException {
        this.setScalar(varname, scalar, false);
    }

    public void setScalar(String varname, long scalar, boolean reuse) throws DMLException {
        this.setScalar(varname, new IntObject(varname, scalar), reuse);
    }

    public void setScalar(String varname, double scalar) throws DMLException {
        this.setScalar(varname, scalar, false);
    }

    public void setScalar(String varname, double scalar, boolean reuse) throws DMLException {
        this.setScalar(varname, new DoubleObject(varname, scalar), reuse);
    }

    public void setScalar(String varname, String scalar) throws DMLException {
        this.setScalar(varname, scalar, false);
    }

    public void setScalar(String varname, String scalar, boolean reuse) throws DMLException {
        this.setScalar(varname, new StringObject(varname, scalar), reuse);
    }

    public void setScalar(String varname, ScalarObject scalar, boolean reuse) throws DMLException {
        if (!this._inVarnames.contains(varname)) {
            throw new DMLException("Unspecified input variable: " + varname);
        }
        this._vars.put(varname, scalar);
    }

    public void setMatrix(String varname, double[][] matrix) throws DMLException {
        this.setMatrix(varname, matrix, false);
    }

    public void setMatrix(String varname, double[][] matrix, boolean reuse) throws DMLException {
        this.setMatrix(varname, DataConverter.convertToMatrixBlock(matrix), reuse);
    }

    public void setMatrix(String varname, MatrixBlock matrix, boolean reuse) throws DMLException {
        if (!this._inVarnames.contains(varname)) {
            throw new DMLException("Unspecified input variable: " + varname);
        }
        int blocksize = ConfigurationManager.getBlocksize();
        MatrixCharacteristics mc = new MatrixCharacteristics(matrix.getNumRows(), matrix.getNumColumns(), blocksize, blocksize);
        MatrixFormatMetaData meta = new MatrixFormatMetaData(mc, OutputInfo.BinaryBlockOutputInfo, InputInfo.BinaryBlockInputInfo);
        MatrixObject mo = new MatrixObject(Expression.ValueType.DOUBLE, OptimizerUtils.getUniqueTempFileName(), meta);
        mo.acquireModify(matrix);
        mo.release();
        this._vars.put(varname, mo);
        if (reuse) {
            mo.enableCleanup(false);
            this._inVarReuse.put(varname, mo);
        }
    }

    public void setFrame(String varname, String[][] frame) throws DMLException {
        this.setFrame(varname, frame, false);
    }

    public void setFrame(String varname, String[][] frame, List<Expression.ValueType> schema) throws DMLException {
        this.setFrame(varname, frame, schema, false);
    }

    public void setFrame(String varname, String[][] frame, List<Expression.ValueType> schema, List<String> colnames) throws DMLException {
        this.setFrame(varname, frame, schema, colnames, false);
    }

    public void setFrame(String varname, String[][] frame, boolean reuse) throws DMLException {
        this.setFrame(varname, DataConverter.convertToFrameBlock(frame), reuse);
    }

    public void setFrame(String varname, String[][] frame, List<Expression.ValueType> schema, boolean reuse) throws DMLException {
        this.setFrame(varname, DataConverter.convertToFrameBlock(frame, schema.toArray(new Expression.ValueType[0])), reuse);
    }

    public void setFrame(String varname, String[][] frame, List<Expression.ValueType> schema, List<String> colnames, boolean reuse) throws DMLException {
        this.setFrame(varname, DataConverter.convertToFrameBlock(frame, schema.toArray(new Expression.ValueType[0]), colnames.toArray(new String[0])), reuse);
    }

    public void setFrame(String varname, FrameBlock frame, boolean reuse) throws DMLException {
        if (!this._inVarnames.contains(varname)) {
            throw new DMLException("Unspecified input variable: " + varname);
        }
        MatrixCharacteristics mc = new MatrixCharacteristics(frame.getNumRows(), frame.getNumColumns(), -1, -1);
        MatrixFormatMetaData meta = new MatrixFormatMetaData(mc, OutputInfo.BinaryCellOutputInfo, InputInfo.BinaryCellInputInfo);
        FrameObject fo = new FrameObject(OptimizerUtils.getUniqueTempFileName(), meta);
        fo.acquireModify(frame);
        fo.release();
        this._vars.put(varname, fo);
        if (reuse) {
            fo.enableCleanup(false);
            this._inVarReuse.put(varname, fo);
        }
    }

    public void clearParameters() {
        this._vars.removeAll();
    }

    public ResultVariables executeScript() throws DMLException {
        this._vars.putAll(this._inVarReuse);
        ExecutionContext ec = ExecutionContextFactory.createContext(this._vars, this._prog);
        this._prog.execute(ec);
        this._vars.removeAllNotIn(this._outVarnames);
        ResultVariables rvars = new ResultVariables();
        for (String ovar : this._outVarnames) {
            Data tmpVar = this._vars.get(ovar);
            if (tmpVar == null) continue;
            rvars.addResult(ovar, tmpVar);
        }
        return rvars;
    }

    public String explain() throws DMLException {
        return Explain.explain(this._prog);
    }

    public void enableFunctionRecompile(String fnamespace, String ... fnames) throws DMLException {
        if (fnamespace == null) {
            fnamespace = ".defaultNS";
        }
        CompilerConfig cconf = ConfigurationManager.getCompilerConfig();
        cconf.set(CompilerConfig.ConfigType.ALLOW_DYN_RECOMPILATION, true);
        ConfigurationManager.setLocalConfig(cconf);
        FunctionCallGraph fgraph = this._prog.getProgramBlocks().isEmpty() ? null : new FunctionCallGraph(this._prog.getProgramBlocks().get(0).getStatementBlock().getDMLProg());
        for (String fname : fnames) {
            String fkey = DMLProgram.constructFunctionKey(fnamespace, fname);
            if (!fgraph.isRecursiveFunction(fkey)) {
                FunctionProgramBlock fpb = this._prog.getFunctionProgramBlock(fnamespace, fname);
                if (fpb != null) {
                    fpb.setRecompileOnce(true);
                    continue;
                }
                LOG.warn((Object)("Failed to enable function recompile for non-existing '" + fkey + "'."));
                continue;
            }
            LOG.warn((Object)("Failed to enable function recompile for recursive '" + fkey + "'."));
        }
    }
}

