/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.util;

public class ConvolutionUtils {
    public static long getP(long H, long R, long verticalStride, long heightPadding) {
        long ret = (H + 2L * heightPadding - R) / verticalStride + 1L;
        if (ret <= 0L) {
            throw new RuntimeException("Incorrect output patch size: (image_height + 2 * pad_h - filter_height) / verticalStride + 1) needs to be positive, but is " + ret + " (" + H + " + 2 * " + heightPadding + " - " + R + ") / " + verticalStride + " + 1))");
        }
        return ret;
    }

    public static long getQ(long W, long S, long horizontalStride, long widthPadding) {
        long ret = (W + 2L * widthPadding - S) / horizontalStride + 1L;
        if (ret <= 0L) {
            throw new RuntimeException("Incorrect output patch size: (image_width + 2 * pad_w - filter_width) / horizontalStride + 1) needs to be positive, but is " + ret + " (" + W + " + 2 * " + widthPadding + " - " + S + ") / " + horizontalStride + " + 1))");
        }
        return ret;
    }
}

