/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.transform;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.sysml.runtime.io.IOUtilFunctions;
import org.apache.sysml.runtime.matrix.data.FrameBlock;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.data.Pair;
import org.apache.sysml.runtime.transform.DistinctValue;
import org.apache.sysml.runtime.transform.MVImputeAgent;
import org.apache.sysml.runtime.transform.TfUtils;
import org.apache.sysml.runtime.transform.decode.DecoderRecode;
import org.apache.sysml.runtime.transform.encode.Encoder;
import org.apache.sysml.runtime.transform.meta.TfMetaUtils;
import org.apache.sysml.runtime.util.UtilFunctions;
import org.apache.wink.json4j.JSONException;
import org.apache.wink.json4j.JSONObject;

public class RecodeAgent
extends Encoder {
    private static final long serialVersionUID = 8213163881283341874L;
    private int[] _mvrcdList = null;
    private int[] _fullrcdList = null;
    private HashMap<Integer, HashMap<String, Long>> _rcdMaps = new HashMap();
    private HashMap<Integer, HashMap<String, String>> _finalMaps = null;
    private HashMap<Integer, HashSet<Object>> _rcdMapsPart = null;

    public RecodeAgent(JSONObject parsedSpec, String[] colnames, int clen) throws JSONException {
        super(null, clen);
        int rcdCount = 0;
        if (parsedSpec.containsKey("recode")) {
            int[] collist = TfMetaUtils.parseJsonIDList(parsedSpec, colnames, "recode");
            rcdCount = this.initColList(collist);
        }
        if (parsedSpec.containsKey("mvrcd")) {
            this._mvrcdList = TfMetaUtils.parseJsonIDList(parsedSpec, colnames, "mvrcd");
            rcdCount += this._mvrcdList.length;
        }
        if (rcdCount > 0) {
            int i;
            this._fullrcdList = new int[rcdCount];
            int idx = -1;
            if (this._colList != null) {
                for (i = 0; i < this._colList.length; ++i) {
                    this._fullrcdList[++idx] = this._colList[i];
                }
            }
            if (this._mvrcdList != null) {
                for (i = 0; i < this._mvrcdList.length; ++i) {
                    this._fullrcdList[++idx] = this._mvrcdList[i];
                }
            }
        }
    }

    public HashMap<Integer, HashMap<String, Long>> getCPRecodeMaps() {
        return this._rcdMaps;
    }

    public HashMap<Integer, HashSet<Object>> getCPRecodeMapsPartial() {
        return this._rcdMapsPart;
    }

    public HashMap<Integer, HashMap<String, String>> getRecodeMaps() {
        return this._finalMaps;
    }

    void prepare(String[] words, TfUtils agents) {
        if (this._colList == null && this._mvrcdList == null) {
            return;
        }
        String w = null;
        for (int colID : this._fullrcdList) {
            HashMap<String, Long> map;
            Long count;
            w = UtilFunctions.unquote(words[colID - 1].trim());
            if (this._rcdMaps.get(colID) == null) {
                this._rcdMaps.put(colID, new HashMap());
            }
            if ((count = (map = this._rcdMaps.get(colID)).get(w)) == null) {
                map.put(w, new Long(1L));
                continue;
            }
            map.put(w, count + 1L);
        }
    }

    private HashMap<String, Long> handleMVConstant(int colID, TfUtils agents, HashMap<String, Long> map) {
        MVImputeAgent mvagent = agents.getMVImputeAgent();
        if (mvagent.getMethod(colID) == MVImputeAgent.MVMethod.CONSTANT) {
            String repValue = mvagent.getReplacement(colID);
            if (repValue == null) {
                throw new RuntimeException("Expecting a constant replacement value for column ID " + colID);
            }
            repValue = UtilFunctions.unquote(repValue);
            Long count = map.get(repValue);
            long mvCount = agents.getValid() - mvagent.getNonMVCount(colID);
            if (count == null) {
                map.put(repValue, mvCount);
            } else {
                map.put(repValue, count + mvCount);
            }
        }
        return map;
    }

    @Override
    public void mapOutputTransformationMetadata(OutputCollector<IntWritable, DistinctValue> out, int taskID, TfUtils agents) throws IOException {
        this.mapOutputHelper(taskID, out, null, agents);
    }

    public ArrayList<Pair<Integer, DistinctValue>> mapOutputTransformationMetadata(int taskID, ArrayList<Pair<Integer, DistinctValue>> list, TfUtils agents) throws IOException {
        this.mapOutputHelper(taskID, null, list, agents);
        return list;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public void mapOutputHelper(int taskID, OutputCollector<IntWritable, DistinctValue> out, ArrayList<Pair<Integer, DistinctValue>> list, TfUtils agents) throws IOException {
        if (this._colList == null && this._mvrcdList == null) {
            return;
        }
        try {
            int i = 0;
            while (i < this._fullrcdList.length) {
                int colID = this._fullrcdList[i];
                HashMap<String, Long> map = this._rcdMaps.get(colID);
                if (map != null) {
                    map = this.handleMVConstant(colID, agents, map);
                    if (out != null) {
                        IntWritable iw = new IntWritable(colID);
                        for (String s : map.keySet()) {
                            out.collect((Object)iw, (Object)new DistinctValue(s, map.get(s)));
                        }
                    } else if (list != null) {
                        for (String s : map.keySet()) {
                            list.add(new Pair<Integer, DistinctValue>(colID, new DistinctValue(s, map.get(s))));
                        }
                    }
                }
                ++i;
            }
            return;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeMetadata(HashMap<String, Long> map, String outputDir, int colID, FileSystem fs, TfUtils agents, boolean fromCP) throws IOException {
        Object object;
        BufferedWriter br2;
        MVImputeAgent mvagent = agents.getMVImputeAgent();
        String mode = null;
        Long count = null;
        int rcdIndex = 0;
        int modeIndex = 0;
        long maxCount = Long.MIN_VALUE;
        boolean isRecoded = this.isApplicable(colID) != -1;
        boolean isModeImputed = mvagent.getMethod(colID) == MVImputeAgent.MVMethod.GLOBAL_MODE;
        Path pt = new Path(outputDir + "/Recode/" + agents.getName(colID) + ".map");
        BufferedWriter br = null;
        try {
            if (isRecoded) {
                br = new BufferedWriter(new OutputStreamWriter((OutputStream)fs.create(pt, true)));
            }
            if (agents.getNAStrings() != null) {
                for (String naword : agents.getNAStrings()) {
                    map.remove(naword);
                }
            }
            if (fromCP) {
                map = this.handleMVConstant(colID, agents, map);
            }
            if (map.size() == 0) {
                throw new RuntimeException("Can not proceed since \"" + agents.getName(colID) + "\" (id=" + colID + ") contains only the missing values, and not a single valid value -- set imputation method to \"constant\".");
            }
            ArrayList<String> newNames = new ArrayList<String>(map.keySet());
            Collections.sort(newNames);
            for (String w : newNames) {
                count = map.get(w);
                ++rcdIndex;
                if (br != null) {
                    br.write(UtilFunctions.quote(w) + "," + rcdIndex + "," + count + "\n");
                }
                if (maxCount < count) {
                    maxCount = count;
                    mode = w;
                    modeIndex = rcdIndex;
                }
                map.put(w, Long.valueOf(rcdIndex));
            }
        }
        catch (Throwable throwable) {
            IOUtilFunctions.closeSilently(br);
            throw throwable;
        }
        IOUtilFunctions.closeSilently(br);
        if (mode == null) {
            mode = "";
            maxCount = 0L;
        }
        if (isRecoded) {
            pt = new Path(outputDir + "/Recode/" + agents.getName(colID) + ".mode");
            br2 = new BufferedWriter(new OutputStreamWriter((OutputStream)fs.create(pt, true)));
            object = null;
            try {
                br2.write(UtilFunctions.quote(mode) + "," + modeIndex + "," + maxCount);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (br2 != null) {
                    if (object != null) {
                        try {
                            br2.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        br2.close();
                    }
                }
            }
            pt = new Path(outputDir + "/Recode/" + agents.getName(colID) + ".ndistinct");
            br2 = new BufferedWriter(new OutputStreamWriter((OutputStream)fs.create(pt, true)));
            object = null;
            try {
                br2.write("" + map.size());
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (br2 != null) {
                    if (object != null) {
                        try {
                            br2.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        br2.close();
                    }
                }
            }
        }
        if (isModeImputed) {
            pt = new Path(outputDir + "/Impute/" + agents.getName(colID) + ".impute");
            br2 = new BufferedWriter(new OutputStreamWriter((OutputStream)fs.create(pt, true)));
            object = null;
            try {
                br2.write(colID + "," + UtilFunctions.quote(mode));
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (br2 != null) {
                    if (object != null) {
                        try {
                            br2.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        br2.close();
                    }
                }
            }
        }
    }

    public void outputTransformationMetadata(String outputDir, FileSystem fs, TfUtils agents) throws IOException {
        if (this._colList == null && this._mvrcdList == null) {
            return;
        }
        for (int i = 0; i < this._fullrcdList.length; ++i) {
            int colID = this._fullrcdList[i];
            this.writeMetadata(this._rcdMaps.get(colID), outputDir, colID, fs, agents, true);
        }
    }

    @Override
    public void mergeAndOutputTransformationMetadata(Iterator<DistinctValue> values, String outputDir, int colID, FileSystem fs, TfUtils agents) throws IOException {
        HashMap<String, Long> map = new HashMap<String, Long>();
        DistinctValue d = new DistinctValue();
        String word = null;
        Long count = null;
        Long val = null;
        while (values.hasNext()) {
            d.reset();
            d = values.next();
            word = d.getWord();
            count = d.getCount();
            val = map.get(word);
            if (val == null) {
                map.put(word, count);
                continue;
            }
            map.put(word, val + count);
        }
        this.writeMetadata(map, outputDir, colID, fs, agents, false);
    }

    @Override
    public void loadTxMtd(JobConf job, FileSystem fs, Path txMtdDir, TfUtils agents) throws IOException {
        if (!this.isApplicable()) {
            return;
        }
        this._finalMaps = new HashMap();
        if (fs.isDirectory(txMtdDir)) {
            for (int i = 0; i < this._colList.length; ++i) {
                int colID = this._colList[i];
                Path path = new Path(txMtdDir + "/Recode/" + agents.getName(colID) + ".map");
                TfUtils.checkValidInputFile(fs, path, true);
                HashMap<String, String> map = new HashMap<String, String>();
                Pair<String, String> pair = new Pair<String, String>();
                String line = null;
                try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)fs.open(path)));){
                    while ((line = br.readLine()) != null) {
                        DecoderRecode.parseRecodeMapEntry(line, pair);
                        map.put(pair.getKey(), pair.getValue());
                    }
                }
                this._finalMaps.put(colID, map);
            }
        } else {
            throw new RuntimeException("Path to recode maps must be a directory: " + txMtdDir);
        }
    }

    private String lookupRCDMap(int colID, String key) {
        if (this._finalMaps != null) {
            return this._finalMaps.get(colID).get(key);
        }
        Long tmp = this._rcdMaps.get(colID).get(key);
        return tmp != null ? Long.toString(tmp) : null;
    }

    @Override
    public MatrixBlock encode(FrameBlock in, MatrixBlock out) {
        if (!this.isApplicable()) {
            return out;
        }
        this.build(in);
        this.apply(in, out);
        return out;
    }

    @Override
    public void build(FrameBlock in) {
        if (!this.isApplicable()) {
            return;
        }
        Iterator<String[]> iter = in.getStringRowIterator();
        while (iter.hasNext()) {
            String[] row = iter.next();
            for (int j = 0; j < this._colList.length; ++j) {
                int colID = this._colList[j];
                if (!this._rcdMaps.containsKey(colID)) {
                    this._rcdMaps.put(colID, new HashMap());
                }
                HashMap<String, Long> map = this._rcdMaps.get(colID);
                String key = row[colID - 1];
                if (key == null || key.isEmpty() || map.containsKey(key)) continue;
                map.put(key, Long.valueOf(map.size() + 1));
            }
        }
    }

    public void buildPartial(FrameBlock in) {
        if (!this.isApplicable()) {
            return;
        }
        if (this._rcdMapsPart == null) {
            this._rcdMapsPart = new HashMap();
        }
        for (int j = 0; j < this._colList.length; ++j) {
            int colID = this._colList[j];
            if (!this._rcdMapsPart.containsKey(colID)) {
                this._rcdMapsPart.put(colID, new HashSet());
            }
            HashSet<Object> map = this._rcdMapsPart.get(colID);
            for (int i = 0; i < in.getNumRows(); ++i) {
                map.add(in.get(i, colID - 1));
            }
            map.remove(null);
            map.remove("");
        }
    }

    @Override
    public String[] apply(String[] words) {
        if (!this.isApplicable()) {
            return words;
        }
        for (int i = 0; i < this._colList.length; ++i) {
            int colID = this._colList[i];
            String key = UtilFunctions.unquote(words[colID - 1].trim());
            String val = this.lookupRCDMap(colID, key);
            words[colID - 1] = val != null ? val : "NaN";
        }
        return words;
    }

    @Override
    public MatrixBlock apply(FrameBlock in, MatrixBlock out) {
        for (int j = 0; j < this._colList.length; ++j) {
            int colID = this._colList[j];
            for (int i = 0; i < in.getNumRows(); ++i) {
                Object okey = in.get(i, colID - 1);
                String key = okey != null ? okey.toString() : null;
                String val = this.lookupRCDMap(colID, key);
                out.quickSetValue(i, colID - 1, val != null ? Double.parseDouble(val) : Double.NaN);
            }
        }
        return out;
    }

    @Override
    public FrameBlock getMetaData(FrameBlock meta) {
        int j;
        if (!this.isApplicable()) {
            return meta;
        }
        int maxDistinct = 0;
        for (j = 0; j < this._colList.length; ++j) {
            if (!this._rcdMaps.containsKey(this._colList[j])) continue;
            maxDistinct = Math.max(maxDistinct, this._rcdMaps.get(this._colList[j]).size());
        }
        meta.ensureAllocatedColumns(maxDistinct);
        for (j = 0; j < this._colList.length; ++j) {
            int colID = this._colList[j];
            int rowID = 0;
            if (this._rcdMaps.containsKey(this._colList[j])) {
                for (Map.Entry<String, Long> e : this._rcdMaps.get(colID).entrySet()) {
                    String tmp = RecodeAgent.constructRecodeMapEntry(e.getKey(), e.getValue());
                    meta.set(rowID++, colID - 1, tmp);
                }
            }
            meta.getColumnMetadata(colID - 1).setNumDistinct(this._rcdMaps.get(colID).size());
        }
        return meta;
    }

    @Override
    public void initMetaData(FrameBlock meta) {
        if (meta == null || meta.getNumRows() <= 0) {
            return;
        }
        for (int j = 0; j < this._colList.length; ++j) {
            int colID = this._colList[j];
            this._rcdMaps.put(colID, meta.getRecodeMap(colID - 1));
        }
    }

    public static String constructRecodeMapEntry(String token, Long code) {
        return token + "\u00b7" + code.toString();
    }
}

