/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.transform;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hadoop.mapred.lib.NullOutputFormat;
import org.apache.sysml.runtime.matrix.data.CSVFileFormatProperties;
import org.apache.sysml.runtime.matrix.mapred.MRJobConfiguration;
import org.apache.sysml.runtime.transform.DistinctValue;
import org.apache.sysml.runtime.transform.GTFMTDMapper;
import org.apache.sysml.runtime.transform.GTFMTDReducer;
import org.apache.sysml.runtime.transform.TfUtils;

public class GenTfMtdMR {
    public static long runJob(String inputPath, String txMtdPath, String specWithIDs, String smallestFile, String partOffsetsFile, CSVFileFormatProperties inputDataProperties, long numCols, int replication, String headerLine) throws IOException, ClassNotFoundException, InterruptedException {
        JobConf job = new JobConf(GenTfMtdMR.class);
        job.setJobName("GenTfMTD");
        job.setJarByClass(GenTfMtdMR.class);
        job.setMapperClass(GTFMTDMapper.class);
        job.setReducerClass(GTFMTDReducer.class);
        job.setInputFormat(TextInputFormat.class);
        job.setOutputFormat(NullOutputFormat.class);
        job.setMapOutputKeyClass(IntWritable.class);
        job.setMapOutputValueClass(DistinctValue.class);
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(LongWritable.class);
        job.setInt("dfs.replication", replication);
        FileInputFormat.addInputPath((JobConf)job, (Path)new Path(inputPath));
        Path outPath = new Path(txMtdPath);
        FileSystem fs = FileSystem.get((Configuration)job);
        fs.delete(outPath, true);
        FileOutputFormat.setOutputPath((JobConf)job, (Path)outPath);
        job.set("transform.has.header", Boolean.toString(inputDataProperties.hasHeader()));
        job.set("transform.field.delimiter", inputDataProperties.getDelim());
        if (inputDataProperties.getNAStrings() != null) {
            job.set("transform.na.strings", TfUtils.prepNAStrings(inputDataProperties.getNAStrings()));
        }
        job.set("transform.specification", specWithIDs);
        job.set("transform.smallest.file", smallestFile);
        job.setLong("transform.num.columns", numCols);
        job.set("transform.header.line", headerLine);
        job.set("output.matrices.dirs", txMtdPath);
        job.set("transform.offsets.file", partOffsetsFile);
        job.setBoolean("adaptivemr.map.enable", false);
        RunningJob runjob = JobClient.runJob((JobConf)job);
        Counters c = runjob.getCounters();
        long tx_numRows = ((Counters.Counter)c.findCounter((Enum)MRJobConfiguration.DataTransformCounters.TRANSFORMED_NUM_ROWS)).getCounter();
        return tx_numRows;
    }
}

