/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.transform;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.CharacterCodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.sysml.runtime.io.IOUtilFunctions;
import org.apache.sysml.runtime.matrix.data.FrameBlock;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.data.Pair;
import org.apache.sysml.runtime.transform.DistinctValue;
import org.apache.sysml.runtime.transform.MVImputeAgent;
import org.apache.sysml.runtime.transform.TfUtils;
import org.apache.sysml.runtime.transform.encode.Encoder;
import org.apache.sysml.runtime.transform.meta.TfMetaUtils;
import org.apache.sysml.runtime.util.UtilFunctions;
import org.apache.wink.json4j.JSONArray;
import org.apache.wink.json4j.JSONException;
import org.apache.wink.json4j.JSONObject;

public class BinAgent
extends Encoder {
    private static final long serialVersionUID = 1917445005206076078L;
    public static final String MIN_PREFIX = "min";
    public static final String MAX_PREFIX = "max";
    public static final String NBINS_PREFIX = "nbins";
    private int[] _numBins = null;
    private double[] _min = null;
    private double[] _max = null;
    private double[] _binWidths = null;
    private double[][] _binMins = null;
    private double[][] _binMaxs = null;

    public BinAgent(JSONObject parsedSpec, String[] colnames, int clen) throws JSONException, IOException {
        this(parsedSpec, colnames, clen, false);
    }

    public BinAgent(JSONObject parsedSpec, String[] colnames, int clen, boolean colsOnly) throws JSONException, IOException {
        super(null, clen);
        if (!parsedSpec.containsKey("bin")) {
            return;
        }
        if (colsOnly) {
            List<Integer> collist = TfMetaUtils.parseBinningColIDs(parsedSpec, colnames);
            this.initColList(ArrayUtils.toPrimitive((Integer[])collist.toArray(new Integer[0])));
        } else {
            JSONObject obj = (JSONObject)parsedSpec.get("bin");
            JSONArray attrs = (JSONArray)obj.get("attributes");
            JSONArray nbins = (JSONArray)obj.get("numbins");
            this.initColList(attrs);
            this._numBins = new int[attrs.size()];
            for (int i = 0; i < this._numBins.length; ++i) {
                this._numBins[i] = UtilFunctions.toInt(nbins.get(i));
            }
            this._min = new double[this._colList.length];
            Arrays.fill(this._min, Double.MAX_VALUE);
            this._max = new double[this._colList.length];
            Arrays.fill(this._max, -1.7976931348623157E308);
            this._binWidths = new double[this._colList.length];
        }
    }

    public int[] getNumBins() {
        return this._numBins;
    }

    public double[] getMin() {
        return this._min;
    }

    public double[] getBinWidths() {
        return this._binWidths;
    }

    public void prepare(String[] words, TfUtils agents) {
        if (!this.isApplicable()) {
            return;
        }
        for (int i = 0; i < this._colList.length; ++i) {
            int colID = this._colList[i];
            String w = null;
            double d = 0.0;
            w = UtilFunctions.unquote(words[colID - 1].trim());
            if (TfUtils.isNA(agents.getNAStrings(), w)) continue;
            d = UtilFunctions.parseToDouble(w);
            if (d < this._min[i]) {
                this._min[i] = d;
            }
            if (!(d > this._max[i])) continue;
            this._max[i] = d;
        }
    }

    private DistinctValue prepMinOutput(int idx) throws CharacterCodingException {
        String s = MIN_PREFIX + Double.toString(this._min[idx]);
        return new DistinctValue(s, -1L);
    }

    private DistinctValue prepMaxOutput(int idx) throws CharacterCodingException {
        String s = MAX_PREFIX + Double.toString(this._max[idx]);
        return new DistinctValue(s, -1L);
    }

    private DistinctValue prepNBinsOutput(int idx) throws CharacterCodingException {
        String s = NBINS_PREFIX + Double.toString(this._numBins[idx]);
        return new DistinctValue(s, -1L);
    }

    @Override
    public void mapOutputTransformationMetadata(OutputCollector<IntWritable, DistinctValue> out, int taskID, TfUtils agents) throws IOException {
        if (!this.isApplicable()) {
            return;
        }
        try {
            for (int i = 0; i < this._colList.length; ++i) {
                int colID = this._colList[i];
                IntWritable iw = new IntWritable(-colID);
                out.collect((Object)iw, (Object)this.prepMinOutput(i));
                out.collect((Object)iw, (Object)this.prepMaxOutput(i));
                out.collect((Object)iw, (Object)this.prepNBinsOutput(i));
            }
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public ArrayList<Pair<Integer, DistinctValue>> mapOutputTransformationMetadata(int taskID, ArrayList<Pair<Integer, DistinctValue>> list, TfUtils agents) throws IOException {
        if (!this.isApplicable()) {
            return list;
        }
        try {
            for (int i = 0; i < this._colList.length; ++i) {
                int colID = this._colList[i];
                Integer iw = -colID;
                list.add(new Pair<Integer, DistinctValue>(iw, this.prepMinOutput(i)));
                list.add(new Pair<Integer, DistinctValue>(iw, this.prepMaxOutput(i)));
                list.add(new Pair<Integer, DistinctValue>(iw, this.prepNBinsOutput(i)));
            }
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeTfMtd(int colID, String min, String max, String binwidth, String nbins, String tfMtdDir, FileSystem fs, TfUtils agents) throws IOException {
        Path pt = new Path(tfMtdDir + "/Bin/" + agents.getName(colID) + ".bin");
        BufferedWriter br = null;
        try {
            br = new BufferedWriter(new OutputStreamWriter((OutputStream)fs.create(pt, true)));
            br.write(colID + "," + min + "," + max + "," + binwidth + "," + nbins + "\n");
        }
        catch (Throwable throwable) {
            IOUtilFunctions.closeSilently(br);
            throw throwable;
        }
        IOUtilFunctions.closeSilently(br);
    }

    @Override
    public void mergeAndOutputTransformationMetadata(Iterator<DistinctValue> values, String outputDir, int colID, FileSystem fs, TfUtils agents) throws IOException {
        double min = Double.MAX_VALUE;
        double max = -1.7976931348623157E308;
        int nbins = 0;
        DistinctValue val = new DistinctValue();
        String w = null;
        while (values.hasNext()) {
            double d;
            val.reset();
            val = values.next();
            w = val.getWord();
            if (w.startsWith(MIN_PREFIX)) {
                d = UtilFunctions.parseToDouble(w.substring(MIN_PREFIX.length()));
                if (!(d < min)) continue;
                min = d;
                continue;
            }
            if (w.startsWith(MAX_PREFIX)) {
                d = UtilFunctions.parseToDouble(w.substring(MAX_PREFIX.length()));
                if (!(d > max)) continue;
                max = d;
                continue;
            }
            if (w.startsWith(NBINS_PREFIX)) {
                nbins = (int)UtilFunctions.parseToLong(w.substring(NBINS_PREFIX.length()));
                continue;
            }
            throw new RuntimeException("MVImputeAgent: Invalid prefix while merging map output: " + w);
        }
        double binwidth = (max - min) / (double)nbins;
        this.writeTfMtd(colID, Double.toString(min), Double.toString(max), Double.toString(binwidth), Integer.toString(nbins), outputDir, fs, agents);
    }

    public void outputTransformationMetadata(String outputDir, FileSystem fs, TfUtils agents) throws IOException {
        if (!this.isApplicable()) {
            return;
        }
        MVImputeAgent mvagent = agents.getMVImputeAgent();
        for (int i = 0; i < this._colList.length; ++i) {
            int colID = this._colList[i];
            if (mvagent.isApplicable(colID) != -1 && mvagent.getMethod(colID) == MVImputeAgent.MVMethod.CONSTANT) {
                double cst = UtilFunctions.parseToDouble(mvagent.getReplacement(colID));
                if (cst < this._min[i]) {
                    this._min[i] = cst;
                }
                if (cst > this._max[i]) {
                    this._max[i] = cst;
                }
            }
            double binwidth = (this._max[i] - this._min[i]) / (double)this._numBins[i];
            this.writeTfMtd(colID, Double.toString(this._min[i]), Double.toString(this._max[i]), Double.toString(binwidth), Integer.toString(this._numBins[i]), outputDir, fs, agents);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadTxMtd(JobConf job, FileSystem fs, Path txMtdDir, TfUtils agents) throws IOException {
        block5: {
            block4: {
                if (!this.isApplicable()) {
                    return;
                }
                if (!fs.isDirectory(txMtdDir)) break block4;
                for (int i = 0; i < this._colList.length; ++i) {
                    int colID = this._colList[i];
                    Path path = new Path(txMtdDir + "/Bin/" + agents.getName(colID) + ".bin");
                    TfUtils.checkValidInputFile(fs, path, true);
                    BufferedReader br = null;
                    try {
                        int nbins;
                        br = new BufferedReader(new InputStreamReader((InputStream)fs.open(path)));
                        String[] fields = br.readLine().split(",");
                        double min = UtilFunctions.parseToDouble(fields[1]);
                        double binwidth = UtilFunctions.parseToDouble(fields[3]);
                        this._numBins[i] = nbins = UtilFunctions.parseToInt(fields[4]);
                        this._min[i] = min;
                        this._binWidths[i] = binwidth;
                    }
                    catch (Throwable throwable) {
                        IOUtilFunctions.closeSilently(br);
                        throw throwable;
                    }
                    IOUtilFunctions.closeSilently(br);
                }
                break block5;
            }
            throw new RuntimeException("Path to recode maps must be a directory: " + txMtdDir);
        }
    }

    @Override
    public MatrixBlock encode(FrameBlock in, MatrixBlock out) {
        this.build(in);
        return this.apply(in, out);
    }

    @Override
    public void build(FrameBlock in) {
    }

    @Override
    public String[] apply(String[] words) {
        if (!this.isApplicable()) {
            return words;
        }
        for (int i = 0; i < this._colList.length; ++i) {
            int colID = this._colList[i];
            try {
                double val = UtilFunctions.parseToDouble(words[colID - 1]);
                int binid = 1;
                for (double tmp = this._min[i] + this._binWidths[i]; val > tmp && binid < this._numBins[i]; tmp += this._binWidths[i], ++binid) {
                }
                words[colID - 1] = Integer.toString(binid);
                continue;
            }
            catch (NumberFormatException e) {
                throw new RuntimeException("Encountered \"" + words[colID - 1] + "\" in column ID \"" + colID + "\", when expecting a numeric value. Consider adding \"" + words[colID - 1] + "\" to na.strings, along with an appropriate imputation method.");
            }
        }
        return words;
    }

    @Override
    public MatrixBlock apply(FrameBlock in, MatrixBlock out) {
        for (int j = 0; j < this._colList.length; ++j) {
            int colID = this._colList[j];
            for (int i = 0; i < in.getNumRows(); ++i) {
                double inVal = UtilFunctions.objectToDouble(in.getSchema()[colID - 1], in.get(i, colID - 1));
                int ix = Arrays.binarySearch(this._binMaxs[j], inVal);
                int binID = (ix < 0 ? Math.abs(ix + 1) : ix) + 1;
                out.quickSetValue(i, colID - 1, binID);
            }
        }
        return out;
    }

    @Override
    public FrameBlock getMetaData(FrameBlock meta) {
        return meta;
    }

    @Override
    public void initMetaData(FrameBlock meta) {
        this._binMins = new double[this._colList.length][];
        this._binMaxs = new double[this._colList.length][];
        for (int j = 0; j < this._colList.length; ++j) {
            int colID = this._colList[j];
            int nbins = (int)meta.getColumnMetadata()[colID - 1].getNumDistinct();
            this._binMins[j] = new double[nbins];
            this._binMaxs[j] = new double[nbins];
            for (int i = 0; i < nbins; ++i) {
                String[] tmp = meta.get(i, colID - 1).toString().split("\u00b7");
                this._binMins[j][i] = Double.parseDouble(tmp[0]);
                this._binMaxs[j][i] = Double.parseDouble(tmp[1]);
            }
        }
    }
}

