/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.matrix.data;

import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.CholeskyDecomposition;
import org.apache.commons.math3.linear.DecompositionSolver;
import org.apache.commons.math3.linear.EigenDecomposition;
import org.apache.commons.math3.linear.LUDecomposition;
import org.apache.commons.math3.linear.QRDecomposition;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.util.DataConverter;

public class LibCommonsMath {
    private LibCommonsMath() {
    }

    public static boolean isSupportedUnaryOperation(String opcode) {
        return opcode.equals("inverse") || opcode.equals("cholesky");
    }

    public static boolean isSupportedMultiReturnOperation(String opcode) {
        return opcode.equals("qr") || opcode.equals("lu") || opcode.equals("eigen");
    }

    public static boolean isSupportedMatrixMatrixOperation(String opcode) {
        return opcode.equals("solve");
    }

    public static MatrixBlock unaryOperations(MatrixObject inj, String opcode) throws DMLRuntimeException {
        Array2DRowRealMatrix matrixInput = DataConverter.convertToArray2DRowRealMatrix(inj);
        if (opcode.equals("inverse")) {
            return LibCommonsMath.computeMatrixInverse(matrixInput);
        }
        if (opcode.equals("cholesky")) {
            return LibCommonsMath.computeCholesky(matrixInput);
        }
        return null;
    }

    public static MatrixBlock[] multiReturnOperations(MatrixObject in, String opcode) throws DMLRuntimeException {
        if (opcode.equals("qr")) {
            return LibCommonsMath.computeQR(in);
        }
        if (opcode.equals("lu")) {
            return LibCommonsMath.computeLU(in);
        }
        if (opcode.equals("eigen")) {
            return LibCommonsMath.computeEigen(in);
        }
        return null;
    }

    public static MatrixBlock matrixMatrixOperations(MatrixObject in1, MatrixObject in2, String opcode) throws DMLRuntimeException {
        if (opcode.equals("solve")) {
            return LibCommonsMath.computeSolve(in1, in2);
        }
        return null;
    }

    private static MatrixBlock computeSolve(MatrixObject in1, MatrixObject in2) throws DMLRuntimeException {
        Array2DRowRealMatrix matrixInput = DataConverter.convertToArray2DRowRealMatrix(in1);
        Array2DRowRealMatrix vectorInput = DataConverter.convertToArray2DRowRealMatrix(in2);
        QRDecomposition qrdecompose = new QRDecomposition((RealMatrix)matrixInput);
        DecompositionSolver solver = qrdecompose.getSolver();
        RealMatrix solutionMatrix = solver.solve((RealMatrix)vectorInput);
        return DataConverter.convertToMatrixBlock(solutionMatrix.getData());
    }

    private static MatrixBlock[] computeQR(MatrixObject in) throws DMLRuntimeException {
        Array2DRowRealMatrix matrixInput = DataConverter.convertToArray2DRowRealMatrix(in);
        QRDecomposition qrdecompose = new QRDecomposition((RealMatrix)matrixInput);
        RealMatrix H = qrdecompose.getH();
        RealMatrix R = qrdecompose.getR();
        MatrixBlock mbH = DataConverter.convertToMatrixBlock(H.getData());
        MatrixBlock mbR = DataConverter.convertToMatrixBlock(R.getData());
        return new MatrixBlock[]{mbH, mbR};
    }

    private static MatrixBlock[] computeLU(MatrixObject in) throws DMLRuntimeException {
        if (in.getNumRows() != in.getNumColumns()) {
            throw new DMLRuntimeException("LU Decomposition can only be done on a square matrix. Input matrix is rectangular (rows=" + in.getNumRows() + ", cols=" + in.getNumColumns() + ")");
        }
        Array2DRowRealMatrix matrixInput = DataConverter.convertToArray2DRowRealMatrix(in);
        LUDecomposition ludecompose = new LUDecomposition((RealMatrix)matrixInput);
        RealMatrix P = ludecompose.getP();
        RealMatrix L = ludecompose.getL();
        RealMatrix U = ludecompose.getU();
        MatrixBlock mbP = DataConverter.convertToMatrixBlock(P.getData());
        MatrixBlock mbL = DataConverter.convertToMatrixBlock(L.getData());
        MatrixBlock mbU = DataConverter.convertToMatrixBlock(U.getData());
        return new MatrixBlock[]{mbP, mbL, mbU};
    }

    private static MatrixBlock[] computeEigen(MatrixObject in) throws DMLRuntimeException {
        if (in.getNumRows() != in.getNumColumns()) {
            throw new DMLRuntimeException("Eigen Decomposition can only be done on a square matrix. Input matrix is rectangular (rows=" + in.getNumRows() + ", cols=" + in.getNumColumns() + ")");
        }
        Array2DRowRealMatrix matrixInput = DataConverter.convertToArray2DRowRealMatrix(in);
        EigenDecomposition eigendecompose = new EigenDecomposition((RealMatrix)matrixInput);
        RealMatrix eVectorsMatrix = eigendecompose.getV();
        double[][] eVectors = eVectorsMatrix.getData();
        double[] eValues = eigendecompose.getRealEigenvalues();
        int n = eValues.length;
        for (int i = 0; i < n; ++i) {
            int j;
            int k = i;
            double p = eValues[i];
            for (j = i + 1; j < n; ++j) {
                if (!(eValues[j] < p)) continue;
                k = j;
                p = eValues[j];
            }
            if (k == i) continue;
            eValues[k] = eValues[i];
            eValues[i] = p;
            for (j = 0; j < n; ++j) {
                p = eVectors[j][i];
                eVectors[j][i] = eVectors[j][k];
                eVectors[j][k] = p;
            }
        }
        MatrixBlock mbValues = DataConverter.convertToMatrixBlock(eValues, true);
        MatrixBlock mbVectors = DataConverter.convertToMatrixBlock(eVectors);
        return new MatrixBlock[]{mbValues, mbVectors};
    }

    private static MatrixBlock computeMatrixInverse(Array2DRowRealMatrix in) throws DMLRuntimeException {
        if (!in.isSquare()) {
            throw new DMLRuntimeException("Input to inv() must be square matrix -- given: a " + in.getRowDimension() + "x" + in.getColumnDimension() + " matrix.");
        }
        QRDecomposition qrdecompose = new QRDecomposition((RealMatrix)in);
        DecompositionSolver solver = qrdecompose.getSolver();
        RealMatrix inverseMatrix = solver.getInverse();
        return DataConverter.convertToMatrixBlock(inverseMatrix.getData());
    }

    private static MatrixBlock computeCholesky(Array2DRowRealMatrix in) throws DMLRuntimeException {
        if (!in.isSquare()) {
            throw new DMLRuntimeException("Input to cholesky() must be square matrix -- given: a " + in.getRowDimension() + "x" + in.getColumnDimension() + " matrix.");
        }
        CholeskyDecomposition cholesky = new CholeskyDecomposition((RealMatrix)in);
        RealMatrix rmL = cholesky.getL();
        return DataConverter.convertToMatrixBlock(rmL.getData());
    }
}

