/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.io;

import org.apache.sysml.conf.CompilerConfig;
import org.apache.sysml.conf.ConfigurationManager;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.io.MatrixReader;
import org.apache.sysml.runtime.io.ReadProperties;
import org.apache.sysml.runtime.io.ReaderBinaryBlock;
import org.apache.sysml.runtime.io.ReaderBinaryBlockParallel;
import org.apache.sysml.runtime.io.ReaderBinaryCell;
import org.apache.sysml.runtime.io.ReaderTextCSV;
import org.apache.sysml.runtime.io.ReaderTextCSVParallel;
import org.apache.sysml.runtime.io.ReaderTextCell;
import org.apache.sysml.runtime.io.ReaderTextCellParallel;
import org.apache.sysml.runtime.matrix.data.CSVFileFormatProperties;
import org.apache.sysml.runtime.matrix.data.InputInfo;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.data.SparseBlock;

public class MatrixReaderFactory {
    public static MatrixReader createMatrixReader(InputInfo iinfo) throws DMLRuntimeException {
        MatrixReader reader = null;
        if (iinfo == InputInfo.TextCellInputInfo || iinfo == InputInfo.MatrixMarketInputInfo) {
            reader = ConfigurationManager.getCompilerConfigFlag(CompilerConfig.ConfigType.PARALLEL_CP_READ_TEXTFORMATS) && MatrixBlock.DEFAULT_SPARSEBLOCK == SparseBlock.Type.MCSR ? new ReaderTextCellParallel(iinfo) : new ReaderTextCell(iinfo);
        } else if (iinfo == InputInfo.CSVInputInfo) {
            reader = ConfigurationManager.getCompilerConfigFlag(CompilerConfig.ConfigType.PARALLEL_CP_READ_TEXTFORMATS) && MatrixBlock.DEFAULT_SPARSEBLOCK == SparseBlock.Type.MCSR ? new ReaderTextCSVParallel(new CSVFileFormatProperties()) : new ReaderTextCSV(new CSVFileFormatProperties());
        } else if (iinfo == InputInfo.BinaryCellInputInfo) {
            reader = new ReaderBinaryCell();
        } else if (iinfo == InputInfo.BinaryBlockInputInfo) {
            reader = ConfigurationManager.getCompilerConfigFlag(CompilerConfig.ConfigType.PARALLEL_CP_READ_BINARYFORMATS) && MatrixBlock.DEFAULT_SPARSEBLOCK == SparseBlock.Type.MCSR ? new ReaderBinaryBlockParallel(false) : new ReaderBinaryBlock(false);
        } else {
            throw new DMLRuntimeException("Failed to create matrix reader for unknown input info: " + InputInfo.inputInfoToString(iinfo));
        }
        return reader;
    }

    public static MatrixReader createMatrixReader(ReadProperties props) throws DMLRuntimeException {
        if (props == null) {
            throw new DMLRuntimeException("Failed to create matrix reader with empty properties.");
        }
        MatrixReader reader = null;
        InputInfo iinfo = props.inputInfo;
        if (iinfo == InputInfo.TextCellInputInfo || iinfo == InputInfo.MatrixMarketInputInfo) {
            reader = ConfigurationManager.getCompilerConfigFlag(CompilerConfig.ConfigType.PARALLEL_CP_READ_TEXTFORMATS) && MatrixBlock.DEFAULT_SPARSEBLOCK == SparseBlock.Type.MCSR ? new ReaderTextCellParallel(iinfo) : new ReaderTextCell(iinfo);
        } else if (iinfo == InputInfo.CSVInputInfo) {
            reader = ConfigurationManager.getCompilerConfigFlag(CompilerConfig.ConfigType.PARALLEL_CP_READ_TEXTFORMATS) && MatrixBlock.DEFAULT_SPARSEBLOCK == SparseBlock.Type.MCSR ? new ReaderTextCSVParallel(props.formatProperties != null ? (CSVFileFormatProperties)props.formatProperties : new CSVFileFormatProperties()) : new ReaderTextCSV(props.formatProperties != null ? (CSVFileFormatProperties)props.formatProperties : new CSVFileFormatProperties());
        } else if (iinfo == InputInfo.BinaryCellInputInfo) {
            reader = new ReaderBinaryCell();
        } else if (iinfo == InputInfo.BinaryBlockInputInfo) {
            reader = ConfigurationManager.getCompilerConfigFlag(CompilerConfig.ConfigType.PARALLEL_CP_READ_BINARYFORMATS) && MatrixBlock.DEFAULT_SPARSEBLOCK == SparseBlock.Type.MCSR ? new ReaderBinaryBlockParallel(props.localFS) : new ReaderBinaryBlock(props.localFS);
        } else {
            throw new DMLRuntimeException("Failed to create matrix reader for unknown input info: " + InputInfo.inputInfoToString(iinfo));
        }
        return reader;
    }
}

