/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.spark;

import java.util.Iterator;
import java.util.LinkedList;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.function.PairFlatMapFunction;
import org.apache.spark.api.java.function.PairFunction;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysml.runtime.controlprogram.context.SparkExecutionContext;
import org.apache.sysml.runtime.functionobjects.Multiply;
import org.apache.sysml.runtime.functionobjects.Plus;
import org.apache.sysml.runtime.instructions.InstructionUtils;
import org.apache.sysml.runtime.instructions.cp.CPOperand;
import org.apache.sysml.runtime.instructions.spark.BinarySPInstruction;
import org.apache.sysml.runtime.instructions.spark.SPInstruction;
import org.apache.sysml.runtime.instructions.spark.utils.RDDAggregateUtils;
import org.apache.sysml.runtime.matrix.MatrixCharacteristics;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.data.MatrixIndexes;
import org.apache.sysml.runtime.matrix.data.TripleIndexes;
import org.apache.sysml.runtime.matrix.operators.AggregateBinaryOperator;
import org.apache.sysml.runtime.matrix.operators.AggregateOperator;
import org.apache.sysml.runtime.matrix.operators.Operator;
import scala.Tuple2;

public class RmmSPInstruction
extends BinarySPInstruction {
    public RmmSPInstruction(Operator op, CPOperand in1, CPOperand in2, CPOperand out, String opcode, String istr) {
        super(op, in1, in2, out, opcode, istr);
        this._sptype = SPInstruction.SPINSTRUCTION_TYPE.RMM;
    }

    public static RmmSPInstruction parseInstruction(String str) throws DMLRuntimeException {
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        String opcode = parts[0];
        if ("rmm".equals(opcode)) {
            CPOperand in1 = new CPOperand(parts[1]);
            CPOperand in2 = new CPOperand(parts[2]);
            CPOperand out = new CPOperand(parts[3]);
            return new RmmSPInstruction(null, in1, in2, out, opcode, str);
        }
        throw new DMLRuntimeException("RmmSPInstruction.parseInstruction():: Unknown opcode " + opcode);
    }

    @Override
    public void processInstruction(ExecutionContext ec) throws DMLRuntimeException {
        SparkExecutionContext sec = (SparkExecutionContext)ec;
        MatrixCharacteristics mc1 = sec.getMatrixCharacteristics(this.input1.getName());
        MatrixCharacteristics mc2 = sec.getMatrixCharacteristics(this.input2.getName());
        JavaPairRDD<MatrixIndexes, MatrixBlock> in1 = sec.getBinaryBlockRDDHandleForVariable(this.input1.getName());
        JavaPairRDD<MatrixIndexes, MatrixBlock> in2 = sec.getBinaryBlockRDDHandleForVariable(this.input2.getName());
        JavaPairRDD tmp1 = in1.flatMapToPair((PairFlatMapFunction)new RmmReplicateFunction(mc2.getCols(), mc2.getColsPerBlock(), true));
        JavaPairRDD tmp2 = in2.flatMapToPair((PairFlatMapFunction)new RmmReplicateFunction(mc1.getRows(), mc1.getRowsPerBlock(), false));
        JavaPairRDD<MatrixIndexes, MatrixBlock> out = tmp1.join(tmp2).mapToPair((PairFunction)new RmmMultiplyFunction());
        out = RDDAggregateUtils.sumByKeyStable(out, false);
        this.updateBinaryMMOutputMatrixCharacteristics(sec, true);
        sec.setRDDHandleForVariable(this.output.getName(), out);
        sec.addLineageRDD(this.output.getName(), this.input1.getName());
        sec.addLineageRDD(this.output.getName(), this.input2.getName());
    }

    private static class RmmMultiplyFunction
    implements PairFunction<Tuple2<TripleIndexes, Tuple2<MatrixBlock, MatrixBlock>>, MatrixIndexes, MatrixBlock> {
        private static final long serialVersionUID = -5772410117511730911L;
        private AggregateBinaryOperator _op = null;

        public RmmMultiplyFunction() {
            AggregateOperator agg = new AggregateOperator(0.0, Plus.getPlusFnObject());
            this._op = new AggregateBinaryOperator(Multiply.getMultiplyFnObject(), agg);
        }

        public Tuple2<MatrixIndexes, MatrixBlock> call(Tuple2<TripleIndexes, Tuple2<MatrixBlock, MatrixBlock>> arg0) throws Exception {
            TripleIndexes ixIn = (TripleIndexes)arg0._1();
            MatrixIndexes ixOut = new MatrixIndexes(ixIn.getFirstIndex(), ixIn.getSecondIndex());
            MatrixBlock blkIn1 = (MatrixBlock)((Tuple2)arg0._2())._1();
            MatrixBlock blkIn2 = (MatrixBlock)((Tuple2)arg0._2())._2();
            MatrixBlock blkOut = new MatrixBlock();
            blkIn1.aggregateBinaryOperations(blkIn1, blkIn2, blkOut, this._op);
            return new Tuple2((Object)ixOut, (Object)blkOut);
        }
    }

    private static class RmmReplicateFunction
    implements PairFlatMapFunction<Tuple2<MatrixIndexes, MatrixBlock>, TripleIndexes, MatrixBlock> {
        private static final long serialVersionUID = 3577072668341033932L;
        private long _len = -1L;
        private long _blen = -1L;
        private boolean _left = false;

        public RmmReplicateFunction(long len, long blen, boolean left) {
            this._len = len;
            this._blen = blen;
            this._left = left;
        }

        public Iterator<Tuple2<TripleIndexes, MatrixBlock>> call(Tuple2<MatrixIndexes, MatrixBlock> arg0) throws Exception {
            LinkedList<Tuple2> ret = new LinkedList<Tuple2>();
            MatrixIndexes ixIn = (MatrixIndexes)arg0._1();
            MatrixBlock blkIn = (MatrixBlock)arg0._2();
            long numBlocks = (long)Math.ceil((double)this._len / (double)this._blen);
            if (this._left) {
                long i = ixIn.getRowIndex();
                long k = ixIn.getColumnIndex();
                for (long j = 1L; j <= numBlocks; ++j) {
                    TripleIndexes tmptix = new TripleIndexes(i, j, k);
                    MatrixBlock tmpblk = new MatrixBlock(blkIn);
                    ret.add(new Tuple2((Object)tmptix, (Object)tmpblk));
                }
            } else {
                long k = ixIn.getRowIndex();
                long j = ixIn.getColumnIndex();
                for (long i = 1L; i <= numBlocks; ++i) {
                    TripleIndexes tmptix = new TripleIndexes(i, j, k);
                    MatrixBlock tmpblk = new MatrixBlock(blkIn);
                    ret.add(new Tuple2((Object)tmptix, (Object)tmpblk));
                }
            }
            return ret.iterator();
        }
    }
}

