/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.spark;

import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.function.PairFlatMapFunction;
import org.apache.sysml.hops.recompile.Recompiler;
import org.apache.sysml.parser.Expression;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.caching.CacheableData;
import org.apache.sysml.runtime.controlprogram.caching.FrameObject;
import org.apache.sysml.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysml.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysml.runtime.controlprogram.context.SparkExecutionContext;
import org.apache.sysml.runtime.instructions.InstructionUtils;
import org.apache.sysml.runtime.instructions.cp.CPOperand;
import org.apache.sysml.runtime.instructions.spark.CSVReblockSPInstruction;
import org.apache.sysml.runtime.instructions.spark.UnarySPInstruction;
import org.apache.sysml.runtime.instructions.spark.functions.ExtractBlockForBinaryReblock;
import org.apache.sysml.runtime.instructions.spark.utils.FrameRDDConverterUtils;
import org.apache.sysml.runtime.instructions.spark.utils.RDDAggregateUtils;
import org.apache.sysml.runtime.instructions.spark.utils.RDDConverterUtils;
import org.apache.sysml.runtime.matrix.MatrixCharacteristics;
import org.apache.sysml.runtime.matrix.MatrixFormatMetaData;
import org.apache.sysml.runtime.matrix.data.CSVFileFormatProperties;
import org.apache.sysml.runtime.matrix.data.FrameBlock;
import org.apache.sysml.runtime.matrix.data.InputInfo;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.data.MatrixIndexes;
import org.apache.sysml.runtime.matrix.operators.Operator;

public class ReblockSPInstruction
extends UnarySPInstruction {
    private int brlen;
    private int bclen;
    private boolean outputEmptyBlocks;

    public ReblockSPInstruction(Operator op, CPOperand in, CPOperand out, int br, int bc, boolean emptyBlocks, String opcode, String instr) {
        super(op, in, out, opcode, instr);
        this.brlen = br;
        this.bclen = bc;
        this.outputEmptyBlocks = emptyBlocks;
    }

    public static ReblockSPInstruction parseInstruction(String str) throws DMLRuntimeException {
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        String opcode = parts[0];
        if (!opcode.equals("rblk")) {
            throw new DMLRuntimeException("Incorrect opcode for ReblockSPInstruction:" + opcode);
        }
        CPOperand in = new CPOperand(parts[1]);
        CPOperand out = new CPOperand(parts[2]);
        int brlen = Integer.parseInt(parts[3]);
        int bclen = Integer.parseInt(parts[4]);
        boolean outputEmptyBlocks = Boolean.parseBoolean(parts[5]);
        Operator op = null;
        return new ReblockSPInstruction(op, in, out, brlen, bclen, outputEmptyBlocks, opcode, str);
    }

    @Override
    public void processInstruction(ExecutionContext ec) throws DMLRuntimeException {
        SparkExecutionContext sec = (SparkExecutionContext)ec;
        CacheableData<?> obj = sec.getCacheableData(this.input1.getName());
        MatrixCharacteristics mc = sec.getMatrixCharacteristics(this.input1.getName());
        MatrixCharacteristics mcOut = sec.getMatrixCharacteristics(this.output.getName());
        mcOut.set(mc.getRows(), mc.getCols(), this.brlen, this.bclen, mc.getNonZeros());
        MatrixFormatMetaData iimd = (MatrixFormatMetaData)obj.getMetaData();
        if (iimd == null) {
            throw new DMLRuntimeException("Error: Metadata not found");
        }
        InputInfo iinfo = iimd.getInputInfo();
        if (Recompiler.checkCPReblock(sec, this.input1.getName())) {
            if (this.input1.getDataType() == Expression.DataType.MATRIX) {
                Recompiler.executeInMemoryMatrixReblock(sec, this.input1.getName(), this.output.getName());
            } else if (this.input1.getDataType() == Expression.DataType.FRAME) {
                Recompiler.executeInMemoryFrameReblock(sec, this.input1.getName(), this.output.getName());
            }
            return;
        }
        if (this.input1.getDataType() == Expression.DataType.MATRIX) {
            this.processMatrixReblockInstruction(sec, iinfo);
        } else if (this.input1.getDataType() == Expression.DataType.FRAME) {
            this.processFrameReblockInstruction(sec, iinfo);
        }
    }

    protected void processMatrixReblockInstruction(SparkExecutionContext sec, InputInfo iinfo) throws DMLRuntimeException {
        MatrixObject mo = sec.getMatrixObject(this.input1.getName());
        MatrixCharacteristics mc = sec.getMatrixCharacteristics(this.input1.getName());
        MatrixCharacteristics mcOut = sec.getMatrixCharacteristics(this.output.getName());
        if (iinfo == InputInfo.TextCellInputInfo || iinfo == InputInfo.MatrixMarketInputInfo) {
            sec.checkAndRaiseValidationWarningJDKVersion();
            JavaPairRDD<?, ?> lines = sec.getRDDHandleForVariable(this.input1.getName(), iinfo);
            JavaPairRDD<MatrixIndexes, MatrixBlock> out = RDDConverterUtils.textCellToBinaryBlock(sec.getSparkContext(), lines, mcOut, this.outputEmptyBlocks);
            sec.setRDDHandleForVariable(this.output.getName(), out);
            sec.addLineageRDD(this.output.getName(), this.input1.getName());
        } else {
            if (iinfo == InputInfo.CSVInputInfo) {
                CSVReblockSPInstruction csvInstruction = null;
                boolean hasHeader = false;
                String delim = ",";
                boolean fill = false;
                double fillValue = 0.0;
                if (mo.getFileFormatProperties() instanceof CSVFileFormatProperties && mo.getFileFormatProperties() != null) {
                    CSVFileFormatProperties props = (CSVFileFormatProperties)mo.getFileFormatProperties();
                    hasHeader = props.hasHeader();
                    delim = props.getDelim();
                    fill = props.isFill();
                    fillValue = props.getFillValue();
                }
                csvInstruction = new CSVReblockSPInstruction(null, this.input1, this.output, mcOut.getRowsPerBlock(), mcOut.getColsPerBlock(), hasHeader, delim, fill, fillValue, "csvrblk", this.instString);
                csvInstruction.processInstruction(sec);
                return;
            }
            if (iinfo == InputInfo.BinaryCellInputInfo) {
                JavaPairRDD<?, ?> binaryCells = sec.getRDDHandleForVariable(this.input1.getName(), iinfo);
                JavaPairRDD<MatrixIndexes, MatrixBlock> out = RDDConverterUtils.binaryCellToBinaryBlock(sec.getSparkContext(), binaryCells, mcOut, this.outputEmptyBlocks);
                sec.setRDDHandleForVariable(this.output.getName(), out);
                sec.addLineageRDD(this.output.getName(), this.input1.getName());
            } else if (iinfo == InputInfo.BinaryBlockInputInfo) {
                JavaPairRDD<MatrixIndexes, MatrixBlock> in1 = sec.getBinaryBlockRDDHandleForVariable(this.input1.getName());
                JavaPairRDD<MatrixIndexes, MatrixBlock> out = in1.flatMapToPair((PairFlatMapFunction)new ExtractBlockForBinaryReblock(mc, mcOut));
                out = RDDAggregateUtils.mergeByKey(out, false);
                sec.setRDDHandleForVariable(this.output.getName(), out);
                sec.addLineageRDD(this.output.getName(), this.input1.getName());
            } else {
                throw new DMLRuntimeException("The given InputInfo is not implemented for ReblockSPInstruction:" + InputInfo.inputInfoToString(iinfo));
            }
        }
    }

    protected void processFrameReblockInstruction(SparkExecutionContext sec, InputInfo iinfo) throws DMLRuntimeException {
        FrameObject fo = sec.getFrameObject(this.input1.getName());
        MatrixCharacteristics mcOut = sec.getMatrixCharacteristics(this.output.getName());
        if (iinfo == InputInfo.TextCellInputInfo) {
            sec.checkAndRaiseValidationWarningJDKVersion();
            JavaPairRDD<?, ?> lines = sec.getRDDHandleForVariable(this.input1.getName(), iinfo);
            JavaPairRDD<Long, FrameBlock> out = FrameRDDConverterUtils.textCellToBinaryBlock(sec.getSparkContext(), lines, mcOut, fo.getSchema());
            sec.setRDDHandleForVariable(this.output.getName(), out);
            sec.addLineageRDD(this.output.getName(), this.input1.getName());
        } else if (iinfo == InputInfo.CSVInputInfo) {
            CSVReblockSPInstruction csvInstruction = null;
            boolean hasHeader = false;
            String delim = ",";
            boolean fill = false;
            double fillValue = 0.0;
            if (fo.getFileFormatProperties() instanceof CSVFileFormatProperties && fo.getFileFormatProperties() != null) {
                CSVFileFormatProperties props = (CSVFileFormatProperties)fo.getFileFormatProperties();
                hasHeader = props.hasHeader();
                delim = props.getDelim();
                fill = props.isFill();
                fillValue = props.getFillValue();
            }
            csvInstruction = new CSVReblockSPInstruction(null, this.input1, this.output, mcOut.getRowsPerBlock(), mcOut.getColsPerBlock(), hasHeader, delim, fill, fillValue, "csvrblk", this.instString);
            csvInstruction.processInstruction(sec);
        } else {
            throw new DMLRuntimeException("The given InputInfo is not implemented for ReblockSPInstruction: " + InputInfo.inputInfoToString(iinfo));
        }
    }
}

