/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.spark;

import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.function.Function;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.compress.CompressedMatrixBlock;
import org.apache.sysml.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysml.runtime.controlprogram.context.SparkExecutionContext;
import org.apache.sysml.runtime.instructions.InstructionUtils;
import org.apache.sysml.runtime.instructions.cp.CPOperand;
import org.apache.sysml.runtime.instructions.spark.SPInstruction;
import org.apache.sysml.runtime.instructions.spark.UnarySPInstruction;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.data.MatrixIndexes;
import org.apache.sysml.runtime.matrix.operators.Operator;

public class CompressionSPInstruction
extends UnarySPInstruction {
    public CompressionSPInstruction(Operator op, CPOperand in, CPOperand out, String opcode, String istr) {
        super(op, in, out, opcode, istr);
        this._sptype = SPInstruction.SPINSTRUCTION_TYPE.Reorg;
    }

    public static CompressionSPInstruction parseInstruction(String str) throws DMLRuntimeException {
        InstructionUtils.checkNumFields(str, 2);
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        String opcode = parts[0];
        CPOperand in = new CPOperand(parts[1]);
        CPOperand out = new CPOperand(parts[2]);
        return new CompressionSPInstruction(null, in, out, opcode, str);
    }

    @Override
    public void processInstruction(ExecutionContext ec) throws DMLRuntimeException {
        SparkExecutionContext sec = (SparkExecutionContext)ec;
        JavaPairRDD<MatrixIndexes, MatrixBlock> in = sec.getBinaryBlockRDDHandleForVariable(this.input1.getName());
        JavaPairRDD out = in.mapValues((Function)new CompressionFunction());
        sec.setRDDHandleForVariable(this.output.getName(), out);
        sec.addLineageRDD(this.input1.getName(), this.output.getName());
    }

    public static class CompressionFunction
    implements Function<MatrixBlock, MatrixBlock> {
        private static final long serialVersionUID = -6528833083609423922L;

        public MatrixBlock call(MatrixBlock arg0) throws Exception {
            CompressedMatrixBlock cmb = new CompressedMatrixBlock(arg0);
            cmb.compress();
            return cmb;
        }
    }
}

