/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.mr;

import java.util.ArrayList;
import org.apache.sysml.lops.AppendM;
import org.apache.sysml.lops.BinaryM;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.instructions.InstructionUtils;
import org.apache.sysml.runtime.instructions.mr.BinaryMRInstructionBase;
import org.apache.sysml.runtime.instructions.mr.IDistributedCacheConsumer;
import org.apache.sysml.runtime.instructions.mr.MRInstruction;
import org.apache.sysml.runtime.matrix.data.MatrixValue;
import org.apache.sysml.runtime.matrix.data.OperationsOnMatrixValues;
import org.apache.sysml.runtime.matrix.mapred.CachedValueMap;
import org.apache.sysml.runtime.matrix.mapred.DistributedCacheInput;
import org.apache.sysml.runtime.matrix.mapred.IndexedMatrixValue;
import org.apache.sysml.runtime.matrix.mapred.MRBaseForCommonInstructions;
import org.apache.sysml.runtime.matrix.operators.BinaryOperator;
import org.apache.sysml.runtime.matrix.operators.Operator;

public class BinaryMInstruction
extends BinaryMRInstructionBase
implements IDistributedCacheConsumer {
    private BinaryM.VectorType _vectorType = null;

    public BinaryMInstruction(Operator op, byte in1, byte in2, AppendM.CacheType ctype, BinaryM.VectorType vtype, byte out, String istr) {
        super(op, in1, in2, out);
        this.mrtype = MRInstruction.MRINSTRUCTION_TYPE.ArithmeticBinary;
        this.instString = istr;
        this._vectorType = vtype;
    }

    public static BinaryMInstruction parseInstruction(String str) throws DMLRuntimeException {
        InstructionUtils.checkNumFields(str, 5);
        String[] parts = InstructionUtils.getInstructionParts(str);
        String opcode = parts[0];
        byte in1 = Byte.parseByte(parts[1]);
        byte in2 = Byte.parseByte(parts[2]);
        byte out = Byte.parseByte(parts[3]);
        AppendM.CacheType ctype = AppendM.CacheType.valueOf(parts[4]);
        BinaryM.VectorType vtype = BinaryM.VectorType.valueOf(parts[5]);
        BinaryOperator bop = InstructionUtils.parseExtendedBinaryOperator(opcode);
        return new BinaryMInstruction(bop, in1, in2, ctype, vtype, out, str);
    }

    @Override
    public void processInstruction(Class<? extends MatrixValue> valueClass, CachedValueMap cachedValues, IndexedMatrixValue tempValue, IndexedMatrixValue zeroInput, int blockRowFactor, int blockColFactor) throws DMLRuntimeException {
        ArrayList<IndexedMatrixValue> blkList = cachedValues.get(this.input1);
        if (blkList == null) {
            return;
        }
        for (IndexedMatrixValue in1 : blkList) {
            IndexedMatrixValue out = this.output != this.input1 && this.output != this.input2 ? cachedValues.holdPlace(this.output, valueClass) : tempValue;
            DistributedCacheInput dcInput = MRBaseForCommonInstructions.dcValues.get(this.input2);
            IndexedMatrixValue in2 = null;
            in2 = this._vectorType == BinaryM.VectorType.COL_VECTOR ? dcInput.getDataBlock((int)in1.getIndexes().getRowIndex(), 1) : dcInput.getDataBlock(1, (int)in1.getIndexes().getColumnIndex());
            out.getIndexes().setIndexes(in1.getIndexes());
            OperationsOnMatrixValues.performBinaryIgnoreIndexes(in1.getValue(), in2.getValue(), out.getValue(), (BinaryOperator)this.optr);
            if (out != tempValue) continue;
            cachedValues.add(this.output, out);
        }
    }

    @Override
    public boolean isDistCacheOnlyIndex(String inst, byte index) {
        return index == this.input2 && index != this.input1;
    }

    @Override
    public void addDistCacheIndex(String inst, ArrayList<Byte> indexes) {
        indexes.add(this.input2);
    }
}

