/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.mr;

import java.util.ArrayList;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.instructions.InstructionUtils;
import org.apache.sysml.runtime.instructions.mr.AppendInstruction;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.data.MatrixIndexes;
import org.apache.sysml.runtime.matrix.data.MatrixValue;
import org.apache.sysml.runtime.matrix.mapred.CachedValueMap;
import org.apache.sysml.runtime.matrix.mapred.IndexedMatrixValue;
import org.apache.sysml.runtime.matrix.operators.Operator;

public class AppendGInstruction
extends AppendInstruction {
    private long _offset = -1L;
    private long _offset2 = -1L;
    private long _len = -1L;

    public AppendGInstruction(Operator op, byte in1, byte in2, long offset, long offset2, byte out, boolean cbind, String istr) {
        super(op, in1, in2, out, cbind, istr);
        this._offset = offset;
        this._offset2 = offset2;
        this._len = this._offset + this._offset2;
    }

    public static AppendGInstruction parseInstruction(String str) throws DMLRuntimeException {
        String[] parts = InstructionUtils.getInstructionParts(str);
        InstructionUtils.checkNumFields(parts, 6);
        byte in1 = Byte.parseByte(parts[1]);
        byte in2 = Byte.parseByte(parts[2]);
        long offset = (long)Double.parseDouble(parts[3]);
        long len = (long)Double.parseDouble(parts[4]);
        byte out = Byte.parseByte(parts[5]);
        boolean cbind = Boolean.parseBoolean(parts[6]);
        return new AppendGInstruction(null, in1, in2, offset, len, out, cbind, str);
    }

    @Override
    public void processInstruction(Class<? extends MatrixValue> valueClass, CachedValueMap cachedValues, IndexedMatrixValue tempValue, IndexedMatrixValue zeroInput, int brlen, int bclen) throws DMLRuntimeException {
        ArrayList<IndexedMatrixValue> blkList2;
        int blen = this._cbind ? bclen : brlen;
        ArrayList<IndexedMatrixValue> blkList1 = cachedValues.get(this.input1);
        if (blkList1 != null) {
            for (IndexedMatrixValue in1 : blkList1) {
                if (in1 == null) continue;
                if (this._offset % (long)blen == 0L) {
                    cachedValues.add(this.output, in1);
                    continue;
                }
                MatrixIndexes tmpix = in1.getIndexes();
                MatrixBlock tmpval = (MatrixBlock)in1.getValue();
                if (this._cbind && this._offset / (long)blen + 1L == tmpix.getColumnIndex() || !this._cbind && this._offset / (long)blen + 1L == tmpix.getRowIndex()) {
                    IndexedMatrixValue data = cachedValues.holdPlace(this.output, valueClass);
                    MatrixBlock tmpvalNew = (MatrixBlock)data.getValue();
                    int lrlen = this._cbind ? tmpval.getNumRows() : Math.min(blen, (int)(this._len - (tmpix.getRowIndex() - 1L) * (long)blen));
                    int lclen = this._cbind ? Math.min(blen, (int)(this._len - (tmpix.getColumnIndex() - 1L) * (long)blen)) : tmpval.getNumColumns();
                    tmpvalNew.reset(lrlen, lclen);
                    tmpvalNew.copy(0, tmpval.getNumRows() - 1, 0, tmpval.getNumColumns() - 1, tmpval, true);
                    data.getIndexes().setIndexes(tmpix);
                    continue;
                }
                cachedValues.add(this.output, in1);
            }
        }
        if ((blkList2 = cachedValues.get(this.input2)) != null) {
            for (IndexedMatrixValue in2 : blkList2) {
                MatrixBlock tmpvalNew2;
                MatrixIndexes ix2;
                IndexedMatrixValue data2;
                MatrixIndexes ix1;
                if (in2 == null) continue;
                MatrixIndexes tmpix = in2.getIndexes();
                MatrixBlock tmpval = (MatrixBlock)in2.getValue();
                if (this._offset % (long)bclen == 0L) {
                    IndexedMatrixValue data = cachedValues.holdPlace(this.output, valueClass);
                    ix1 = data.getIndexes();
                    long rix = this._cbind ? tmpix.getRowIndex() : this._offset / (long)blen + tmpix.getRowIndex();
                    long cix = this._cbind ? this._offset / (long)blen + tmpix.getColumnIndex() : tmpix.getColumnIndex();
                    ix1.setIndexes(rix, cix);
                    data.set(ix1, in2.getValue());
                    continue;
                }
                IndexedMatrixValue data1 = cachedValues.holdPlace(this.output, valueClass);
                ix1 = data1.getIndexes();
                MatrixBlock tmpvalNew = (MatrixBlock)data1.getValue();
                if (this._cbind) {
                    int cix1 = (int)(this._offset / (long)blen + tmpix.getColumnIndex());
                    int cols1 = Math.min(blen, (int)(this._len - (long)(cix1 - 1) * (long)blen));
                    ix1.setIndexes(tmpix.getRowIndex(), cix1);
                    tmpvalNew.reset(tmpval.getNumRows(), cols1);
                    tmpvalNew.copy(0, tmpval.getNumRows() - 1, (int)((this._offset + 1L) % (long)blen) - 1, cols1 - 1, tmpval.sliceOperations(0, tmpval.getNumRows() - 1, 0, (int)((long)cols1 - this._offset % (long)blen - 1L), new MatrixBlock()), true);
                    data1.getIndexes().setIndexes(ix1);
                    if ((long)cols1 - this._offset % (long)blen >= (long)tmpval.getNumColumns()) continue;
                    data2 = cachedValues.holdPlace(this.output, valueClass);
                    ix2 = data2.getIndexes();
                    tmpvalNew2 = (MatrixBlock)data2.getValue();
                    int cix2 = (int)(this._offset / (long)blen + 1L + tmpix.getColumnIndex());
                    int cols2 = Math.min(blen, (int)(this._len - (long)(cix2 - 1) * (long)blen));
                    ix2.setIndexes(tmpix.getRowIndex(), cix2);
                    tmpvalNew2.reset(tmpval.getNumRows(), cols2);
                    tmpvalNew2.copy(0, tmpval.getNumRows() - 1, 0, cols2 - 1, tmpval.sliceOperations(0, tmpval.getNumRows() - 1, (int)((long)cols1 - this._offset % (long)blen), tmpval.getNumColumns() - 1, new MatrixBlock()), true);
                    data2.getIndexes().setIndexes(ix2);
                    continue;
                }
                int rix1 = (int)(this._offset / (long)blen + tmpix.getRowIndex());
                int rows1 = Math.min(blen, (int)(this._len - (long)(rix1 - 1) * (long)blen));
                ix1.setIndexes(rix1, tmpix.getColumnIndex());
                tmpvalNew.reset(rows1, tmpval.getNumColumns());
                tmpvalNew.copy((int)((this._offset + 1L) % (long)blen) - 1, rows1 - 1, 0, tmpval.getNumColumns() - 1, tmpval.sliceOperations(0, (int)((long)rows1 - this._offset % (long)blen - 1L), 0, tmpval.getNumColumns() - 1, new MatrixBlock()), true);
                data1.getIndexes().setIndexes(ix1);
                if ((long)rows1 - this._offset % (long)blen >= (long)tmpval.getNumRows()) continue;
                data2 = cachedValues.holdPlace(this.output, valueClass);
                ix2 = data2.getIndexes();
                tmpvalNew2 = (MatrixBlock)data2.getValue();
                int rix2 = (int)(this._offset / (long)blen + 1L + tmpix.getRowIndex());
                int rows2 = Math.min(blen, (int)(this._len - (long)(rix2 - 1) * (long)blen));
                ix2.setIndexes(rix2, tmpix.getColumnIndex());
                tmpvalNew2.reset(rows2, tmpval.getNumColumns());
                tmpvalNew2.copy(0, rows2 - 1, 0, tmpval.getNumColumns() - 1, tmpval.sliceOperations((int)((long)rows1 - this._offset % (long)blen), tmpval.getNumRows() - 1, 0, tmpval.getNumColumns() - 1, new MatrixBlock()), true);
                data2.getIndexes().setIndexes(ix2);
            }
        }
    }
}

