/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.cp;

import org.apache.sysml.parser.Expression;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysml.runtime.instructions.cp.ArithmeticBinaryCPInstruction;
import org.apache.sysml.runtime.instructions.cp.CPOperand;
import org.apache.sysml.runtime.instructions.cp.DoubleObject;
import org.apache.sysml.runtime.instructions.cp.IntObject;
import org.apache.sysml.runtime.instructions.cp.ScalarObject;
import org.apache.sysml.runtime.instructions.cp.StringObject;
import org.apache.sysml.runtime.matrix.operators.BinaryOperator;
import org.apache.sysml.runtime.matrix.operators.Operator;

public class ScalarScalarArithmeticCPInstruction
extends ArithmeticBinaryCPInstruction {
    public ScalarScalarArithmeticCPInstruction(Operator op, CPOperand in1, CPOperand in2, CPOperand out, String opcode, String istr) {
        super(op, in1, in2, out, opcode, istr);
    }

    @Override
    public void processInstruction(ExecutionContext ec) throws DMLRuntimeException {
        ScalarObject so1 = ec.getScalarInput(this.input1.getName(), this.input1.getValueType(), this.input1.isLiteral());
        ScalarObject so2 = ec.getScalarInput(this.input2.getName(), this.input2.getValueType(), this.input2.isLiteral());
        BinaryOperator dop = (BinaryOperator)this._optr;
        ScalarObject sores = null;
        if (so1 instanceof StringObject || so2 instanceof StringObject) {
            if (!this.getOpcode().equals("+")) {
                throw new DMLRuntimeException("Arithmetic '" + this.getOpcode() + "' not supported over string inputs.");
            }
            sores = new StringObject(dop.fn.execute(so1.getLanguageSpecificStringValue(), so2.getLanguageSpecificStringValue()));
        } else if (so1 instanceof DoubleObject || so2 instanceof DoubleObject || this.output.getValueType() == Expression.ValueType.DOUBLE) {
            sores = new DoubleObject(dop.fn.execute(so1.getDoubleValue(), so2.getDoubleValue()));
        } else if (so1 instanceof IntObject || so2 instanceof IntObject) {
            double tmp = dop.fn.execute(so1.getLongValue(), so2.getLongValue());
            if (tmp > 9.223372036854776E18) {
                throw new DMLRuntimeException("Integer operation created numerical result overflow (" + tmp + " > " + Long.MAX_VALUE + ").");
            }
            sores = new IntObject((long)tmp);
        } else {
            sores = new DoubleObject(dop.fn.execute(so1.getDoubleValue(), so2.getDoubleValue()));
        }
        ec.setScalarOutput(this.output.getName(), sores);
    }
}

