/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.cp;

import java.util.ArrayList;
import org.apache.sysml.api.DMLScript;
import org.apache.sysml.lops.MultipleCP;
import org.apache.sysml.parser.Expression;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysml.runtime.instructions.cp.BuiltinMultipleCPInstruction;
import org.apache.sysml.runtime.instructions.cp.CPOperand;
import org.apache.sysml.runtime.instructions.cp.ScalarObject;
import org.apache.sysml.runtime.instructions.cp.StringObject;
import org.apache.sysml.runtime.matrix.operators.Operator;

public class ScalarBuiltinMultipleCPInstruction
extends BuiltinMultipleCPInstruction {
    public ScalarBuiltinMultipleCPInstruction(Operator op, String opcode, String istr, CPOperand output, CPOperand ... inputs) {
        super(op, opcode, istr, output, inputs);
    }

    @Override
    public void processInstruction(ExecutionContext ec) throws DMLRuntimeException {
        String result;
        if (MultipleCP.OperationType.PRINTF.toString().equalsIgnoreCase(this.getOpcode())) {
            ArrayList<ScalarObject> scalarObjects = new ArrayList<ScalarObject>();
            for (CPOperand input : this.inputs) {
                ScalarObject so = ec.getScalarInput(input.getName(), input.getValueType(), input.isLiteral());
                scalarObjects.add(so);
            }
            ScalarObject formatStringObject = (ScalarObject)scalarObjects.get(0);
            if (formatStringObject.getValueType() != Expression.ValueType.STRING) {
                throw new DMLRuntimeException("First parameter needs to be a string");
            }
            String formatString = formatStringObject.getStringValue();
            Object[] objects = null;
            if (scalarObjects.size() > 1) {
                objects = new Object[scalarObjects.size() - 1];
                block7: for (int i = 1; i < scalarObjects.size(); ++i) {
                    ScalarObject scalarObject = (ScalarObject)scalarObjects.get(i);
                    switch (scalarObject.getValueType()) {
                        case INT: {
                            objects[i - 1] = scalarObject.getLongValue();
                            continue block7;
                        }
                        case DOUBLE: {
                            objects[i - 1] = scalarObject.getDoubleValue();
                            continue block7;
                        }
                        case BOOLEAN: {
                            objects[i - 1] = scalarObject.getBooleanValue();
                            continue block7;
                        }
                        case STRING: {
                            objects[i - 1] = scalarObject.getStringValue();
                            continue block7;
                        }
                    }
                }
            }
            result = String.format(formatString, objects);
            if (!DMLScript.suppressPrint2Stdout()) {
                System.out.println(result);
            }
        } else {
            throw new DMLRuntimeException("Opcode (" + this.getOpcode() + ") not recognized in ScalarBuiltinMultipleCPInstruction");
        }
        ec.setScalarOutput(this.output.getName(), new StringObject(result));
    }
}

