/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.cp;

import java.util.ArrayList;
import org.apache.sysml.parser.Expression;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysml.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysml.runtime.instructions.InstructionUtils;
import org.apache.sysml.runtime.instructions.cp.CPInstruction;
import org.apache.sysml.runtime.instructions.cp.CPOperand;
import org.apache.sysml.runtime.instructions.cp.ComputationCPInstruction;
import org.apache.sysml.runtime.matrix.data.LibCommonsMath;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.operators.Operator;

public class MultiReturnBuiltinCPInstruction
extends ComputationCPInstruction {
    int arity;
    protected ArrayList<CPOperand> _outputs;

    public MultiReturnBuiltinCPInstruction(Operator op, CPOperand input1, ArrayList<CPOperand> outputs, String opcode, String istr) {
        super(op, input1, null, outputs.get(0), opcode, istr);
        this._cptype = CPInstruction.CPINSTRUCTION_TYPE.MultiReturnBuiltin;
        this._outputs = outputs;
    }

    public int getArity() {
        return this.arity;
    }

    public CPOperand getOutput(int i) {
        return this._outputs.get(i);
    }

    public static MultiReturnBuiltinCPInstruction parseInstruction(String str) throws DMLRuntimeException {
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        ArrayList<CPOperand> outputs = new ArrayList<CPOperand>();
        String opcode = parts[0];
        if (opcode.equalsIgnoreCase("qr")) {
            CPOperand in1 = new CPOperand(parts[1]);
            outputs.add(new CPOperand(parts[2], Expression.ValueType.DOUBLE, Expression.DataType.MATRIX));
            outputs.add(new CPOperand(parts[3], Expression.ValueType.DOUBLE, Expression.DataType.MATRIX));
            return new MultiReturnBuiltinCPInstruction(null, in1, outputs, opcode, str);
        }
        if (opcode.equalsIgnoreCase("lu")) {
            CPOperand in1 = new CPOperand(parts[1]);
            outputs.add(new CPOperand(parts[2], Expression.ValueType.DOUBLE, Expression.DataType.MATRIX));
            outputs.add(new CPOperand(parts[3], Expression.ValueType.DOUBLE, Expression.DataType.MATRIX));
            outputs.add(new CPOperand(parts[4], Expression.ValueType.DOUBLE, Expression.DataType.MATRIX));
            return new MultiReturnBuiltinCPInstruction(null, in1, outputs, opcode, str);
        }
        if (opcode.equalsIgnoreCase("eigen")) {
            CPOperand in1 = new CPOperand(parts[1]);
            outputs.add(new CPOperand(parts[2], Expression.ValueType.DOUBLE, Expression.DataType.MATRIX));
            outputs.add(new CPOperand(parts[3], Expression.ValueType.DOUBLE, Expression.DataType.MATRIX));
            return new MultiReturnBuiltinCPInstruction(null, in1, outputs, opcode, str);
        }
        throw new DMLRuntimeException("Invalid opcode in MultiReturnBuiltin instruction: " + opcode);
    }

    @Override
    public void processInstruction(ExecutionContext ec) throws DMLRuntimeException {
        String opcode = this.getOpcode();
        MatrixObject mo = ec.getMatrixObject(this.input1.getName());
        MatrixBlock[] out = null;
        if (!LibCommonsMath.isSupportedMultiReturnOperation(opcode)) {
            throw new DMLRuntimeException("Invalid opcode in MultiReturnBuiltin instruction: " + opcode);
        }
        out = LibCommonsMath.multiReturnOperations(mo, opcode);
        for (int i = 0; i < this._outputs.size(); ++i) {
            ec.setMatrixOutput(this._outputs.get(i).getName(), out[i]);
        }
    }
}

