/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.cp;

import java.io.IOException;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysml.runtime.functionobjects.RemoveFile;
import org.apache.sysml.runtime.functionobjects.RenameFile;
import org.apache.sysml.runtime.instructions.InstructionUtils;
import org.apache.sysml.runtime.instructions.cp.CPInstruction;
import org.apache.sysml.runtime.matrix.operators.Operator;
import org.apache.sysml.runtime.matrix.operators.SimpleOperator;
import org.apache.sysml.runtime.util.MapReduceTool;

public class FileCPInstruction
extends CPInstruction {
    private FileOperationCode _code;
    private String _input1;
    private String _input2;

    public FileCPInstruction(Operator op, FileOperationCode code, String in1, String in2, int arity, String opcode, String istr) {
        super(op, opcode, istr);
        this._cptype = CPInstruction.CPINSTRUCTION_TYPE.File;
        this._code = code;
        this._input1 = in1;
        this._input2 = in2;
    }

    private static FileOperationCode getFileOperationCode(String str) throws DMLRuntimeException {
        if (str.equalsIgnoreCase("rm")) {
            return FileOperationCode.RemoveFile;
        }
        if (str.equalsIgnoreCase("mv")) {
            return FileOperationCode.MoveFile;
        }
        throw new DMLRuntimeException("Invalid function: " + str);
    }

    public static FileCPInstruction parseInstruction(String str) throws DMLRuntimeException {
        String opcode = InstructionUtils.getOpCode(str);
        int _arity = 2;
        if (opcode.equalsIgnoreCase("rm")) {
            _arity = 1;
        }
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        InstructionUtils.checkNumFields(parts, _arity);
        opcode = parts[0];
        FileOperationCode focode = FileCPInstruction.getFileOperationCode(opcode);
        String in1 = parts[1];
        String in2 = null;
        if (_arity == 2) {
            in2 = parts[2];
        }
        if (opcode.equalsIgnoreCase("rm")) {
            return new FileCPInstruction(new SimpleOperator(RemoveFile.getRemoveFileFnObject()), focode, in1, in2, _arity, opcode, str);
        }
        if (opcode.equalsIgnoreCase("mv")) {
            return new FileCPInstruction(new SimpleOperator(RenameFile.getRenameFileFnObject()), focode, in1, in2, _arity, opcode, str);
        }
        return null;
    }

    @Override
    public void processInstruction(ExecutionContext ec) throws DMLRuntimeException {
        try {
            switch (this._code) {
                case RemoveFile: {
                    MapReduceTool.deleteFileIfExistOnHDFS(this._input1);
                    MapReduceTool.deleteFileIfExistOnHDFS(this._input1 + ".mtd");
                    break;
                }
                case MoveFile: {
                    MapReduceTool.renameFileOnHDFS(this._input1, this._input2);
                    MapReduceTool.renameFileOnHDFS(this._input1 + ".mtd", this._input2 + ".mtd");
                    break;
                }
                default: {
                    throw new DMLRuntimeException("Unexpected opcode: " + (Object)((Object)this._code));
                }
            }
        }
        catch (IOException e) {
            throw new DMLRuntimeException(e);
        }
    }

    private static enum FileOperationCode {
        RemoveFile,
        MoveFile;

    }
}

