/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.cp;

import org.apache.sysml.hops.DataGenOp;
import org.apache.sysml.hops.Hop;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysml.runtime.instructions.InstructionUtils;
import org.apache.sysml.runtime.instructions.cp.CPOperand;
import org.apache.sysml.runtime.instructions.cp.UnaryCPInstruction;
import org.apache.sysml.runtime.matrix.data.LibMatrixDatagen;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.data.RandomMatrixGenerator;
import org.apache.sysml.runtime.matrix.operators.Operator;
import org.apache.sysml.runtime.util.UtilFunctions;

public class DataGenCPInstruction
extends UnaryCPInstruction {
    private Hop.DataGenMethod method = Hop.DataGenMethod.INVALID;
    private long rows;
    private long cols;
    private int rowsInBlock;
    private int colsInBlock;
    private double minValue;
    private double maxValue;
    private double sparsity;
    private String pdf;
    private String pdfParams;
    private long seed = 0L;
    private double seq_from;
    private double seq_to;
    private double seq_incr;
    private boolean replace;
    private int numThreads = -1;

    public DataGenCPInstruction(Operator op, Hop.DataGenMethod mthd, CPOperand in, CPOperand out, long rows, long cols, int rpb, int cpb, double minValue, double maxValue, double sparsity, long seed, String probabilityDensityFunction, String pdfParams, int k, String opcode, String istr) {
        super(op, in, out, opcode, istr);
        this.method = mthd;
        this.rows = rows;
        this.cols = cols;
        this.rowsInBlock = rpb;
        this.colsInBlock = cpb;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.sparsity = sparsity;
        this.seed = seed;
        this.pdf = probabilityDensityFunction;
        this.numThreads = k;
        this.pdfParams = pdfParams;
    }

    public DataGenCPInstruction(Operator op, Hop.DataGenMethod mthd, CPOperand in, CPOperand out, long rows, long cols, int rpb, int cpb, double maxValue, boolean replace, long seed, String opcode, String istr) {
        super(op, in, out, opcode, istr);
        this.method = mthd;
        this.rows = rows;
        this.cols = cols;
        this.rowsInBlock = rpb;
        this.colsInBlock = cpb;
        this.maxValue = maxValue;
        this.replace = replace;
        this.seed = seed;
    }

    public DataGenCPInstruction(Operator op, Hop.DataGenMethod mthd, CPOperand in, CPOperand out, long rows, long cols, int rpb, int cpb, double seqFrom, double seqTo, double seqIncr, String opcode, String istr) {
        super(op, in, out, opcode, istr);
        this.method = mthd;
        this.rows = rows;
        this.cols = cols;
        this.rowsInBlock = rpb;
        this.colsInBlock = cpb;
        this.seq_from = seqFrom;
        this.seq_to = seqTo;
        this.seq_incr = seqIncr;
    }

    public long getRows() {
        return this.rows;
    }

    public void setRows(long rows) {
        this.rows = rows;
    }

    public long getCols() {
        return this.cols;
    }

    public void setCols(long cols) {
        this.cols = cols;
    }

    public int getRowsInBlock() {
        return this.rowsInBlock;
    }

    public void setRowsInBlock(int rowsInBlock) {
        this.rowsInBlock = rowsInBlock;
    }

    public int getColsInBlock() {
        return this.colsInBlock;
    }

    public void setColsInBlock(int colsInBlock) {
        this.colsInBlock = colsInBlock;
    }

    public double getMinValue() {
        return this.minValue;
    }

    public void setMinValue(double minValue) {
        this.minValue = minValue;
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(double maxValue) {
        this.maxValue = maxValue;
    }

    public double getSparsity() {
        return this.sparsity;
    }

    public void setSparsity(double sparsity) {
        this.sparsity = sparsity;
    }

    public static DataGenCPInstruction parseInstruction(String str) throws DMLRuntimeException {
        Hop.DataGenMethod method = Hop.DataGenMethod.INVALID;
        String[] s = InstructionUtils.getInstructionPartsWithValueType(str);
        String opcode = s[0];
        if (opcode.equalsIgnoreCase("rand")) {
            method = Hop.DataGenMethod.RAND;
            InstructionUtils.checkNumFields(s, 12);
        } else if (opcode.equalsIgnoreCase("seq")) {
            method = Hop.DataGenMethod.SEQ;
            InstructionUtils.checkNumFields(s, 8);
        } else if (opcode.equalsIgnoreCase("sample")) {
            method = Hop.DataGenMethod.SAMPLE;
            InstructionUtils.checkNumFields(s, 7);
        }
        CPOperand out = new CPOperand(s[s.length - 1]);
        Operator op = null;
        if (method == Hop.DataGenMethod.RAND) {
            long rows = -1L;
            long cols = -1L;
            if (!s[1].contains("\u00b6")) {
                rows = Double.valueOf(s[1]).longValue();
            }
            if (!s[2].contains("\u00b6")) {
                cols = Double.valueOf(s[2]).longValue();
            }
            int rpb = Integer.parseInt(s[3]);
            int cpb = Integer.parseInt(s[4]);
            double minValue = -1.0;
            double maxValue = -1.0;
            if (!s[5].contains("\u00b6")) {
                minValue = Double.valueOf(s[5]);
            }
            if (!s[6].contains("\u00b6")) {
                maxValue = Double.valueOf(s[6]);
            }
            double sparsity = -1.0;
            if (!s[7].contains("\u00b6")) {
                sparsity = Double.valueOf(s[7]);
            }
            long seed = -1L;
            if (!s[8].contains("\u00b6")) {
                seed = Long.parseLong(s[8]);
            }
            String pdf = s[9];
            String pdfParams = null;
            if (!s[10].contains("\u00b6")) {
                pdfParams = s[10];
            }
            int k = Integer.parseInt(s[11]);
            return new DataGenCPInstruction(op, method, null, out, rows, cols, rpb, cpb, minValue, maxValue, sparsity, seed, pdf, pdfParams, k, opcode, str);
        }
        if (method == Hop.DataGenMethod.SEQ) {
            long rows = Double.valueOf(s[1]).longValue();
            long cols = Double.valueOf(s[2]).longValue();
            int rpb = Integer.parseInt(s[3]);
            int cpb = Integer.parseInt(s[4]);
            double incr = Double.NaN;
            double to = Double.NaN;
            double from = Double.NaN;
            if (!s[5].contains("\u00b6")) {
                from = Double.valueOf(s[5]);
            }
            if (!s[6].contains("\u00b6")) {
                to = Double.valueOf(s[6]);
            }
            if (!s[7].contains("\u00b6")) {
                incr = Double.valueOf(s[7]);
            }
            return new DataGenCPInstruction(op, method, null, out, rows, cols, rpb, cpb, from, to, incr, opcode, str);
        }
        if (method == Hop.DataGenMethod.SAMPLE) {
            double max = 0.0;
            long rows = 0L;
            boolean replace = false;
            if (!s[1].contains("\u00b6")) {
                max = Double.valueOf(s[1]);
            }
            if (!s[2].contains("\u00b6")) {
                rows = Double.valueOf(s[2]).longValue();
            }
            long cols = 1L;
            if (!s[3].contains("\u00b6")) {
                replace = Boolean.valueOf(s[3]);
            }
            long seed = Long.parseLong(s[4]);
            int rpb = Integer.parseInt(s[5]);
            int cpb = Integer.parseInt(s[6]);
            return new DataGenCPInstruction(op, method, null, out, rows, cols, rpb, cpb, max, replace, seed, opcode, str);
        }
        throw new DMLRuntimeException("Unrecognized data generation method: " + (Object)((Object)method));
    }

    @Override
    public void processInstruction(ExecutionContext ec) throws DMLRuntimeException {
        MatrixBlock soresBlock = null;
        if (this.rows > Integer.MAX_VALUE || this.cols > Integer.MAX_VALUE) {
            throw new DMLRuntimeException("RandCPInstruction does not support dimensions larger than integer: rows=" + this.rows + ", cols=" + this.cols + ".");
        }
        if (this.method == Hop.DataGenMethod.RAND) {
            long lSeed = this.seed;
            if (lSeed == -1L) {
                lSeed = DataGenOp.generateRandomSeed();
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Process DataGenCPInstruction rand with seed = " + lSeed + "."));
            }
            RandomMatrixGenerator rgen = LibMatrixDatagen.createRandomMatrixGenerator(this.pdf, (int)this.rows, (int)this.cols, this.rowsInBlock, this.colsInBlock, this.sparsity, this.minValue, this.maxValue, this.pdfParams);
            soresBlock = MatrixBlock.randOperations(rgen, this.seed, this.numThreads);
        } else if (this.method == Hop.DataGenMethod.SEQ) {
            this.seq_incr = LibMatrixDatagen.updateSeqIncr(this.seq_from, this.seq_to, this.seq_incr);
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Process DataGenCPInstruction seq with seqFrom=" + this.seq_from + ", seqTo=" + this.seq_to + ", seqIncr" + this.seq_incr));
            }
            soresBlock = MatrixBlock.seqOperations(this.seq_from, this.seq_to, this.seq_incr);
        } else if (this.method == Hop.DataGenMethod.SAMPLE) {
            long range = UtilFunctions.toLong(this.maxValue);
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Process DataGenCPInstruction sample with range=" + range + ", size=" + this.rows + ", replace" + this.replace + ", seed=" + this.seed));
            }
            if (range < this.rows && !this.replace) {
                throw new DMLRuntimeException("Sample (size=" + this.rows + ") larger than population (size=" + range + ") can only be generated with replacement.");
            }
            soresBlock = MatrixBlock.sampleOperations(range, (int)this.rows, this.replace, this.seed);
        }
        ec.setMatrixOutput(this.output.getName(), soresBlock);
    }
}

