/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.cp;

import org.apache.sysml.parser.Expression;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.functionobjects.OffsetColumnIndex;
import org.apache.sysml.runtime.instructions.InstructionUtils;
import org.apache.sysml.runtime.instructions.cp.BinaryCPInstruction;
import org.apache.sysml.runtime.instructions.cp.CPInstruction;
import org.apache.sysml.runtime.instructions.cp.CPOperand;
import org.apache.sysml.runtime.instructions.cp.FrameAppendCPInstruction;
import org.apache.sysml.runtime.instructions.cp.MatrixAppendCPInstruction;
import org.apache.sysml.runtime.instructions.cp.ScalarAppendCPInstruction;
import org.apache.sysml.runtime.matrix.operators.Operator;
import org.apache.sysml.runtime.matrix.operators.ReorgOperator;

public abstract class AppendCPInstruction
extends BinaryCPInstruction {
    protected AppendType _type;

    public AppendCPInstruction(Operator op, CPOperand in1, CPOperand in2, CPOperand in3, CPOperand out, AppendType type, String opcode, String istr) {
        super(op, in1, in2, out, opcode, istr);
        this._cptype = CPInstruction.CPINSTRUCTION_TYPE.Append;
        this._type = type;
    }

    public static AppendCPInstruction parseInstruction(String str) throws DMLRuntimeException {
        AppendType type;
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        InstructionUtils.checkNumFields(parts, 5);
        String opcode = parts[0];
        CPOperand in1 = new CPOperand(parts[1]);
        CPOperand in2 = new CPOperand(parts[2]);
        CPOperand in3 = new CPOperand(parts[3]);
        CPOperand out = new CPOperand(parts[4]);
        boolean cbind = Boolean.parseBoolean(parts[5]);
        AppendType appendType = in1.getDataType() != Expression.DataType.MATRIX && in1.getDataType() != Expression.DataType.FRAME ? AppendType.STRING : (type = cbind ? AppendType.CBIND : AppendType.RBIND);
        if (!opcode.equalsIgnoreCase("append")) {
            throw new DMLRuntimeException("Unknown opcode while parsing a AppendCPInstruction: " + str);
        }
        ReorgOperator op = new ReorgOperator(OffsetColumnIndex.getOffsetColumnIndexFnObject(-1));
        if (type == AppendType.STRING) {
            return new ScalarAppendCPInstruction(op, in1, in2, in3, out, type, opcode, str);
        }
        if (in1.getDataType() == Expression.DataType.MATRIX) {
            return new MatrixAppendCPInstruction(op, in1, in2, in3, out, type, opcode, str);
        }
        return new FrameAppendCPInstruction(op, in1, in2, in3, out, type, opcode, str);
    }

    public static enum AppendType {
        CBIND,
        RBIND,
        STRING;

    }
}

