/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.controlprogram.parfor;

import java.io.Closeable;
import java.io.File;
import java.util.Iterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.spark.api.java.function.VoidFunction;
import org.apache.sysml.conf.ConfigurationManager;
import org.apache.sysml.runtime.controlprogram.parfor.util.PairWritableBlock;
import org.apache.sysml.runtime.io.IOUtilFunctions;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.data.MatrixIndexes;
import org.apache.sysml.runtime.matrix.data.OutputInfo;
import scala.Tuple2;

public class DataPartitionerRemoteSparkReducer
implements VoidFunction<Tuple2<Long, Iterable<Writable>>> {
    private static final long serialVersionUID = -7149865018683261964L;
    private final String _fnameNew;
    private final int _replication;

    public DataPartitionerRemoteSparkReducer(String fnameNew, OutputInfo oi, int replication) {
        this._fnameNew = fnameNew;
        this._replication = replication;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void call(Tuple2<Long, Iterable<Writable>> arg0) throws Exception {
        Long key = (Long)arg0._1();
        Iterator valueList = ((Iterable)arg0._2()).iterator();
        SequenceFile.Writer writer = null;
        try {
            Configuration job = new Configuration((Configuration)ConfigurationManager.getCachedJobConf());
            FileSystem fs = FileSystem.get((Configuration)job);
            Path path = new Path(this._fnameNew + File.separator + key);
            writer = new SequenceFile.Writer(fs, job, path, MatrixIndexes.class, MatrixBlock.class, job.getInt("io.file.buffer.size", 4096), (short)this._replication, fs.getDefaultBlockSize(), null, new SequenceFile.Metadata());
            while (valueList.hasNext()) {
                PairWritableBlock pair = (PairWritableBlock)valueList.next();
                writer.append((Writable)pair.indexes, (Writable)pair.block);
            }
        }
        catch (Throwable throwable) {
            IOUtilFunctions.closeSilently(writer);
            throw throwable;
        }
        IOUtilFunctions.closeSilently((Closeable)writer);
    }
}

