/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.compress;

import java.util.Arrays;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.compress.BitmapDecoderRLE;
import org.apache.sysml.runtime.compress.BitmapEncoder;
import org.apache.sysml.runtime.compress.ColGroup;
import org.apache.sysml.runtime.compress.ColGroupOffset;
import org.apache.sysml.runtime.compress.UncompressedBitmap;
import org.apache.sysml.runtime.compress.utils.ConverterUtils;
import org.apache.sysml.runtime.compress.utils.LinearAlgebraUtils;
import org.apache.sysml.runtime.functionobjects.Builtin;
import org.apache.sysml.runtime.functionobjects.KahanFunction;
import org.apache.sysml.runtime.functionobjects.KahanPlus;
import org.apache.sysml.runtime.instructions.cp.KahanObject;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.data.Pair;
import org.apache.sysml.runtime.matrix.operators.ScalarOperator;

public class ColGroupRLE
extends ColGroupOffset {
    private static final long serialVersionUID = 7450232907594748177L;
    private static final Log LOG = LogFactory.getLog((String)ColGroupRLE.class.getName());

    public ColGroupRLE() {
    }

    public ColGroupRLE(int[] colIndices, int numRows, UncompressedBitmap ubm) {
        super(colIndices, numRows, ubm);
        int numVals = ubm.getNumValues();
        char[][] lbitmaps = new char[numVals][];
        int totalLen = 0;
        for (int k = 0; k < numVals; ++k) {
            lbitmaps[k] = BitmapEncoder.genRLEBitmap(ubm.getOffsetsList(k).extractValues(), ubm.getNumOffsets(k));
            totalLen += lbitmaps[k].length;
        }
        this.createCompressedBitmaps(numVals, totalLen, lbitmaps);
        double ucSize = MatrixBlock.estimateSizeDenseInMemory(numRows, colIndices.length);
        if ((double)this.estimateInMemorySize() > ucSize) {
            LOG.warn((Object)("RLE group larger than UC dense: " + this.estimateInMemorySize() + " " + ucSize));
        }
    }

    public ColGroupRLE(int[] colIndices, int numRows, boolean zeros, double[] values, char[] bitmaps, int[] bitmapOffs) {
        super(colIndices, numRows, zeros, values);
        this._data = bitmaps;
        this._ptr = bitmapOffs;
    }

    @Override
    public ColGroup.CompressionType getCompType() {
        return ColGroup.CompressionType.RLE_BITMAP;
    }

    @Override
    public Iterator<Integer> getDecodeIterator(int k) {
        return new BitmapDecoderRLE(this._data, this._ptr[k], this.len(k));
    }

    @Override
    public void decompressToBlock(MatrixBlock target, int rl, int ru) {
        if (LOW_LEVEL_OPT && this.getNumValues() > 1) {
            int blksz = 131072;
            int numCols = this.getNumCols();
            int numVals = this.getNumValues();
            int[] astart = new int[numVals];
            int[] apos = this.skipScan(numVals, rl, astart);
            for (int bi = rl; bi < ru; bi += 131072) {
                int bimax = Math.min(bi + 131072, ru);
                int k = 0;
                int off = 0;
                while (k < numVals) {
                    int boff = this._ptr[k];
                    int blen = this.len(k);
                    int bix = apos[k];
                    int start = astart[k];
                    while (bix < blen & start < bimax) {
                        char len = this._data[boff + bix + 1];
                        for (int i = Math.max(rl, start += this._data[boff + bix]); i < Math.min(start + len, ru); ++i) {
                            for (int j = 0; j < numCols; ++j) {
                                if (this._values[off + j] == 0.0) continue;
                                target.appendValue(i, this._colIndexes[j], this._values[off + j]);
                            }
                        }
                        start += len;
                        bix += 2;
                    }
                    apos[k] = bix;
                    astart[k] = start;
                    ++k;
                    off += numCols;
                }
            }
        } else {
            super.decompressToBlock(target, rl, ru);
        }
    }

    @Override
    public void decompressToBlock(MatrixBlock target, int[] colixTargets) {
        if (LOW_LEVEL_OPT && this.getNumValues() > 1) {
            int blksz = 131072;
            int numCols = this.getNumCols();
            int numVals = this.getNumValues();
            int n = this.getNumRows();
            int[] apos = new int[numVals];
            int[] astart = new int[numVals];
            int[] cix = new int[numCols];
            for (int j = 0; j < numCols; ++j) {
                cix[j] = colixTargets[this._colIndexes[j]];
            }
            for (int bi = 0; bi < n; bi += 131072) {
                int bimax = Math.min(bi + 131072, n);
                int k = 0;
                int off = 0;
                while (k < numVals) {
                    int boff = this._ptr[k];
                    int bix = apos[k];
                    int blen = this.len(k);
                    if (bix < blen) {
                        int start = astart[k];
                        while (bix < blen & start < bimax) {
                            char len = this._data[boff + bix + 1];
                            for (int i = start += this._data[boff + bix]; i < start + len; ++i) {
                                for (int j = 0; j < numCols; ++j) {
                                    if (this._values[off + j] == 0.0) continue;
                                    target.appendValue(i, cix[j], this._values[off + j]);
                                }
                            }
                            start += len;
                            bix += 2;
                        }
                        apos[k] = bix;
                        astart[k] = start;
                    }
                    ++k;
                    off += numCols;
                }
            }
        } else {
            super.decompressToBlock(target, colixTargets);
        }
    }

    @Override
    public void decompressToBlock(MatrixBlock target, int colpos) {
        int blksz = 131072;
        int numCols = this.getNumCols();
        int numVals = this.getNumValues();
        int n = this.getNumRows();
        double[] c = target.getDenseBlock();
        int[] astart = new int[numVals];
        int[] apos = ColGroupRLE.allocIVector(numVals, true);
        for (int bi = 0; bi < n; bi += 131072) {
            int bimax = Math.min(bi + 131072, n);
            int k = 0;
            int off = 0;
            while (k < numVals) {
                int boff = this._ptr[k];
                int bix = apos[k];
                int blen = this.len(k);
                if (bix < blen) {
                    int start = astart[k];
                    while (bix < blen & start < bimax) {
                        char len = this._data[boff + bix + 1];
                        for (int i = start += this._data[boff + bix]; i < start + len; ++i) {
                            c[i] = this._values[off + colpos];
                        }
                        start += len;
                        bix += 2;
                    }
                    apos[k] = bix;
                    astart[k] = start;
                }
                ++k;
                off += numCols;
            }
        }
        target.recomputeNonZeros();
    }

    @Override
    public void rightMultByVector(MatrixBlock vector, MatrixBlock result, int rl, int ru) throws DMLRuntimeException {
        double[] b = ConverterUtils.getDenseVector(vector);
        double[] c = result.getDenseBlock();
        int numCols = this.getNumCols();
        int numVals = this.getNumValues();
        double[] sb = new double[numCols];
        for (int j = 0; j < numCols; ++j) {
            sb[j] = b[this._colIndexes[j]];
        }
        if (LOW_LEVEL_OPT && numVals > 1 && this._numRows > 65536) {
            int blksz = 131072;
            int[] astart = new int[numVals];
            int[] apos = this.skipScan(numVals, rl, astart);
            double[] aval = this.preaggValues(numVals, sb);
            for (int bi = rl; bi < ru; bi += 131072) {
                int bimax = Math.min(bi + 131072, ru);
                for (int k = 0; k < numVals; ++k) {
                    int bix;
                    int boff = this._ptr[k];
                    int blen = this.len(k);
                    double val = aval[k];
                    int start = astart[k];
                    for (bix = apos[k]; bix < blen; bix += 2) {
                        char lstart = this._data[boff + bix];
                        char llen = this._data[boff + bix + 1];
                        LinearAlgebraUtils.vectAdd(val, c, Math.max(bi, start + lstart), Math.min(start + lstart + llen, bimax) - Math.max(bi, start + lstart));
                        if (start + lstart + llen >= bimax) break;
                        start += lstart + llen;
                    }
                    apos[k] = bix;
                    astart[k] = start;
                }
            }
        } else {
            block4: for (int k = 0; k < numVals; ++k) {
                char llen;
                char lstart;
                int bix;
                int boff = this._ptr[k];
                int blen = this.len(k);
                double val = this.sumValues(k, sb);
                int start = 0;
                if (rl > 0) {
                    for (bix = 0; bix < blen && start + (lstart = this._data[boff + bix]) + (llen = this._data[boff + bix + 1]) < rl; bix += 2) {
                        start += lstart + llen;
                    }
                }
                while (bix < blen) {
                    lstart = this._data[boff + bix];
                    llen = this._data[boff + bix + 1];
                    LinearAlgebraUtils.vectAdd(val, c, Math.max(rl, start + lstart), Math.min(start + lstart + llen, ru) - Math.max(rl, start + lstart));
                    if (start + lstart + llen >= ru) continue block4;
                    start += lstart + llen;
                    bix += 2;
                }
            }
        }
    }

    @Override
    public void leftMultByRowVector(MatrixBlock vector, MatrixBlock result) throws DMLRuntimeException {
        double[] a = ConverterUtils.getDenseVector(vector);
        double[] c = result.getDenseBlock();
        int numCols = this.getNumCols();
        int numVals = this.getNumValues();
        int n = this.getNumRows();
        if (LOW_LEVEL_OPT && numVals > 1 && this._numRows > 65536) {
            int blksz = 131072;
            int[] astart = new int[numVals];
            int[] apos = ColGroupRLE.allocIVector(numVals, true);
            double[] cvals = ColGroupRLE.allocDVector(numVals, true);
            for (int ai = 0; ai < n; ai += 131072) {
                int aimax = Math.min(ai + 131072, n);
                for (int k = 0; k < numVals; ++k) {
                    int boff = this._ptr[k];
                    int blen = this.len(k);
                    int bix = apos[k];
                    int start = astart[k];
                    while (bix < blen & start < aimax) {
                        char len = this._data[boff + bix + 1];
                        int n2 = k;
                        cvals[n2] = cvals[n2] + LinearAlgebraUtils.vectSum(a, start += this._data[boff + bix], len);
                        start += len;
                        bix += 2;
                    }
                    apos[k] = bix;
                    astart[k] = start;
                }
            }
            int k = 0;
            int valOff = 0;
            while (k < numVals) {
                for (int j = 0; j < numCols; ++j) {
                    int n3 = this._colIndexes[j];
                    c[n3] = c[n3] + cvals[k] * this._values[valOff + j];
                }
                ++k;
                valOff += numCols;
            }
        } else {
            int k = 0;
            int valOff = 0;
            while (k < numVals) {
                int boff = this._ptr[k];
                int blen = this.len(k);
                double vsum = 0.0;
                int curRunEnd = 0;
                for (int bix = 0; bix < blen; bix += 2) {
                    int curRunStartOff = curRunEnd + this._data[boff + bix];
                    char curRunLen = this._data[boff + bix + 1];
                    vsum += LinearAlgebraUtils.vectSum(a, curRunStartOff, curRunLen);
                    curRunEnd = curRunStartOff + curRunLen;
                }
                for (int j = 0; j < numCols; ++j) {
                    int n4 = this._colIndexes[j];
                    c[n4] = c[n4] + vsum * this._values[valOff + j];
                }
                ++k;
                valOff += numCols;
            }
        }
    }

    @Override
    public ColGroup scalarOperation(ScalarOperator op) throws DMLRuntimeException {
        double val0 = op.executeScalar(0.0);
        if (op.sparseSafe || val0 == 0.0) {
            return new ColGroupRLE(this._colIndexes, this._numRows, this._zeros, this.applyScalarOp(op), this._data, this._ptr);
        }
        boolean[] lind = this.computeZeroIndicatorVector();
        int[] loff = this.computeOffsets(lind);
        if (loff.length == 0) {
            return new ColGroupRLE(this._colIndexes, this._numRows, true, this.applyScalarOp(op), this._data, this._ptr);
        }
        double[] rvalues = this.applyScalarOp(op, val0, this.getNumCols());
        char[] lbitmap = BitmapEncoder.genRLEBitmap(loff, loff.length);
        char[] rbitmaps = Arrays.copyOf(this._data, this._data.length + lbitmap.length);
        System.arraycopy(lbitmap, 0, rbitmaps, this._data.length, lbitmap.length);
        int[] rbitmapOffs = Arrays.copyOf(this._ptr, this._ptr.length + 1);
        rbitmapOffs[rbitmapOffs.length - 1] = rbitmaps.length;
        return new ColGroupRLE(this._colIndexes, this._numRows, loff.length < this._numRows, rvalues, rbitmaps, rbitmapOffs);
    }

    @Override
    protected final void computeSum(MatrixBlock result, KahanFunction kplus) {
        KahanObject kbuff = new KahanObject(result.quickGetValue(0, 0), result.quickGetValue(0, 1));
        int numCols = this.getNumCols();
        int numVals = this.getNumValues();
        for (int k = 0; k < numVals; ++k) {
            int boff = this._ptr[k];
            int blen = this.len(k);
            int valOff = k * numCols;
            int curRunEnd = 0;
            int count = 0;
            for (int bix = 0; bix < blen; bix += 2) {
                int curRunStartOff = curRunEnd + this._data[boff + bix];
                curRunEnd = curRunStartOff + this._data[boff + bix + 1];
                count += curRunEnd - curRunStartOff;
            }
            for (int j = 0; j < numCols; ++j) {
                kplus.execute3(kbuff, this._values[valOff + j], count);
            }
        }
        result.quickSetValue(0, 0, kbuff._sum);
        result.quickSetValue(0, 1, kbuff._correction);
    }

    @Override
    protected final void computeRowSums(MatrixBlock result, KahanFunction kplus, int rl, int ru) {
        KahanObject kbuff = new KahanObject(0.0, 0.0);
        KahanPlus kplus2 = KahanPlus.getKahanPlusFnObject();
        int numVals = this.getNumValues();
        double[] c = result.getDenseBlock();
        if (ALLOW_CACHE_CONSCIOUS_ROWSUMS && LOW_LEVEL_OPT && numVals > 1 && this._numRows > 65536) {
            int blksz = 65536;
            int[] astart = new int[numVals];
            int[] apos = this.skipScan(numVals, rl, astart);
            double[] aval = this.sumAllValues(kplus, kbuff, false);
            for (int bi = rl; bi < ru; bi += 65536) {
                int bimax = Math.min(bi + 65536, ru);
                for (int k = 0; k < numVals; ++k) {
                    int bix;
                    int boff = this._ptr[k];
                    int blen = this.len(k);
                    double val = aval[k];
                    int start = astart[k];
                    for (bix = apos[k]; bix < blen; bix += 2) {
                        char lstart = this._data[boff + bix];
                        char llen = this._data[boff + bix + 1];
                        int from = Math.max(bi, start + lstart);
                        int to = Math.min(start + lstart + llen, bimax);
                        for (int rix = from; rix < to; ++rix) {
                            kbuff.set(c[2 * rix], c[2 * rix + 1]);
                            kplus2.execute2(kbuff, val);
                            c[2 * rix] = kbuff._sum;
                            c[2 * rix + 1] = kbuff._correction;
                        }
                        if (start + lstart + llen >= bimax) break;
                        start += lstart + llen;
                    }
                    apos[k] = bix;
                    astart[k] = start;
                }
            }
        } else {
            for (int k = 0; k < numVals; ++k) {
                int boff = this._ptr[k];
                int blen = this.len(k);
                double val = this.sumValues(k, kplus, kbuff);
                if (val == 0.0) continue;
                Pair<Integer, Integer> tmp = this.skipScanVal(k, rl);
                int curRunStartOff = tmp.getValue();
                int curRunEnd = tmp.getValue();
                for (int bix = tmp.getKey().intValue(); bix < blen && curRunEnd < ru; bix += 2) {
                    curRunStartOff = curRunEnd + this._data[boff + bix];
                    curRunEnd = curRunStartOff + this._data[boff + bix + 1];
                    for (int rix = curRunStartOff; rix < curRunEnd && rix < ru; ++rix) {
                        kbuff.set(c[2 * rix], c[2 * rix + 1]);
                        kplus2.execute2(kbuff, val);
                        c[2 * rix] = kbuff._sum;
                        c[2 * rix + 1] = kbuff._correction;
                    }
                }
            }
        }
    }

    @Override
    protected final void computeColSums(MatrixBlock result, KahanFunction kplus) {
        KahanObject kbuff = new KahanObject(0.0, 0.0);
        int numCols = this.getNumCols();
        int numVals = this.getNumValues();
        for (int k = 0; k < numVals; ++k) {
            int boff = this._ptr[k];
            int blen = this.len(k);
            int valOff = k * numCols;
            int curRunEnd = 0;
            int count = 0;
            for (int bix = 0; bix < blen; bix += 2) {
                int curRunStartOff = curRunEnd + this._data[boff + bix];
                curRunEnd = curRunStartOff + this._data[boff + bix + 1];
                count += curRunEnd - curRunStartOff;
            }
            for (int j = 0; j < numCols; ++j) {
                kbuff.set(result.quickGetValue(0, this._colIndexes[j]), result.quickGetValue(1, this._colIndexes[j]));
                kplus.execute3(kbuff, this._values[valOff + j], count);
                result.quickSetValue(0, this._colIndexes[j], kbuff._sum);
                result.quickSetValue(1, this._colIndexes[j], kbuff._correction);
            }
        }
    }

    @Override
    protected final void computeRowMxx(MatrixBlock result, Builtin builtin, int rl, int ru) {
        int numVals = this.getNumValues();
        double[] c = result.getDenseBlock();
        for (int k = 0; k < numVals; ++k) {
            int boff = this._ptr[k];
            int blen = this.len(k);
            double val = this.mxxValues(k, builtin);
            Pair<Integer, Integer> tmp = this.skipScanVal(k, rl);
            int curRunStartOff = tmp.getValue();
            int curRunEnd = tmp.getValue();
            for (int bix = tmp.getKey().intValue(); bix < blen && curRunEnd < ru; bix += 2) {
                curRunStartOff = curRunEnd + this._data[boff + bix];
                curRunEnd = curRunStartOff + this._data[boff + bix + 1];
                for (int rix = curRunStartOff; rix < curRunEnd && rix < ru; ++rix) {
                    c[rix] = builtin.execute2(c[rix], val);
                }
            }
        }
    }

    public boolean[] computeZeroIndicatorVector() throws DMLRuntimeException {
        boolean[] ret = new boolean[this._numRows];
        int numVals = this.getNumValues();
        Arrays.fill(ret, true);
        for (int k = 0; k < numVals; ++k) {
            int boff = this._ptr[k];
            int blen = this.len(k);
            int curRunStartOff = 0;
            int curRunEnd = 0;
            for (int bix = 0; bix < blen; bix += 2) {
                curRunStartOff = curRunEnd + this._data[boff + bix];
                curRunEnd = curRunStartOff + this._data[boff + bix + 1];
                Arrays.fill(ret, curRunStartOff, curRunEnd, false);
            }
        }
        return ret;
    }

    @Override
    protected void countNonZerosPerRow(int[] rnnz, int rl, int ru) {
        int numVals = this.getNumValues();
        int numCols = this.getNumCols();
        int[] astart = new int[numVals];
        int[] apos = this.skipScan(numVals, rl, astart);
        for (int k = 0; k < numVals; ++k) {
            int boff = this._ptr[k];
            int blen = this.len(k);
            int curRunStartOff = 0;
            int curRunEnd = 0;
            for (int bix = apos[k]; bix < blen && curRunStartOff < ru; bix += 2) {
                curRunStartOff = curRunEnd + this._data[boff + bix];
                curRunEnd = curRunStartOff + this._data[boff + bix + 1];
                for (int i = Math.max(curRunStartOff, rl); i < Math.min(curRunEnd, ru); ++i) {
                    int n = i - rl;
                    rnnz[n] = rnnz[n] + numCols;
                }
            }
        }
    }

    private int[] skipScan(int numVals, int rl, int[] astart) {
        int[] apos = ColGroupRLE.allocIVector(numVals, rl == 0);
        if (rl > 0) {
            for (int k = 0; k < numVals; ++k) {
                char llen;
                char lstart;
                int bix;
                int boff = this._ptr[k];
                int blen = this.len(k);
                int start = 0;
                for (bix = 0; bix < blen && start + (lstart = this._data[boff + bix]) + (llen = this._data[boff + bix + 1]) < rl; bix += 2) {
                    start += lstart + llen;
                }
                apos[k] = bix;
                astart[k] = start;
            }
        }
        return apos;
    }

    private Pair<Integer, Integer> skipScanVal(int k, int rl) {
        int apos = 0;
        int astart = 0;
        if (rl > 0) {
            char llen;
            char lstart;
            int bix;
            int boff = this._ptr[k];
            int blen = this.len(k);
            int start = 0;
            for (bix = 0; bix < blen && start + (lstart = this._data[boff + bix]) + (llen = this._data[boff + bix + 1]) < rl; bix += 2) {
                start += lstart + llen;
            }
            apos = bix;
            astart = start;
        }
        return new Pair<Integer, Integer>(apos, astart);
    }
}

