/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.parser;

import java.util.HashMap;
import org.apache.sysml.lops.Lop;
import org.apache.sysml.parser.ConstIdentifier;
import org.apache.sysml.parser.DataIdentifier;
import org.apache.sysml.parser.Expression;
import org.apache.sysml.parser.FunctionCallIdentifier;
import org.apache.sysml.parser.Identifier;
import org.apache.sysml.parser.IntIdentifier;
import org.apache.sysml.parser.LanguageException;
import org.apache.sysml.parser.VariableSet;

public class IterablePredicate
extends Expression {
    private DataIdentifier _iterVar;
    private Expression _fromExpr;
    private Expression _toExpr;
    private Expression _incrementExpr;
    private HashMap<String, String> _parforParams;

    public IterablePredicate(DataIdentifier iterVar, Expression fromExpr, Expression toExpr, Expression incrementExpr, HashMap<String, String> parForParamValues, String filename, int blp, int bcp, int elp, int ecp) {
        this._iterVar = iterVar;
        this._fromExpr = fromExpr;
        this._toExpr = toExpr;
        this._incrementExpr = incrementExpr;
        this._parforParams = parForParamValues;
        this.setAllPositions(filename, blp, bcp, elp, ecp);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append(this._iterVar.getName());
        sb.append(" in seq(");
        sb.append(this._fromExpr.toString());
        sb.append(",");
        sb.append(this._toExpr.toString());
        if (this._incrementExpr != null) {
            sb.append(",");
            sb.append(this._incrementExpr.toString());
        }
        sb.append(")");
        if (this._parforParams != null && this._parforParams.size() > 0) {
            for (String key : this._parforParams.keySet()) {
                sb.append(",");
                sb.append(key);
                sb.append("=");
                sb.append(this._parforParams.get(key));
            }
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public VariableSet variablesRead() {
        VariableSet result = new VariableSet();
        result.addVariables(this._fromExpr.variablesRead());
        result.addVariables(this._toExpr.variablesRead());
        if (this._incrementExpr != null) {
            result.addVariables(this._incrementExpr.variablesRead());
        }
        return result;
    }

    @Override
    public VariableSet variablesUpdated() {
        VariableSet result = new VariableSet();
        result.addVariable(this._iterVar.getName(), this._iterVar);
        return result;
    }

    @Override
    public Expression rewriteExpression(String prefix) throws LanguageException {
        LOG.error((Object)(this.printErrorLocation() + "rewriteExpression not supported for IterablePredicate"));
        throw new LanguageException(this.printErrorLocation() + "rewriteExpression not supported for IterablePredicate");
    }

    @Override
    public void validateExpression(HashMap<String, DataIdentifier> ids, HashMap<String, ConstIdentifier> constVars, boolean conditional) throws LanguageException {
        DataIdentifier otherDI;
        if (this._iterVar instanceof FunctionCallIdentifier || this._fromExpr instanceof FunctionCallIdentifier || this._toExpr instanceof FunctionCallIdentifier || this._incrementExpr instanceof FunctionCallIdentifier) {
            this.raiseValidateError("user-defined function calls not supported for iterable predicates", false, "Unsupported Expression");
        }
        if (ids.containsKey(this._iterVar.getName()) && ((otherDI = ids.get(this._iterVar.getName())).getDataType() != Expression.DataType.SCALAR || otherDI.getValueType() != Expression.ValueType.INT)) {
            this.raiseValidateError("iterable predicate in for loop '" + this._iterVar.getName() + "' must be a scalar integer", conditional);
        }
        this._iterVar.setIntProperties();
        ids.put(this._iterVar.getName(), this._iterVar);
        if (this._incrementExpr == null && this._fromExpr instanceof ConstIdentifier && this._toExpr instanceof ConstIdentifier) {
            ConstIdentifier cFrom = (ConstIdentifier)this._fromExpr;
            ConstIdentifier cTo = (ConstIdentifier)this._toExpr;
            this._incrementExpr = new IntIdentifier(cFrom.getLongValue() <= cTo.getLongValue() ? 1L : -1L, this.getFilename(), this.getBeginLine(), this.getBeginColumn(), this.getEndLine(), this.getEndColumn());
        }
        this._fromExpr.validateExpression(ids, constVars, conditional);
        this._toExpr.validateExpression(ids, constVars, conditional);
        if (this._incrementExpr != null) {
            this._incrementExpr.validateExpression(ids, constVars, conditional);
        }
        this.checkNumericScalarOutput(this._fromExpr);
        this.checkNumericScalarOutput(this._toExpr);
        this.checkNumericScalarOutput(this._incrementExpr);
    }

    public DataIdentifier getIterVar() {
        return this._iterVar;
    }

    public void setIterVar(DataIdentifier iterVar) {
        this._iterVar = iterVar;
    }

    public Expression getFromExpr() {
        return this._fromExpr;
    }

    public void setFromExpr(Expression from) {
        this._fromExpr = from;
    }

    public Expression getToExpr() {
        return this._toExpr;
    }

    public void setToExpr(Expression to) {
        this._toExpr = to;
    }

    public Expression getIncrementExpr() {
        return this._incrementExpr;
    }

    public void setIncrementExpr(Expression increment) {
        this._incrementExpr = increment;
    }

    public HashMap<String, String> getParForParams() {
        return this._parforParams;
    }

    public void setParForParams(HashMap<String, String> params) {
        this._parforParams = params;
    }

    public static String[] createIterablePredicateVariables(String varName, Lop from, Lop to, Lop incr) {
        String[] ret = new String[4];
        ret[0] = varName;
        if (from.getType() == Lop.Type.Data) {
            ret[1] = from.getOutputParameters().getLabel();
        }
        if (to.getType() == Lop.Type.Data) {
            ret[2] = to.getOutputParameters().getLabel();
        }
        if (incr != null && incr.getType() == Lop.Type.Data) {
            ret[3] = incr.getOutputParameters().getLabel();
        }
        return ret;
    }

    private void checkNumericScalarOutput(Expression expr) throws LanguageException {
        if (expr == null || expr.getOutput() == null) {
            return;
        }
        Identifier ident = expr.getOutput();
        if (ident.getDataType() == Expression.DataType.MATRIX || ident.getDataType() == Expression.DataType.OBJECT || ident.getDataType() == Expression.DataType.SCALAR && (ident.getValueType() == Expression.ValueType.BOOLEAN || ident.getValueType() == Expression.ValueType.STRING || ident.getValueType() == Expression.ValueType.OBJECT)) {
            LOG.error((Object)(this.printErrorLocation() + "expression in iterable predicate in for loop '" + expr.toString() + "' must return a numeric scalar"));
            throw new LanguageException(this.printErrorLocation() + "expression in iterable predicate in for loop '" + expr.toString() + "' must return a numeric scalar");
        }
    }
}

