/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.parser;

import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysml.hops.Hop;
import org.apache.sysml.parser.ConstIdentifier;
import org.apache.sysml.parser.DataIdentifier;
import org.apache.sysml.parser.Identifier;
import org.apache.sysml.parser.LanguageException;
import org.apache.sysml.parser.MultiAssignmentStatement;
import org.apache.sysml.parser.VariableSet;

public abstract class Expression {
    protected static final Log LOG = LogFactory.getLog((String)Expression.class.getName());
    protected Kind _kind;
    protected Identifier[] _outputs = null;
    private static int _tempId;
    private String _filename;
    private int _beginLine;
    private int _beginColumn;
    private int _endLine;
    private int _endColumn;
    private ArrayList<String> _parseExceptionList = new ArrayList();

    public abstract Expression rewriteExpression(String var1) throws LanguageException;

    public void setOutput(Identifier output) {
        if (this._outputs == null) {
            this._outputs = new Identifier[1];
        }
        this._outputs[0] = output;
    }

    public Kind getKind() {
        return this._kind;
    }

    public Identifier getOutput() {
        if (this._outputs != null && this._outputs.length > 0) {
            return this._outputs[0];
        }
        return null;
    }

    public Identifier[] getOutputs() {
        return this._outputs;
    }

    public void validateExpression(HashMap<String, DataIdentifier> ids, HashMap<String, ConstIdentifier> currConstVars, boolean conditional) throws LanguageException {
        this.raiseValidateError("Should never be invoked in Baseclass 'Expression'", false);
    }

    public void validateExpression(MultiAssignmentStatement mas, HashMap<String, DataIdentifier> ids, HashMap<String, ConstIdentifier> currConstVars, boolean conditional) throws LanguageException {
        this.raiseValidateError("Should never be invoked in Baseclass 'Expression'", false);
    }

    public static BinaryOp getBinaryOp(String val) {
        if (val.equalsIgnoreCase("+")) {
            return BinaryOp.PLUS;
        }
        if (val.equalsIgnoreCase("-")) {
            return BinaryOp.MINUS;
        }
        if (val.equalsIgnoreCase("*")) {
            return BinaryOp.MULT;
        }
        if (val.equalsIgnoreCase("/")) {
            return BinaryOp.DIV;
        }
        if (val.equalsIgnoreCase("%%")) {
            return BinaryOp.MODULUS;
        }
        if (val.equalsIgnoreCase("%/%")) {
            return BinaryOp.INTDIV;
        }
        if (val.equalsIgnoreCase("^")) {
            return BinaryOp.POW;
        }
        if (val.equalsIgnoreCase("%*%")) {
            return BinaryOp.MATMULT;
        }
        return BinaryOp.INVALID;
    }

    public static RelationalOp getRelationalOp(String val) {
        if (val == null) {
            return null;
        }
        if (val.equalsIgnoreCase("<")) {
            return RelationalOp.LESS;
        }
        if (val.equalsIgnoreCase("<=")) {
            return RelationalOp.LESSEQUAL;
        }
        if (val.equalsIgnoreCase(">")) {
            return RelationalOp.GREATER;
        }
        if (val.equalsIgnoreCase(">=")) {
            return RelationalOp.GREATEREQUAL;
        }
        if (val.equalsIgnoreCase("==")) {
            return RelationalOp.EQUAL;
        }
        if (val.equalsIgnoreCase("!=")) {
            return RelationalOp.NOTEQUAL;
        }
        return RelationalOp.INVALID;
    }

    public static BooleanOp getBooleanOp(String val) {
        if (val.equalsIgnoreCase("&&")) {
            return BooleanOp.CONDITIONALAND;
        }
        if (val.equalsIgnoreCase("&")) {
            return BooleanOp.LOGICALAND;
        }
        if (val.equalsIgnoreCase("||")) {
            return BooleanOp.CONDITIONALOR;
        }
        if (val.equalsIgnoreCase("|")) {
            return BooleanOp.LOGICALOR;
        }
        if (val.equalsIgnoreCase("!")) {
            return BooleanOp.NOT;
        }
        return BooleanOp.INVALID;
    }

    public static Hop.FileFormatTypes convertFormatType(String format) {
        if (format == null) {
            return Hop.FileFormatTypes.TEXT;
        }
        if (format.equalsIgnoreCase("text")) {
            return Hop.FileFormatTypes.TEXT;
        }
        if (format.equalsIgnoreCase("binary")) {
            return Hop.FileFormatTypes.BINARY;
        }
        if (format.equalsIgnoreCase("mm")) {
            return Hop.FileFormatTypes.MM;
        }
        if (format.equalsIgnoreCase("csv")) {
            return Hop.FileFormatTypes.CSV;
        }
        return Hop.FileFormatTypes.TEXT;
    }

    public static String getTempName() {
        return "parsertemp" + _tempId++;
    }

    public abstract VariableSet variablesRead();

    public abstract VariableSet variablesUpdated();

    public static DataType computeDataType(Expression expression1, Expression expression2, boolean cast) throws LanguageException {
        return Expression.computeDataType(expression1.getOutput(), expression2.getOutput(), cast);
    }

    public static DataType computeDataType(Identifier identifier1, Identifier identifier2, boolean cast) throws LanguageException {
        DataType d2;
        DataType d1 = identifier1.getDataType();
        if (d1 == (d2 = identifier2.getDataType())) {
            return d1;
        }
        if (cast) {
            if (d1 == DataType.MATRIX && d2 == DataType.SCALAR) {
                return DataType.MATRIX;
            }
            if (d1 == DataType.SCALAR && d2 == DataType.MATRIX) {
                return DataType.MATRIX;
            }
        }
        identifier1.raiseValidateError("Invalid Datatypes for operation " + (Object)((Object)d1) + " " + (Object)((Object)d2), false, "Invalid Parameters");
        return null;
    }

    public static ValueType computeValueType(Expression expression1, Expression expression2, boolean cast) throws LanguageException {
        return Expression.computeValueType(expression1.getOutput(), expression2.getOutput(), cast);
    }

    public static ValueType computeValueType(Identifier identifier1, Identifier identifier2, boolean cast) throws LanguageException {
        ValueType v2;
        ValueType v1 = identifier1.getValueType();
        if (v1 == (v2 = identifier2.getValueType())) {
            return v1;
        }
        if (cast) {
            if (v1 == ValueType.DOUBLE && v2 == ValueType.INT) {
                return ValueType.DOUBLE;
            }
            if (v2 == ValueType.DOUBLE && v1 == ValueType.INT) {
                return ValueType.DOUBLE;
            }
            if (v1 == ValueType.STRING || v2 == ValueType.STRING) {
                return ValueType.STRING;
            }
        }
        identifier1.raiseValidateError("Invalid Valuetypes for operation " + (Object)((Object)v1) + " " + (Object)((Object)v2), false, "Invalid Parameters");
        return null;
    }

    public boolean equals(Object that) {
        if (that == null || !(that instanceof Expression)) {
            return false;
        }
        Expression thatExpr = (Expression)that;
        String thisStr = this.toString();
        String thatStr = thatExpr.toString();
        return thisStr.equalsIgnoreCase(thatStr);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public void raiseValidateError(String message) throws LanguageException {
        this.raiseValidateError(message, false, null);
    }

    public void raiseValidateError(String message, boolean conditional) throws LanguageException {
        this.raiseValidateError(message, conditional, null);
    }

    public void raiseValidateError(String message, boolean conditional, String errorCode) throws LanguageException {
        if (!conditional) {
            String fullMsg = this.printErrorLocation() + message;
            if (errorCode != null) {
                throw new LanguageException(fullMsg, errorCode);
            }
            throw new LanguageException(fullMsg);
        }
        String fullMsg = this.printWarningLocation() + message;
        LOG.warn((Object)fullMsg);
    }

    public static long[] getBinaryMatrixCharacteristics(Expression expression1, Expression expression2) {
        long[] ret = new long[]{-1L, -1L, -1L, -1L};
        Identifier idleft = expression1.getOutput();
        Identifier idright = expression2.getOutput();
        if (idleft.getDataType() == DataType.SCALAR && idright.getDataType() == DataType.SCALAR) {
            ret[0] = 0L;
            ret[1] = 0L;
            ret[2] = 0L;
            ret[3] = 0L;
        } else if (idleft.getDataType() == DataType.SCALAR && idright.getDataType() == DataType.MATRIX) {
            ret[0] = idright.getDim1();
            ret[1] = idright.getDim2();
            ret[2] = idright.getRowsInBlock();
            ret[3] = idright.getColumnsInBlock();
        } else if (idleft.getDataType() == DataType.MATRIX && idright.getDataType() == DataType.SCALAR) {
            ret[0] = idleft.getDim1();
            ret[1] = idleft.getDim2();
            ret[2] = idleft.getRowsInBlock();
            ret[3] = idleft.getColumnsInBlock();
        } else if (idleft.getDataType() == DataType.MATRIX && idright.getDataType() == DataType.MATRIX) {
            ret[0] = idleft.getDim1();
            ret[1] = idleft.getDim2();
            ret[2] = idleft.getRowsInBlock();
            ret[3] = idleft.getColumnsInBlock();
            if (ret[0] < 0L && idright.getDim1() > 1L) {
                ret[0] = idright.getDim1();
            }
            if (ret[1] < 0L && idright.getDim2() > 1L) {
                ret[1] = idright.getDim2();
            }
        }
        return ret;
    }

    public void setFilename(String passed) {
        this._filename = passed;
    }

    public void setBeginLine(int passed) {
        this._beginLine = passed;
    }

    public void setBeginColumn(int passed) {
        this._beginColumn = passed;
    }

    public void setEndLine(int passed) {
        this._endLine = passed;
    }

    public void setEndColumn(int passed) {
        this._endColumn = passed;
    }

    public void setParseExceptionList(ArrayList<String> passed) {
        this._parseExceptionList = passed;
    }

    public void setAllPositions(String filename, int blp, int bcp, int elp, int ecp) {
        this._filename = filename;
        this._beginLine = blp;
        this._beginColumn = bcp;
        this._endLine = elp;
        this._endColumn = ecp;
    }

    public String getFilename() {
        return this._filename;
    }

    public int getBeginLine() {
        return this._beginLine;
    }

    public int getBeginColumn() {
        return this._beginColumn;
    }

    public int getEndLine() {
        return this._endLine;
    }

    public int getEndColumn() {
        return this._endColumn;
    }

    public ArrayList<String> getParseExceptionList() {
        return this._parseExceptionList;
    }

    public String printErrorLocation() {
        return "ERROR: " + this._filename + " -- line " + this._beginLine + ", column " + this._beginColumn + " -- ";
    }

    public String printWarningLocation() {
        return "WARNING: " + this._filename + " -- line " + this._beginLine + ", column " + this._beginColumn + " -- ";
    }

    public String printInfoLocation() {
        return "INFO: " + this._filename + " -- line " + this._beginLine + ", column " + this._beginColumn + " -- ";
    }

    public static enum FormatType {
        TEXT,
        BINARY,
        MM,
        CSV;

    }

    public static enum ValueType {
        INT,
        DOUBLE,
        STRING,
        BOOLEAN,
        OBJECT,
        UNKNOWN;

    }

    public static enum DataType {
        MATRIX,
        SCALAR,
        FRAME,
        OBJECT,
        UNKNOWN;


        public boolean isMatrix() {
            return this == MATRIX;
        }

        public boolean isScalar() {
            return this == SCALAR;
        }
    }

    public static enum FunctCallOp {
        INTERNAL,
        EXTERNAL;

    }

    public static enum DataOp {
        READ,
        WRITE,
        RAND,
        MATRIX;

    }

    public static enum ParameterizedBuiltinFunctionOp {
        GROUPEDAGG,
        RMEMPTY,
        REPLACE,
        ORDER,
        CDF,
        INVCDF,
        PNORM,
        QNORM,
        PT,
        QT,
        PF,
        QF,
        PCHISQ,
        QCHISQ,
        PEXP,
        QEXP,
        TRANSFORM,
        TRANSFORMAPPLY,
        TRANSFORMDECODE,
        TRANSFORMENCODE,
        TRANSFORMMETA,
        TOSTRING,
        INVALID;

    }

    public static enum BuiltinFunctionOp {
        ABS,
        ACOS,
        ASIN,
        ATAN,
        CAST_AS_BOOLEAN,
        CAST_AS_DOUBLE,
        CAST_AS_FRAME,
        CAST_AS_INT,
        CAST_AS_MATRIX,
        CAST_AS_SCALAR,
        CBIND,
        CEIL,
        CHOLESKY,
        COLMAX,
        COLMEAN,
        COLMIN,
        COLSD,
        COLSUM,
        COLVAR,
        COS,
        COV,
        CUMMAX,
        CUMMIN,
        CUMPROD,
        CUMSUM,
        DIAG,
        EIGEN,
        CONV2D,
        CONV2D_BACKWARD_FILTER,
        CONV2D_BACKWARD_DATA,
        BIAS_ADD,
        BIAS_MULTIPLY,
        MAX_POOL,
        AVG_POOL,
        MAX_POOL_BACKWARD,
        EXP,
        FLOOR,
        INTERQUANTILE,
        INVERSE,
        IQM,
        LENGTH,
        LOG,
        LU,
        MAX,
        MEAN,
        MEDIAN,
        MIN,
        MOMENT,
        NCOL,
        NROW,
        OUTER,
        PPRED,
        PROD,
        QR,
        QUANTILE,
        RANGE,
        RBIND,
        REV,
        ROUND,
        ROWINDEXMAX,
        ROWINDEXMIN,
        ROWMAX,
        ROWMEAN,
        ROWMIN,
        ROWSD,
        ROWSUM,
        ROWVAR,
        SAMPLE,
        SD,
        SEQ,
        SIN,
        SIGN,
        SOLVE,
        SQRT,
        SUM,
        TABLE,
        TAN,
        TRACE,
        TRANS,
        VAR;

    }

    public static enum BooleanOp {
        CONDITIONALAND,
        CONDITIONALOR,
        LOGICALAND,
        LOGICALOR,
        NOT,
        INVALID;

    }

    public static enum RelationalOp {
        LESSEQUAL,
        LESS,
        GREATEREQUAL,
        GREATER,
        EQUAL,
        NOTEQUAL,
        INVALID;

    }

    public static enum BinaryOp {
        PLUS,
        MINUS,
        MULT,
        DIV,
        MODULUS,
        INTDIV,
        MATMULT,
        POW,
        INVALID;

    }

    public static enum Kind {
        BinaryOp,
        BooleanOp,
        BuiltinFunctionOp,
        ParameterizedBuiltinFunctionOp,
        DataOp,
        Data,
        RelationalOp,
        FunctionCallOp;

    }
}

