/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.parser;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysml.api.DMLScript;
import org.apache.sysml.conf.DMLConfig;
import org.apache.sysml.lops.Lop;
import org.apache.sysml.lops.LopProperties;
import org.apache.sysml.lops.LopsException;
import org.apache.sysml.lops.compile.Dag;
import org.apache.sysml.parser.Expression;
import org.apache.sysml.parser.ExternalFunctionStatement;
import org.apache.sysml.parser.ForStatement;
import org.apache.sysml.parser.ForStatementBlock;
import org.apache.sysml.parser.FunctionStatement;
import org.apache.sysml.parser.FunctionStatementBlock;
import org.apache.sysml.parser.IfStatement;
import org.apache.sysml.parser.IfStatementBlock;
import org.apache.sysml.parser.IterablePredicate;
import org.apache.sysml.parser.LanguageException;
import org.apache.sysml.parser.ParForStatementBlock;
import org.apache.sysml.parser.StatementBlock;
import org.apache.sysml.parser.VariableSet;
import org.apache.sysml.parser.WhileStatement;
import org.apache.sysml.parser.WhileStatementBlock;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.ExternalFunctionProgramBlock;
import org.apache.sysml.runtime.controlprogram.ExternalFunctionProgramBlockCP;
import org.apache.sysml.runtime.controlprogram.ForProgramBlock;
import org.apache.sysml.runtime.controlprogram.FunctionProgramBlock;
import org.apache.sysml.runtime.controlprogram.IfProgramBlock;
import org.apache.sysml.runtime.controlprogram.ParForProgramBlock;
import org.apache.sysml.runtime.controlprogram.Program;
import org.apache.sysml.runtime.controlprogram.ProgramBlock;
import org.apache.sysml.runtime.controlprogram.WhileProgramBlock;
import org.apache.sysml.runtime.instructions.CPInstructionParser;
import org.apache.sysml.runtime.instructions.Instruction;
import org.apache.sysml.runtime.instructions.cp.CPInstruction;

public class DMLProgram {
    private ArrayList<StatementBlock> _blocks = new ArrayList();
    private HashMap<String, FunctionStatementBlock> _functionBlocks = new HashMap();
    private HashMap<String, DMLProgram> _namespaces = new HashMap();
    public static String DEFAULT_NAMESPACE = ".defaultNS";
    public static String INTERNAL_NAMESPACE = "_internal";
    private static final Log LOG = LogFactory.getLog((String)DMLProgram.class.getName());

    public HashMap<String, DMLProgram> getNamespaces() {
        return this._namespaces;
    }

    public void addStatementBlock(StatementBlock b) {
        this._blocks.add(b);
    }

    public int getNumStatementBlocks() {
        return this._blocks.size();
    }

    public FunctionStatementBlock getFunctionStatementBlock(String fkey) {
        String[] tmp = DMLProgram.splitFunctionKey(fkey);
        return this.getFunctionStatementBlock(tmp[0], tmp[1]);
    }

    public FunctionStatementBlock getFunctionStatementBlock(String namespaceKey, String functionName) {
        DMLProgram namespaceProgram = this.getNamespaces().get(namespaceKey);
        if (namespaceProgram == null) {
            return null;
        }
        FunctionStatementBlock retVal = namespaceProgram._functionBlocks.get(functionName);
        return retVal;
    }

    public HashMap<String, FunctionStatementBlock> getFunctionStatementBlocks(String namespaceKey) throws LanguageException {
        DMLProgram namespaceProgram = this.getNamespaces().get(namespaceKey);
        if (namespaceProgram == null) {
            LOG.error((Object)("ERROR: namespace " + namespaceKey + " is undefined"));
            throw new LanguageException("ERROR: namespace " + namespaceKey + " is undefined");
        }
        return namespaceProgram._functionBlocks;
    }

    public boolean hasFunctionStatementBlocks() {
        boolean ret = false;
        for (DMLProgram nsProg : this._namespaces.values()) {
            ret |= !nsProg._functionBlocks.isEmpty();
        }
        return ret;
    }

    public ArrayList<FunctionStatementBlock> getFunctionStatementBlocks() throws LanguageException {
        ArrayList<FunctionStatementBlock> ret = new ArrayList<FunctionStatementBlock>();
        for (DMLProgram nsProg : this._namespaces.values()) {
            ret.addAll(nsProg._functionBlocks.values());
        }
        return ret;
    }

    public void addFunctionStatementBlock(String namespace, String fname, FunctionStatementBlock fsb) throws LanguageException {
        DMLProgram namespaceProgram = this.getNamespaces().get(namespace);
        if (namespaceProgram == null) {
            throw new LanguageException("Namespace does not exist.");
        }
        namespaceProgram._functionBlocks.put(fname, fsb);
    }

    public ArrayList<StatementBlock> getStatementBlocks() {
        return this._blocks;
    }

    public void setStatementBlocks(ArrayList<StatementBlock> passed) {
        this._blocks = passed;
    }

    public StatementBlock getStatementBlock(int i) {
        return this._blocks.get(i);
    }

    public void mergeStatementBlocks() {
        this._blocks = StatementBlock.mergeStatementBlocks(this._blocks);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (String namespaceKey : this.getNamespaces().keySet()) {
            sb.append("NAMESPACE = " + namespaceKey + "\n");
            DMLProgram namespaceProg = this.getNamespaces().get(namespaceKey);
            sb.append("FUNCTIONS = ");
            for (FunctionStatementBlock fsb : namespaceProg._functionBlocks.values()) {
                sb.append(fsb);
                sb.append(", ");
            }
            sb.append("\n");
            sb.append("********************************** \n");
        }
        sb.append("******** MAIN SCRIPT BODY ******** \n");
        for (StatementBlock b : this._blocks) {
            sb.append(b);
            sb.append("\n");
        }
        sb.append("********************************** \n");
        return sb.toString();
    }

    public Program getRuntimeProgram(DMLConfig config) throws IOException, LanguageException, DMLRuntimeException, LopsException {
        Program rtprog = new Program();
        for (String namespace : this._namespaces.keySet()) {
            for (String fname : this.getFunctionStatementBlocks(namespace).keySet()) {
                FunctionStatementBlock fsb = this.getFunctionStatementBlocks(namespace).get(fname);
                FunctionProgramBlock rtpb = (FunctionProgramBlock)this.createRuntimeProgramBlock(rtprog, fsb, config);
                rtprog.addFunctionProgramBlock(namespace, fname, rtpb);
                rtpb.setRecompileOnce(fsb.isRecompileOnce());
            }
        }
        for (StatementBlock sb : this._blocks) {
            ProgramBlock rtpb = this.createRuntimeProgramBlock(rtprog, sb, config);
            rtprog.addProgramBlock(rtpb);
        }
        return rtprog;
    }

    public ProgramBlock createRuntimeProgramBlock(Program prog, StatementBlock sb, DMLConfig config) throws IOException, LopsException, DMLRuntimeException {
        Dag<Lop> dag = null;
        Dag<Lop> pred_dag = null;
        ArrayList<Instruction> pred_instruct = null;
        Object retPB = null;
        if (sb instanceof WhileStatementBlock) {
            WhileStatementBlock wsb;
            pred_dag = new Dag<Lop>();
            ((WhileStatementBlock)sb).get_predicateLops().addToDag(pred_dag);
            pred_instruct = new ArrayList<Instruction>();
            ArrayList<Instruction> pInst = pred_dag.getJobs(null, config);
            for (Instruction i : pInst) {
                pred_instruct.add(i);
            }
            WhileProgramBlock rtpb = new WhileProgramBlock(prog, pred_instruct);
            if (rtpb.getPredicateResultVar() == null) {
                if (((WhileStatementBlock)sb).get_predicateLops().getExecLocation() == LopProperties.ExecLocation.Data) {
                    String resultVar = ((WhileStatementBlock)sb).get_predicateLops().getOutputParameters().getLabel();
                    rtpb.setPredicateResultVar(resultVar);
                } else {
                    LOG.error((Object)(sb.printBlockErrorLocation() + "Error in translating the WHILE predicate."));
                    throw new LopsException(sb.printBlockErrorLocation() + "Error in translating the WHILE predicate.");
                }
            }
            if ((wsb = (WhileStatementBlock)sb).getNumStatements() > 1) {
                LOG.error((Object)(wsb.printBlockErrorLocation() + "WhileStatementBlock should only have 1 statement"));
                throw new LopsException(wsb.printBlockErrorLocation() + "WhileStatementBlock should only have 1 statement");
            }
            WhileStatement wstmt = (WhileStatement)wsb.getStatement(0);
            for (StatementBlock sblock : wstmt.getBody()) {
                ProgramBlock childBlock = this.createRuntimeProgramBlock(prog, sblock, config);
                rtpb.addProgramBlock(childBlock);
            }
            if (wsb.getLops() != null && !wsb.getLops().isEmpty()) {
                LOG.error((Object)(wsb.printBlockErrorLocation() + "WhileStatementBlock should have no Lops"));
                throw new LopsException(wsb.printBlockErrorLocation() + "WhileStatementBlock should have no Lops");
            }
            retPB = rtpb;
            ((ProgramBlock)retPB).setStatementBlock(sb);
            ((ProgramBlock)retPB).setAllPositions(sb.getBeginLine(), sb.getBeginColumn(), sb.getEndLine(), sb.getEndColumn());
        } else if (sb instanceof IfStatementBlock) {
            ProgramBlock childBlock;
            IfStatementBlock isb;
            pred_dag = new Dag();
            ((IfStatementBlock)sb).get_predicateLops().addToDag(pred_dag);
            pred_instruct = new ArrayList();
            ArrayList<Instruction> pInst = pred_dag.getJobs(null, config);
            for (Instruction i : pInst) {
                pred_instruct.add(i);
            }
            IfProgramBlock rtpb = new IfProgramBlock(prog, pred_instruct);
            if (rtpb.getPredicateResultVar() == null) {
                if (((IfStatementBlock)sb).get_predicateLops().getExecLocation() == LopProperties.ExecLocation.Data) {
                    String resultVar = ((IfStatementBlock)sb).get_predicateLops().getOutputParameters().getLabel();
                    rtpb.setPredicateResultVar(resultVar);
                } else {
                    LOG.error((Object)(sb.printBlockErrorLocation() + "Error in translating the IF predicate."));
                    throw new LopsException(sb.printBlockErrorLocation() + "Error in translating the IF predicate.");
                }
            }
            if ((isb = (IfStatementBlock)sb).getNumStatements() > 1) {
                LOG.error((Object)(isb.printBlockErrorLocation() + "IfStatementBlock should have only 1 statement"));
                throw new LopsException(isb.printBlockErrorLocation() + "IfStatementBlock should have only 1 statement");
            }
            IfStatement istmt = (IfStatement)isb.getStatement(0);
            for (StatementBlock sblock : istmt.getIfBody()) {
                childBlock = this.createRuntimeProgramBlock(prog, sblock, config);
                rtpb.addProgramBlockIfBody(childBlock);
            }
            for (StatementBlock sblock : istmt.getElseBody()) {
                childBlock = this.createRuntimeProgramBlock(prog, sblock, config);
                rtpb.addProgramBlockElseBody(childBlock);
            }
            if (isb.getLops() != null && !isb.getLops().isEmpty()) {
                LOG.error((Object)(isb.printBlockErrorLocation() + "IfStatementBlock should have no Lops"));
                throw new LopsException(isb.printBlockErrorLocation() + "IfStatementBlock should have no Lops");
            }
            retPB = rtpb;
            ((ProgramBlock)retPB).setStatementBlock(sb);
            ((ProgramBlock)retPB).setAllPositions(sb.getBeginLine(), sb.getBeginColumn(), sb.getEndLine(), sb.getEndColumn());
        } else if (sb instanceof ForStatementBlock) {
            ForStatementBlock fsb = (ForStatementBlock)sb;
            Dag<Lop> fromDag = new Dag<Lop>();
            Dag<Lop> toDag = new Dag<Lop>();
            Dag<Lop> incrementDag = new Dag<Lop>();
            if (fsb.getFromHops() != null) {
                fsb.getFromLops().addToDag(fromDag);
            }
            if (fsb.getToHops() != null) {
                fsb.getToLops().addToDag(toDag);
            }
            if (fsb.getIncrementHops() != null) {
                fsb.getIncrementLops().addToDag(incrementDag);
            }
            ArrayList<Instruction> fromInstructions = fromDag.getJobs(null, config);
            ArrayList<Instruction> toInstructions = toDag.getJobs(null, config);
            ArrayList<Instruction> incrementInstructions = incrementDag.getJobs(null, config);
            String sbName = null;
            ForProgramBlock rtpb = null;
            IterablePredicate iterPred = fsb.getIterPredicate();
            String[] iterPredData = IterablePredicate.createIterablePredicateVariables(iterPred.getIterVar().getName(), fsb.getFromLops(), fsb.getToLops(), fsb.getIncrementLops());
            if (sb instanceof ParForStatementBlock) {
                sbName = "ParForStatementBlock";
                rtpb = new ParForProgramBlock(prog, iterPredData, iterPred.getParForParams());
                ParForProgramBlock pfrtpb = (ParForProgramBlock)rtpb;
                pfrtpb.setResultVariables(((ParForStatementBlock)sb).getResultVariables());
                pfrtpb.setStatementBlock((ParForStatementBlock)sb);
            } else {
                sbName = "ForStatementBlock";
                rtpb = new ForProgramBlock(prog, iterPredData);
            }
            rtpb.setFromInstructions(fromInstructions);
            rtpb.setToInstructions(toInstructions);
            rtpb.setIncrementInstructions(incrementInstructions);
            rtpb.setIterablePredicateVars(iterPredData);
            if (fsb.getNumStatements() > 1) {
                LOG.error((Object)(fsb.printBlockErrorLocation() + " " + sbName + " should have 1 statement"));
                throw new LopsException(fsb.printBlockErrorLocation() + " " + sbName + " should have 1 statement");
            }
            ForStatement fs = (ForStatement)fsb.getStatement(0);
            for (StatementBlock sblock : fs.getBody()) {
                ProgramBlock childBlock = this.createRuntimeProgramBlock(prog, sblock, config);
                rtpb.addProgramBlock(childBlock);
            }
            if (fsb.getLops() != null && !fsb.getLops().isEmpty()) {
                LOG.error((Object)(fsb.printBlockErrorLocation() + sbName + " should have no Lops"));
                throw new LopsException(fsb.printBlockErrorLocation() + sbName + " should have no Lops");
            }
            retPB = rtpb;
            ((ProgramBlock)retPB).setStatementBlock(sb);
            ((ProgramBlock)retPB).setAllPositions(sb.getBeginLine(), sb.getBeginColumn(), sb.getEndLine(), sb.getEndColumn());
        } else if (sb instanceof FunctionStatementBlock) {
            FunctionStatementBlock fsb = (FunctionStatementBlock)sb;
            if (fsb.getNumStatements() > 1) {
                LOG.error((Object)(fsb.printBlockErrorLocation() + "FunctionStatementBlock should only have 1 statement"));
                throw new LopsException(fsb.printBlockErrorLocation() + "FunctionStatementBlock should only have 1 statement");
            }
            FunctionStatement fstmt = (FunctionStatement)fsb.getStatement(0);
            FunctionProgramBlock rtpb = null;
            if (fstmt instanceof ExternalFunctionStatement) {
                String execType = ((ExternalFunctionStatement)fstmt).getOtherParams().get("exectype");
                boolean isCP = execType.equals("mem");
                String scratchSpaceLoc = null;
                try {
                    scratchSpaceLoc = config.getTextValue("scratch");
                }
                catch (Exception e) {
                    LOG.error((Object)(fsb.printBlockErrorLocation() + "could not retrieve parameter " + "scratch" + " from DMLConfig"));
                }
                StringBuilder buff = new StringBuilder();
                buff.append(scratchSpaceLoc);
                buff.append("/");
                buff.append("_p");
                buff.append(DMLScript.getUUID());
                buff.append("/");
                buff.append("_t0");
                buff.append("/");
                buff.append("PackageSupport");
                buff.append("/");
                String basedir = buff.toString();
                rtpb = isCP ? new ExternalFunctionProgramBlockCP(prog, fstmt.getInputParams(), fstmt.getOutputParams(), ((ExternalFunctionStatement)fstmt).getOtherParams(), basedir) : new ExternalFunctionProgramBlock(prog, fstmt.getInputParams(), fstmt.getOutputParams(), ((ExternalFunctionStatement)fstmt).getOtherParams(), basedir);
                if (!fstmt.getBody().isEmpty()) {
                    LOG.error((Object)(fstmt.printErrorLocation() + "ExternalFunctionStatementBlock should have no statement blocks in body"));
                    throw new LopsException(fstmt.printErrorLocation() + "ExternalFunctionStatementBlock should have no statement blocks in body");
                }
            } else {
                rtpb = new FunctionProgramBlock(prog, fstmt.getInputParams(), fstmt.getOutputParams());
                for (StatementBlock sblock : fstmt.getBody()) {
                    ProgramBlock childBlock = this.createRuntimeProgramBlock(prog, sblock, config);
                    rtpb.addProgramBlock(childBlock);
                }
            }
            if (fsb.getLops() != null && !fsb.getLops().isEmpty()) {
                LOG.error((Object)(fsb.printBlockErrorLocation() + "FunctionStatementBlock should have no Lops"));
                throw new LopsException(fsb.printBlockErrorLocation() + "FunctionStatementBlock should have no Lops");
            }
            retPB = rtpb;
            ((ProgramBlock)retPB).setAllPositions(sb.getBeginLine(), sb.getBeginColumn(), sb.getEndLine(), sb.getEndColumn());
        } else {
            ProgramBlock rtpb = new ProgramBlock(prog);
            dag = new Dag<Lop>();
            if (sb.getLops() != null && !sb.getLops().isEmpty()) {
                for (Lop l : sb.getLops()) {
                    l.addToDag(dag);
                }
                ArrayList<Instruction> instruct = dag.getJobs(sb, config);
                rtpb.addInstructions(instruct);
            }
            retPB = rtpb;
            ((ProgramBlock)retPB).setStatementBlock(sb);
            ((ProgramBlock)retPB).setAllPositions(sb.getBeginLine(), sb.getBeginColumn(), sb.getEndLine(), sb.getEndColumn());
        }
        return retPB;
    }

    private ProgramBlock verifyAndCorrectProgramBlock(VariableSet in, VariableSet out, VariableSet kill, ProgramBlock pb) throws DMLRuntimeException {
        Instruction inst;
        boolean foundRMInst;
        Expression.DataType dt;
        for (String varName : in.getVariableNames()) {
            if (out.containsVariable(varName) || (dt = in.getVariable(varName).getDataType()) != Expression.DataType.MATRIX && dt != Expression.DataType.UNKNOWN || (foundRMInst = this.rContainsRMInstruction(pb, varName))) continue;
            inst = this.createCleanupInstruction(varName);
            inst.setLocation(in.getVariable(varName));
            this.addCleanupInstruction(pb, inst);
            LOG.trace((Object)("Adding instruction (r1) " + inst.toString()));
        }
        for (String varName : kill.getVariableNames()) {
            if (in.containsVariable(varName) || out.containsVariable(varName) || (dt = kill.getVariable(varName).getDataType()) != Expression.DataType.MATRIX && dt != Expression.DataType.UNKNOWN || (foundRMInst = this.rContainsRMInstruction(pb, varName))) continue;
            inst = this.createCleanupInstruction(varName);
            inst.setLocation(kill.getVariable(varName));
            this.addCleanupInstruction(pb, inst);
            LOG.trace((Object)("Adding instruction (r2) " + inst.toString()));
        }
        return pb;
    }

    private Instruction createCleanupInstruction(String varName) throws DMLRuntimeException {
        StringBuilder sb = new StringBuilder();
        sb.append("CP");
        sb.append("\u00b0");
        sb.append("rmvar");
        sb.append("\u00b0");
        sb.append(varName);
        String str = sb.toString();
        CPInstruction inst = CPInstructionParser.parseSingleInstruction(str);
        return inst;
    }

    private boolean rContainsRMInstruction(ProgramBlock pb, String varName) {
        block6: {
            block8: {
                block7: {
                    block5: {
                        if (!(pb instanceof WhileProgramBlock)) break block5;
                        WhileProgramBlock tmp = (WhileProgramBlock)pb;
                        for (ProgramBlock c : tmp.getChildBlocks()) {
                            if (!this.rContainsRMInstruction(c, varName)) continue;
                            return true;
                        }
                        break block6;
                    }
                    if (!(pb instanceof IfProgramBlock)) break block7;
                    IfProgramBlock tmp = (IfProgramBlock)pb;
                    for (ProgramBlock c : tmp.getChildBlocksIfBody()) {
                        if (!this.rContainsRMInstruction(c, varName)) continue;
                        return true;
                    }
                    for (ProgramBlock c : tmp.getChildBlocksElseBody()) {
                        if (!this.rContainsRMInstruction(c, varName)) continue;
                        return true;
                    }
                    break block6;
                }
                if (!(pb instanceof ForProgramBlock)) break block8;
                ForProgramBlock tmp = (ForProgramBlock)pb;
                for (ProgramBlock c : tmp.getChildBlocks()) {
                    if (!this.rContainsRMInstruction(c, varName)) continue;
                    return true;
                }
                break block6;
            }
            if (pb instanceof FunctionProgramBlock) break block6;
            for (Instruction inst : pb.getInstructions()) {
                String instStr = inst.toString();
                if (!instStr.contains("rmfilevar\u00b0" + varName) && !instStr.contains("rmvar\u00b0" + varName)) continue;
                return true;
            }
        }
        return false;
    }

    private void addCleanupInstruction(ProgramBlock pb, Instruction inst) throws DMLRuntimeException {
        if (pb instanceof WhileProgramBlock) {
            WhileProgramBlock wpb = (WhileProgramBlock)pb;
            ArrayList<ProgramBlock> childs = wpb.getChildBlocks();
            if (!childs.get(childs.size() - 1).getInstructions().isEmpty()) {
                childs.get(childs.size() - 1).addInstruction(inst);
            } else {
                ProgramBlock pbNew = new ProgramBlock(pb.getProgram());
                pbNew.addInstruction(inst);
                childs.add(pbNew);
            }
        } else if (pb instanceof ForProgramBlock) {
            ForProgramBlock wpb = (ForProgramBlock)pb;
            ArrayList<ProgramBlock> childs = wpb.getChildBlocks();
            if (!childs.get(childs.size() - 1).getInstructions().isEmpty()) {
                childs.get(childs.size() - 1).addInstruction(inst);
            } else {
                ProgramBlock pbNew = new ProgramBlock(pb.getProgram());
                pbNew.addInstruction(inst);
                childs.add(pbNew);
            }
        } else if (pb instanceof IfProgramBlock) {
            ((IfProgramBlock)pb).addExitInstruction(inst);
        } else if (!(pb instanceof FunctionProgramBlock)) {
            pb.addInstruction(inst);
        }
    }

    public static String constructFunctionKey(String fnamespace, String fname) {
        return fnamespace + "::" + fname;
    }

    public static String[] splitFunctionKey(String fkey) {
        return fkey.split("::");
    }
}

