/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.parser;

import java.util.HashMap;
import org.apache.sysml.parser.ConstIdentifier;
import org.apache.sysml.parser.DataIdentifier;
import org.apache.sysml.parser.Expression;
import org.apache.sysml.parser.FunctionCallIdentifier;
import org.apache.sysml.parser.Identifier;
import org.apache.sysml.parser.LanguageException;
import org.apache.sysml.parser.StringIdentifier;
import org.apache.sysml.parser.VariableSet;

public class BinaryExpression
extends Expression {
    private Expression _left;
    private Expression _right;
    private Expression.BinaryOp _opcode;

    @Override
    public Expression rewriteExpression(String prefix) throws LanguageException {
        BinaryExpression newExpr = new BinaryExpression(this._opcode, this.getFilename(), this.getBeginLine(), this.getBeginColumn(), this.getEndLine(), this.getEndColumn());
        newExpr.setLeft(this._left.rewriteExpression(prefix));
        newExpr.setRight(this._right.rewriteExpression(prefix));
        return newExpr;
    }

    public BinaryExpression(Expression.BinaryOp bop) {
        this._kind = Expression.Kind.BinaryOp;
        this._opcode = bop;
        this.setFilename("MAIN SCRIPT");
        this.setBeginLine(0);
        this.setBeginColumn(0);
        this.setEndLine(0);
        this.setEndColumn(0);
    }

    public BinaryExpression(Expression.BinaryOp bop, String filename, int beginLine, int beginColumn, int endLine, int endColumn) {
        this._kind = Expression.Kind.BinaryOp;
        this._opcode = bop;
        this.setFilename(filename);
        this.setBeginLine(beginLine);
        this.setBeginColumn(beginColumn);
        this.setEndLine(endLine);
        this.setEndColumn(endColumn);
    }

    public Expression.BinaryOp getOpCode() {
        return this._opcode;
    }

    public void setLeft(Expression l) {
        this._left = l;
        if (this._left != null) {
            this.setFilename(this._left.getFilename());
            this.setBeginLine(this._left.getBeginLine());
            this.setBeginColumn(this._left.getBeginColumn());
        }
    }

    public void setRight(Expression r) {
        this._right = r;
        if (this._right != null) {
            this.setFilename(this._right.getFilename());
            this.setBeginLine(this._right.getEndLine());
            this.setBeginColumn(this._right.getEndColumn());
        }
    }

    public Expression getLeft() {
        return this._left;
    }

    public Expression getRight() {
        return this._right;
    }

    @Override
    public void validateExpression(HashMap<String, DataIdentifier> ids, HashMap<String, ConstIdentifier> constVars, boolean conditional) throws LanguageException {
        if (this._left instanceof FunctionCallIdentifier || this._right instanceof FunctionCallIdentifier) {
            this.raiseValidateError("user-defined function calls not supported in binary expressions", false, "Unsupported Expression");
        }
        this._left.validateExpression(ids, constVars, conditional);
        this._right.validateExpression(ids, constVars, conditional);
        if (this._left instanceof DataIdentifier && constVars.containsKey(((DataIdentifier)this._left).getName())) {
            this._left = constVars.get(((DataIdentifier)this._left).getName());
        }
        if (this._right instanceof DataIdentifier && constVars.containsKey(((DataIdentifier)this._right).getName())) {
            this._right = constVars.get(((DataIdentifier)this._right).getName());
        }
        String outputName = BinaryExpression.getTempName();
        DataIdentifier output = new DataIdentifier(outputName);
        output.setAllPositions(this.getFilename(), this.getBeginLine(), this.getBeginColumn(), this.getEndLine(), this.getEndColumn());
        output.setDataType(BinaryExpression.computeDataType(this.getLeft(), this.getRight(), true));
        Expression.ValueType resultVT = BinaryExpression.computeValueType(this.getLeft(), this.getRight(), true);
        if (this.getOpCode() == Expression.BinaryOp.POW || this.getOpCode() == Expression.BinaryOp.DIV) {
            resultVT = Expression.ValueType.DOUBLE;
        }
        output.setValueType(resultVT);
        this.checkAndSetDimensions(output, conditional);
        if (this.getOpCode() == Expression.BinaryOp.MATMULT) {
            if (this.getLeft().getOutput().getDataType() != Expression.DataType.MATRIX || this.getRight().getOutput().getDataType() != Expression.DataType.MATRIX) {
                // empty if block
            }
            if (this.getLeft().getOutput().getDim2() != -1L && this.getRight().getOutput().getDim1() != -1L && this.getLeft().getOutput().getDim2() != this.getRight().getOutput().getDim1()) {
                this.raiseValidateError("invalid dimensions for matrix multiplication (k1=" + this.getLeft().getOutput().getDim2() + ", k2=" + this.getRight().getOutput().getDim1() + ")", conditional, "Invalid Parameters");
            }
            output.setDimensions(this.getLeft().getOutput().getDim1(), this.getRight().getOutput().getDim2());
        }
        this.setOutput(output);
    }

    private void checkAndSetDimensions(DataIdentifier output, boolean conditional) throws LanguageException {
        Identifier left = this.getLeft().getOutput();
        Identifier right = this.getRight().getOutput();
        Identifier pivot = null;
        Identifier aux = null;
        if (left.getDataType() == Expression.DataType.MATRIX) {
            pivot = left;
            if (right.getDataType() == Expression.DataType.MATRIX) {
                aux = right;
            }
        } else if (right.getDataType() == Expression.DataType.MATRIX) {
            pivot = right;
        }
        if (pivot != null && aux != null && BinaryExpression.isSameDimensionBinaryOp(this.getOpCode()) && pivot.dimsKnown() && aux.dimsKnown() && (pivot.getDim1() != aux.getDim1() && aux.getDim1() > 1L || pivot.getDim2() != aux.getDim2() && aux.getDim2() > 1L)) {
            this.raiseValidateError("Mismatch in dimensions for operation " + this.toString(), conditional, "Invalid Parameters");
        }
        if (pivot != null) {
            output.setDimensions(pivot.getDim1(), pivot.getDim2());
        }
    }

    public String toString() {
        String leftString = this._left instanceof StringIdentifier ? "\"" + this._left.toString() + "\"" : this._left.toString();
        String rightString = this._right instanceof StringIdentifier ? "\"" + this._right.toString() + "\"" : this._right.toString();
        return "(" + leftString + " " + this._opcode.toString() + " " + rightString + ")";
    }

    @Override
    public VariableSet variablesRead() {
        VariableSet result = new VariableSet();
        result.addVariables(this._left.variablesRead());
        result.addVariables(this._right.variablesRead());
        return result;
    }

    @Override
    public VariableSet variablesUpdated() {
        VariableSet result = new VariableSet();
        result.addVariables(this._left.variablesUpdated());
        result.addVariables(this._right.variablesUpdated());
        return result;
    }

    public static boolean isSameDimensionBinaryOp(Expression.BinaryOp op) {
        return op == Expression.BinaryOp.PLUS || op == Expression.BinaryOp.MINUS || op == Expression.BinaryOp.MULT || op == Expression.BinaryOp.DIV || op == Expression.BinaryOp.MODULUS || op == Expression.BinaryOp.INTDIV || op == Expression.BinaryOp.POW;
    }
}

