/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.lops;

import java.util.HashMap;
import java.util.Map;
import org.apache.sysml.hops.HopsException;
import org.apache.sysml.lops.Lop;
import org.apache.sysml.lops.LopProperties;
import org.apache.sysml.lops.LopsException;
import org.apache.sysml.lops.compile.JobType;
import org.apache.sysml.parser.Expression;

public class ParameterizedBuiltin
extends Lop {
    private OperationTypes _operation;
    private HashMap<String, Lop> _inputParams;
    private boolean _bRmEmptyBC;

    public ParameterizedBuiltin(HashMap<String, Lop> paramLops, OperationTypes op, Expression.DataType dt, Expression.ValueType vt, LopProperties.ExecType et) throws HopsException {
        super(Lop.Type.ParameterizedBuiltin, dt, vt);
        this._operation = op;
        for (Lop lop : paramLops.values()) {
            this.addInput(lop);
            lop.addOutput(this);
        }
        this._inputParams = paramLops;
        boolean breaksAlignment = false;
        boolean aligner = false;
        boolean definesMRJob = false;
        LopProperties.ExecLocation eloc = null;
        if (this._operation == OperationTypes.REPLACE && et == LopProperties.ExecType.MR) {
            eloc = LopProperties.ExecLocation.MapOrReduce;
            this.lps.addCompatibility(JobType.GMR);
            this.lps.addCompatibility(JobType.DATAGEN);
            this.lps.addCompatibility(JobType.REBLOCK);
        } else if (this._operation == OperationTypes.RMEMPTY && et == LopProperties.ExecType.MR) {
            eloc = LopProperties.ExecLocation.Reduce;
            this.lps.addCompatibility(JobType.GMR);
            this.lps.addCompatibility(JobType.DATAGEN);
            this.lps.addCompatibility(JobType.REBLOCK);
            breaksAlignment = true;
        } else if (this._operation == OperationTypes.REXPAND && et == LopProperties.ExecType.MR) {
            eloc = LopProperties.ExecLocation.MapOrReduce;
            this.lps.addCompatibility(JobType.GMR);
            this.lps.addCompatibility(JobType.DATAGEN);
            this.lps.addCompatibility(JobType.REBLOCK);
            breaksAlignment = true;
        } else if (this._operation == OperationTypes.TRANSFORM && et == LopProperties.ExecType.MR) {
            definesMRJob = true;
            eloc = LopProperties.ExecLocation.MapAndReduce;
            this.lps.addCompatibility(JobType.TRANSFORM);
        } else {
            eloc = LopProperties.ExecLocation.ControlProgram;
            this.lps.addCompatibility(JobType.INVALID);
        }
        this.lps.setProperties(this.inputs, et, eloc, breaksAlignment, aligner, definesMRJob);
    }

    public ParameterizedBuiltin(HashMap<String, Lop> paramLops, OperationTypes op, Expression.DataType dt, Expression.ValueType vt, LopProperties.ExecType et, boolean bRmEmptyBC) throws HopsException {
        this(paramLops, op, dt, vt, et);
        this._bRmEmptyBC = bRmEmptyBC;
    }

    public OperationTypes getOp() {
        return this._operation;
    }

    public int getInputIndex(String name) {
        Lop n = this._inputParams.get(name);
        for (int i = 0; i < this.getInputs().size(); ++i) {
            if (this.getInputs().get(i) != n) continue;
            return i;
        }
        return -1;
    }

    public Lop getNamedInput(String name) {
        return this._inputParams.get(name);
    }

    @Override
    public String getInstructions(String output) throws LopsException {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.getExecType());
        sb.append("\u00b0");
        switch (this._operation) {
            case CDF: 
            case INVCDF: {
                sb.append(this._operation == OperationTypes.CDF ? "cdf" : "invcdf");
                sb.append("\u00b0");
                for (String s : this._inputParams.keySet()) {
                    sb.append(s);
                    sb.append("=");
                    Lop iLop = this._inputParams.get(s);
                    sb.append(iLop.prepScalarLabel());
                    sb.append("\u00b0");
                }
                break;
            }
            case RMEMPTY: {
                sb.append("rmempty");
                sb.append("\u00b0");
                for (String s : this._inputParams.keySet()) {
                    sb.append(s);
                    sb.append("=");
                    Lop iLop = this._inputParams.get(s);
                    if (s.equals("target") || s.equals("select") || this.getExecType() == LopProperties.ExecType.SPARK) {
                        sb.append(iLop.getOutputParameters().getLabel());
                    } else {
                        sb.append(iLop.prepScalarLabel());
                    }
                    sb.append("\u00b0");
                }
                break;
            }
            case REPLACE: {
                sb.append("replace");
                sb.append("\u00b0");
                sb.append(ParameterizedBuiltin.compileGenericParamMap(this._inputParams));
                break;
            }
            case REXPAND: {
                sb.append("rexpand");
                sb.append("\u00b0");
                for (String s : this._inputParams.keySet()) {
                    sb.append(s);
                    sb.append("=");
                    Lop iLop = this._inputParams.get(s);
                    if (s.equals("target") || this.getExecType() == LopProperties.ExecType.SPARK) {
                        sb.append(iLop.getOutputParameters().getLabel());
                    } else {
                        sb.append(iLop.prepScalarLabel());
                    }
                    sb.append("\u00b0");
                }
                break;
            }
            case TRANSFORM: 
            case TRANSFORMAPPLY: 
            case TRANSFORMDECODE: 
            case TRANSFORMMETA: {
                sb.append(this._operation.toString().toLowerCase());
                sb.append("\u00b0");
                sb.append(ParameterizedBuiltin.compileGenericParamMap(this._inputParams));
                break;
            }
            case TOSTRING: {
                sb.append("toString");
                sb.append("\u00b0");
                sb.append(ParameterizedBuiltin.compileGenericParamMap(this._inputParams));
                break;
            }
            default: {
                throw new LopsException(this.printErrorLocation() + "In ParameterizedBuiltin Lop, Unknown operation: " + (Object)((Object)this._operation));
            }
        }
        if (this._operation == OperationTypes.RMEMPTY) {
            sb.append("bRmEmptyBC");
            sb.append("=");
            sb.append(this._bRmEmptyBC);
            sb.append("\u00b0");
        }
        sb.append(this.prepOutputOperand(output));
        return sb.toString();
    }

    @Override
    public String getInstructions(int input_index1, int input_index2, int input_index3, int output_index) throws LopsException {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.getExecType());
        sb.append("\u00b0");
        switch (this._operation) {
            case REPLACE: {
                sb.append("replace");
                sb.append("\u00b0");
                Lop iLop = this._inputParams.get("target");
                int pos = this.getInputs().indexOf(iLop);
                int index = pos == 0 ? input_index1 : (pos == 1 ? input_index2 : input_index3);
                sb.append(this.prepInputOperand(index));
                sb.append("\u00b0");
                Lop iLop2 = this._inputParams.get("pattern");
                sb.append(iLop2.prepScalarLabel());
                sb.append("\u00b0");
                Lop iLop3 = this._inputParams.get("replacement");
                sb.append(iLop3.prepScalarLabel());
                sb.append("\u00b0");
                break;
            }
            default: {
                throw new LopsException(this.printErrorLocation() + "In ParameterizedBuiltin Lop, Unknown operation: " + (Object)((Object)this._operation));
            }
        }
        sb.append(this.prepOutputOperand(output_index));
        return sb.toString();
    }

    @Override
    public String getInstructions(int input_index1, int input_index2, int input_index3, int input_index4, int output_index) throws LopsException {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.getExecType());
        sb.append("\u00b0");
        switch (this._operation) {
            case RMEMPTY: {
                sb.append("rmempty");
                sb.append("\u00b0");
                Lop iLop1 = this._inputParams.get("target");
                int pos1 = this.getInputs().indexOf(iLop1);
                int index1 = pos1 == 0 ? input_index1 : (pos1 == 1 ? input_index2 : (pos1 == 2 ? input_index3 : input_index4));
                sb.append(this.prepInputOperand(index1));
                sb.append("\u00b0");
                Lop iLop2 = this._inputParams.get("offset");
                int pos2 = this.getInputs().indexOf(iLop2);
                int index2 = pos2 == 0 ? input_index1 : (pos2 == 1 ? input_index2 : (pos1 == 2 ? input_index3 : input_index4));
                sb.append(this.prepInputOperand(index2));
                sb.append("\u00b0");
                Lop iLop3 = this._inputParams.get("maxdim");
                sb.append(iLop3.prepScalarLabel());
                sb.append("\u00b0");
                Lop iLop4 = this._inputParams.get("margin");
                sb.append(iLop4.prepScalarLabel());
                sb.append("\u00b0");
                break;
            }
            default: {
                throw new LopsException(this.printErrorLocation() + "In ParameterizedBuiltin Lop, Unknown operation: " + (Object)((Object)this._operation));
            }
        }
        sb.append(this.prepOutputOperand(output_index));
        return sb.toString();
    }

    @Override
    public String getInstructions(int input_index1, int input_index2, int input_index3, int input_index4, int input_index5, int output_index) throws LopsException {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.getExecType());
        sb.append("\u00b0");
        switch (this._operation) {
            case REXPAND: {
                sb.append("rexpand");
                sb.append("\u00b0");
                Lop iLop1 = this._inputParams.get("target");
                int pos1 = this.getInputs().indexOf(iLop1);
                int index1 = pos1 == 0 ? input_index1 : (pos1 == 1 ? input_index2 : (pos1 == 2 ? input_index3 : (pos1 == 3 ? input_index4 : input_index5)));
                sb.append(this.prepInputOperand(index1));
                sb.append("\u00b0");
                Lop iLop2 = this._inputParams.get("max");
                sb.append(iLop2.prepScalarLabel());
                sb.append("\u00b0");
                Lop iLop3 = this._inputParams.get("dir");
                sb.append(iLop3.prepScalarLabel());
                sb.append("\u00b0");
                Lop iLop4 = this._inputParams.get("cast");
                sb.append(iLop4.prepScalarLabel());
                sb.append("\u00b0");
                Lop iLop5 = this._inputParams.get("ignore");
                sb.append(iLop5.prepScalarLabel());
                sb.append("\u00b0");
                break;
            }
            default: {
                throw new LopsException(this.printErrorLocation() + "In ParameterizedBuiltin Lop, Unknown operation: " + (Object)((Object)this._operation));
            }
        }
        sb.append(this.prepOutputOperand(output_index));
        return sb.toString();
    }

    @Override
    public String getInstructions(int output_index) throws LopsException {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.getExecType());
        sb.append("\u00b0");
        if (this._operation == OperationTypes.TRANSFORM) {
            Lop iLop4;
            Lop iLop3b;
            sb.append("transform");
            sb.append("\u00b0");
            Lop iLop = this._inputParams.get("target");
            sb.append(iLop.prepInputOperand(this.getInputIndex("target")));
            sb.append("\u00b0");
            Lop iLop2 = this._inputParams.get("transformPath");
            sb.append(iLop2.prepScalarLabel());
            sb.append("\u00b0");
            Lop iLop3a = this._inputParams.get("applyTransformPath");
            if (iLop3a != null) {
                sb.append("applymtd=");
                sb.append(iLop3a.prepScalarLabel());
                sb.append("\u00b0");
            }
            if ((iLop3b = this._inputParams.get("spec")) != null) {
                sb.append("spec=");
                sb.append(iLop3b.prepScalarLabel());
                sb.append("\u00b0");
            }
            if ((iLop4 = this._inputParams.get("outputNames")) != null) {
                sb.append("outnames=");
                sb.append(iLop4.prepScalarLabel());
                sb.append("\u00b0");
            }
        } else {
            throw new LopsException(this.printErrorLocation() + "In ParameterizedBuiltin Lop, Unknown operation: " + (Object)((Object)this._operation));
        }
        sb.append(this.prepOutputOperand(output_index));
        return sb.toString();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._operation.toString());
        if (!this.getInputs().isEmpty()) {
            sb.append("(");
        }
        for (Lop cur : this.getInputs()) {
            sb.append(cur.toString());
        }
        if (!this.getInputs().isEmpty()) {
            sb.append(") ");
        }
        sb.append(" ; num_rows=" + this.getOutputParameters().getNumRows());
        sb.append(" ; num_cols=" + this.getOutputParameters().getNumCols());
        sb.append(" ; format=" + (Object)((Object)this.getOutputParameters().getFormat()));
        sb.append(" ; blocked=" + this.getOutputParameters().isBlocked());
        return sb.toString();
    }

    private static String compileGenericParamMap(HashMap<String, Lop> params) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Lop> e : params.entrySet()) {
            sb.append(e.getKey());
            sb.append("=");
            if (e.getValue().getDataType() != Expression.DataType.SCALAR) {
                sb.append(e.getValue().getOutputParameters().getLabel());
            } else {
                sb.append(e.getValue().prepScalarLabel());
            }
            sb.append("\u00b0");
        }
        return sb.toString();
    }

    public static enum OperationTypes {
        CDF,
        INVCDF,
        RMEMPTY,
        REPLACE,
        REXPAND,
        TRANSFORM,
        TRANSFORMAPPLY,
        TRANSFORMDECODE,
        TRANSFORMMETA,
        TOSTRING;

    }
}

