/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.lops;

import org.apache.sysml.lops.Lop;
import org.apache.sysml.lops.LopProperties;
import org.apache.sysml.lops.LopsException;
import org.apache.sysml.lops.compile.JobType;
import org.apache.sysml.parser.Expression;

public class MultipleCP
extends Lop {
    OperationType operationType;

    public MultipleCP(OperationType operationType, Expression.DataType dt, Expression.ValueType vt, Lop ... inputLops) {
        super(Lop.Type.MULTIPLE_CP, dt, vt);
        this.operationType = operationType;
        for (Lop inputLop : inputLops) {
            this.addInput(inputLop);
            inputLop.addOutput(this);
        }
        boolean breaksAlignment = false;
        boolean aligner = false;
        boolean definesMRJob = false;
        this.lps.addCompatibility(JobType.INVALID);
        this.lps.setProperties(this.inputs, LopProperties.ExecType.CP, LopProperties.ExecLocation.ControlProgram, breaksAlignment, aligner, definesMRJob);
    }

    @Override
    public String toString() {
        return "Operation Type: " + (Object)((Object)this.operationType);
    }

    public OperationType getOperationType() {
        return this.operationType;
    }

    @Override
    public String getInstructions(String output) throws LopsException {
        String opString = this.getOpcode();
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.getExecType());
        sb.append("\u00b0");
        sb.append(opString);
        sb.append("\u00b0");
        for (Lop input : this.inputs) {
            sb.append(input.prepScalarInputOperand(this.getExecType()));
            sb.append("\u00b0");
        }
        sb.append(this.prepOutputOperand(output));
        return sb.toString();
    }

    private String getOpcode() throws LopsException {
        switch (this.operationType) {
            case PRINTF: {
                return OperationType.PRINTF.toString().toLowerCase();
            }
        }
        throw new UnsupportedOperationException("MultipleCP operation type (" + (Object)((Object)this.operationType) + ") is not defined.");
    }

    public static enum OperationType {
        PRINTF;

    }
}

