/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.hops.rewrite;

import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysml.hops.Hop;
import org.apache.sysml.hops.HopsException;
import org.apache.sysml.hops.IndexingOp;
import org.apache.sysml.hops.LeftIndexingOp;
import org.apache.sysml.hops.LiteralOp;
import org.apache.sysml.hops.rewrite.HopRewriteRule;
import org.apache.sysml.hops.rewrite.HopRewriteUtils;
import org.apache.sysml.hops.rewrite.ProgramRewriteStatus;

public class RewriteIndexingVectorization
extends HopRewriteRule {
    private static final Log LOG = LogFactory.getLog((String)RewriteIndexingVectorization.class.getName());

    @Override
    public ArrayList<Hop> rewriteHopDAGs(ArrayList<Hop> roots, ProgramRewriteStatus state) throws HopsException {
        if (roots == null) {
            return roots;
        }
        for (Hop h : roots) {
            this.rule_IndexingVectorization(h);
        }
        return roots;
    }

    @Override
    public Hop rewriteHopDAG(Hop root, ProgramRewriteStatus state) throws HopsException {
        if (root == null) {
            return root;
        }
        this.rule_IndexingVectorization(root);
        return root;
    }

    private void rule_IndexingVectorization(Hop hop) throws HopsException {
        if (hop.isVisited()) {
            return;
        }
        for (int i = 0; i < hop.getInput().size(); ++i) {
            Hop hi = hop.getInput().get(i);
            this.vectorizeLeftIndexing(hi);
            this.rule_IndexingVectorization(hi);
        }
        hop.setVisited();
    }

    private void vectorizeRightIndexing(Hop hop) throws HopsException {
        if (hop instanceof IndexingOp) {
            Object newRix;
            ArrayList<Hop> ihops;
            Hop input;
            IndexingOp ihop0 = (IndexingOp)hop;
            boolean isSingleRow = ihop0.isRowLowerEqualsUpper();
            boolean isSingleCol = ihop0.isColLowerEqualsUpper();
            boolean appliedRow = false;
            if (isSingleRow && isSingleCol) {
                input = ihop0.getInput().get(0);
                ihops = new ArrayList<Hop>();
                ihops.add(ihop0);
                for (Hop hop2 : input.getParent()) {
                    if (hop2 == ihop0 || !(hop2 instanceof IndexingOp) || hop2.getInput().get(0) != input || !((IndexingOp)hop2).isRowLowerEqualsUpper() || hop2.getInput().get(1) != ihop0.getInput().get(1)) continue;
                    ihops.add(hop2);
                }
                if (ihops.size() > 1) {
                    newRix = new IndexingOp("tmp", input.getDataType(), input.getValueType(), input, ihop0.getInput().get(1), ihop0.getInput().get(1), new LiteralOp(1L), HopRewriteUtils.createValueHop(input, false), true, false);
                    HopRewriteUtils.setOutputParameters((Hop)newRix, -1L, -1L, input.getRowsInBlock(), input.getColsInBlock(), -1L);
                    ((IndexingOp)newRix).refreshSizeInformation();
                    for (Hop c : ihops) {
                        HopRewriteUtils.removeChildReference(c, input);
                        HopRewriteUtils.addChildReference(c, (Hop)newRix, 0);
                        HopRewriteUtils.removeChildReferenceByPos(c, c.getInput().get(1), 1);
                        HopRewriteUtils.addChildReference(c, new LiteralOp(1L), 1);
                        HopRewriteUtils.removeChildReferenceByPos(c, c.getInput().get(2), 2);
                        HopRewriteUtils.addChildReference(c, new LiteralOp(1L), 2);
                        c.refreshSizeInformation();
                    }
                    appliedRow = true;
                    LOG.debug((Object)"Applied vectorizeRightIndexingRow");
                }
            }
            if (isSingleRow && isSingleCol && !appliedRow) {
                input = ihop0.getInput().get(0);
                ihops = new ArrayList();
                ihops.add(ihop0);
                for (Hop hop3 : input.getParent()) {
                    if (hop3 == ihop0 || !(hop3 instanceof IndexingOp) || hop3.getInput().get(0) != input || !((IndexingOp)hop3).isColLowerEqualsUpper() || hop3.getInput().get(3) != ihop0.getInput().get(3)) continue;
                    ihops.add(hop3);
                }
                if (ihops.size() > 1) {
                    newRix = new IndexingOp("tmp", input.getDataType(), input.getValueType(), input, new LiteralOp(1L), HopRewriteUtils.createValueHop(input, true), ihop0.getInput().get(3), ihop0.getInput().get(3), false, true);
                    HopRewriteUtils.setOutputParameters((Hop)newRix, -1L, -1L, input.getRowsInBlock(), input.getColsInBlock(), -1L);
                    ((IndexingOp)newRix).refreshSizeInformation();
                    for (Hop c : ihops) {
                        HopRewriteUtils.removeChildReference(c, input);
                        HopRewriteUtils.addChildReference(c, (Hop)newRix, 0);
                        HopRewriteUtils.replaceChildReference(c, c.getInput().get(3), new LiteralOp(1L), 3);
                        HopRewriteUtils.replaceChildReference(c, c.getInput().get(4), new LiteralOp(1L), 4);
                        c.refreshSizeInformation();
                    }
                    LOG.debug((Object)"Applied vectorizeRightIndexingCol");
                }
            }
        }
    }

    private void vectorizeLeftIndexing(Hop hop) throws HopsException {
        if (hop instanceof LeftIndexingOp) {
            int posp;
            Object newLix;
            ArrayList<Integer> ihop0parentsPos;
            Hop c;
            IndexingOp newRix;
            Hop input;
            LeftIndexingOp tmp;
            LeftIndexingOp current;
            ArrayList<LeftIndexingOp> ihops;
            LeftIndexingOp ihop0 = (LeftIndexingOp)hop;
            boolean isSingleRow = ihop0.getRowLowerEqualsUpper();
            boolean isSingleCol = ihop0.getColLowerEqualsUpper();
            boolean appliedRow = false;
            if (isSingleRow && isSingleCol) {
                ihops = new ArrayList<LeftIndexingOp>();
                ihops.add(ihop0);
                current = ihop0;
                while (current.getInput().get(0) instanceof LeftIndexingOp && (tmp = (LeftIndexingOp)current.getInput().get(0)).getParent().size() <= 1 && tmp.getRowLowerEqualsUpper() && tmp.getInput().get(2) == ihop0.getInput().get(2) && tmp.getInput().get(0).getDim2() > 1L) {
                    ihops.add(tmp);
                    current = tmp;
                }
                if (ihops.size() > 1) {
                    input = current.getInput().get(0);
                    Hop rowExpr = ihop0.getInput().get(2);
                    newRix = new IndexingOp("tmp1", input.getDataType(), input.getValueType(), input, rowExpr, rowExpr, new LiteralOp(1L), HopRewriteUtils.createValueHop(input, false), true, false);
                    HopRewriteUtils.setOutputParameters(newRix, -1L, -1L, input.getRowsInBlock(), input.getColsInBlock(), -1L);
                    newRix.refreshSizeInformation();
                    HopRewriteUtils.removeChildReference(current, input);
                    HopRewriteUtils.addChildReference(current, newRix, 0);
                    for (int i = ihops.size() - 1; i >= 0; --i) {
                        c = (Hop)ihops.get(i);
                        HopRewriteUtils.replaceChildReference(c, c.getInput().get(2), new LiteralOp(1L), 2);
                        HopRewriteUtils.replaceChildReference(c, c.getInput().get(3), new LiteralOp(1L), 3);
                        ((LeftIndexingOp)c).setRowLowerEqualsUpper(true);
                        c.refreshSizeInformation();
                    }
                    ArrayList ihop0parents = (ArrayList)ihop0.getParent().clone();
                    ihop0parentsPos = new ArrayList<Integer>();
                    for (Hop parent : ihop0parents) {
                        int posp2 = HopRewriteUtils.getChildReferencePos(parent, ihop0);
                        HopRewriteUtils.removeChildReferenceByPos(parent, ihop0, posp2);
                        ihop0parentsPos.add(posp2);
                    }
                    newLix = new LeftIndexingOp("tmp2", input.getDataType(), input.getValueType(), input, ihop0, rowExpr, rowExpr, new LiteralOp(1L), HopRewriteUtils.createValueHop(input, false), true, false);
                    HopRewriteUtils.setOutputParameters((Hop)newLix, -1L, -1L, input.getRowsInBlock(), input.getColsInBlock(), -1L);
                    ((LeftIndexingOp)newLix).refreshSizeInformation();
                    for (int i = 0; i < ihop0parentsPos.size(); ++i) {
                        Hop parent = (Hop)ihop0parents.get(i);
                        posp = (Integer)ihop0parentsPos.get(i);
                        HopRewriteUtils.addChildReference(parent, (Hop)newLix, posp);
                    }
                    appliedRow = true;
                    LOG.debug((Object)"Applied vectorizeLeftIndexingRow");
                }
            }
            if (isSingleRow && isSingleCol && !appliedRow) {
                ihops = new ArrayList();
                ihops.add(ihop0);
                current = ihop0;
                while (current.getInput().get(0) instanceof LeftIndexingOp && (tmp = (LeftIndexingOp)current.getInput().get(0)).getParent().size() <= 1 && tmp.getColLowerEqualsUpper() && tmp.getInput().get(4) == ihop0.getInput().get(4) && tmp.getInput().get(0).getDim1() > 1L) {
                    ihops.add(tmp);
                    current = tmp;
                }
                if (ihops.size() > 1) {
                    input = current.getInput().get(0);
                    Hop colExpr = ihop0.getInput().get(4);
                    newRix = new IndexingOp("tmp1", input.getDataType(), input.getValueType(), input, new LiteralOp(1L), HopRewriteUtils.createValueHop(input, true), colExpr, colExpr, false, true);
                    HopRewriteUtils.setOutputParameters(newRix, -1L, -1L, input.getRowsInBlock(), input.getColsInBlock(), -1L);
                    newRix.refreshSizeInformation();
                    HopRewriteUtils.removeChildReference(current, input);
                    HopRewriteUtils.addChildReference(current, newRix, 0);
                    for (int i = ihops.size() - 1; i >= 0; --i) {
                        c = (Hop)ihops.get(i);
                        HopRewriteUtils.replaceChildReference(c, c.getInput().get(4), new LiteralOp(1L), 4);
                        HopRewriteUtils.replaceChildReference(c, c.getInput().get(5), new LiteralOp(1L), 5);
                        ((LeftIndexingOp)c).setColLowerEqualsUpper(true);
                        c.refreshSizeInformation();
                    }
                    ArrayList ihop0parents = (ArrayList)ihop0.getParent().clone();
                    ihop0parentsPos = new ArrayList();
                    for (Hop parent : ihop0parents) {
                        int posp3 = HopRewriteUtils.getChildReferencePos(parent, ihop0);
                        HopRewriteUtils.removeChildReferenceByPos(parent, ihop0, posp3);
                        ihop0parentsPos.add(posp3);
                    }
                    newLix = new LeftIndexingOp("tmp2", input.getDataType(), input.getValueType(), input, ihop0, new LiteralOp(1L), HopRewriteUtils.createValueHop(input, true), colExpr, colExpr, false, true);
                    HopRewriteUtils.setOutputParameters((Hop)newLix, -1L, -1L, input.getRowsInBlock(), input.getColsInBlock(), -1L);
                    ((LeftIndexingOp)newLix).refreshSizeInformation();
                    for (int i = 0; i < ihop0parentsPos.size(); ++i) {
                        Hop parent = (Hop)ihop0parents.get(i);
                        posp = (Integer)ihop0parentsPos.get(i);
                        HopRewriteUtils.addChildReference(parent, (Hop)newLix, posp);
                    }
                    appliedRow = true;
                    LOG.debug((Object)"Applied vectorizeLeftIndexingCol");
                }
            }
        }
    }
}

