/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.hops.rewrite;

import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysml.hops.DataOp;
import org.apache.sysml.hops.Hop;
import org.apache.sysml.hops.HopsException;
import org.apache.sysml.hops.LiteralOp;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.utils.Explain;

public class HopDagValidator {
    private static final Log LOG = LogFactory.getLog((String)HopDagValidator.class.getName());

    public static void validateHopDag(ArrayList<Hop> roots) throws HopsException {
        if (roots == null) {
            return;
        }
        try {
            Hop.resetVisitStatus(roots);
            for (Hop hop : roots) {
                HopDagValidator.rValidateHop(hop);
            }
        }
        catch (HopsException ex) {
            try {
                LOG.error((Object)("\n" + Explain.explainHops(roots)));
            }
            catch (DMLRuntimeException dMLRuntimeException) {
                // empty catch block
            }
            throw ex;
        }
    }

    public static void validateHopDag(Hop root) throws HopsException {
        if (root == null) {
            return;
        }
        try {
            root.resetVisitStatus();
            HopDagValidator.rValidateHop(root);
        }
        catch (HopsException ex) {
            try {
                LOG.error((Object)("\n" + Explain.explain(root)));
            }
            catch (DMLRuntimeException dMLRuntimeException) {
                // empty catch block
            }
            throw ex;
        }
    }

    private static void rValidateHop(Hop hop) throws HopsException {
        if (hop.isVisited()) {
            return;
        }
        for (Hop parent : hop.getParent()) {
            if (parent.getInput().contains(hop)) continue;
            throw new HopsException("Hop id=" + hop.getHopID() + " not properly linked to its parent pid=" + parent.getHopID() + " " + parent.getClass().getName());
        }
        for (Hop child : hop.getInput()) {
            if (child.getParent().contains(hop)) continue;
            throw new HopsException("Hop id=" + hop.getHopID() + " not properly linked to its child cid=" + child.getHopID() + " " + child.getClass().getName());
        }
        if (hop.getInput().isEmpty() && !(hop instanceof DataOp) && !(hop instanceof LiteralOp)) {
            throw new HopsException("Hop id=" + hop.getHopID() + " is not a dataop/literal but has no childs.");
        }
        for (Hop child : hop.getInput()) {
            HopDagValidator.rValidateHop(child);
        }
        hop.setVisited();
    }
}

