/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.hops.codegen.cplan;

import java.util.Arrays;
import org.apache.sysml.hops.codegen.cplan.CNode;
import org.apache.sysml.parser.Expression;

public class CNodeTernary
extends CNode {
    private final TernaryType _type;

    public CNodeTernary(CNode in1, CNode in2, CNode in3, TernaryType type) {
        this._inputs.add(in1);
        this._inputs.add(in2);
        this._inputs.add(in3);
        this._type = type;
        this.setOutputDims();
    }

    public TernaryType getType() {
        return this._type;
    }

    @Override
    public String codegen(boolean sparse) {
        if (this._generated) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(((CNode)this._inputs.get(0)).codegen(sparse));
        sb.append(((CNode)this._inputs.get(1)).codegen(sparse));
        sb.append(((CNode)this._inputs.get(2)).codegen(sparse));
        String var = this.createVarname();
        String tmp = this._type.getTemplate(sparse);
        tmp = tmp.replaceAll("%TMP%", var);
        for (int j = 1; j <= 3; ++j) {
            String varj = ((CNode)this._inputs.get(j - 1)).getVarname();
            tmp = tmp.replaceAll("%IN" + j + "v%", varj + (varj.startsWith("b") ? "" : "vals"));
            tmp = tmp.replaceAll("%IN" + j + "%", varj);
        }
        sb.append(tmp);
        this._generated = true;
        return sb.toString();
    }

    public String toString() {
        switch (this._type) {
            case PLUS_MULT: {
                return "t(+*)";
            }
            case MINUS_MULT: {
                return "t(-*)";
            }
            case REPLACE: 
            case REPLACE_NAN: {
                return "t(rplc)";
            }
            case LOOKUP_RC1: {
                return "u(ixrc1)";
            }
        }
        return super.toString();
    }

    @Override
    public void setOutputDims() {
        switch (this._type) {
            case PLUS_MULT: 
            case MINUS_MULT: 
            case REPLACE: 
            case REPLACE_NAN: 
            case LOOKUP_RC1: {
                this._rows = 0L;
                this._cols = 0L;
                this._dataType = Expression.DataType.SCALAR;
            }
        }
    }

    @Override
    public int hashCode() {
        if (this._hash == 0) {
            int h1 = super.hashCode();
            int h2 = this._type.hashCode();
            this._hash = Arrays.hashCode(new int[]{h1, h2});
        }
        return this._hash;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof CNodeTernary)) {
            return false;
        }
        CNodeTernary that = (CNodeTernary)o;
        return super.equals(that) && this._type == that._type;
    }

    public static enum TernaryType {
        PLUS_MULT,
        MINUS_MULT,
        REPLACE,
        REPLACE_NAN,
        LOOKUP_RC1;


        public static boolean contains(String value) {
            for (TernaryType tt : TernaryType.values()) {
                if (!tt.name().equals(value)) continue;
                return true;
            }
            return false;
        }

        public String getTemplate(boolean sparse) {
            switch (this) {
                case PLUS_MULT: {
                    return "    double %TMP% = %IN1% + %IN2% * %IN3%;\n";
                }
                case MINUS_MULT: {
                    return "    double %TMP% = %IN1% - %IN2% * %IN3%;\n";
                }
                case REPLACE: {
                    return "    double %TMP% = (%IN1% == %IN2% || (Double.isNaN(%IN1%) && Double.isNaN(%IN2%))) ? %IN3% : %IN1%;\n";
                }
                case REPLACE_NAN: {
                    return "    double %TMP% = Double.isNaN(%IN1%) ? %IN3% : %IN1%;\n";
                }
                case LOOKUP_RC1: {
                    return sparse ? "    double %TMP% = getValue(%IN1v%, rowIndex*%IN2%+%IN3%-1);\n" : "    double %TMP% = getValue(%IN1%, rowIndex*%IN2%+%IN3%-1);\n";
                }
            }
            throw new RuntimeException("Invalid ternary type: " + this.toString());
        }
    }
}

