/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.hops.codegen;

import java.util.ArrayList;
import org.apache.sysml.hops.Hop;
import org.apache.sysml.hops.HopsException;
import org.apache.sysml.hops.MemoTable;
import org.apache.sysml.hops.OptimizerUtils;
import org.apache.sysml.lops.Lop;
import org.apache.sysml.lops.LopProperties;
import org.apache.sysml.lops.LopsException;
import org.apache.sysml.lops.SpoofFused;
import org.apache.sysml.parser.Expression;

public class SpoofFusedOp
extends Hop
implements Hop.MultiThreadedHop {
    private Class<?> _class = null;
    private boolean _distSupported = false;
    private int _numThreads = -1;
    private SpoofOutputDimsType _dimsType;

    public SpoofFusedOp() {
    }

    public SpoofFusedOp(String name, Expression.DataType dt, Expression.ValueType vt, Class<?> cla, boolean dist, SpoofOutputDimsType type) {
        super(name, dt, vt);
        this._class = cla;
        this._distSupported = dist;
        this._dimsType = type;
    }

    @Override
    public void setMaxNumThreads(int k) {
        this._numThreads = k;
    }

    @Override
    public int getMaxNumThreads() {
        return this._numThreads;
    }

    @Override
    public boolean allowsAllExecTypes() {
        return this._distSupported;
    }

    @Override
    protected double computeOutputMemEstimate(long dim1, long dim2, long nnz) {
        return OptimizerUtils.estimateSize(dim1, dim2);
    }

    @Override
    protected double computeIntermediateMemEstimate(long dim1, long dim2, long nnz) {
        return 0.0;
    }

    @Override
    protected long[] inferOutputCharacteristics(MemoTable memo) {
        return null;
    }

    @Override
    public Lop constructLops() throws HopsException, LopsException {
        if (this.getLops() != null) {
            return this.getLops();
        }
        LopProperties.ExecType et = this.optFindExecType();
        ArrayList<Lop> inputs = new ArrayList<Lop>();
        for (Hop c : this.getInput()) {
            inputs.add(c.constructLops());
        }
        int k = OptimizerUtils.getConstrainedNumThreads(this._numThreads);
        SpoofFused lop = new SpoofFused(inputs, this.getDataType(), this.getValueType(), this._class, k, et);
        this.setOutputDimensions(lop);
        this.setLineNumbers(lop);
        this.setLops(lop);
        return lop;
    }

    @Override
    protected LopProperties.ExecType optFindExecType() throws HopsException {
        this.checkAndSetForcedPlatform();
        if (this._etypeForced != null) {
            this._etype = this._etypeForced;
        } else {
            this._etype = this.findExecTypeByMemEstimate();
            this.checkAndSetInvalidCPDimsAndSize();
        }
        if (this._etype == LopProperties.ExecType.MR) {
            this._etype = LopProperties.ExecType.CP;
        }
        return this._etype;
    }

    @Override
    public String getOpString() {
        return "spoof(" + this._class.getSimpleName() + ")";
    }

    @Override
    public void refreshSizeInformation() {
        switch (this._dimsType) {
            case ROW_DIMS: {
                this.setDim1(this.getInput().get(0).getDim1());
                this.setDim2(1L);
                break;
            }
            case COLUMN_DIMS_ROWS: {
                this.setDim1(this.getInput().get(0).getDim2());
                this.setDim2(1L);
                break;
            }
            case COLUMN_DIMS_COLS: {
                this.setDim1(1L);
                this.setDim2(this.getInput().get(0).getDim2());
                break;
            }
            case INPUT_DIMS: {
                this.setDim1(this.getInput().get(0).getDim1());
                this.setDim2(this.getInput().get(0).getDim2());
                break;
            }
            case SCALAR: {
                this.setDim1(0L);
                this.setDim2(0L);
                break;
            }
            case MULTI_SCALAR: {
                this.setDim1(1L);
                break;
            }
            case ROW_RANK_DIMS: {
                this.setDim1(this.getInput().get(0).getDim1());
                this.setDim2(this.getInput().get(1).getDim2());
                break;
            }
            case COLUMN_RANK_DIMS: {
                this.setDim1(this.getInput().get(0).getDim2());
                this.setDim2(this.getInput().get(1).getDim2());
                break;
            }
            default: {
                throw new RuntimeException("Failed to refresh size information for type: " + this._dimsType.toString());
            }
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        SpoofFusedOp ret = new SpoofFusedOp();
        ret.clone(this, false);
        ret._class = this._class;
        ret._distSupported = this._distSupported;
        ret._numThreads = this._numThreads;
        ret._dimsType = this._dimsType;
        return ret;
    }

    @Override
    public boolean compare(Hop that) {
        boolean ret;
        if (!(that instanceof SpoofFusedOp)) {
            return false;
        }
        SpoofFusedOp that2 = (SpoofFusedOp)that;
        boolean bl = ret = this._class.equals(that2._class) && this._distSupported == that2._distSupported && this._numThreads == that2._numThreads && this.getInput().size() == that2.getInput().size();
        if (ret) {
            for (int i = 0; i < this.getInput().size(); ++i) {
                ret &= this.getInput().get(i) == that2.getInput().get(i);
            }
        }
        return ret;
    }

    public static enum SpoofOutputDimsType {
        INPUT_DIMS,
        ROW_DIMS,
        COLUMN_DIMS_ROWS,
        COLUMN_DIMS_COLS,
        SCALAR,
        MULTI_SCALAR,
        ROW_RANK_DIMS,
        COLUMN_RANK_DIMS;

    }
}

