/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.hops.codegen;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.sysml.api.DMLException;
import org.apache.sysml.api.DMLScript;
import org.apache.sysml.hops.Hop;
import org.apache.sysml.hops.HopsException;
import org.apache.sysml.hops.OptimizerUtils;
import org.apache.sysml.hops.codegen.SpoofFusedOp;
import org.apache.sysml.hops.codegen.cplan.CNode;
import org.apache.sysml.hops.codegen.cplan.CNodeCell;
import org.apache.sysml.hops.codegen.cplan.CNodeData;
import org.apache.sysml.hops.codegen.cplan.CNodeMultiAgg;
import org.apache.sysml.hops.codegen.cplan.CNodeOuterProduct;
import org.apache.sysml.hops.codegen.cplan.CNodeRow;
import org.apache.sysml.hops.codegen.cplan.CNodeTernary;
import org.apache.sysml.hops.codegen.cplan.CNodeTpl;
import org.apache.sysml.hops.codegen.template.CPlanMemoTable;
import org.apache.sysml.hops.codegen.template.PlanSelection;
import org.apache.sysml.hops.codegen.template.PlanSelectionFuseAll;
import org.apache.sysml.hops.codegen.template.PlanSelectionFuseCostBased;
import org.apache.sysml.hops.codegen.template.PlanSelectionFuseNoRedundancy;
import org.apache.sysml.hops.codegen.template.TemplateBase;
import org.apache.sysml.hops.codegen.template.TemplateUtils;
import org.apache.sysml.hops.recompile.RecompileStatus;
import org.apache.sysml.hops.recompile.Recompiler;
import org.apache.sysml.hops.rewrite.HopRewriteUtils;
import org.apache.sysml.hops.rewrite.ProgramRewriteStatus;
import org.apache.sysml.hops.rewrite.ProgramRewriter;
import org.apache.sysml.hops.rewrite.RewriteCommonSubexpressionElimination;
import org.apache.sysml.hops.rewrite.RewriteRemoveUnnecessaryCasts;
import org.apache.sysml.lops.LopsException;
import org.apache.sysml.parser.DMLProgram;
import org.apache.sysml.parser.Expression;
import org.apache.sysml.parser.ForStatement;
import org.apache.sysml.parser.ForStatementBlock;
import org.apache.sysml.parser.FunctionStatement;
import org.apache.sysml.parser.FunctionStatementBlock;
import org.apache.sysml.parser.IfStatement;
import org.apache.sysml.parser.IfStatementBlock;
import org.apache.sysml.parser.LanguageException;
import org.apache.sysml.parser.StatementBlock;
import org.apache.sysml.parser.WhileStatement;
import org.apache.sysml.parser.WhileStatementBlock;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.codegen.CodegenUtils;
import org.apache.sysml.runtime.codegen.SpoofCellwise;
import org.apache.sysml.runtime.controlprogram.ForProgramBlock;
import org.apache.sysml.runtime.controlprogram.FunctionProgramBlock;
import org.apache.sysml.runtime.controlprogram.IfProgramBlock;
import org.apache.sysml.runtime.controlprogram.LocalVariableMap;
import org.apache.sysml.runtime.controlprogram.Program;
import org.apache.sysml.runtime.controlprogram.ProgramBlock;
import org.apache.sysml.runtime.controlprogram.WhileProgramBlock;
import org.apache.sysml.runtime.instructions.Instruction;
import org.apache.sysml.runtime.matrix.data.Pair;
import org.apache.sysml.utils.Explain;
import org.apache.sysml.utils.Statistics;

public class SpoofCompiler {
    private static final Log LOG = LogFactory.getLog((String)SpoofCompiler.class.getName());
    public static boolean LDEBUG = false;
    public static CompilerType JAVA_COMPILER = CompilerType.JANINO;
    public static IntegrationType INTEGRATION = IntegrationType.HOPS;
    public static final boolean RECOMPILE_CODEGEN = true;
    public static final boolean PRUNE_REDUNDANT_PLANS = true;
    public static PlanCachePolicy PLAN_CACHE_POLICY = PlanCachePolicy.CSLH;
    public static final int PLAN_CACHE_SIZE = 1024;
    public static final PlanSelector PLAN_SEL_POLICY = PlanSelector.FUSE_COST_BASED;
    private static final PlanCache planCache;
    private static ProgramRewriter rewriteCSE;

    public static void generateCode(DMLProgram dmlprog) throws LanguageException, HopsException, DMLRuntimeException {
        for (String namespaceKey : dmlprog.getNamespaces().keySet()) {
            for (String fname : dmlprog.getFunctionStatementBlocks(namespaceKey).keySet()) {
                FunctionStatementBlock fsblock = dmlprog.getFunctionStatementBlock(namespaceKey, fname);
                SpoofCompiler.generateCodeFromStatementBlock(fsblock);
            }
        }
        for (int i = 0; i < dmlprog.getNumStatementBlocks(); ++i) {
            StatementBlock current = dmlprog.getStatementBlock(i);
            SpoofCompiler.generateCodeFromStatementBlock(current);
        }
    }

    public static void generateCode(Program rtprog) throws LanguageException, HopsException, DMLRuntimeException, LopsException, IOException {
        for (FunctionProgramBlock functionProgramBlock : rtprog.getFunctionProgramBlocks().values()) {
            SpoofCompiler.generateCodeFromProgramBlock(functionProgramBlock);
        }
        for (ProgramBlock programBlock : rtprog.getProgramBlocks()) {
            SpoofCompiler.generateCodeFromProgramBlock(programBlock);
        }
    }

    public static void generateCodeFromStatementBlock(StatementBlock current) throws HopsException, DMLRuntimeException {
        if (current instanceof FunctionStatementBlock) {
            FunctionStatementBlock fsb = (FunctionStatementBlock)current;
            FunctionStatement fstmt = (FunctionStatement)fsb.getStatement(0);
            for (StatementBlock sb : fstmt.getBody()) {
                SpoofCompiler.generateCodeFromStatementBlock(sb);
            }
        } else if (current instanceof WhileStatementBlock) {
            WhileStatementBlock wsb = (WhileStatementBlock)current;
            WhileStatement wstmt = (WhileStatement)wsb.getStatement(0);
            wsb.setPredicateHops(SpoofCompiler.optimize(wsb.getPredicateHops(), false));
            for (StatementBlock sb : wstmt.getBody()) {
                SpoofCompiler.generateCodeFromStatementBlock(sb);
            }
        } else if (current instanceof IfStatementBlock) {
            IfStatementBlock isb = (IfStatementBlock)current;
            IfStatement istmt = (IfStatement)isb.getStatement(0);
            isb.setPredicateHops(SpoofCompiler.optimize(isb.getPredicateHops(), false));
            for (StatementBlock sb : istmt.getIfBody()) {
                SpoofCompiler.generateCodeFromStatementBlock(sb);
            }
            for (StatementBlock sb : istmt.getElseBody()) {
                SpoofCompiler.generateCodeFromStatementBlock(sb);
            }
        } else if (current instanceof ForStatementBlock) {
            ForStatementBlock fsb = (ForStatementBlock)current;
            ForStatement fstmt = (ForStatement)fsb.getStatement(0);
            fsb.setFromHops(SpoofCompiler.optimize(fsb.getFromHops(), false));
            fsb.setToHops(SpoofCompiler.optimize(fsb.getToHops(), false));
            fsb.setIncrementHops(SpoofCompiler.optimize(fsb.getIncrementHops(), false));
            for (StatementBlock sb : fstmt.getBody()) {
                SpoofCompiler.generateCodeFromStatementBlock(sb);
            }
        } else {
            current.set_hops(SpoofCompiler.generateCodeFromHopDAGs(current.get_hops()));
            current.updateRecompilationFlag();
        }
    }

    public static void generateCodeFromProgramBlock(ProgramBlock current) throws HopsException, DMLRuntimeException, LopsException, IOException {
        if (current instanceof FunctionProgramBlock) {
            FunctionProgramBlock fsb = (FunctionProgramBlock)current;
            for (ProgramBlock pb : fsb.getChildBlocks()) {
                SpoofCompiler.generateCodeFromProgramBlock(pb);
            }
        } else if (current instanceof WhileProgramBlock) {
            WhileProgramBlock wpb = (WhileProgramBlock)current;
            WhileStatementBlock wsb = (WhileStatementBlock)wpb.getStatementBlock();
            if (wsb != null && wsb.getPredicateHops() != null) {
                wpb.setPredicate(SpoofCompiler.generateCodeFromHopDAGsToInst(wsb.getPredicateHops()));
            }
            for (ProgramBlock sb : wpb.getChildBlocks()) {
                SpoofCompiler.generateCodeFromProgramBlock(sb);
            }
        } else if (current instanceof IfProgramBlock) {
            IfProgramBlock ipb = (IfProgramBlock)current;
            IfStatementBlock isb = (IfStatementBlock)ipb.getStatementBlock();
            if (isb != null && isb.getPredicateHops() != null) {
                ipb.setPredicate(SpoofCompiler.generateCodeFromHopDAGsToInst(isb.getPredicateHops()));
            }
            for (ProgramBlock pb : ipb.getChildBlocksIfBody()) {
                SpoofCompiler.generateCodeFromProgramBlock(pb);
            }
            for (ProgramBlock pb : ipb.getChildBlocksElseBody()) {
                SpoofCompiler.generateCodeFromProgramBlock(pb);
            }
        } else if (current instanceof ForProgramBlock) {
            ForProgramBlock fpb = (ForProgramBlock)current;
            ForStatementBlock fsb = (ForStatementBlock)fpb.getStatementBlock();
            if (fsb != null && fsb.getFromHops() != null) {
                fpb.setFromInstructions(SpoofCompiler.generateCodeFromHopDAGsToInst(fsb.getFromHops()));
            }
            if (fsb != null && fsb.getToHops() != null) {
                fpb.setToInstructions(SpoofCompiler.generateCodeFromHopDAGsToInst(fsb.getToHops()));
            }
            if (fsb != null && fsb.getIncrementHops() != null) {
                fpb.setIncrementInstructions(SpoofCompiler.generateCodeFromHopDAGsToInst(fsb.getIncrementHops()));
            }
            for (ProgramBlock pb : fpb.getChildBlocks()) {
                SpoofCompiler.generateCodeFromProgramBlock(pb);
            }
        } else {
            StatementBlock sb = current.getStatementBlock();
            current.setInstructions(SpoofCompiler.generateCodeFromHopDAGsToInst(sb, sb.get_hops()));
        }
    }

    public static ArrayList<Hop> generateCodeFromHopDAGs(ArrayList<Hop> roots) throws HopsException, DMLRuntimeException {
        if (roots == null) {
            return roots;
        }
        ArrayList<Hop> optimized = SpoofCompiler.optimize(roots, false);
        Hop.resetVisitStatus(roots);
        Hop.resetVisitStatus(optimized);
        return optimized;
    }

    public static ArrayList<Instruction> generateCodeFromHopDAGsToInst(StatementBlock sb, ArrayList<Hop> roots) throws DMLRuntimeException, HopsException, LopsException, IOException {
        return Recompiler.recompileHopsDag(sb, roots, new LocalVariableMap(), new RecompileStatus(), false, 0L);
    }

    public static ArrayList<Instruction> generateCodeFromHopDAGsToInst(Hop root) throws DMLRuntimeException, HopsException, LopsException, IOException {
        return Recompiler.recompileHopsDag(root, new LocalVariableMap(), new RecompileStatus(), false, 0L);
    }

    public static Hop optimize(Hop root, boolean recompile) throws DMLRuntimeException {
        if (root == null) {
            return root;
        }
        return SpoofCompiler.optimize(new ArrayList<Hop>(Arrays.asList(root)), recompile).get(0);
    }

    public static ArrayList<Hop> optimize(ArrayList<Hop> roots, boolean recompile) throws DMLRuntimeException {
        if (roots == null || roots.isEmpty()) {
            return roots;
        }
        long t0 = DMLScript.STATISTICS ? System.nanoTime() : 0L;
        ArrayList<Hop> ret = roots;
        try {
            boolean compileLiterals = PLAN_CACHE_POLICY == PlanCachePolicy.CONSTANT || !recompile;
            HashMap<Long, Pair<Hop[], CNodeTpl>> cplans = SpoofCompiler.constructCPlans(roots, compileLiterals);
            cplans = SpoofCompiler.cleanupCPlans(cplans);
            if (LOG.isTraceEnabled() && !cplans.isEmpty()) {
                LOG.trace((Object)("Codegen EXPLAIN (before optimize): \n" + Explain.explainHops(roots)));
            }
            HashMap clas = new HashMap();
            for (Map.Entry<Long, Pair<Hop[], CNodeTpl>> cplan : cplans.entrySet()) {
                Pair<Hop[], CNodeTpl> tmp = cplan.getValue();
                Class<?> cla = planCache.getPlan(tmp.getValue());
                if (cla == null) {
                    String src = tmp.getValue().codegen(false);
                    if (LOG.isTraceEnabled() || DMLScript.EXPLAIN.isHopsType(recompile)) {
                        LOG.info((Object)("Codegen EXPLAIN (generated cplan for HopID: " + cplan.getKey() + "):"));
                        LOG.info((Object)(tmp.getValue().getClassname() + Explain.explainCPlan(cplan.getValue().getValue())));
                    }
                    if (LOG.isTraceEnabled() || DMLScript.EXPLAIN.isRuntimeType(recompile)) {
                        LOG.info((Object)("Codegen EXPLAIN (generated code for HopID: " + cplan.getKey() + "):"));
                        LOG.info((Object)src);
                    }
                    cla = CodegenUtils.compileClass("codegen." + tmp.getValue().getClassname(), src);
                    if (PLAN_CACHE_POLICY != PlanCachePolicy.NONE) {
                        planCache.putPlan(tmp.getValue(), cla);
                    }
                } else if (DMLScript.STATISTICS) {
                    Statistics.incrementCodegenPlanCacheHits();
                }
                if (cla != null) {
                    clas.put(cplan.getKey(), new Pair(tmp.getKey(), cla));
                }
                if (!DMLScript.STATISTICS) continue;
                Statistics.incrementCodegenPlanCacheTotal();
            }
            if (!cplans.isEmpty()) {
                ret = SpoofCompiler.constructModifiedHopDag(roots, cplans, clas);
                ret = rewriteCSE.rewriteHopDAGs(ret, new ProgramRewriteStatus());
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Codegen EXPLAIN (after optimize): \n" + Explain.explainHops(roots)));
                }
            }
        }
        catch (Exception ex) {
            throw new DMLRuntimeException(ex);
        }
        if (DMLScript.STATISTICS) {
            Statistics.incrementCodegenDAGCompile();
            Statistics.incrementCodegenCompileTime(System.nanoTime() - t0);
        }
        Hop.resetVisitStatus(roots);
        return ret;
    }

    public static void cleanupCodeGenerator() {
        if (PLAN_CACHE_POLICY != PlanCachePolicy.NONE) {
            CodegenUtils.clearClassCache();
            planCache.clear();
        }
    }

    public static PlanSelection createPlanSelector() {
        switch (PLAN_SEL_POLICY) {
            case FUSE_ALL: {
                return new PlanSelectionFuseAll();
            }
            case FUSE_NO_REDUNDANCY: {
                return new PlanSelectionFuseNoRedundancy();
            }
            case FUSE_COST_BASED: {
                return new PlanSelectionFuseCostBased();
            }
        }
        throw new RuntimeException("Unsupported plan selector: " + (Object)((Object)PLAN_SEL_POLICY));
    }

    public static void setExecTypeSpecificJavaCompiler() {
        JAVA_COMPILER = OptimizerUtils.isSparkExecutionMode() ? CompilerType.JANINO : CompilerType.JAVAC;
    }

    private static HashMap<Long, Pair<Hop[], CNodeTpl>> constructCPlans(ArrayList<Hop> roots, boolean compileLiterals) throws DMLException {
        CPlanMemoTable memo = new CPlanMemoTable();
        for (Hop hop : roots) {
            SpoofCompiler.rExploreCPlans(hop, memo, compileLiterals);
        }
        memo.pruneSuboptimal(roots);
        LinkedHashMap<Long, Pair<Hop[], CNodeTpl>> ret = new LinkedHashMap<Long, Pair<Hop[], CNodeTpl>>();
        HashSet<Long> visited = new HashSet<Long>();
        for (Hop hop : roots) {
            SpoofCompiler.rConstructCPlans(hop, memo, ret, compileLiterals, visited);
        }
        return ret;
    }

    private static void rExploreCPlans(Hop hop, CPlanMemoTable memo, boolean compileLiterals) throws DMLException {
        if (memo.contains(hop.getHopID()) || memo.containsHop(hop)) {
            return;
        }
        for (Hop c : hop.getInput()) {
            SpoofCompiler.rExploreCPlans(c, memo, compileLiterals);
        }
        for (TemplateBase tpl : TemplateUtils.TEMPLATES) {
            if (!tpl.open(hop)) continue;
            CPlanMemoTable.MemoTableEntrySet P = new CPlanMemoTable.MemoTableEntrySet(tpl.getType(), false);
            memo.addAll(hop, SpoofCompiler.enumPlans(hop, -1, P, tpl, memo));
        }
        for (Hop c : hop.getInput()) {
            if (!memo.contains(c.getHopID())) continue;
            for (CPlanMemoTable.MemoTableEntry me : memo.getDistinct(c.getHopID())) {
                TemplateBase tpl = TemplateUtils.createTemplate(me.type, me.closed);
                if (!tpl.fuse(hop, c)) continue;
                int pos = hop.getInput().indexOf(c);
                CPlanMemoTable.MemoTableEntrySet P = new CPlanMemoTable.MemoTableEntrySet(tpl.getType(), pos, c.getHopID(), tpl.isClosed());
                memo.addAll(hop, SpoofCompiler.enumPlans(hop, pos, P, tpl, memo));
            }
        }
        memo.pruneRedundant(hop.getHopID());
        if (memo.contains(hop.getHopID())) {
            Iterator<CPlanMemoTable.MemoTableEntry> iter = memo.get(hop.getHopID()).iterator();
            while (iter.hasNext()) {
                CPlanMemoTable.MemoTableEntry me = iter.next();
                TemplateBase tpl = TemplateUtils.createTemplate(me.type);
                TemplateBase.CloseType ccode = tpl.close(hop);
                if (ccode == TemplateBase.CloseType.CLOSED_INVALID) {
                    iter.remove();
                    continue;
                }
                if (ccode != TemplateBase.CloseType.CLOSED_VALID) continue;
                me.closed = true;
            }
        }
        memo.addHop(hop);
    }

    private static CPlanMemoTable.MemoTableEntrySet enumPlans(Hop hop, int pos, CPlanMemoTable.MemoTableEntrySet P, TemplateBase tpl, CPlanMemoTable memo) {
        for (int k = 0; k < hop.getInput().size(); ++k) {
            if (k == pos) continue;
            Hop input2 = hop.getInput().get(k);
            if (memo.contains(input2.getHopID()) && !memo.get((long)input2.getHopID()).get((int)0).closed && TemplateUtils.isType(memo.get((long)input2.getHopID()).get((int)0).type, tpl.getType(), TemplateBase.TemplateType.CellTpl) && tpl.merge(hop, input2) && (tpl.getType() != TemplateBase.TemplateType.RowTpl || pos == -1 || TemplateUtils.hasCommonRowTemplateMatrixInput(hop.getInput().get(pos), input2, memo))) {
                P.crossProduct(k, -1L, input2.getHopID());
                continue;
            }
            P.crossProduct(k, -1L);
        }
        return P;
    }

    private static void rConstructCPlans(Hop hop, CPlanMemoTable memo, HashMap<Long, Pair<Hop[], CNodeTpl>> cplans, boolean compileLiterals, HashSet<Long> visited) throws DMLException {
        if (hop == null || visited.contains(hop.getHopID())) {
            return;
        }
        if (memo.containsTopLevel(hop.getHopID())) {
            cplans.put(hop.getHopID(), TemplateUtils.createTemplate(memo.getBest((long)hop.getHopID()).type).constructCplan(hop, memo, compileLiterals));
            if (DMLScript.STATISTICS) {
                Statistics.incrementCodegenCPlanCompile(1L);
            }
        }
        if (cplans.containsKey(hop.getHopID())) {
            for (Hop c : cplans.get(hop.getHopID()).getKey()) {
                SpoofCompiler.rConstructCPlans(c, memo, cplans, compileLiterals, visited);
            }
        } else {
            for (Hop c : hop.getInput()) {
                SpoofCompiler.rConstructCPlans(c, memo, cplans, compileLiterals, visited);
            }
        }
        visited.add(hop.getHopID());
    }

    private static ArrayList<Hop> constructModifiedHopDag(ArrayList<Hop> orig, HashMap<Long, Pair<Hop[], CNodeTpl>> cplans, HashMap<Long, Pair<Hop[], Class<?>>> cla) {
        HashSet<Long> memo = new HashSet<Long>();
        for (int i = 0; i < orig.size(); ++i) {
            Hop hop = orig.get(i);
            SpoofCompiler.rConstructModifiedHopDag(hop, cplans, cla, memo);
        }
        return orig;
    }

    private static void rConstructModifiedHopDag(Hop hop, HashMap<Long, Pair<Hop[], CNodeTpl>> cplans, HashMap<Long, Pair<Hop[], Class<?>>> clas, HashSet<Long> memo) {
        if (memo.contains(hop.getHopID())) {
            return;
        }
        Hop hnew = hop;
        if (clas.containsKey(hop.getHopID())) {
            Pair<Hop[], Class<?>> tmpCla = clas.get(hop.getHopID());
            CNodeTpl tmpCNode = cplans.get(hop.getHopID()).getValue();
            hnew = new SpoofFusedOp(hop.getName(), hop.getDataType(), hop.getValueType(), tmpCla.getValue(), false, tmpCNode.getOutputDimType());
            Hop[] inHops = tmpCla.getKey();
            for (int i = 0; i < inHops.length; ++i) {
                if (tmpCNode instanceof CNodeOuterProduct && inHops[i].getHopID() == ((CNodeData)tmpCNode.getInput().get(2)).getHopID() && !TemplateUtils.hasTransposeParentUnderOuterProduct(inHops[i])) {
                    hnew.addInput(HopRewriteUtils.createTranspose(inHops[i]));
                    continue;
                }
                hnew.addInput(inHops[i]);
            }
            HopRewriteUtils.setOutputParameters(hnew, hop.getDim1(), hop.getDim2(), hop.getRowsInBlock(), hop.getColsInBlock(), hop.getNnz());
            if (tmpCNode instanceof CNodeOuterProduct && ((CNodeOuterProduct)tmpCNode).isTransposeOutput()) {
                hnew = HopRewriteUtils.createTranspose(hnew);
            } else if (tmpCNode instanceof CNodeMultiAgg) {
                ArrayList<Hop> roots = ((CNodeMultiAgg)tmpCNode).getRootNodes();
                hnew.setDataType(Expression.DataType.MATRIX);
                HopRewriteUtils.setOutputParameters(hnew, 1L, roots.size(), inHops[0].getRowsInBlock(), inHops[0].getColsInBlock(), -1L);
                for (int i = 0; i < roots.size(); ++i) {
                    Hop hnewi = HopRewriteUtils.createScalarIndexing(hnew, 1L, i + 1);
                    HopRewriteUtils.rewireAllParentChildReferences(roots.get(i), hnewi);
                }
            } else if (tmpCNode instanceof CNodeCell && ((CNodeCell)tmpCNode).requiredCastDtm()) {
                HopRewriteUtils.setOutputParametersForScalar(hnew);
                hnew = HopRewriteUtils.createUnary(hnew, Hop.OpOp1.CAST_AS_MATRIX);
            }
            if (!(tmpCNode instanceof CNodeMultiAgg)) {
                HopRewriteUtils.rewireAllParentChildReferences(hop, hnew);
            }
            memo.add(hnew.getHopID());
        }
        for (int i = 0; i < hnew.getInput().size(); ++i) {
            Hop c = hnew.getInput().get(i);
            SpoofCompiler.rConstructModifiedHopDag(c, cplans, clas, memo);
        }
        memo.add(hnew.getHopID());
    }

    private static HashMap<Long, Pair<Hop[], CNodeTpl>> cleanupCPlans(HashMap<Long, Pair<Hop[], CNodeTpl>> cplans) {
        HashMap<Long, Pair<Hop[], CNodeTpl>> cplans2 = new HashMap<Long, Pair<Hop[], CNodeTpl>>();
        for (Map.Entry<Long, Pair<Hop[], CNodeTpl>> e : cplans.entrySet()) {
            CNodeData in1;
            CNodeTpl tpl;
            block14: {
                block13: {
                    tpl = e.getValue().getValue();
                    Hop[] inHops = e.getValue().getKey();
                    HashSet<Long> leafs = new HashSet<Long>();
                    if (tpl instanceof CNodeMultiAgg) {
                        for (CNode out : ((CNodeMultiAgg)tpl).getOutputs()) {
                            SpoofCompiler.rCollectLeafIDs(out, leafs);
                        }
                    } else {
                        SpoofCompiler.rCollectLeafIDs(tpl.getOutput(), leafs);
                    }
                    if (inHops.length == leafs.size()) {
                        cplans2.put(e.getKey(), e.getValue());
                    } else {
                        tpl.cleanupInputs(leafs);
                        ArrayList<Hop> tmp = new ArrayList<Hop>();
                        for (Hop hop : inHops) {
                            if (hop == null || !leafs.contains(hop.getHopID())) continue;
                            tmp.add(hop);
                        }
                        cplans2.put(e.getKey(), new Pair<Hop[], CNodeTpl>(tmp.toArray(new Hop[0]), tpl));
                    }
                    if (!(tpl instanceof CNodeCell)) break block13;
                    in1 = (CNodeData)tpl.getInput().get(0);
                    if (!SpoofCompiler.rHasLookupRC1(tpl.getOutput(), in1) && !SpoofCompiler.isLookupRC1(tpl.getOutput(), in1)) break block14;
                    cplans2.remove(e.getKey());
                    if (!LOG.isTraceEnabled()) break block14;
                    LOG.trace((Object)"Removed cplan due to invalid rc1 indexing on main input.");
                    break block14;
                }
                if (tpl instanceof CNodeMultiAgg) {
                    in1 = (CNodeData)tpl.getInput().get(0);
                    for (CNode output : ((CNodeMultiAgg)tpl).getOutputs()) {
                        if (!SpoofCompiler.rHasLookupRC1(output, in1) && !SpoofCompiler.isLookupRC1(output, in1)) continue;
                        cplans2.remove(e.getKey());
                        if (!LOG.isTraceEnabled()) continue;
                        LOG.trace((Object)"Removed cplan due to invalid rc1 indexing on main input.");
                    }
                }
            }
            if (tpl instanceof CNodeCell || tpl instanceof CNodeOuterProduct) {
                in1 = (CNodeData)tpl.getInput().get(0);
                SpoofCompiler.rFindAndRemoveLookup(tpl.getOutput(), in1);
            } else if (tpl instanceof CNodeMultiAgg) {
                in1 = (CNodeData)tpl.getInput().get(0);
                SpoofCompiler.rFindAndRemoveLookupMultiAgg((CNodeMultiAgg)tpl, in1);
            }
            if (tpl instanceof CNodeCell && (((CNodeCell)tpl).getCellType() == SpoofCellwise.CellType.NO_AGG && TemplateUtils.hasSingleOperation(tpl) || TemplateUtils.hasNoOperation(tpl)) || tpl instanceof CNodeRow && TemplateUtils.hasSingleOperation(tpl)) {
                cplans2.remove(e.getKey());
            }
            if (!(tpl.getOutput() instanceof CNodeData)) continue;
            cplans2.remove(e.getKey());
        }
        return cplans2;
    }

    private static void rCollectLeafIDs(CNode node, HashSet<Long> leafs) {
        if (node instanceof CNodeData && !((CNodeData)node).isLiteral()) {
            leafs.add(((CNodeData)node).getHopID());
        }
        for (CNode c : node.getInput()) {
            SpoofCompiler.rCollectLeafIDs(c, leafs);
        }
    }

    private static void rFindAndRemoveLookupMultiAgg(CNodeMultiAgg node, CNodeData mainInput) {
        for (CNode output : node.getOutputs()) {
            SpoofCompiler.rFindAndRemoveLookup(output, mainInput);
        }
        for (int i = 0; i < node.getOutputs().size(); ++i) {
            CNode tmp = node.getOutputs().get(i);
            if (!TemplateUtils.isLookup(tmp) || !(tmp.getInput().get(0) instanceof CNodeData) || ((CNodeData)tmp.getInput().get(0)).getHopID() != mainInput.getHopID()) continue;
            node.getOutputs().set(i, tmp.getInput().get(0));
        }
    }

    private static void rFindAndRemoveLookup(CNode node, CNodeData mainInput) {
        for (int i = 0; i < node.getInput().size(); ++i) {
            CNode tmp = node.getInput().get(i);
            if (TemplateUtils.isLookup(tmp) && tmp.getInput().get(0) instanceof CNodeData && ((CNodeData)tmp.getInput().get(0)).getHopID() == mainInput.getHopID()) {
                node.getInput().set(i, tmp.getInput().get(0));
                continue;
            }
            SpoofCompiler.rFindAndRemoveLookup(tmp, mainInput);
        }
    }

    private static boolean rHasLookupRC1(CNode node, CNodeData mainInput) {
        boolean ret = false;
        for (int i = 0; i < node.getInput().size() && !ret; ++i) {
            CNode tmp = node.getInput().get(i);
            if (SpoofCompiler.isLookupRC1(tmp, mainInput)) {
                ret = true;
                continue;
            }
            ret |= SpoofCompiler.rHasLookupRC1(tmp, mainInput);
        }
        return ret;
    }

    private static boolean isLookupRC1(CNode node, CNodeData mainInput) {
        return node instanceof CNodeTernary && ((CNodeTernary)node).getType() == CNodeTernary.TernaryType.LOOKUP_RC1 && node.getInput().get(0) instanceof CNodeData && ((CNodeData)node.getInput().get(0)).getHopID() == mainInput.getHopID();
    }

    static {
        if (LDEBUG) {
            Logger.getLogger((String)"org.apache.sysml.hops.codegen").setLevel(Level.TRACE);
        }
        planCache = new PlanCache(1024);
        rewriteCSE = new ProgramRewriter(new RewriteCommonSubexpressionElimination(true), new RewriteRemoveUnnecessaryCasts());
    }

    private static class PlanCache {
        private final LinkedHashMap<CNode, Class<?>> _plans = new LinkedHashMap();
        private final int _maxSize;

        public PlanCache(int maxSize) {
            this._maxSize = maxSize;
        }

        public synchronized Class<?> getPlan(CNode key) {
            Class value = (Class)this._plans.remove(key);
            if (value != null) {
                this._plans.put(key, value);
            }
            return value;
        }

        public synchronized void putPlan(CNode key, Class<?> value) {
            if (this._plans.size() >= this._maxSize) {
                Iterator<Map.Entry<CNode, Class<?>>> iter = this._plans.entrySet().iterator();
                Class<?> rmCla = iter.next().getValue();
                CodegenUtils.clearClassCache(rmCla);
                iter.remove();
            }
            this._plans.put(key, value);
        }

        public synchronized void clear() {
            this._plans.clear();
        }
    }

    public static enum PlanCachePolicy {
        CONSTANT,
        CSLH,
        NONE;


        public static PlanCachePolicy get(boolean planCache, boolean compileLiterals) {
            return !planCache ? NONE : (compileLiterals ? CONSTANT : CSLH);
        }
    }

    public static enum PlanSelector {
        FUSE_ALL,
        FUSE_NO_REDUNDANCY,
        FUSE_COST_BASED;

    }

    public static enum IntegrationType {
        HOPS,
        RUNTIME;

    }

    public static enum CompilerType {
        JAVAC,
        JANINO;

    }
}

