/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.hops;

import org.apache.sysml.api.DMLScript;
import org.apache.sysml.conf.ConfigurationManager;
import org.apache.sysml.hops.BinaryOp;
import org.apache.sysml.hops.DataGenOp;
import org.apache.sysml.hops.Hop;
import org.apache.sysml.hops.HopsException;
import org.apache.sysml.hops.LiteralOp;
import org.apache.sysml.hops.MemoTable;
import org.apache.sysml.hops.OptimizerUtils;
import org.apache.sysml.hops.ParameterizedBuiltinOp;
import org.apache.sysml.hops.ReorgOp;
import org.apache.sysml.hops.rewrite.HopRewriteUtils;
import org.apache.sysml.lops.Aggregate;
import org.apache.sysml.lops.CentralMoment;
import org.apache.sysml.lops.CoVariance;
import org.apache.sysml.lops.CombineBinary;
import org.apache.sysml.lops.CombineTernary;
import org.apache.sysml.lops.Group;
import org.apache.sysml.lops.Lop;
import org.apache.sysml.lops.LopProperties;
import org.apache.sysml.lops.LopsException;
import org.apache.sysml.lops.PartialAggregate;
import org.apache.sysml.lops.PickByCount;
import org.apache.sysml.lops.PlusMult;
import org.apache.sysml.lops.RepMat;
import org.apache.sysml.lops.SortKeys;
import org.apache.sysml.lops.Ternary;
import org.apache.sysml.lops.UnaryCP;
import org.apache.sysml.parser.Expression;
import org.apache.sysml.runtime.matrix.MatrixCharacteristics;

public class TernaryOp
extends Hop {
    public static boolean ALLOW_CTABLE_SEQUENCE_REWRITES = true;
    private Hop.OpOp3 _op = null;
    private boolean _dimInputsPresent = false;
    private boolean _disjointInputs = false;

    private TernaryOp() {
    }

    public TernaryOp(String l, Expression.DataType dt, Expression.ValueType vt, Hop.OpOp3 o, Hop inp1, Hop inp2, Hop inp3) {
        super(l, dt, vt);
        this._op = o;
        this.getInput().add(0, inp1);
        this.getInput().add(1, inp2);
        this.getInput().add(2, inp3);
        inp1.getParent().add(this);
        inp2.getParent().add(this);
        inp3.getParent().add(this);
    }

    public TernaryOp(String l, Expression.DataType dt, Expression.ValueType vt, Hop.OpOp3 o, Hop inp1, Hop inp2, Hop inp3, Hop inp4, Hop inp5) {
        super(l, dt, vt);
        this._op = o;
        this.getInput().add(0, inp1);
        this.getInput().add(1, inp2);
        this.getInput().add(2, inp3);
        this.getInput().add(3, inp4);
        this.getInput().add(4, inp5);
        inp1.getParent().add(this);
        inp2.getParent().add(this);
        inp3.getParent().add(this);
        inp4.getParent().add(this);
        inp5.getParent().add(this);
        this._dimInputsPresent = true;
    }

    public Hop.OpOp3 getOp() {
        return this._op;
    }

    public void setDisjointInputs(boolean flag) {
        this._disjointInputs = flag;
    }

    @Override
    public Lop constructLops() throws HopsException, LopsException {
        if (this.getLops() != null) {
            return this.getLops();
        }
        try {
            switch (this._op) {
                case CENTRALMOMENT: {
                    this.constructLopsCentralMoment();
                    break;
                }
                case COVARIANCE: {
                    this.constructLopsCovariance();
                    break;
                }
                case QUANTILE: 
                case INTERQUANTILE: {
                    this.constructLopsQuantile();
                    break;
                }
                case CTABLE: {
                    this.constructLopsCtable();
                    break;
                }
                case PLUS_MULT: 
                case MINUS_MULT: {
                    this.constructLopsPlusMult();
                    break;
                }
                default: {
                    throw new HopsException(this.printErrorLocation() + "Unknown TernaryOp (" + (Object)((Object)this._op) + ") while constructing Lops \n");
                }
            }
        }
        catch (LopsException e) {
            throw new HopsException(this.printErrorLocation() + "error constructing Lops for TernaryOp Hop ", e);
        }
        this.constructAndSetLopsDataFlowProperties();
        return this.getLops();
    }

    private void constructLopsCentralMoment() throws HopsException, LopsException {
        if (this._op != Hop.OpOp3.CENTRALMOMENT) {
            throw new HopsException("Unexpected operation: " + (Object)((Object)this._op) + ", expecting " + (Object)((Object)Hop.OpOp3.CENTRALMOMENT));
        }
        LopProperties.ExecType et = this.optFindExecType();
        if (et == LopProperties.ExecType.MR) {
            CombineBinary combine = CombineBinary.constructCombineLop(CombineBinary.OperationTypes.PreCentralMoment, this.getInput().get(0).constructLops(), this.getInput().get(1).constructLops(), Expression.DataType.MATRIX, this.getValueType());
            combine.getOutputParameters().setDimensions(this.getInput().get(0).getDim1(), this.getInput().get(0).getDim2(), this.getInput().get(0).getRowsInBlock(), this.getInput().get(0).getColsInBlock(), this.getInput().get(0).getNnz());
            CentralMoment cm = new CentralMoment(combine, this.getInput().get(2).constructLops(), Expression.DataType.MATRIX, this.getValueType(), et);
            cm.getOutputParameters().setDimensions(1L, 1L, 0L, 0L, -1L);
            this.setLineNumbers(cm);
            UnaryCP unary1 = new UnaryCP(cm, (UnaryCP.OperationTypes)((Object)HopsOpOp1LopsUS.get((Object)Hop.OpOp1.CAST_AS_SCALAR)), this.getDataType(), this.getValueType());
            unary1.getOutputParameters().setDimensions(0L, 0L, 0L, 0L, -1L);
            this.setLineNumbers(unary1);
            this.setLops(unary1);
        } else {
            CentralMoment cm = new CentralMoment(this.getInput().get(0).constructLops(), this.getInput().get(1).constructLops(), this.getInput().get(2).constructLops(), this.getDataType(), this.getValueType(), et);
            cm.getOutputParameters().setDimensions(0L, 0L, 0L, 0L, -1L);
            this.setLineNumbers(cm);
            this.setLops(cm);
        }
    }

    private void constructLopsCovariance() throws HopsException, LopsException {
        if (this._op != Hop.OpOp3.COVARIANCE) {
            throw new HopsException("Unexpected operation: " + (Object)((Object)this._op) + ", expecting " + (Object)((Object)Hop.OpOp3.COVARIANCE));
        }
        LopProperties.ExecType et = this.optFindExecType();
        if (et == LopProperties.ExecType.MR) {
            CombineTernary combine = CombineTernary.constructCombineLop(CombineTernary.OperationTypes.PreCovWeighted, this.getInput().get(0).constructLops(), this.getInput().get(1).constructLops(), this.getInput().get(2).constructLops(), Expression.DataType.MATRIX, this.getValueType());
            combine.getOutputParameters().setDimensions(this.getInput().get(0).getDim1(), this.getInput().get(0).getDim2(), this.getInput().get(0).getRowsInBlock(), this.getInput().get(0).getColsInBlock(), this.getInput().get(0).getNnz());
            CoVariance cov = new CoVariance(combine, Expression.DataType.MATRIX, this.getValueType(), et);
            cov.getOutputParameters().setDimensions(1L, 1L, 0L, 0L, -1L);
            this.setLineNumbers(cov);
            UnaryCP unary1 = new UnaryCP(cov, (UnaryCP.OperationTypes)((Object)HopsOpOp1LopsUS.get((Object)Hop.OpOp1.CAST_AS_SCALAR)), this.getDataType(), this.getValueType());
            unary1.getOutputParameters().setDimensions(0L, 0L, 0L, 0L, -1L);
            this.setLineNumbers(unary1);
            this.setLops(unary1);
        } else {
            CoVariance cov = new CoVariance(this.getInput().get(0).constructLops(), this.getInput().get(1).constructLops(), this.getInput().get(2).constructLops(), this.getDataType(), this.getValueType(), et);
            cov.getOutputParameters().setDimensions(0L, 0L, 0L, 0L, -1L);
            this.setLineNumbers(cov);
            this.setLops(cov);
        }
    }

    private void constructLopsQuantile() throws HopsException, LopsException {
        if (this._op != Hop.OpOp3.QUANTILE && this._op != Hop.OpOp3.INTERQUANTILE) {
            throw new HopsException("Unexpected operation: " + (Object)((Object)this._op) + ", expecting " + (Object)((Object)Hop.OpOp3.QUANTILE) + " or " + (Object)((Object)Hop.OpOp3.INTERQUANTILE));
        }
        LopProperties.ExecType et = this.optFindExecType();
        if (et == LopProperties.ExecType.MR) {
            CombineBinary combine = CombineBinary.constructCombineLop(CombineBinary.OperationTypes.PreSort, this.getInput().get(0).constructLops(), this.getInput().get(1).constructLops(), Expression.DataType.MATRIX, this.getValueType());
            SortKeys sort = SortKeys.constructSortByValueLop(combine, SortKeys.OperationTypes.WithWeights, Expression.DataType.MATRIX, this.getValueType(), et);
            LopProperties.ExecType et_pick = this.getInput().get(2).getDataType() == Expression.DataType.SCALAR ? LopProperties.ExecType.CP : LopProperties.ExecType.MR;
            PickByCount pick = new PickByCount(sort, this.getInput().get(2).constructLops(), this.getDataType(), this.getValueType(), this._op == Hop.OpOp3.QUANTILE ? PickByCount.OperationTypes.VALUEPICK : PickByCount.OperationTypes.RANGEPICK, et_pick, false);
            combine.getOutputParameters().setDimensions(this.getInput().get(0).getDim1(), this.getInput().get(0).getDim2(), this.getInput().get(0).getRowsInBlock(), this.getInput().get(0).getColsInBlock(), this.getInput().get(0).getNnz());
            sort.getOutputParameters().setDimensions(this.getInput().get(0).getDim1(), this.getInput().get(0).getDim2(), this.getInput().get(0).getRowsInBlock(), this.getInput().get(0).getColsInBlock(), this.getInput().get(0).getNnz());
            this.setOutputDimensions(pick);
            this.setLineNumbers(pick);
            this.setLops(pick);
        } else {
            SortKeys sort = SortKeys.constructSortByValueLop(this.getInput().get(0).constructLops(), this.getInput().get(1).constructLops(), SortKeys.OperationTypes.WithWeights, this.getInput().get(0).getDataType(), this.getInput().get(0).getValueType(), et);
            PickByCount pick = new PickByCount(sort, this.getInput().get(2).constructLops(), this.getDataType(), this.getValueType(), this._op == Hop.OpOp3.QUANTILE ? PickByCount.OperationTypes.VALUEPICK : PickByCount.OperationTypes.RANGEPICK, et, true);
            sort.getOutputParameters().setDimensions(this.getInput().get(0).getDim1(), this.getInput().get(0).getDim2(), this.getInput().get(0).getRowsInBlock(), this.getInput().get(0).getColsInBlock(), this.getInput().get(0).getNnz());
            this.setOutputDimensions(pick);
            this.setLineNumbers(pick);
            this.setLops(pick);
        }
    }

    private void constructLopsCtable() throws HopsException, LopsException {
        if (this._op != Hop.OpOp3.CTABLE) {
            throw new HopsException("Unexpected operation: " + (Object)((Object)this._op) + ", expecting " + (Object)((Object)Hop.OpOp3.CTABLE));
        }
        Expression.DataType dt1 = this.getInput().get(0).getDataType();
        Expression.DataType dt2 = this.getInput().get(1).getDataType();
        Expression.DataType dt3 = this.getInput().get(2).getDataType();
        Ternary.OperationTypes tertiaryOpOrig = Ternary.findCtableOperationByInputDataTypes(dt1, dt2, dt3);
        Lop[] inputLops = new Lop[this.getInput().size()];
        for (int i = 0; i < this.getInput().size(); ++i) {
            inputLops[i] = this.getInput().get(i).constructLops();
        }
        LopProperties.ExecType et = this.optFindExecType();
        this.setRequiresReblock(false);
        if (et == LopProperties.ExecType.CP || et == LopProperties.ExecType.SPARK) {
            Ternary.OperationTypes tertiaryOp = this.isSequenceRewriteApplicable(true) ? Ternary.OperationTypes.CTABLE_EXPAND_SCALAR_WEIGHT : tertiaryOpOrig;
            boolean ignoreZeros = false;
            if (this.isMatrixIgnoreZeroRewriteApplicable()) {
                ignoreZeros = true;
                inputLops[0] = ((ParameterizedBuiltinOp)this.getInput().get(0)).getTargetHop().getInput().get(0).constructLops();
                inputLops[1] = ((ParameterizedBuiltinOp)this.getInput().get(1)).getTargetHop().getInput().get(0).constructLops();
            }
            Ternary tertiary = new Ternary(inputLops, tertiaryOp, this.getDataType(), this.getValueType(), ignoreZeros, et);
            tertiary.getOutputParameters().setDimensions(this._dim1, this._dim2, this.getRowsInBlock(), this.getColsInBlock(), -1L);
            tertiary.setAllPositions(this.getBeginLine(), this.getBeginColumn(), this.getEndLine(), this.getEndColumn());
            if (et == LopProperties.ExecType.SPARK) {
                tertiary.getOutputParameters().setDimensions(this._dim1, this._dim2, -1L, -1L, -1L);
                this.setRequiresReblock(true);
            } else {
                tertiary.getOutputParameters().setDimensions(this._dim1, this._dim2, this.getRowsInBlock(), this.getColsInBlock(), -1L);
            }
            this.setLops(tertiary);
        } else {
            Ternary.OperationTypes tertiaryOp = this.isSequenceRewriteApplicable() ? Ternary.OperationTypes.CTABLE_EXPAND_SCALAR_WEIGHT : tertiaryOpOrig;
            Group group1 = null;
            Group group2 = null;
            Group group3 = null;
            Group group4 = null;
            group1 = new Group(inputLops[0], Group.OperationTypes.Sort, this.getDataType(), this.getValueType());
            group1.getOutputParameters().setDimensions(this.getDim1(), this.getDim2(), this.getRowsInBlock(), this.getColsInBlock(), this.getNnz());
            group1.setAllPositions(this.getBeginLine(), this.getBeginColumn(), this.getEndLine(), this.getEndColumn());
            Ternary tertiary = null;
            switch (tertiaryOp) {
                case CTABLE_TRANSFORM: {
                    group2 = new Group(inputLops[1], Group.OperationTypes.Sort, this.getDataType(), this.getValueType());
                    group2.getOutputParameters().setDimensions(this.getDim1(), this.getDim2(), this.getRowsInBlock(), this.getColsInBlock(), this.getNnz());
                    group2.setAllPositions(this.getBeginLine(), this.getBeginColumn(), this.getEndLine(), this.getEndColumn());
                    group3 = new Group(inputLops[2], Group.OperationTypes.Sort, this.getDataType(), this.getValueType());
                    group3.getOutputParameters().setDimensions(this.getDim1(), this.getDim2(), this.getRowsInBlock(), this.getColsInBlock(), this.getNnz());
                    group3.setAllPositions(this.getBeginLine(), this.getBeginColumn(), this.getEndLine(), this.getEndColumn());
                    if (inputLops.length == 3) {
                        tertiary = new Ternary(new Lop[]{group1, group2, group3}, tertiaryOp, this.getDataType(), this.getValueType(), et);
                        break;
                    }
                    tertiary = new Ternary(new Lop[]{group1, group2, group3, inputLops[3], inputLops[4]}, tertiaryOp, this.getDataType(), this.getValueType(), et);
                    break;
                }
                case CTABLE_TRANSFORM_SCALAR_WEIGHT: {
                    group2 = new Group(inputLops[1], Group.OperationTypes.Sort, this.getDataType(), this.getValueType());
                    group2.getOutputParameters().setDimensions(this.getDim1(), this.getDim2(), this.getRowsInBlock(), this.getColsInBlock(), this.getNnz());
                    group2.setAllPositions(this.getBeginLine(), this.getBeginColumn(), this.getEndLine(), this.getEndColumn());
                    if (inputLops.length == 3) {
                        tertiary = new Ternary(new Lop[]{group1, group2, inputLops[2]}, tertiaryOp, this.getDataType(), this.getValueType(), et);
                        break;
                    }
                    tertiary = new Ternary(new Lop[]{group1, group2, inputLops[2], inputLops[3], inputLops[4]}, tertiaryOp, this.getDataType(), this.getValueType(), et);
                    break;
                }
                case CTABLE_EXPAND_SCALAR_WEIGHT: {
                    int left = this.isSequenceRewriteApplicable(true) ? 1 : 0;
                    Group group = new Group(this.getInput().get(left).constructLops(), Group.OperationTypes.Sort, this.getDataType(), this.getValueType());
                    group.getOutputParameters().setDimensions(this.getDim1(), this.getDim2(), this.getRowsInBlock(), this.getColsInBlock(), this.getNnz());
                    if (inputLops.length == 3) {
                        tertiary = new Ternary(new Lop[]{group, this.getInput().get(2).constructLops(), new LiteralOp(left).constructLops()}, tertiaryOp, this.getDataType(), this.getValueType(), et);
                        break;
                    }
                    tertiary = new Ternary(new Lop[]{group, this.getInput().get(2).constructLops(), new LiteralOp(left).constructLops(), inputLops[3], inputLops[4]}, tertiaryOp, this.getDataType(), this.getValueType(), et);
                    break;
                }
                case CTABLE_TRANSFORM_HISTOGRAM: {
                    if (inputLops.length == 3) {
                        tertiary = new Ternary(new Lop[]{group1, this.getInput().get(1).constructLops(), this.getInput().get(2).constructLops()}, tertiaryOp, this.getDataType(), this.getValueType(), et);
                        break;
                    }
                    tertiary = new Ternary(new Lop[]{group1, this.getInput().get(1).constructLops(), this.getInput().get(2).constructLops(), inputLops[3], inputLops[4]}, tertiaryOp, this.getDataType(), this.getValueType(), et);
                    break;
                }
                case CTABLE_TRANSFORM_WEIGHTED_HISTOGRAM: {
                    group3 = new Group(this.getInput().get(2).constructLops(), Group.OperationTypes.Sort, this.getDataType(), this.getValueType());
                    group3.getOutputParameters().setDimensions(this.getDim1(), this.getDim2(), this.getRowsInBlock(), this.getColsInBlock(), this.getNnz());
                    group3.setAllPositions(this.getBeginLine(), this.getBeginColumn(), this.getEndLine(), this.getEndColumn());
                    if (inputLops.length == 3) {
                        tertiary = new Ternary(new Lop[]{group1, this.getInput().get(1).constructLops(), group3}, tertiaryOp, this.getDataType(), this.getValueType(), et);
                        break;
                    }
                    tertiary = new Ternary(new Lop[]{group1, this.getInput().get(1).constructLops(), group3, inputLops[3], inputLops[4]}, tertiaryOp, this.getDataType(), this.getValueType(), et);
                    break;
                }
                default: {
                    throw new HopsException("Invalid ternary operator type: " + (Object)((Object)this._op));
                }
            }
            tertiary.getOutputParameters().setDimensions(this._dim1, this._dim2, this._dimInputsPresent ? this.getRowsInBlock() : -1L, this._dimInputsPresent ? this.getColsInBlock() : -1L, -1L);
            this.setLineNumbers(tertiary);
            Lop lctable = tertiary;
            if (!this._disjointInputs && tertiaryOp != Ternary.OperationTypes.CTABLE_EXPAND_SCALAR_WEIGHT) {
                group4 = new Group(tertiary, Group.OperationTypes.Sort, this.getDataType(), this.getValueType());
                group4.getOutputParameters().setDimensions(this._dim1, this._dim2, this._dimInputsPresent ? this.getRowsInBlock() : -1L, this._dimInputsPresent ? this.getColsInBlock() : -1L, -1L);
                group4.setAllPositions(this.getBeginLine(), this.getBeginColumn(), this.getEndLine(), this.getEndColumn());
                Aggregate agg1 = new Aggregate(group4, (Aggregate.OperationTypes)((Object)HopsAgg2Lops.get((Object)Hop.AggOp.SUM)), this.getDataType(), this.getValueType(), LopProperties.ExecType.MR);
                agg1.getOutputParameters().setDimensions(this._dim1, this._dim2, this._dimInputsPresent ? this.getRowsInBlock() : -1L, this._dimInputsPresent ? this.getColsInBlock() : -1L, -1L);
                agg1.setAllPositions(this.getBeginLine(), this.getBeginColumn(), this.getEndLine(), this.getEndColumn());
                agg1.setupCorrectionLocation(PartialAggregate.CorrectionLocationType.NONE);
                lctable = agg1;
            }
            this.setLops(lctable);
            if (!this.dimsKnown() && !this._dimInputsPresent) {
                this.setRequiresReblock(true);
            }
        }
    }

    private void constructLopsPlusMult() throws HopsException, LopsException {
        if (this._op != Hop.OpOp3.PLUS_MULT && this._op != Hop.OpOp3.MINUS_MULT) {
            throw new HopsException("Unexpected operation: " + (Object)((Object)this._op) + ", expecting " + (Object)((Object)Hop.OpOp3.PLUS_MULT) + " or" + (Object)((Object)Hop.OpOp3.MINUS_MULT));
        }
        LopProperties.ExecType et = null;
        et = DMLScript.USE_ACCELERATOR && (DMLScript.FORCE_ACCELERATOR || this.getMemEstimate() < (double)OptimizerUtils.GPU_MEMORY_BUDGET) ? LopProperties.ExecType.GPU : this.optFindExecType();
        PlusMult plusmult = null;
        if (et == LopProperties.ExecType.CP || et == LopProperties.ExecType.SPARK || et == LopProperties.ExecType.GPU) {
            plusmult = new PlusMult(this.getInput().get(0).constructLops(), this.getInput().get(1).constructLops(), this.getInput().get(2).constructLops(), this._op, this.getDataType(), this.getValueType(), et);
        } else {
            Hop left = this.getInput().get(0);
            Hop right = this.getInput().get(2);
            boolean requiresRep = BinaryOp.requiresReplication(left, right);
            Lop rightLop = right.constructLops();
            if (requiresRep) {
                Lop offset = TernaryOp.createOffsetLop(left, right.getDim2() <= 1L);
                rightLop = new RepMat(rightLop, offset, right.getDim2() <= 1L, right.getDataType(), right.getValueType());
                this.setOutputDimensions(rightLop);
                this.setLineNumbers(rightLop);
            }
            Group group1 = new Group(left.constructLops(), Group.OperationTypes.Sort, this.getDataType(), this.getValueType());
            this.setLineNumbers(group1);
            this.setOutputDimensions(group1);
            Group group2 = new Group(rightLop, Group.OperationTypes.Sort, this.getDataType(), this.getValueType());
            this.setLineNumbers(group2);
            this.setOutputDimensions(group2);
            plusmult = new PlusMult(group1, this.getInput().get(1).constructLops(), group2, this._op, this.getDataType(), this.getValueType(), et);
        }
        this.setOutputDimensions(plusmult);
        this.setLineNumbers(plusmult);
        this.setLops(plusmult);
    }

    @Override
    public String getOpString() {
        String s = new String("");
        s = s + "t(" + (String)HopsOpOp3String.get((Object)this._op) + ")";
        return s;
    }

    @Override
    public boolean allowsAllExecTypes() {
        return true;
    }

    @Override
    protected double computeOutputMemEstimate(long dim1, long dim2, long nnz) {
        switch (this._op) {
            case CTABLE: {
                double sparsity = OptimizerUtils.getSparsity(dim1, dim2, nnz <= dim1 ? nnz : dim1);
                return OptimizerUtils.estimateSizeExactSparsity(dim1, dim2, sparsity);
            }
            case QUANTILE: {
                return OptimizerUtils.estimateSizeExactSparsity(dim1, dim2, 1.0);
            }
            case PLUS_MULT: 
            case MINUS_MULT: {
                double sparsity = OptimizerUtils.getSparsity(dim1, dim2, nnz);
                return OptimizerUtils.estimateSizeExactSparsity(dim1, dim2, sparsity);
            }
        }
        throw new RuntimeException("Memory for operation (" + (Object)((Object)this._op) + ") can not be estimated.");
    }

    @Override
    protected double computeIntermediateMemEstimate(long dim1, long dim2, long nnz) {
        double ret = 0.0;
        if (this._op == Hop.OpOp3.CTABLE) {
            if (this._dim1 > 0L && this._dim2 > 0L) {
                double sp = OptimizerUtils.getSparsity(this._dim1, this._dim2, Math.min(nnz, this._dim1));
                ret = OptimizerUtils.estimateSizeExactSparsity(this._dim1, this._dim2, sp);
            } else {
                ret = 8L * dim1 + 32L * dim1;
            }
        } else if (this._op == Hop.OpOp3.QUANTILE) {
            ret = this.getInput().get(0).getMemEstimate() * 4.0;
        }
        return ret;
    }

    @Override
    protected long[] inferOutputCharacteristics(MemoTable memo) {
        long[] ret = null;
        MatrixCharacteristics[] mc = memo.getAllInputStats(this.getInput());
        switch (this._op) {
            case CTABLE: {
                boolean dimsSpec = this.getInput().size() > 3;
                long worstCaseDim = -1L;
                if (mc[0].dimsKnown() || mc[1].dimsKnown()) {
                    long l = mc[0].dimsKnown() ? (mc[0].getRows() > 1L ? mc[0].getRows() : mc[0].getCols()) : (worstCaseDim = mc[1].getRows() > 1L ? mc[1].getRows() : mc[1].getCols());
                }
                if (dimsSpec && this.getInput().get(3) instanceof LiteralOp && this.getInput().get(4) instanceof LiteralOp) {
                    long outputDim2;
                    long outputDim1 = HopRewriteUtils.getIntValueSafe((LiteralOp)this.getInput().get(3));
                    long outputNNZ = outputDim1 * (outputDim2 = HopRewriteUtils.getIntValueSafe((LiteralOp)this.getInput().get(4))) > outputDim1 ? outputDim1 : outputDim1 * outputDim2;
                    this._dim1 = outputDim1;
                    this._dim2 = outputDim2;
                    return new long[]{outputDim1, outputDim2, outputNNZ};
                }
                return new long[]{worstCaseDim, worstCaseDim, worstCaseDim};
            }
            case QUANTILE: {
                if (!mc[2].dimsKnown()) break;
                return new long[]{mc[2].getRows(), 1L, mc[2].getRows()};
            }
            case PLUS_MULT: 
            case MINUS_MULT: {
                double sp1 = OptimizerUtils.getSparsity(mc[0].getRows(), mc[0].getRows(), mc[0].getNonZeros());
                double sp2 = OptimizerUtils.getSparsity(mc[2].getRows(), mc[2].getRows(), mc[2].getNonZeros());
                return new long[]{mc[0].getRows(), mc[0].getCols(), (long)Math.min(sp1 + sp2, 1.0)};
            }
            default: {
                throw new RuntimeException("Memory for operation (" + (Object)((Object)this._op) + ") can not be estimated.");
            }
        }
        return ret;
    }

    @Override
    protected LopProperties.ExecType optFindExecType() throws HopsException {
        LopProperties.ExecType REMOTE;
        this.checkAndSetForcedPlatform();
        LopProperties.ExecType execType = REMOTE = OptimizerUtils.isSparkExecutionMode() ? LopProperties.ExecType.SPARK : LopProperties.ExecType.MR;
        if (this._etypeForced != null) {
            this._etype = this._etypeForced;
        } else {
            this._etype = OptimizerUtils.isMemoryBasedOptLevel() ? this.findExecTypeByMemEstimate() : (this.getInput().get(0).areDimsBelowThreshold() && this.getInput().get(1).areDimsBelowThreshold() && this.getInput().get(2).areDimsBelowThreshold() ? LopProperties.ExecType.CP : REMOTE);
            this.checkAndSetInvalidCPDimsAndSize();
        }
        if (ConfigurationManager.isDynamicRecompilation() && !this.dimsKnown(true) && (this._etype == REMOTE || this._etype == LopProperties.ExecType.CP && this._dimInputsPresent)) {
            this.setRequiresRecompile();
        }
        return this._etype;
    }

    @Override
    public void refreshSizeInformation() {
        if (this.getDataType() != Expression.DataType.SCALAR) {
            switch (this._op) {
                case CTABLE: {
                    Ternary.OperationTypes tertiaryOp;
                    Hop input1 = this.getInput().get(0);
                    Hop input2 = this.getInput().get(1);
                    Hop input3 = this.getInput().get(2);
                    if (this._dim1 != -1L && this._dim2 != -1L) break;
                    if (this.isSequenceRewriteApplicable()) {
                        if (input1 instanceof DataGenOp && ((DataGenOp)input1).getOp() == Hop.DataGenMethod.SEQ) {
                            this.setDim1(input1._dim1);
                        } else {
                            this.setDim2(input2._dim1);
                        }
                    }
                    if ((tertiaryOp = Ternary.findCtableOperationByInputDataTypes(input1.getDataType(), input2.getDataType(), input3.getDataType())) == Ternary.OperationTypes.CTABLE_TRANSFORM_HISTOGRAM && input2 instanceof LiteralOp) {
                        this.setDim2(HopRewriteUtils.getIntValueSafe((LiteralOp)input2));
                    }
                    if (this.getInput().size() < 5) break;
                    if (this.getInput().get(3) instanceof LiteralOp) {
                        this.setDim1(HopRewriteUtils.getIntValueSafe((LiteralOp)this.getInput().get(3)));
                    }
                    if (!(this.getInput().get(4) instanceof LiteralOp)) break;
                    this.setDim2(HopRewriteUtils.getIntValueSafe((LiteralOp)this.getInput().get(4)));
                    break;
                }
                case QUANTILE: {
                    break;
                }
                case PLUS_MULT: 
                case MINUS_MULT: {
                    this.setDim1(this.getInput().get((int)0)._dim1);
                    this.setDim2(this.getInput().get((int)0)._dim2);
                    break;
                }
                default: {
                    throw new RuntimeException("Size information for operation (" + (Object)((Object)this._op) + ") can not be updated.");
                }
            }
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        TernaryOp ret = new TernaryOp();
        ret.clone(this, false);
        ret._op = this._op;
        ret._dimInputsPresent = this._dimInputsPresent;
        ret._disjointInputs = this._disjointInputs;
        return ret;
    }

    @Override
    public boolean compare(Hop that) {
        if (!(that instanceof TernaryOp)) {
            return false;
        }
        TernaryOp that2 = (TernaryOp)that;
        boolean ret = this._op == that2._op && this.getInput().get(0) == that2.getInput().get(0) && this.getInput().get(1) == that2.getInput().get(1) && this.getInput().get(2) == that2.getInput().get(2);
        if ((ret &= this._dimInputsPresent == that2._dimInputsPresent) && this._dimInputsPresent) {
            ret &= this.getInput().get(3) == that2.getInput().get(3) && this.getInput().get(4) == that2.getInput().get(4);
        }
        return ret &= this._disjointInputs == that2._disjointInputs && this._outputEmptyBlocks == that2._outputEmptyBlocks;
    }

    private boolean isSequenceRewriteApplicable() {
        return this.isSequenceRewriteApplicable(true) || this.isSequenceRewriteApplicable(false);
    }

    private boolean isSequenceRewriteApplicable(boolean left) {
        boolean ret = false;
        if (!ALLOW_CTABLE_SEQUENCE_REWRITES) {
            return ret;
        }
        try {
            if (this.getInput().size() == 2 || this.getInput().size() == 3 && this.getInput().get(2).getDataType() == Expression.DataType.SCALAR) {
                Hop input1 = this.getInput().get(0);
                Hop input2 = this.getInput().get(1);
                if (input1.getDataType() == Expression.DataType.MATRIX && input2.getDataType() == Expression.DataType.MATRIX) {
                    Hop incr;
                    DataGenOp dgop;
                    if (left && input1 instanceof DataGenOp && (dgop = (DataGenOp)input1).getOp() == Hop.DataGenMethod.SEQ) {
                        incr = dgop.getInput().get(dgop.getParamIndex("incr"));
                        boolean bl = ret = incr instanceof LiteralOp && HopRewriteUtils.getDoubleValue((LiteralOp)incr) == 1.0 || dgop.getIncrementValue() == 1.0;
                    }
                    if (!left && input2 instanceof DataGenOp && (dgop = (DataGenOp)input2).getOp() == Hop.DataGenMethod.SEQ) {
                        incr = dgop.getInput().get(dgop.getParamIndex("incr"));
                        ret |= incr instanceof LiteralOp && HopRewriteUtils.getDoubleValue((LiteralOp)incr) == 1.0 || dgop.getIncrementValue() == 1.0;
                    }
                }
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        return ret;
    }

    public boolean isMatrixIgnoreZeroRewriteApplicable() {
        boolean ret = false;
        if (!ALLOW_CTABLE_SEQUENCE_REWRITES || this._op != Hop.OpOp3.CTABLE) {
            return ret;
        }
        try {
            if (this.getInput().size() == 2 || this.getInput().size() > 2 && this.getInput().get(2).getDataType() == Expression.DataType.SCALAR) {
                Hop input1 = this.getInput().get(0);
                Hop input2 = this.getInput().get(1);
                if (input1.getDataType() == Expression.DataType.MATRIX && input2.getDataType() == Expression.DataType.MATRIX && input1 instanceof ParameterizedBuiltinOp && ((ParameterizedBuiltinOp)input1).getOp() == Hop.ParamBuiltinOp.RMEMPTY && input2 instanceof ParameterizedBuiltinOp && ((ParameterizedBuiltinOp)input2).getOp() == Hop.ParamBuiltinOp.RMEMPTY) {
                    ParameterizedBuiltinOp pb1 = (ParameterizedBuiltinOp)input1;
                    ParameterizedBuiltinOp pb2 = (ParameterizedBuiltinOp)input2;
                    Hop pbin1 = pb1.getTargetHop();
                    Hop pbin2 = pb2.getTargetHop();
                    if (pbin1 instanceof ReorgOp && ((ReorgOp)pbin1).getOp() == Hop.ReOrgOp.RESHAPE && pbin2 instanceof ReorgOp && ((ReorgOp)pbin2).getOp() == Hop.ReOrgOp.RESHAPE) {
                        Hop left = pbin1.getInput().get(0);
                        Hop right = pbin2.getInput().get(0);
                        if (left instanceof BinaryOp && ((BinaryOp)left).getOp() == Hop.OpOp2.MULT && left.getInput().get(0) instanceof BinaryOp && ((BinaryOp)left.getInput().get(0)).getOp() == Hop.OpOp2.NOTEQUAL && left.getInput().get(0).getInput().get(1) instanceof LiteralOp && HopRewriteUtils.getDoubleValue((LiteralOp)left.getInput().get(0).getInput().get(1)) == 0.0 && left.getInput().get(0).getInput().get(0) == right) {
                            ret = true;
                        } else if (right instanceof BinaryOp && ((BinaryOp)right).getOp() == Hop.OpOp2.MULT && right.getInput().get(0) instanceof BinaryOp && ((BinaryOp)right.getInput().get(0)).getOp() == Hop.OpOp2.NOTEQUAL && right.getInput().get(0).getInput().get(1) instanceof LiteralOp && HopRewriteUtils.getDoubleValue((LiteralOp)right.getInput().get(0).getInput().get(1)) == 0.0 && right.getInput().get(0).getInput().get(0) == left) {
                            ret = true;
                        }
                    }
                }
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        return ret;
    }
}

