/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.hops;

import org.apache.sysml.conf.ConfigurationManager;
import org.apache.sysml.hops.DataOp;
import org.apache.sysml.hops.Hop;
import org.apache.sysml.hops.HopsException;
import org.apache.sysml.hops.LiteralOp;
import org.apache.sysml.hops.MemoTable;
import org.apache.sysml.hops.OptimizerUtils;
import org.apache.sysml.lops.Binary;
import org.apache.sysml.lops.Group;
import org.apache.sysml.lops.LeftIndex;
import org.apache.sysml.lops.Lop;
import org.apache.sysml.lops.LopProperties;
import org.apache.sysml.lops.LopsException;
import org.apache.sysml.lops.RangeBasedReIndex;
import org.apache.sysml.lops.UnaryCP;
import org.apache.sysml.lops.ZeroOut;
import org.apache.sysml.parser.Expression;
import org.apache.sysml.runtime.matrix.MatrixCharacteristics;

public class LeftIndexingOp
extends Hop {
    public static LeftIndexingMethod FORCED_LEFT_INDEXING = null;
    public static String OPSTRING = "lix";
    private boolean _rowLowerEqualsUpper = false;
    private boolean _colLowerEqualsUpper = false;

    private LeftIndexingOp() {
    }

    public LeftIndexingOp(String l, Expression.DataType dt, Expression.ValueType vt, Hop inpMatrixLeft, Hop inpMatrixRight, Hop inpRowL, Hop inpRowU, Hop inpColL, Hop inpColU, boolean passedRowsLEU, boolean passedColsLEU) {
        super(l, dt, vt);
        this.getInput().add(0, inpMatrixLeft);
        this.getInput().add(1, inpMatrixRight);
        this.getInput().add(2, inpRowL);
        this.getInput().add(3, inpRowU);
        this.getInput().add(4, inpColL);
        this.getInput().add(5, inpColU);
        inpMatrixLeft.getParent().add(this);
        inpMatrixRight.getParent().add(this);
        inpRowL.getParent().add(this);
        inpRowU.getParent().add(this);
        inpColL.getParent().add(this);
        inpColU.getParent().add(this);
        this.setRowLowerEqualsUpper(passedRowsLEU);
        this.setColLowerEqualsUpper(passedColsLEU);
    }

    public boolean getRowLowerEqualsUpper() {
        return this._rowLowerEqualsUpper;
    }

    public boolean getColLowerEqualsUpper() {
        return this._colLowerEqualsUpper;
    }

    public void setRowLowerEqualsUpper(boolean passed) {
        this._rowLowerEqualsUpper = passed;
    }

    public void setColLowerEqualsUpper(boolean passed) {
        this._colLowerEqualsUpper = passed;
    }

    @Override
    public Lop constructLops() throws HopsException, LopsException {
        if (this.getLops() != null) {
            return this.getLops();
        }
        try {
            LopProperties.ExecType et = this.optFindExecType();
            if (et == LopProperties.ExecType.MR) {
                Lop top = this.getInput().get(2).constructLops();
                Lop bottom = this.getInput().get(3).constructLops();
                Lop left = this.getInput().get(4).constructLops();
                Lop right = this.getInput().get(5).constructLops();
                UnaryCP nrow = new UnaryCP(this.getInput().get(0).constructLops(), UnaryCP.OperationTypes.NROW, Expression.DataType.SCALAR, Expression.ValueType.INT);
                UnaryCP ncol = new UnaryCP(this.getInput().get(0).constructLops(), UnaryCP.OperationTypes.NCOL, Expression.DataType.SCALAR, Expression.ValueType.INT);
                Lop rightInput = null;
                if (this.isRightHandSideScalar()) {
                    rightInput = new UnaryCP(this.getInput().get(1).constructLops(), UnaryCP.OperationTypes.CAST_AS_MATRIX, Expression.DataType.MATRIX, Expression.ValueType.DOUBLE);
                    rightInput.getOutputParameters().setDimensions(1L, 1L, ConfigurationManager.getBlocksize(), ConfigurationManager.getBlocksize(), -1L);
                } else {
                    rightInput = this.getInput().get(1).constructLops();
                }
                RangeBasedReIndex reindex = new RangeBasedReIndex(rightInput, top, bottom, left, right, (Lop)nrow, (Lop)ncol, this.getDataType(), this.getValueType(), et, true);
                reindex.getOutputParameters().setDimensions(this.getInput().get(0).getDim1(), this.getInput().get(0).getDim2(), this.getRowsInBlock(), this.getColsInBlock(), this.getNnz());
                this.setLineNumbers(reindex);
                Group group1 = new Group(reindex, Group.OperationTypes.Sort, Expression.DataType.MATRIX, this.getValueType());
                group1.getOutputParameters().setDimensions(this.getInput().get(0).getDim1(), this.getInput().get(0).getDim2(), this.getRowsInBlock(), this.getColsInBlock(), this.getNnz());
                this.setLineNumbers(group1);
                ZeroOut zeroout = new ZeroOut(this.getInput().get(0).constructLops(), top, bottom, left, right, this.getInput().get(0).getDim1(), this.getInput().get(0).getDim2(), this.getDataType(), this.getValueType(), et);
                zeroout.getOutputParameters().setDimensions(this.getInput().get(0).getDim1(), this.getInput().get(0).getDim2(), this.getRowsInBlock(), this.getColsInBlock(), this.getNnz());
                this.setLineNumbers(zeroout);
                Group group2 = new Group(zeroout, Group.OperationTypes.Sort, Expression.DataType.MATRIX, this.getValueType());
                group2.getOutputParameters().setDimensions(this.getInput().get(0).getDim1(), this.getInput().get(0).getDim2(), this.getRowsInBlock(), this.getColsInBlock(), this.getNnz());
                this.setLineNumbers(group2);
                Binary binary = new Binary(group1, group2, (Binary.OperationTypes)((Object)HopsOpOp2LopsB.get((Object)Hop.OpOp2.PLUS)), this.getDataType(), this.getValueType(), et);
                binary.getOutputParameters().setDimensions(this.getInput().get(0).getDim1(), this.getInput().get(0).getDim2(), this.getRowsInBlock(), this.getColsInBlock(), this.getNnz());
                this.setLineNumbers(binary);
                this.setLops(binary);
            } else if (et == LopProperties.ExecType.SPARK) {
                Hop left = this.getInput().get(0);
                Hop right = this.getInput().get(1);
                LeftIndexingMethod method = LeftIndexingOp.getOptMethodLeftIndexingMethod(left.getDim1(), left.getDim2(), left.getRowsInBlock(), left.getColsInBlock(), left.getNnz(), right.getDim1(), right.getDim2(), right.getNnz(), right.getDataType());
                Lop rightInput = right.constructLops();
                if (this.isRightHandSideScalar()) {
                    rightInput = new UnaryCP(rightInput, left.getDataType() == Expression.DataType.MATRIX ? UnaryCP.OperationTypes.CAST_AS_MATRIX : UnaryCP.OperationTypes.CAST_AS_FRAME, left.getDataType(), right.getValueType());
                    long bsize = ConfigurationManager.getBlocksize();
                    rightInput.getOutputParameters().setDimensions(1L, 1L, bsize, bsize, -1L);
                }
                LeftIndex leftIndexLop = new LeftIndex(left.constructLops(), rightInput, this.getInput().get(2).constructLops(), this.getInput().get(3).constructLops(), this.getInput().get(4).constructLops(), this.getInput().get(5).constructLops(), this.getDataType(), this.getValueType(), et, this.getSpLixCacheType(method));
                this.setOutputDimensions(leftIndexLop);
                this.setLineNumbers(leftIndexLop);
                this.setLops(leftIndexLop);
            } else {
                LeftIndex left = new LeftIndex(this.getInput().get(0).constructLops(), this.getInput().get(1).constructLops(), this.getInput().get(2).constructLops(), this.getInput().get(3).constructLops(), this.getInput().get(4).constructLops(), this.getInput().get(5).constructLops(), this.getDataType(), this.getValueType(), et);
                this.setOutputDimensions(left);
                this.setLineNumbers(left);
                this.setLops(left);
            }
        }
        catch (Exception e) {
            throw new HopsException(this.printErrorLocation() + "In LeftIndexingOp Hop, error in constructing Lops ", e);
        }
        this.constructAndSetLopsDataFlowProperties();
        return this.getLops();
    }

    private boolean isRightHandSideScalar() {
        Hop rightHandSide = this.getInput().get(1);
        return rightHandSide.getDataType() == Expression.DataType.SCALAR;
    }

    private LeftIndex.LixCacheType getSpLixCacheType(LeftIndexingMethod method) {
        switch (method) {
            case SP_MLEFTINDEX_L: {
                return LeftIndex.LixCacheType.LEFT;
            }
            case SP_MLEFTINDEX_R: {
                return LeftIndex.LixCacheType.RIGHT;
            }
        }
        return LeftIndex.LixCacheType.NONE;
    }

    @Override
    public String getOpString() {
        String s = new String("");
        s = s + OPSTRING;
        return s;
    }

    @Override
    public boolean allowsAllExecTypes() {
        return false;
    }

    @Override
    public void computeMemEstimate(MemoTable memo) {
        super.computeMemEstimate(memo);
        Hop rhM = this.getInput().get(1);
        MatrixCharacteristics mcRhM = memo.getAllInputStats(rhM);
        if (this.dimsKnown() && !rhM.dimsKnown() && !mcRhM.dimsKnown()) {
            double subSize = -1.0;
            subSize = this._rowLowerEqualsUpper && this._colLowerEqualsUpper ? (double)OptimizerUtils.estimateSize(1L, 1L) : (this._rowLowerEqualsUpper ? (double)OptimizerUtils.estimateSize(1L, this._dim2) : (this._colLowerEqualsUpper ? (double)OptimizerUtils.estimateSize(this._dim1, 1L) : this._outputMemEstimate));
            this._memEstimate = this.getInputSize(0) + subSize + this._outputMemEstimate;
        } else if (this.dimsKnown() && this._nnz < 0L && this._memEstimate >= OptimizerUtils.DEFAULT_SIZE) {
            MatrixCharacteristics mcM1 = memo.getAllInputStats(this.getInput().get(0));
            MatrixCharacteristics mcM2 = memo.getAllInputStats(this.getInput().get(1));
            if (mcM1.getNonZeros() >= 0L && mcM2.getNonZeros() >= 0L && this.hasConstantIndexingRange()) {
                long lnnz = mcM1.getNonZeros() + mcM2.getNonZeros();
                this._outputMemEstimate = this.computeOutputMemEstimate(this._dim1, this._dim2, lnnz);
                this._memEstimate = this.getInputSize(0) + this.getInputSize(1) + this._outputMemEstimate;
            }
        }
    }

    @Override
    protected double computeOutputMemEstimate(long dim1, long dim2, long nnz) {
        double sparsity = 1.0;
        if (nnz < 0L) {
            Hop input1 = this.getInput().get(0);
            Hop input2 = this.getInput().get(1);
            if (input1.dimsKnown() && this.hasConstantIndexingRange()) {
                sparsity = OptimizerUtils.getLeftIndexingSparsity(input1.getDim1(), input1.getDim2(), input1.getNnz(), input2.getDim1(), input2.getDim2(), input2.getNnz());
            }
        } else {
            sparsity = OptimizerUtils.getSparsity(dim1, dim2, nnz);
        }
        return OptimizerUtils.estimateSizeExactSparsity(dim1, dim2, sparsity);
    }

    @Override
    protected double computeIntermediateMemEstimate(long dim1, long dim2, long nnz) {
        return 0.0;
    }

    @Override
    protected long[] inferOutputCharacteristics(MemoTable memo) {
        long[] ret = null;
        Hop input1 = this.getInput().get(0);
        Hop input2 = this.getInput().get(1);
        MatrixCharacteristics mc1 = memo.getAllInputStats(input1);
        MatrixCharacteristics mc2 = memo.getAllInputStats(input2);
        if (mc1.dimsKnown()) {
            double sparsity = OptimizerUtils.getLeftIndexingSparsity(mc1.getRows(), mc1.getCols(), mc1.getNonZeros(), mc2.getRows(), mc2.getCols(), mc2.getNonZeros());
            long lnnz = !this.hasConstantIndexingRange() ? -1L : (long)(sparsity * (double)mc1.getRows() * (double)mc1.getCols());
            ret = new long[]{mc1.getRows(), mc1.getCols(), lnnz};
        }
        return ret;
    }

    @Override
    protected LopProperties.ExecType optFindExecType() throws HopsException {
        LopProperties.ExecType REMOTE;
        this.checkAndSetForcedPlatform();
        LopProperties.ExecType execType = REMOTE = OptimizerUtils.isSparkExecutionMode() ? LopProperties.ExecType.SPARK : LopProperties.ExecType.MR;
        if (this._etypeForced != null) {
            this._etype = this._etypeForced;
        } else {
            if (OptimizerUtils.isMemoryBasedOptLevel()) {
                this._etype = this.findExecTypeByMemEstimate();
                this.checkAndModifyRecompilationStatus();
            } else {
                this._etype = this.getInput().get(0).areDimsBelowThreshold() ? LopProperties.ExecType.CP : REMOTE;
            }
            this.checkAndSetInvalidCPDimsAndSize();
        }
        if (ConfigurationManager.isDynamicRecompilation() && !this.dimsKnown(true) && this._etype == REMOTE) {
            this.setRequiresRecompile();
        }
        return this._etype;
    }

    private static LeftIndexingMethod getOptMethodLeftIndexingMethod(long m1_dim1, long m1_dim2, long m1_rpb, long m1_cpb, long m1_nnz, long m2_dim1, long m2_dim2, long m2_nnz, Expression.DataType rhsDt) {
        if (FORCED_LEFT_INDEXING != null) {
            return FORCED_LEFT_INDEXING;
        }
        if (rhsDt == Expression.DataType.SCALAR) {
            return LeftIndexingMethod.SP_MLEFTINDEX_R;
        }
        if (m2_dim1 >= 1L && m2_dim2 >= 1L && m2_dim1 >= 1L && m2_dim2 >= 1L) {
            boolean isAligned = rhsDt == Expression.DataType.MATRIX && (m1_dim1 == m2_dim1 && m1_dim2 <= m1_cpb || m1_dim2 == m2_dim2 && m1_dim1 <= m1_rpb);
            boolean broadcastRhs = OptimizerUtils.checkSparkBroadcastMemoryBudget(m2_dim1, m2_dim2, m1_rpb, m1_cpb, m2_nnz);
            double m1SizeP = OptimizerUtils.estimatePartitionedSizeExactSparsity(m1_dim1, m1_dim2, m1_rpb, m1_cpb, m1_nnz);
            double m2SizeP = OptimizerUtils.estimatePartitionedSizeExactSparsity(m2_dim1, m2_dim2, m1_rpb, m1_cpb, m2_nnz);
            if (broadcastRhs) {
                if (isAligned && m1SizeP < m2SizeP) {
                    return LeftIndexingMethod.SP_MLEFTINDEX_L;
                }
                return LeftIndexingMethod.SP_MLEFTINDEX_R;
            }
        }
        return LeftIndexingMethod.SP_GLEFTINDEX;
    }

    @Override
    public void refreshSizeInformation() {
        Hop input1 = this.getInput().get(0);
        Hop input2 = this.getInput().get(1);
        this.setDim1(input1.getDim1());
        this.setDim2(input1.getDim2());
        if (input1.getNnz() == 0L && this.hasConstantIndexingRange()) {
            if (input2.getDataType() == Expression.DataType.SCALAR) {
                this.setNnz(1L);
            } else {
                this.setNnz(input2.getNnz());
            }
        } else {
            this.setNnz(-1L);
        }
    }

    private boolean hasConstantIndexingRange() {
        return this.getInput().get(2) instanceof LiteralOp && this.getInput().get(3) instanceof LiteralOp && this.getInput().get(4) instanceof LiteralOp && this.getInput().get(5) instanceof LiteralOp;
    }

    private void checkAndModifyRecompilationStatus() {
        if (this._etype == LopProperties.ExecType.CP) {
            this._requiresRecompile = false;
            Hop rInput = this.getInput().get(1);
            if (!rInput.dimsKnown() && rInput instanceof DataOp) {
                ((DataOp)rInput).disableRecompileRead();
            }
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        LeftIndexingOp ret = new LeftIndexingOp();
        ret.clone(this, false);
        return ret;
    }

    @Override
    public boolean compare(Hop that) {
        if (!(that instanceof LeftIndexingOp) || this.getInput().size() != that.getInput().size()) {
            return false;
        }
        return this.getInput().get(0) == that.getInput().get(0) && this.getInput().get(1) == that.getInput().get(1) && this.getInput().get(2) == that.getInput().get(2) && this.getInput().get(3) == that.getInput().get(3) && this.getInput().get(4) == that.getInput().get(4) && this.getInput().get(5) == that.getInput().get(5);
    }

    public static enum LeftIndexingMethod {
        SP_GLEFTINDEX,
        SP_MLEFTINDEX_R,
        SP_MLEFTINDEX_L;

    }
}

