/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.api.mlcontext;

import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.sysml.api.mlcontext.MLContextConversionUtil;
import org.apache.sysml.api.mlcontext.MLContextException;
import org.apache.sysml.api.mlcontext.MatrixMetadata;
import org.apache.sysml.conf.ConfigurationManager;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.context.SparkExecutionContext;
import org.apache.sysml.runtime.matrix.MatrixCharacteristics;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.data.MatrixIndexes;

public class BinaryBlockMatrix {
    JavaPairRDD<MatrixIndexes, MatrixBlock> binaryBlocks;
    MatrixMetadata matrixMetadata;

    public BinaryBlockMatrix(Dataset<Row> dataFrame, MatrixMetadata matrixMetadata) {
        this.matrixMetadata = matrixMetadata;
        this.binaryBlocks = MLContextConversionUtil.dataFrameToMatrixBinaryBlocks(dataFrame, matrixMetadata);
    }

    public BinaryBlockMatrix(Dataset<Row> dataFrame, long numRows, long numCols) {
        this(dataFrame, new MatrixMetadata(numRows, (Long)numCols, (Integer)ConfigurationManager.getBlocksize(), (Integer)ConfigurationManager.getBlocksize()));
    }

    public BinaryBlockMatrix(Dataset<Row> dataFrame) {
        this(dataFrame, new MatrixMetadata());
    }

    public BinaryBlockMatrix(JavaPairRDD<MatrixIndexes, MatrixBlock> binaryBlocks, MatrixCharacteristics matrixCharacteristics) {
        this.binaryBlocks = binaryBlocks;
        this.matrixMetadata = new MatrixMetadata(matrixCharacteristics);
    }

    public JavaPairRDD<MatrixIndexes, MatrixBlock> getBinaryBlocks() {
        return this.binaryBlocks;
    }

    public MatrixBlock getMatrixBlock() {
        try {
            MatrixCharacteristics mc = this.getMatrixCharacteristics();
            return SparkExecutionContext.toMatrixBlock(this.binaryBlocks, (int)mc.getRows(), (int)mc.getCols(), mc.getRowsPerBlock(), mc.getColsPerBlock(), mc.getNonZeros());
        }
        catch (DMLRuntimeException e) {
            throw new MLContextException("Exception while getting MatrixBlock from binary-block matrix", e);
        }
    }

    public MatrixCharacteristics getMatrixCharacteristics() {
        return this.matrixMetadata.asMatrixCharacteristics();
    }

    public MatrixMetadata getMatrixMetadata() {
        return this.matrixMetadata;
    }

    public void setMatrixMetadata(MatrixMetadata matrixMetadata) {
        this.matrixMetadata = matrixMetadata;
    }

    public void setBinaryBlocks(JavaPairRDD<MatrixIndexes, MatrixBlock> binaryBlocks) {
        this.binaryBlocks = binaryBlocks;
    }

    public String toString() {
        if (this.matrixMetadata != null) {
            return this.matrixMetadata.toString();
        }
        return super.toString();
    }
}

