/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.transform;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.CharacterCodingException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.functionobjects.CM;
import org.apache.sysml.runtime.functionobjects.KahanPlus;
import org.apache.sysml.runtime.functionobjects.Mean;
import org.apache.sysml.runtime.instructions.cp.CM_COV_Object;
import org.apache.sysml.runtime.instructions.cp.Data;
import org.apache.sysml.runtime.instructions.cp.KahanObject;
import org.apache.sysml.runtime.matrix.data.FrameBlock;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.data.Pair;
import org.apache.sysml.runtime.matrix.operators.CMOperator;
import org.apache.sysml.runtime.transform.DistinctValue;
import org.apache.sysml.runtime.transform.TfUtils;
import org.apache.sysml.runtime.transform.encode.Encoder;
import org.apache.sysml.runtime.transform.meta.TfMetaUtils;
import org.apache.sysml.runtime.util.UtilFunctions;
import org.apache.wink.json4j.JSONArray;
import org.apache.wink.json4j.JSONException;
import org.apache.wink.json4j.JSONObject;

public class MVImputeAgent
extends Encoder {
    private static final long serialVersionUID = 9057868620144662194L;
    public static final String MEAN_PREFIX = "mean";
    public static final String VARIANCE_PREFIX = "var";
    public static final String CORRECTION_PREFIX = "correction";
    public static final String COUNT_PREFIX = "validcount";
    public static final String TOTAL_COUNT_PREFIX = "totalcount";
    public static final String CONSTANT_PREFIX = "constant";
    private MVMethod[] _mvMethodList = null;
    private MVMethod[] _mvscMethodList = null;
    private BitSet _isMVScaled = null;
    private CM _varFn = CM.getCMFnObject(CMOperator.AggregateOperationTypes.VARIANCE);
    private Mean _meanFn = Mean.getMeanFnObject();
    private KahanObject[] _meanList = null;
    private long[] _countList = null;
    private CM_COV_Object[] _varList = null;
    private int[] _scnomvList = null;
    private MVMethod[] _scnomvMethodList = null;
    private KahanObject[] _scnomvMeanList = null;
    private long[] _scnomvCountList = null;
    private CM_COV_Object[] _scnomvVarList = null;
    private String[] _replacementList = null;
    private String[] _NAstrings = null;
    private List<Integer> _rcList = null;
    private HashMap<Integer, HashMap<String, Long>> _hist = null;

    public String[] getReplacements() {
        return this._replacementList;
    }

    public KahanObject[] getMeans() {
        return this._meanList;
    }

    public CM_COV_Object[] getVars() {
        return this._varList;
    }

    public KahanObject[] getMeans_scnomv() {
        return this._scnomvMeanList;
    }

    public CM_COV_Object[] getVars_scnomv() {
        return this._scnomvVarList;
    }

    public MVImputeAgent(JSONObject parsedSpec, String[] colnames, int clen) throws JSONException {
        super(null, clen);
        int[] collist = TfMetaUtils.parseJsonObjectIDList(parsedSpec, colnames, "impute");
        this.initColList(collist);
        this.parseMethodsAndReplacments(parsedSpec);
        this._hist = new HashMap();
    }

    public MVImputeAgent(JSONObject parsedSpec, String[] colnames, String[] NAstrings, int clen) throws JSONException {
        super(null, clen);
        boolean isMV = parsedSpec.containsKey("impute");
        boolean isSC = parsedSpec.containsKey("scale");
        this._NAstrings = NAstrings;
        if (!isMV) {
            this._colList = null;
            this._mvMethodList = null;
            this._meanList = null;
            this._countList = null;
            this._replacementList = null;
        } else {
            JSONObject mvobj = (JSONObject)parsedSpec.get("impute");
            JSONArray mvattrs = (JSONArray)mvobj.get("attributes");
            JSONArray mvmthds = (JSONArray)mvobj.get("methods");
            int mvLength = mvattrs.size();
            this._colList = new int[mvLength];
            this._mvMethodList = new MVMethod[mvLength];
            this._meanList = new KahanObject[mvLength];
            this._countList = new long[mvLength];
            this._varList = new CM_COV_Object[mvLength];
            this._isMVScaled = new BitSet(this._colList.length);
            this._isMVScaled.clear();
            for (int i = 0; i < this._colList.length; ++i) {
                this._colList[i] = UtilFunctions.toInt(mvattrs.get(i));
                this._mvMethodList[i] = MVMethod.values()[UtilFunctions.toInt(mvmthds.get(i))];
                this._meanList[i] = new KahanObject(0.0, 0.0);
            }
            this._replacementList = new String[mvLength];
            JSONArray constants = (JSONArray)mvobj.get("constants");
            for (int i = 0; i < constants.size(); ++i) {
                this._replacementList[i] = constants.get(i) == null ? "NaN" : constants.get(i).toString();
            }
        }
        if (!isSC) {
            this._scnomvCountList = null;
            this._scnomvMeanList = null;
            this._scnomvVarList = null;
        } else {
            byte mthd;
            int colID;
            int i;
            if (this._colList != null) {
                this._mvscMethodList = new MVMethod[this._colList.length];
            }
            JSONObject scobj = (JSONObject)parsedSpec.get("scale");
            JSONArray scattrs = (JSONArray)scobj.get("attributes");
            JSONArray scmthds = (JSONArray)scobj.get("methods");
            int scLength = scattrs.size();
            int[] _allscaled = new int[scLength];
            int scnomv = 0;
            for (i = 0; i < scLength; ++i) {
                colID = UtilFunctions.toInt(scattrs.get(i));
                mthd = (byte)UtilFunctions.toInt(scmthds.get(i));
                _allscaled[i] = colID;
                int mvidx = this.isApplicable(colID);
                if (mvidx != -1) {
                    this._isMVScaled.set(mvidx);
                    this._mvscMethodList[mvidx] = MVMethod.values()[mthd];
                    this._varList[mvidx] = new CM_COV_Object();
                    continue;
                }
                ++scnomv;
            }
            if (scnomv > 0) {
                this._scnomvList = new int[scnomv];
                this._scnomvMethodList = new MVMethod[scnomv];
                this._scnomvMeanList = new KahanObject[scnomv];
                this._scnomvCountList = new long[scnomv];
                this._scnomvVarList = new CM_COV_Object[scnomv];
                int idx = 0;
                for (i = 0; i < scLength; ++i) {
                    colID = UtilFunctions.toInt(scattrs.get(i));
                    mthd = (byte)UtilFunctions.toInt(scmthds.get(i));
                    if (this.isApplicable(colID) != -1) continue;
                    this._scnomvList[idx] = colID;
                    this._scnomvMethodList[idx] = MVMethod.values()[mthd];
                    this._scnomvMeanList[idx] = new KahanObject(0.0, 0.0);
                    this._scnomvVarList[idx] = new CM_COV_Object();
                    ++idx;
                }
            }
        }
    }

    private void parseMethodsAndReplacments(JSONObject parsedSpec) throws JSONException {
        JSONArray mvspec = (JSONArray)parsedSpec.get("impute");
        this._mvMethodList = new MVMethod[mvspec.size()];
        this._replacementList = new String[mvspec.size()];
        this._meanList = new KahanObject[mvspec.size()];
        this._countList = new long[mvspec.size()];
        for (int i = 0; i < mvspec.size(); ++i) {
            JSONObject mvobj = (JSONObject)mvspec.get(i);
            this._mvMethodList[i] = MVMethod.valueOf(mvobj.get("method").toString().toUpperCase());
            if (this._mvMethodList[i] == MVMethod.CONSTANT) {
                this._replacementList[i] = mvobj.getString("value").toString();
            }
            this._meanList[i] = new KahanObject(0.0, 0.0);
        }
    }

    public void prepare(String[] words) throws IOException {
        try {
            int colID;
            int i;
            String w = null;
            if (this._colList != null) {
                for (i = 0; i < this._colList.length; ++i) {
                    colID = this._colList[i];
                    w = UtilFunctions.unquote(words[colID - 1].trim());
                    try {
                        boolean computeMean;
                        if (TfUtils.isNA(this._NAstrings, w)) continue;
                        int n = i;
                        this._countList[n] = this._countList[n] + 1L;
                        boolean bl = computeMean = this._mvMethodList[i] == MVMethod.GLOBAL_MEAN || this._isMVScaled.get(i);
                        if (!computeMean) continue;
                        double d = UtilFunctions.parseToDouble(w);
                        this._meanFn.execute2(this._meanList[i], d, this._countList[i]);
                        if (!this._isMVScaled.get(i) || this._mvscMethodList[i] != MVMethod.GLOBAL_MODE) continue;
                        this._varFn.execute((Data)this._varList[i], d);
                        continue;
                    }
                    catch (NumberFormatException e) {
                        throw new RuntimeException("Encountered \"" + w + "\" in column ID \"" + colID + "\", when expecting a numeric value. Consider adding \"" + w + "\" to na.strings, along with an appropriate imputation method.");
                    }
                }
            }
            if (this._scnomvList != null) {
                for (i = 0; i < this._scnomvList.length; ++i) {
                    colID = this._scnomvList[i];
                    w = UtilFunctions.unquote(words[colID - 1].trim());
                    double d = UtilFunctions.parseToDouble(w);
                    int n = i;
                    this._scnomvCountList[n] = this._scnomvCountList[n] + 1L;
                    this._meanFn.execute2(this._scnomvMeanList[i], d, this._scnomvCountList[i]);
                    if (this._scnomvMethodList[i] != MVMethod.GLOBAL_MODE) continue;
                    this._varFn.execute((Data)this._scnomvVarList[i], d);
                }
            }
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private String encodeCMObj(CM_COV_Object obj) {
        StringBuilder sb = new StringBuilder();
        sb.append(obj.w);
        sb.append(",");
        sb.append(obj.mean._sum);
        sb.append(",");
        sb.append(obj.mean._correction);
        sb.append(",");
        sb.append(obj.m2._sum);
        sb.append(",");
        sb.append(obj.m2._correction);
        return sb.toString();
    }

    private CM_COV_Object decodeCMObj(String s) {
        CM_COV_Object obj = new CM_COV_Object();
        String[] parts = s.split(",");
        obj.w = UtilFunctions.parseToDouble(parts[0]);
        obj.mean._sum = UtilFunctions.parseToDouble(parts[1]);
        obj.mean._correction = UtilFunctions.parseToDouble(parts[2]);
        obj.m2._sum = UtilFunctions.parseToDouble(parts[3]);
        obj.m2._correction = UtilFunctions.parseToDouble(parts[4]);
        return obj;
    }

    private DistinctValue prepMeanOutput(int taskID, int idx, StringBuilder sb, boolean scnomv) throws CharacterCodingException {
        MVMethod mthd;
        MVMethod mVMethod = mthd = scnomv ? this._scnomvMethodList[idx] : this._mvMethodList[idx];
        if (scnomv || mthd == MVMethod.GLOBAL_MEAN || this._isMVScaled.get(idx)) {
            String suffix = null;
            suffix = scnomv ? "scnomv" : (mthd == MVMethod.GLOBAL_MEAN && this._isMVScaled.get(idx) ? "scmv" : (mthd == MVMethod.GLOBAL_MEAN ? "noscmv" : "scnomv"));
            sb.setLength(0);
            sb.append(MEAN_PREFIX);
            sb.append("_");
            sb.append(taskID);
            sb.append("_");
            double mean = scnomv ? this._scnomvMeanList[idx]._sum : this._meanList[idx]._sum;
            sb.append(Double.toString(mean));
            sb.append(",");
            sb.append(suffix);
            return new DistinctValue(sb.toString(), -1L);
        }
        return null;
    }

    private DistinctValue prepMeanCorrectionOutput(int taskID, int idx, StringBuilder sb, boolean scnomv) throws CharacterCodingException {
        MVMethod mthd;
        MVMethod mVMethod = mthd = scnomv ? this._scnomvMethodList[idx] : this._mvMethodList[idx];
        if (scnomv || mthd == MVMethod.GLOBAL_MEAN || this._isMVScaled.get(idx)) {
            sb.setLength(0);
            sb.append(CORRECTION_PREFIX);
            sb.append("_");
            sb.append(taskID);
            sb.append("_");
            double corr = scnomv ? this._scnomvMeanList[idx]._correction : this._meanList[idx]._correction;
            sb.append(Double.toString(corr));
            return new DistinctValue(sb.toString(), -1L);
        }
        return null;
    }

    private DistinctValue prepMeanCountOutput(int taskID, int idx, StringBuilder sb, boolean scnomv) throws CharacterCodingException {
        MVMethod mthd;
        MVMethod mVMethod = mthd = scnomv ? this._scnomvMethodList[idx] : this._mvMethodList[idx];
        if (scnomv || mthd == MVMethod.GLOBAL_MEAN || this._isMVScaled.get(idx)) {
            sb.setLength(0);
            sb.append(COUNT_PREFIX);
            sb.append("_");
            sb.append(taskID);
            sb.append("_");
            long count = scnomv ? this._scnomvCountList[idx] : this._countList[idx];
            sb.append(Long.toString(count));
            return new DistinctValue(sb.toString(), -1L);
        }
        return null;
    }

    private DistinctValue prepTotalCountOutput(int taskID, int idx, StringBuilder sb, boolean scnomv, TfUtils agents) throws CharacterCodingException {
        MVMethod mthd;
        MVMethod mVMethod = mthd = scnomv ? this._scnomvMethodList[idx] : this._mvMethodList[idx];
        if (scnomv || mthd == MVMethod.GLOBAL_MEAN || this._isMVScaled.get(idx)) {
            sb.setLength(0);
            sb.append(TOTAL_COUNT_PREFIX);
            sb.append("_");
            sb.append(taskID);
            sb.append("_");
            sb.append(Long.toString(agents.getValid()));
            return new DistinctValue(sb.toString(), -1L);
        }
        return null;
    }

    private DistinctValue prepConstantOutput(int idx, StringBuilder sb) throws CharacterCodingException {
        if (this._mvMethodList == null) {
            return null;
        }
        MVMethod mthd = this._mvMethodList[idx];
        if (mthd == MVMethod.CONSTANT) {
            sb.setLength(0);
            sb.append(CONSTANT_PREFIX);
            sb.append("_");
            sb.append(this._replacementList[idx]);
            return new DistinctValue(sb.toString(), -1L);
        }
        return null;
    }

    private DistinctValue prepVarOutput(int taskID, int idx, StringBuilder sb, boolean scnomv) throws CharacterCodingException {
        if (scnomv || this._isMVScaled.get(idx) && this._mvscMethodList[idx] == MVMethod.GLOBAL_MODE) {
            sb.setLength(0);
            sb.append(VARIANCE_PREFIX);
            sb.append("_");
            sb.append(taskID);
            sb.append("_");
            CM_COV_Object cm = scnomv ? this._scnomvVarList[idx] : this._varList[idx];
            sb.append(this.encodeCMObj(cm));
            return new DistinctValue(sb.toString(), -1L);
        }
        return null;
    }

    private void outDV(IntWritable iw, DistinctValue dv, OutputCollector<IntWritable, DistinctValue> out) throws IOException {
        if (dv != null) {
            out.collect((Object)iw, (Object)dv);
        }
    }

    @Override
    public void mapOutputTransformationMetadata(OutputCollector<IntWritable, DistinctValue> out, int taskID, TfUtils agents) throws IOException {
        try {
            IntWritable iw;
            int colID;
            int i;
            StringBuilder sb = new StringBuilder();
            DistinctValue dv = null;
            if (this._colList != null) {
                for (i = 0; i < this._colList.length; ++i) {
                    colID = this._colList[i];
                    iw = new IntWritable(-colID);
                    dv = this.prepMeanOutput(taskID, i, sb, false);
                    this.outDV(iw, dv, out);
                    dv = this.prepMeanCorrectionOutput(taskID, i, sb, false);
                    this.outDV(iw, dv, out);
                    dv = this.prepMeanCountOutput(taskID, i, sb, false);
                    this.outDV(iw, dv, out);
                    dv = this.prepTotalCountOutput(taskID, i, sb, false, agents);
                    this.outDV(iw, dv, out);
                    dv = this.prepConstantOutput(i, sb);
                    this.outDV(iw, dv, out);
                    dv = this.prepVarOutput(taskID, i, sb, false);
                    this.outDV(iw, dv, out);
                }
            }
            if (this._scnomvList != null) {
                for (i = 0; i < this._scnomvList.length; ++i) {
                    colID = this._scnomvList[i];
                    iw = new IntWritable(-colID);
                    dv = this.prepMeanOutput(taskID, i, sb, true);
                    this.outDV(iw, dv, out);
                    dv = this.prepMeanCorrectionOutput(taskID, i, sb, true);
                    this.outDV(iw, dv, out);
                    dv = this.prepMeanCountOutput(taskID, i, sb, true);
                    this.outDV(iw, dv, out);
                    dv = this.prepTotalCountOutput(taskID, i, sb, true, agents);
                    this.outDV(iw, dv, out);
                    dv = this.prepVarOutput(taskID, i, sb, true);
                    this.outDV(iw, dv, out);
                }
            }
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private void addDV(Integer iw, DistinctValue dv, ArrayList<Pair<Integer, DistinctValue>> list) throws IOException {
        if (dv != null) {
            list.add(new Pair<Integer, DistinctValue>(iw, dv));
        }
    }

    public ArrayList<Pair<Integer, DistinctValue>> mapOutputTransformationMetadata(int taskID, ArrayList<Pair<Integer, DistinctValue>> list, TfUtils agents) throws IOException {
        try {
            Integer iw;
            int colID;
            int i;
            StringBuilder sb = new StringBuilder();
            DistinctValue dv = null;
            if (this._colList != null) {
                for (i = 0; i < this._colList.length; ++i) {
                    colID = this._colList[i];
                    iw = -colID;
                    dv = this.prepMeanOutput(taskID, i, sb, false);
                    this.addDV(iw, dv, list);
                    dv = this.prepMeanCorrectionOutput(taskID, i, sb, false);
                    this.addDV(iw, dv, list);
                    dv = this.prepMeanCountOutput(taskID, i, sb, false);
                    this.addDV(iw, dv, list);
                    dv = this.prepTotalCountOutput(taskID, i, sb, false, agents);
                    this.addDV(iw, dv, list);
                    dv = this.prepConstantOutput(i, sb);
                    this.addDV(iw, dv, list);
                    dv = this.prepVarOutput(taskID, i, sb, false);
                    this.addDV(iw, dv, list);
                }
            }
            if (this._scnomvList != null) {
                for (i = 0; i < this._scnomvList.length; ++i) {
                    colID = this._scnomvList[i];
                    iw = -colID;
                    dv = this.prepMeanOutput(taskID, i, sb, true);
                    this.addDV(iw, dv, list);
                    dv = this.prepMeanCorrectionOutput(taskID, i, sb, true);
                    this.addDV(iw, dv, list);
                    dv = this.prepMeanCountOutput(taskID, i, sb, true);
                    this.addDV(iw, dv, list);
                    dv = this.prepTotalCountOutput(taskID, i, sb, true, agents);
                    this.addDV(iw, dv, list);
                    dv = this.prepVarOutput(taskID, i, sb, true);
                    this.addDV(iw, dv, list);
                }
            }
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        return list;
    }

    private void writeTfMtd(int colID, String mean, String tfMtdDir, FileSystem fs, TfUtils agents) throws IOException {
        Path pt = new Path(tfMtdDir + "/Impute/" + agents.getName(colID) + ".impute");
        try (BufferedWriter br = new BufferedWriter(new OutputStreamWriter((OutputStream)fs.create(pt, true)));){
            br.write(colID + "," + mean + "\n");
        }
    }

    private void writeTfMtd(int colID, String mean, String sdev, String tfMtdDir, FileSystem fs, TfUtils agents) throws IOException {
        Path pt = new Path(tfMtdDir + "/Scale/" + agents.getName(colID) + ".scale");
        try (BufferedWriter br = new BufferedWriter(new OutputStreamWriter((OutputStream)fs.create(pt, true)));){
            br.write(colID + "," + mean + "," + sdev + "\n");
        }
    }

    private void writeTfMtd(int colID, String min, String max, String binwidth, String nbins, String tfMtdDir, FileSystem fs, TfUtils agents) throws IOException {
        Path pt = new Path(tfMtdDir + "/Bin/" + agents.getName(colID) + ".bin");
        try (BufferedWriter br = new BufferedWriter(new OutputStreamWriter((OutputStream)fs.create(pt, true)));){
            br.write(colID + "," + min + "," + max + "," + binwidth + "," + nbins + "\n");
        }
    }

    public void outputTransformationMetadata(String outputDir, FileSystem fs, TfUtils agents) throws IOException {
        try {
            int colID;
            int i;
            if (this._colList != null) {
                for (i = 0; i < this._colList.length; ++i) {
                    colID = this._colList[i];
                    double imputedValue = Double.NaN;
                    KahanObject gmean = null;
                    if (this._mvMethodList[i] == MVMethod.GLOBAL_MEAN) {
                        gmean = this._meanList[i];
                        imputedValue = this._meanList[i]._sum;
                        double mean = this._countList[i] == 0L ? 0.0 : this._meanList[i]._sum;
                        this.writeTfMtd(colID, Double.toString(mean), outputDir, fs, agents);
                    } else if (this._mvMethodList[i] == MVMethod.CONSTANT) {
                        this.writeTfMtd(colID, this._replacementList[i], outputDir, fs, agents);
                        if (this._isMVScaled.get(i)) {
                            imputedValue = UtilFunctions.parseToDouble(this._replacementList[i]);
                            gmean = new KahanObject(this._meanList[i]._sum, this._meanList[i]._correction);
                            this._meanFn.execute(gmean, imputedValue, agents.getValid());
                        }
                    }
                    if (!this._isMVScaled.get(i)) continue;
                    double sdev = -1.0;
                    if (this._mvscMethodList[i] == MVMethod.GLOBAL_MODE) {
                        long totalMissingCount = agents.getValid() - this._countList[i];
                        this._varFn.execute(this._varList[i], imputedValue, totalMissingCount);
                        double var = this._varList[i].getRequiredResult(new CMOperator(this._varFn, CMOperator.AggregateOperationTypes.VARIANCE));
                        sdev = Math.sqrt(var);
                    }
                    this.writeTfMtd(colID, Double.toString(gmean._sum), Double.toString(sdev), outputDir, fs, agents);
                }
            }
            if (this._scnomvList != null) {
                for (i = 0; i < this._scnomvList.length; ++i) {
                    colID = this._scnomvList[i];
                    double mean = this._scnomvCountList[i] == 0L ? 0.0 : this._scnomvMeanList[i]._sum;
                    double sdev = -1.0;
                    if (this._scnomvMethodList[i] == MVMethod.GLOBAL_MODE) {
                        double var = this._scnomvVarList[i].getRequiredResult(new CMOperator(this._varFn, CMOperator.AggregateOperationTypes.VARIANCE));
                        sdev = Math.sqrt(var);
                    }
                    this.writeTfMtd(colID, Double.toString(mean), Double.toString(sdev), outputDir, fs, agents);
                }
            }
        }
        catch (DMLRuntimeException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void mergeAndOutputTransformationMetadata(Iterator<DistinctValue> values, String outputDir, int colID, FileSystem fs, TfUtils agents) throws IOException {
        double min = Double.MAX_VALUE;
        double max = -1.7976931348623157E308;
        int nbins = 0;
        long totalRecordCount = 0L;
        long totalValidCount = 0L;
        String mvConstReplacement = null;
        DistinctValue val = new DistinctValue();
        String w = null;
        class MeanObject {
            double mean;
            double correction;
            long count;

            MeanObject() {
            }

            public String toString() {
                return this.mean + "," + this.correction + "," + this.count;
            }
        }
        HashMap<Integer, MeanObject> mapMeans = new HashMap<Integer, MeanObject>();
        HashMap<Integer, CM_COV_Object> mapVars = new HashMap<Integer, CM_COV_Object>();
        boolean isImputed = false;
        boolean isScaled = false;
        boolean isBinned = false;
        while (values.hasNext()) {
            double d;
            MeanObject mo;
            int taskID;
            String[] parts;
            val.reset();
            val = values.next();
            w = val.getWord();
            if (w.startsWith(MEAN_PREFIX)) {
                parts = w.split("_");
                taskID = UtilFunctions.parseToInt(parts[1]);
                mo = (MeanObject)mapMeans.get(taskID);
                if (mo == null) {
                    mo = new MeanObject();
                }
                mo.mean = UtilFunctions.parseToDouble(parts[2].split(",")[0]);
                String s = parts[2].split(",")[1];
                if (s.equalsIgnoreCase("scmv")) {
                    isImputed = true;
                    isScaled = true;
                } else if (s.equalsIgnoreCase("scnomv")) {
                    isScaled = true;
                } else {
                    isImputed = true;
                }
                mapMeans.put(taskID, mo);
                continue;
            }
            if (w.startsWith(CORRECTION_PREFIX)) {
                parts = w.split("_");
                taskID = UtilFunctions.parseToInt(parts[1]);
                mo = (MeanObject)mapMeans.get(taskID);
                if (mo == null) {
                    mo = new MeanObject();
                }
                mo.correction = UtilFunctions.parseToDouble(parts[2]);
                mapMeans.put(taskID, mo);
                continue;
            }
            if (w.startsWith(CONSTANT_PREFIX)) {
                isImputed = true;
                parts = w.split("_");
                mvConstReplacement = parts[1];
                continue;
            }
            if (w.startsWith(COUNT_PREFIX)) {
                parts = w.split("_");
                taskID = UtilFunctions.parseToInt(parts[1]);
                mo = (MeanObject)mapMeans.get(taskID);
                if (mo == null) {
                    mo = new MeanObject();
                }
                mo.count = UtilFunctions.parseToLong(parts[2]);
                totalValidCount += mo.count;
                mapMeans.put(taskID, mo);
                continue;
            }
            if (w.startsWith(TOTAL_COUNT_PREFIX)) {
                parts = w.split("_");
                totalRecordCount += UtilFunctions.parseToLong(parts[2]);
                continue;
            }
            if (w.startsWith(VARIANCE_PREFIX)) {
                isScaled = true;
                parts = w.split("_");
                taskID = UtilFunctions.parseToInt(parts[1]);
                CM_COV_Object cm = this.decodeCMObj(parts[2]);
                mapVars.put(taskID, cm);
                continue;
            }
            if (w.startsWith("min")) {
                isBinned = true;
                d = UtilFunctions.parseToDouble(w.substring("min".length()));
                if (!(d < min)) continue;
                min = d;
                continue;
            }
            if (w.startsWith("max")) {
                isBinned = true;
                d = UtilFunctions.parseToDouble(w.substring("max".length()));
                if (!(d > max)) continue;
                max = d;
                continue;
            }
            if (w.startsWith("nbins")) {
                isBinned = true;
                nbins = (int)UtilFunctions.parseToLong(w.substring("nbins".length()));
                continue;
            }
            throw new RuntimeException("MVImputeAgent: Invalid prefix while merging map output: " + w);
        }
        KahanObject gmean = new KahanObject(0.0, 0.0);
        KahanPlus kp = KahanPlus.getKahanPlusFnObject();
        long gcount = 0L;
        for (Object mo : mapMeans.values()) {
            if ((gcount += ((MeanObject)mo).count) <= 0L) continue;
            double delta = ((MeanObject)mo).mean - gmean._sum;
            kp.execute2(gmean, delta * (double)((MeanObject)mo).count / (double)gcount);
        }
        CM_COV_Object gcm = new CM_COV_Object();
        try {
            for (CM_COV_Object cm : mapVars.values()) {
                gcm = (CM_COV_Object)this._varFn.execute((Data)gcm, cm);
            }
        }
        catch (DMLRuntimeException e) {
            throw new IOException(e);
        }
        if (isImputed && isBinned && mvConstReplacement != null) {
            double cst = UtilFunctions.parseToDouble(mvConstReplacement);
            if (cst < min) {
                min = cst;
            }
            if (cst > max) {
                max = cst;
            }
        }
        if (isImputed) {
            String imputedValue = null;
            imputedValue = mvConstReplacement != null ? mvConstReplacement : Double.toString(gcount == 0L ? 0.0 : gmean._sum);
            this.writeTfMtd(colID, imputedValue, outputDir, fs, agents);
        }
        if (isBinned) {
            double binwidth = (max - min) / (double)nbins;
            this.writeTfMtd(colID, Double.toString(min), Double.toString(max), Double.toString(binwidth), Integer.toString(nbins), outputDir, fs, agents);
        }
        if (isScaled) {
            try {
                if (totalValidCount != totalRecordCount) {
                    long totalMissingCount = totalRecordCount - totalValidCount;
                    int idx = this.isApplicable(colID);
                    if (idx != -1 && this._mvMethodList[idx] == MVMethod.CONSTANT) {
                        this._meanFn.execute(gmean, UtilFunctions.parseToDouble(this._replacementList[idx]), totalRecordCount);
                    }
                    this._varFn.execute(gcm, gmean._sum, totalMissingCount);
                }
                double mean = gcount == 0L ? 0.0 : gmean._sum;
                double var = gcm.getRequiredResult(new CMOperator(this._varFn, CMOperator.AggregateOperationTypes.VARIANCE));
                double sdev = mapVars.size() > 0 ? Math.sqrt(var) : -1.0;
                this.writeTfMtd(colID, Double.toString(mean), Double.toString(sdev), outputDir, fs, agents);
            }
            catch (DMLRuntimeException e) {
                throw new IOException(e);
            }
        }
    }

    private String readReplacement(int colID, FileSystem fs, Path txMtdDir, TfUtils agents) throws IOException {
        Path path = new Path(txMtdDir + "/Impute/" + agents.getName(colID) + ".impute");
        TfUtils.checkValidInputFile(fs, path, true);
        String replacement = null;
        try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)fs.open(path)));){
            String line = br.readLine();
            replacement = UtilFunctions.unquote(line.split(",")[1]);
        }
        return replacement;
    }

    public String readScaleLine(int colID, FileSystem fs, Path txMtdDir, TfUtils agents) throws IOException {
        Path path = new Path(txMtdDir + "/Scale/" + agents.getName(colID) + ".scale");
        TfUtils.checkValidInputFile(fs, path, true);
        String line = null;
        try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)fs.open(path)));){
            line = br.readLine();
        }
        return line;
    }

    private void processScalingFile(int i, int[] list, KahanObject[] meanList, CM_COV_Object[] varList, FileSystem fs, Path tfMtdDir, TfUtils agents) throws IOException {
        int colID = list[i];
        String line = this.readScaleLine(colID, fs, tfMtdDir, agents);
        String[] parts = line.split(",");
        double mean = UtilFunctions.parseToDouble(parts[1]);
        double sd = UtilFunctions.parseToDouble(parts[2]);
        meanList[i]._sum = mean;
        varList[i].mean._sum = sd;
    }

    @Override
    public void loadTxMtd(JobConf job, FileSystem fs, Path tfMtdDir, TfUtils agents) throws IOException {
        if (fs.isDirectory(tfMtdDir)) {
            int i;
            if (this._colList != null) {
                for (i = 0; i < this._colList.length; ++i) {
                    int colID = this._colList[i];
                    if (this._mvMethodList[i] == MVMethod.GLOBAL_MEAN || this._mvMethodList[i] == MVMethod.GLOBAL_MODE) {
                        this._replacementList[i] = this.readReplacement(colID, fs, tfMtdDir, agents);
                        continue;
                    }
                    if (this._mvMethodList[i] == MVMethod.CONSTANT) continue;
                    throw new RuntimeException("Invalid Missing Value Imputation methods: " + (Object)((Object)this._mvMethodList[i]));
                }
            }
            if (this._colList != null) {
                for (i = 0; i < this._colList.length; ++i) {
                    if (!this._isMVScaled.get(i)) continue;
                    this.processScalingFile(i, this._colList, this._meanList, this._varList, fs, tfMtdDir, agents);
                }
            }
            if (this._scnomvList != null) {
                for (i = 0; i < this._scnomvList.length; ++i) {
                    this.processScalingFile(i, this._scnomvList, this._scnomvMeanList, this._scnomvVarList, fs, tfMtdDir, agents);
                }
            }
        } else {
            throw new RuntimeException("Path to recode maps must be a directory: " + tfMtdDir);
        }
    }

    public MVMethod getMethod(int colID) {
        int idx = this.isApplicable(colID);
        if (idx == -1) {
            return MVMethod.INVALID;
        }
        return this._mvMethodList[idx];
    }

    public long getNonMVCount(int colID) {
        int idx = this.isApplicable(colID);
        return idx == -1 ? 0L : this._countList[idx];
    }

    public String getReplacement(int colID) {
        int idx = this.isApplicable(colID);
        return idx == -1 ? null : this._replacementList[idx];
    }

    @Override
    public MatrixBlock encode(FrameBlock in, MatrixBlock out) {
        this.build(in);
        return this.apply(in, out);
    }

    @Override
    public void build(FrameBlock in) {
        try {
            for (int j = 0; j < this._colList.length; ++j) {
                int colID = this._colList[j];
                if (this._mvMethodList[j] == MVMethod.GLOBAL_MEAN) {
                    long off = this._countList[j];
                    for (int i = 0; i < in.getNumRows(); ++i) {
                        this._meanFn.execute2(this._meanList[j], UtilFunctions.objectToDouble(in.getSchema()[colID - 1], in.get(i, colID - 1)), off + (long)i + 1L);
                    }
                    this._replacementList[j] = String.valueOf(this._meanList[j]._sum);
                    int n = j;
                    this._countList[n] = this._countList[n] + (long)in.getNumRows();
                    continue;
                }
                if (this._mvMethodList[j] != MVMethod.GLOBAL_MODE) continue;
                HashMap<String, Long> hist = this._hist.containsKey(colID) ? this._hist.get(colID) : new HashMap<String, Long>();
                for (int i = 0; i < in.getNumRows(); ++i) {
                    String key = String.valueOf(in.get(i, colID - 1));
                    if (key == null || key.isEmpty()) continue;
                    Long val = (Long)hist.get(key);
                    hist.put(key, val != null ? val + 1L : 1L);
                }
                this._hist.put(colID, hist);
                long max = Long.MIN_VALUE;
                for (Map.Entry e : hist.entrySet()) {
                    if ((Long)e.getValue() <= max) continue;
                    this._replacementList[j] = (String)e.getKey();
                    max = (Long)e.getValue();
                }
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public String[] apply(String[] words) {
        int colID;
        int i;
        if (this.isApplicable()) {
            for (i = 0; i < this._colList.length; ++i) {
                colID = this._colList[i];
                String w = UtilFunctions.unquote(words[colID - 1]);
                if (TfUtils.isNA(this._NAstrings, w)) {
                    String string = this._replacementList[i];
                    words[colID - 1] = string;
                    w = string;
                }
                if (!this._isMVScaled.get(i)) continue;
                words[colID - 1] = this._mvscMethodList[i] == MVMethod.GLOBAL_MEAN ? Double.toString(UtilFunctions.parseToDouble(w) - this._meanList[i]._sum) : Double.toString((UtilFunctions.parseToDouble(w) - this._meanList[i]._sum) / this._varList[i].mean._sum);
            }
        }
        if (this._scnomvList != null) {
            for (i = 0; i < this._scnomvList.length; ++i) {
                colID = this._scnomvList[i];
                words[colID - 1] = this._scnomvMethodList[i] == MVMethod.GLOBAL_MEAN ? Double.toString(UtilFunctions.parseToDouble(words[colID - 1]) - this._scnomvMeanList[i]._sum) : Double.toString((UtilFunctions.parseToDouble(words[colID - 1]) - this._scnomvMeanList[i]._sum) / this._scnomvVarList[i].mean._sum);
            }
        }
        return words;
    }

    @Override
    public MatrixBlock apply(FrameBlock in, MatrixBlock out) {
        for (int i = 0; i < in.getNumRows(); ++i) {
            for (int j = 0; j < this._colList.length; ++j) {
                int colID = this._colList[j];
                if (!Double.isNaN(out.quickGetValue(i, colID - 1))) continue;
                out.quickSetValue(i, colID - 1, Double.parseDouble(this._replacementList[j]));
            }
        }
        return out;
    }

    @Override
    public FrameBlock getMetaData(FrameBlock out) {
        for (int j = 0; j < this._colList.length; ++j) {
            out.getColumnMetadata(this._colList[j] - 1).setMvValue(this._replacementList[j]);
        }
        return out;
    }

    @Override
    public void initMetaData(FrameBlock meta) {
        for (int j = 0; j < this._colList.length; ++j) {
            int colID = this._colList[j];
            String mvVal = UtilFunctions.unquote(meta.getColumnMetadata(colID - 1).getMvValue());
            if (this._rcList.contains(colID)) {
                Long mvVal2 = meta.getRecodeMap(colID - 1).get(mvVal);
                if (mvVal2 == null) {
                    throw new RuntimeException("Missing recode value for impute value '" + mvVal + "' (colID=" + colID + ").");
                }
                this._replacementList[j] = mvVal2.toString();
                continue;
            }
            this._replacementList[j] = mvVal;
        }
    }

    public void initRecodeIDList(List<Integer> rcList) {
        this._rcList = rcList;
    }

    public HashMap<String, Long> getHistogram(int colID) {
        return this._hist.get(colID);
    }

    public static enum MVMethod {
        INVALID,
        GLOBAL_MEAN,
        GLOBAL_MODE,
        CONSTANT;

    }
}

